/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.jsonschema.builder;

import com.kms.katalon.ai.mcp.jsonschema.builder.Builder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NumberSchemaBuilder
extends Builder {
    private String description;
    private Number minimum;
    private Number maximum;
    private Number exclusiveMinimum;
    private Number exclusiveMaximum;
    private Number multipleOf;
    private final List<Number> enumValues = new ArrayList<Number>();

    private NumberSchemaBuilder() {
    }

    public static NumberSchemaBuilder create() {
        return new NumberSchemaBuilder();
    }

    public NumberSchemaBuilder description(String description) {
        this.description = description;
        return this;
    }

    public NumberSchemaBuilder minimum(Number minimum) {
        this.minimum = minimum;
        return this;
    }

    public NumberSchemaBuilder maximum(Number maximum) {
        this.maximum = maximum;
        return this;
    }

    public NumberSchemaBuilder exclusiveMinimum(Number exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    public NumberSchemaBuilder exclusiveMaximum(Number exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public NumberSchemaBuilder multipleOf(Number multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }

    public NumberSchemaBuilder enumValue(Number value) {
        this.enumValues.add(value);
        return this;
    }

    public NumberSchemaBuilder enumValues(Number ... values) {
        this.enumValues.clear();
        Arrays.stream(values).forEach(this.enumValues::add);
        return this;
    }

    @Override
    public String getType() {
        return "number";
    }

    @Override
    public Map<String, Object> build() {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("type", this.getType());
        if (this.description != null) {
            schema.put("description", this.description);
        }
        if (this.minimum != null) {
            schema.put("minimum", this.minimum);
        }
        if (this.maximum != null) {
            schema.put("maximum", this.maximum);
        }
        if (this.exclusiveMinimum != null) {
            schema.put("exclusiveMinimum", this.exclusiveMinimum);
        }
        if (this.exclusiveMaximum != null) {
            schema.put("exclusiveMaximum", this.exclusiveMaximum);
        }
        if (this.multipleOf != null) {
            schema.put("multipleOf", this.multipleOf);
        }
        if (!this.enumValues.isEmpty()) {
            schema.put("enum", new ArrayList<Number>(this.enumValues));
        }
        return schema;
    }
}

