/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.jsonschema.builder;

import com.kms.katalon.ai.mcp.jsonschema.builder.Builder;
import com.kms.katalon.ai.mcp.jsonschema.builder.StringSchemaBuilder;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObjectSchemaBuilder
extends Builder {
    private String title;
    private String description;
    private final Map<String, Builder> properties = new LinkedHashMap<String, Builder>();
    private final List<String> required = new ArrayList<String>();
    private Boolean additionalProperties;
    private Long minProperties;
    private Long maxProperties;
    private final Map<String, Object> patternProperties = new HashMap<String, Object>();
    private final Map<String, Object> propertyNames = new HashMap<String, Object>();
    private final List<Builder> oneOf = new ArrayList<Builder>();

    private ObjectSchemaBuilder() {
    }

    public static ObjectSchemaBuilder create() {
        return new ObjectSchemaBuilder();
    }

    public ObjectSchemaBuilder title(String title) {
        this.title = title;
        return this;
    }

    public ObjectSchemaBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ObjectSchemaBuilder property(String name, Builder builder) {
        this.properties.put(name, builder);
        return this;
    }

    public ObjectSchemaBuilder stringProperty(String name, String description) {
        return this.property(name, StringSchemaBuilder.create().description(description));
    }

    public ObjectSchemaBuilder objectProperty(String name, ObjectSchemaBuilder objectBuilder) {
        return this.property(name, objectBuilder);
    }

    public ObjectSchemaBuilder required(String ... propertyNames) {
        String[] stringArray = propertyNames;
        int n = propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            if (!this.required.contains(propertyName)) {
                this.required.add(propertyName);
            }
            ++n2;
        }
        return this;
    }

    public ObjectSchemaBuilder additionalProperties(boolean allowed) {
        this.additionalProperties = allowed;
        return this;
    }

    public ObjectSchemaBuilder minProperties(long minProperties) {
        this.minProperties = minProperties;
        return this;
    }

    public ObjectSchemaBuilder maxProperties(long maxProperties) {
        this.maxProperties = maxProperties;
        return this;
    }

    public ObjectSchemaBuilder addOneOf(Builder builder) {
        this.oneOf.add(builder);
        return this;
    }

    public ObjectSchemaBuilder oneOf(Builder ... builders) {
        this.oneOf.clear();
        Arrays.stream(builders).forEach(this.oneOf::add);
        return this;
    }

    @Override
    public String getType() {
        return "object";
    }

    @Override
    public Map<String, Object> build() {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("type", this.getType());
        if (this.title != null) {
            schema.put("title", this.title);
        }
        if (this.description != null) {
            schema.put("description", this.description);
        }
        if (!this.properties.isEmpty()) {
            LinkedHashMap<String, Map<String, Object>> propertiesSchema = new LinkedHashMap<String, Map<String, Object>>();
            for (Map.Entry<String, Builder> entry : this.properties.entrySet()) {
                propertiesSchema.put(entry.getKey(), entry.getValue().build());
            }
            schema.put("properties", propertiesSchema);
        } else {
            schema.put("properties", new LinkedHashMap());
        }
        if (!this.required.isEmpty()) {
            schema.put("required", new ArrayList<String>(this.required));
        }
        if (this.additionalProperties != null) {
            schema.put("additionalProperties", this.additionalProperties);
        }
        if (this.minProperties != null) {
            schema.put("minProperties", this.minProperties);
        }
        if (this.maxProperties != null) {
            schema.put("maxProperties", this.maxProperties);
        }
        if (!this.patternProperties.isEmpty()) {
            schema.put("patternProperties", new HashMap<String, Object>(this.patternProperties));
        }
        if (!this.propertyNames.isEmpty()) {
            schema.put("propertyNames", new HashMap<String, Object>(this.propertyNames));
        }
        if (!this.oneOf.isEmpty()) {
            ArrayList<Map<String, Object>> oneOfSchemas = new ArrayList<Map<String, Object>>();
            for (Builder builder : this.oneOf) {
                oneOfSchemas.add(builder.build());
            }
            schema.put("oneOf", oneOfSchemas);
        }
        return schema;
    }

    public McpSchema.JsonSchema buildAsMcpJsonSchema() {
        Map<String, Object> schema = this.build();
        return new McpSchema.JsonSchema(this.getType(), (Map)schema.get("properties"), this.required, null, null, null);
    }
}

