/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools;

import com.kms.katalon.ai.mcp.tools.model.CustomKeywordInfoModel;
import com.kms.katalon.ai.mcp.tools.model.FullyQualifiedNameInfoModel;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyRefreshUtil;
import com.kms.katalon.logging.LogUtil;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jdt.core.ICompilationUnit;

public class CustomKeywordTools {
    @Inject
    private IEventBroker eventBroker;
    private static final String KEYWORD_SOURCE_FOLDER_NAME = "Keywords";

    public McpServerFeatures.SyncToolSpecification createCustomKeywordTool() {
        McpSchema.Tool tool = new McpSchema.Tool("createCustomKeyword", "Create Custom Keyword", "Creates a new custom keyword class with the specified content in current Katalon Studio project. The keyword will be created in the Keywords source folder.", this.createInputSchemaForCreateCustomKeywordTool(), this.createOutputSchemaForCreateNewOrUpdateCustomKeywordTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.createCustomKeywordToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult createCustomKeywordToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        String createdKeywordPath = "";
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String className = (String)arguments.get("className");
            String packageName = (String)arguments.get("packageName");
            String keywordFileContent = (String)arguments.get("keywordFileContent");
            if (StringUtils.isBlank((CharSequence)className)) {
                isError = true;
                resultContent = "className parameter is required";
            } else if (StringUtils.isBlank((CharSequence)keywordFileContent)) {
                isError = true;
                resultContent = "keywordFileContent parameter is required";
            } else {
                createdKeywordPath = this.createCustomKeyword(packageName, className, keywordFileContent);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error creating custom keyword: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateNewOrUpdateCustomKeyword(createdKeywordPath);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private String createCustomKeyword(String packageName, String className, String keywordScriptContent) throws Exception {
        String packagePath;
        String packageNameError;
        if (StringUtils.isNotBlank((CharSequence)packageName) && (packageNameError = this.validatePackageName(packageName)) != null) {
            throw new Exception(packageNameError);
        }
        String classNameError = this.validateClassName(className);
        if (classNameError != null) {
            throw new Exception(classNameError);
        }
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        String projectRoot = project.getFolderLocation();
        Path keywordFilePath = Paths.get(projectRoot, KEYWORD_SOURCE_FOLDER_NAME, packagePath = StringUtils.isBlank((CharSequence)packageName) ? "" : packageName.replace(".", "/"), className + ".groovy");
        Path keywordDirPath = keywordFilePath.getParent();
        if (!Files.exists(keywordDirPath, new LinkOption[0])) {
            Files.createDirectories(keywordDirPath, new FileAttribute[0]);
        }
        if (Files.exists(keywordFilePath, new LinkOption[0])) {
            if (StringUtils.isBlank((CharSequence)packageName)) {
                packageName = "root";
            }
            throw new Exception("Class '" + className + "' already exists in the " + packageName + " package.");
        }
        FileUtils.writeStringToFile((File)keywordFilePath.toFile(), (String)keywordScriptContent, (Charset)StandardCharsets.UTF_8);
        String keywordRelativePath = Paths.get(projectRoot, new String[0]).relativize(keywordFilePath).toString().replace("\\", "/");
        this.refreshKeywordInExplorer(keywordRelativePath, project);
        this.openKeywordInEditor(keywordRelativePath, project);
        return keywordRelativePath;
    }

    private Map<String, Object> createStructuredContentResultForCreateNewOrUpdateCustomKeyword(String keywordPath) {
        HashMap<String, Object> structuredContent = new HashMap<String, Object>();
        structuredContent.put("keywordRelativePath", keywordPath != null ? keywordPath : "");
        return structuredContent;
    }

    private void refreshKeywordInExplorer(String keywordRelativeLocation, ProjectEntity projectEntity) {
        try {
            KeywordTreeEntity keywordTreeEntity = TreeEntityUtil.getKeywordTreeEntity((String)keywordRelativeLocation, (ProjectEntity)projectEntity);
            this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)keywordTreeEntity);
            this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)keywordTreeEntity);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to refresh keyword in explorer");
        }
    }

    public McpServerFeatures.SyncToolSpecification getCustomKeywordTool() {
        McpSchema.Tool tool = new McpSchema.Tool("getCustomKeyword", "Get Custom Keyword", "Get a custom keyword class file with the specified fully qualified name and returns its content.", this.createInputSchemaForGetCustomKeywordTool(), this.createOutputSchemaForGetCustomKeywordTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.getCustomKeywordToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult getCustomKeywordToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        Map<Object, Object> structuredContent = new HashMap();
        CustomKeywordInfoModel customKeywordInfo = new CustomKeywordInfoModel();
        String fullyQualifiedName = "";
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            if (StringUtils.isBlank((CharSequence)(fullyQualifiedName = (String)arguments.get("fullyQualifiedName")))) {
                isError = true;
                resultContent = "fullyQualifiedName parameter is required";
            } else {
                customKeywordInfo = this.getCustomKeyword(fullyQualifiedName);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error retrieving custom keyword: " + e.getMessage();
        }
        structuredContent = this.createStructuredContentResultForGetCustomKeywordTool(fullyQualifiedName, customKeywordInfo.getPackageName(), customKeywordInfo.getClassName(), customKeywordInfo.getFileContent(), customKeywordInfo.getRelativeFilePath());
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private CustomKeywordInfoModel getCustomKeyword(String fullyQualifiedName) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        String projectRoot = project.getFolderLocation();
        FullyQualifiedNameInfoModel fullyQualifiedNameInfo = this.getFullyQualifiedNameInfo(fullyQualifiedName);
        Path keywordFilePath = Paths.get(projectRoot, new String[0]).resolve(fullyQualifiedNameInfo.getRelativeFilePath());
        String keywordRelativePath = Paths.get(projectRoot, new String[0]).relativize(keywordFilePath).toString().replace("\\", "/");
        if (!Files.exists(keywordFilePath, new LinkOption[0])) {
            throw new Exception("Custom keyword '" + fullyQualifiedName + "' not found at relative path: " + keywordRelativePath);
        }
        String keywordScriptContent = FileUtils.readFileToString((File)keywordFilePath.toFile(), (Charset)StandardCharsets.UTF_8);
        return new CustomKeywordInfoModel(fullyQualifiedNameInfo.getPackageName(), fullyQualifiedNameInfo.getClassName(), keywordScriptContent, keywordRelativePath);
    }

    private Map<String, Object> createStructuredContentResultForGetCustomKeywordTool(String fullyQualifiedName, String packageName, String className, String keywordFileContent, String keywordRelativePath) {
        HashMap<String, Object> structuredContent = new HashMap<String, Object>();
        structuredContent.put("fullyQualifiedName", fullyQualifiedName);
        structuredContent.put("packageName", packageName);
        structuredContent.put("className", className);
        structuredContent.put("keywordFileContent", keywordFileContent);
        structuredContent.put("keywordRelativePath", keywordRelativePath);
        return structuredContent;
    }

    public McpServerFeatures.SyncToolSpecification updateCustomKeywordTool() {
        McpSchema.Tool tool = new McpSchema.Tool("updateCustomKeyword", "Update Custom Keyword", "Updates an existing custom keyword class file in current Katalon Studio project.", this.createInputSchemaForUpdateCustomKeywordTool(), this.createOutputSchemaForCreateNewOrUpdateCustomKeywordTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.updateCustomKeywordToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult updateCustomKeywordToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        String updatedKeywordPath = "";
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String fullyQualifiedName = (String)arguments.get("fullyQualifiedName");
            String keywordFileContent = (String)arguments.get("keywordFileContent");
            if (StringUtils.isBlank((CharSequence)fullyQualifiedName)) {
                isError = true;
                resultContent = "fullyQualifiedName parameter is required";
            } else {
                updatedKeywordPath = this.updateCustomKeyword(fullyQualifiedName, keywordFileContent);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error updating custom keyword: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateNewOrUpdateCustomKeyword(updatedKeywordPath);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private String updateCustomKeyword(String fullyQualifiedName, String keywordFileContent) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        String projectRoot = project.getFolderLocation();
        FullyQualifiedNameInfoModel currentFullyQualifiedNameInfo = this.getFullyQualifiedNameInfo(fullyQualifiedName);
        Path currentKeywordRelativeFilePath = currentFullyQualifiedNameInfo.getRelativeFilePath();
        Path currentKeywordFilePath = Paths.get(projectRoot, new String[0]).resolve(currentKeywordRelativeFilePath);
        if (!Files.exists(currentKeywordFilePath, new LinkOption[0])) {
            throw new Exception("Custom keyword '" + fullyQualifiedName + "' not found at relative path: " + currentKeywordRelativeFilePath.toString().replace("\\", "/"));
        }
        if (keywordFileContent != null) {
            FileUtils.writeStringToFile((File)currentKeywordFilePath.toFile(), (String)keywordFileContent, (Charset)StandardCharsets.UTF_8);
            GroovyRefreshUtil.refreshFile((String)currentKeywordRelativeFilePath.toString(), (ProjectEntity)project);
        }
        return currentKeywordRelativeFilePath.toString().replace("\\", "/");
    }

    private FullyQualifiedNameInfoModel getFullyQualifiedNameInfo(String fullyQualifiedName) {
        String className;
        String packageName = "";
        int lastDotIndex = fullyQualifiedName.lastIndexOf(46);
        if (lastDotIndex != -1) {
            packageName = fullyQualifiedName.substring(0, lastDotIndex);
            className = fullyQualifiedName.substring(lastDotIndex + 1);
        } else {
            className = fullyQualifiedName;
        }
        String packagePath = StringUtils.isBlank((CharSequence)packageName) ? "" : packageName.replace(".", "/");
        Path filePath = Paths.get(KEYWORD_SOURCE_FOLDER_NAME, packagePath, className + ".groovy");
        return new FullyQualifiedNameInfoModel(packageName, className, filePath);
    }

    private void openKeywordInEditor(String keywordRelativeLocation, ProjectEntity projectEntity) {
        try {
            KeywordTreeEntity keywordTreeEntity = TreeEntityUtil.getKeywordTreeEntity((String)keywordRelativeLocation, (ProjectEntity)projectEntity);
            ICompilationUnit createdCompilationUnit = (ICompilationUnit)keywordTreeEntity.getObject();
            this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", (Object)createdCompilationUnit);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to open keyword in editor");
        }
    }

    private McpSchema.JsonSchema createInputSchemaForCreateCustomKeywordTool() {
        Map<String, Map<String, String>> properties = Map.of("className", Map.of("type", "string", "description", "The name of the custom keyword class to create. Rules: Cannot start with a number, cannot contain spaces or special characters (only letters, numbers, and underscores allowed, must start with letter or underscore)."), "packageName", Map.of("type", "string", "description", "The package name where the keyword should be created (e.g., 'com.example.keywords'). Rules: Cannot start with a number, cannot contain spaces, cannot have special characters (except dots), cannot start or end with a dot. Optional, defaults to root package if not provided."), "keywordFileContent", Map.of("type", "string", "description", "The file content for the custom keyword class. Should contain @Keyword annotated methods."));
        return new McpSchema.JsonSchema("object", properties, List.of("className", "keywordFileContent"), null, null, null);
    }

    private Map<String, Object> createOutputSchemaForCreateNewOrUpdateCustomKeywordTool() {
        return Map.of("type", "object", "properties", Map.of("keywordRelativePath", Map.of("type", "string", "description", "Keyword file path relative to the project root (e.g., 'Keywords/com/example/MyKeyword.groovy').")), "required", List.of("keywordRelativePath"));
    }

    private McpSchema.JsonSchema createInputSchemaForGetCustomKeywordTool() {
        Map<String, Map<String, String>> properties = Map.of("fullyQualifiedName", Map.of("type", "string", "description", "The fully qualified class name of the custom keyword to read (e.g., 'com.example.keywords.MyKeyword' or 'MyKeyword' for root package)."));
        return new McpSchema.JsonSchema("object", properties, List.of("fullyQualifiedName"), null, null, null);
    }

    private Map<String, Object> createOutputSchemaForGetCustomKeywordTool() {
        return Map.of("type", "object", "properties", Map.of("fullyQualifiedName", Map.of("type", "string", "description", "The fully qualified class name of the custom keyword."), "packageName", Map.of("type", "string", "description", "The package name of the custom keyword (empty string for root package)."), "className", Map.of("type", "string", "description", "The class name of the custom keyword."), "keywordFileContent", Map.of("type", "string", "description", "The file content of the custom keyword class."), "keywordRelativePath", Map.of("type", "string", "description", "The relative path to the keyword file from project root.")), "required", List.of("fullyQualifiedName", "packageName", "className", "keywordFileContent", "keywordRelativePath"));
    }

    private McpSchema.JsonSchema createInputSchemaForUpdateCustomKeywordTool() {
        Map<String, Map<String, String>> properties = Map.of("fullyQualifiedName", Map.of("type", "string", "description", "The current fully qualified class name of the custom keyword to update (e.g., 'com.example.keywords.MyKeyword' or 'MyKeyword' for root package)."), "keywordFileContent", Map.of("type", "string", "description", "The new file content for the custom keyword class (optional, null to keep current)."));
        return new McpSchema.JsonSchema("object", properties, List.of("fullyQualifiedName"), null, null, null);
    }

    private String validatePackageName(String packageName) {
        String[] parts;
        if (packageName.startsWith(".") || packageName.endsWith(".")) {
            return "Package name cannot start or end with a dot";
        }
        String[] stringArray = parts = packageName.split("\\.");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (StringUtils.isBlank((CharSequence)part)) {
                return "Package name cannot contain consecutive dots or empty segments";
            }
            if (part.length() > 0 && Character.isDigit(part.charAt(0))) {
                return "Package name segment '" + part + "' cannot start with a number";
            }
            if (part.contains(" ")) {
                return "Package name cannot contain spaces";
            }
            if (!part.matches("^[a-zA-Z_][a-zA-Z0-9_]*$")) {
                return "Package name segment '" + part + "' contains invalid characters. Only letters, numbers, and underscores are allowed, and it must start with a letter or underscore";
            }
            ++n2;
        }
        return null;
    }

    private String validateClassName(String className) {
        if (Character.isDigit(className.charAt(0))) {
            return "Class name cannot start with a number";
        }
        if (className.contains(" ")) {
            return "Class name cannot contain spaces";
        }
        if (!className.matches("^[a-zA-Z_][a-zA-Z0-9_]*$")) {
            return "Class name contains invalid characters. Only letters, numbers, and underscores are allowed, and it must start with a letter or underscore";
        }
        return null;
    }
}

