/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.ai.mcp.tools.schema.CsvFileSchema;
import com.kms.katalon.ai.mcp.tools.schema.DatabaseDataSchema;
import com.kms.katalon.ai.mcp.tools.schema.ExcelFileSchema;
import com.kms.katalon.ai.mcp.tools.schema.InternalDataSchema;
import com.kms.katalon.ai.mcp.tools.schema.TestDataSchema;
import com.kms.katalon.ai.mcp.tools.schema.TestDataSchemaFactory;
import com.kms.katalon.ai.utils.McpToolsUtil;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testdata.InternalDataColumnEntity;
import com.kms.katalon.entity.testdata.events.TestDataUpdatedEvent;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataTools {
    @Inject
    private IEventBroker eventBroker;
    private static final Logger logger = LoggerFactory.getLogger(TestDataTools.class);
    private static final String TEST_DATA_FOLDER_ROOT = "Data Files";
    private static final String DATA_TABLE_FORMAT_DESCRIPTION = "The dataTable parameter is optional and must follow a specific JSON array format where each element represents a row of data. Each row object contains column-name to value mappings. FORMAT: [{\"column1\": \"value1\", \"column2\": \"value2\"}, {\"column1\": \"value3\", \"column2\": \"value4\"}]. EXAMPLE: [{\"username\": \"user1\", \"password\": \"pass1\"}, {\"username\": \"user2\", \"password\": \"pass2\"}]. Important rules: (1) Each array element is an object representing one data row. (2) Object keys are column names, object values are cell values. (3) ALL rows MUST have exactly the same keys (column names). (4) Column names are extracted from the first row. (5) If dataTable is omitted or empty [], an empty test data will be created. VALID: [{\"name\":\"John\",\"age\":\"30\"},{\"name\":\"Jane\",\"age\":\"25\"}]. INVALID: [{\"name\":\"John\"},{\"name\":\"Jane\",\"age\":\"25\"}] (inconsistent columns).";

    public McpServerFeatures.SyncToolSpecification getTestDataListTool() {
        McpSchema.Tool tool = new McpSchema.Tool("getTestDataList", "Get Test Data List", "Retrieves a list of all test data entities available in the current Katalon Studio project", this.createEmptyInputSchema(), this.createOutputSchemaForGetTestDataListTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.getTestDataListToolCallHandler()).build();
    }

    private McpSchema.CallToolResult getTestDataListToolCallHandler() {
        boolean isError = false;
        Object resultContent = "";
        List<Object> testDataList = new ArrayList();
        try {
            testDataList = this.getTestDataList();
            resultContent = JsonUtil.toJson(testDataList);
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error retrieving test data list: " + e.getMessage();
        }
        Map structuredContent = Map.of("results", testDataList);
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    public List<Map<String, Object>> getTestDataList() throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        ArrayList<Map<String, Object>> testDataInfos = new ArrayList<Map<String, Object>>();
        FolderEntity testDataRoot = FolderController.getInstance().getTestDataRoot(project);
        List descendantEntities = FolderController.getInstance().getAllDescentdantEntities(testDataRoot);
        if (descendantEntities == null || descendantEntities.isEmpty()) {
            return testDataInfos;
        }
        for (Object entity : descendantEntities) {
            if (!(entity instanceof DataFileEntity)) continue;
            DataFileEntity testData = (DataFileEntity)entity;
            TestDataSchema schema = this.createTestDataSchema(testData);
            testDataInfos.add(schema.toDataMap());
        }
        return testDataInfos;
    }

    private TestDataSchema createTestDataSchema(DataFileEntity testData) {
        String testDataId = testData.getIdForDisplay();
        String testDataName = testData.getName();
        String description = testData.getDescription();
        String location = testData.getLocation();
        switch (testData.getDriver()) {
            case InternalData: {
                ArrayList<String> columnNames = new ArrayList<String>();
                for (InternalDataColumnEntity column : testData.getInternalDataColumns()) {
                    columnNames.add(column.getName());
                }
                return new InternalDataSchema(testDataId, testDataName, description, location, columnNames);
            }
            case ExcelFile: {
                return new ExcelFileSchema(testDataId, testDataName, description, location, testData.getDataSourceUrl(), testData.isContainsHeaders(), testData.getSheetName());
            }
            case CSV: {
                return new CsvFileSchema(testDataId, testDataName, description, location, testData.getDataSourceUrl(), testData.isContainsHeaders(), testData.getCsvSeperator());
            }
            case DBData: {
                return new DatabaseDataSchema(testDataId, testDataName, description, location, testData.getQuery());
            }
        }
        throw new IllegalArgumentException("Unknown driver type: " + String.valueOf(testData.getDriver()));
    }

    public McpServerFeatures.SyncToolSpecification getInternalTestDataDetailsTool() {
        McpSchema.Tool tool = new McpSchema.Tool("getInternalTestDataDetails", "Get Internal Test Data Details", "Retrieves detailed information about a specific internal test data entity, including its data table content", this.createInputSchemaForGetInternalTestDataDetailsTool(), this.createOutputSchemaForGetInternalTestDataDetailsTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.getInternalTestDataDetailsToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult getInternalTestDataDetailsToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        Map<Object, Object> structuredContent = new HashMap();
        try {
            String testDataId;
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            if (StringUtils.isBlank((CharSequence)(testDataId = (String)arguments.get("testDataId")))) {
                isError = true;
                resultContent = "testDataId parameter is required";
            } else {
                structuredContent = this.getInternalTestDataDetails(testDataId);
                resultContent = JsonUtil.toJson(structuredContent);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error retrieving internal test data details: " + e.getMessage();
            structuredContent = new HashMap();
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private Map<String, Object> getInternalTestDataDetails(String testDataId) throws Exception {
        DataFileEntity testData;
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        String normalizedTestDataId = McpToolsUtil.normalizeData(testDataId, TEST_DATA_FOLDER_ROOT);
        TestDataController testDataController = TestDataController.getInstance();
        try {
            testData = testDataController.getTestDataByDisplayId(normalizedTestDataId);
        }
        catch (Exception e) {
            throw new Exception("Failed to retrieve test data with ID '" + normalizedTestDataId + "': " + e.getMessage(), e);
        }
        if (testData == null) {
            throw new Exception("Test data with ID '" + normalizedTestDataId + "' not found.");
        }
        if (testData.getDriver() != DataFileEntity.DataFileDriverType.InternalData) {
            throw new Exception("Test data '" + normalizedTestDataId + "' is not an internal data type. Only internal data can be retrieved with this tool.");
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("testDataId", testData.getIdForDisplay());
        response.put("testDataName", testData.getName());
        response.put("description", testData.getDescription() != null ? testData.getDescription() : "");
        response.put("location", testData.getLocation() != null ? testData.getLocation() : "");
        response.put("driverType", testData.getDriver().toString());
        List<Map<String, Object>> dataTable = this.convertInternalDataToDataTable(testData);
        response.put("dataTable", dataTable);
        return response;
    }

    private List<Map<String, Object>> convertInternalDataToDataTable(DataFileEntity testData) {
        ArrayList<Map<String, Object>> dataTable = new ArrayList<Map<String, Object>>();
        List columns = testData.getInternalDataColumns();
        if (columns == null || columns.isEmpty()) {
            return dataTable;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (InternalDataColumnEntity column : columns) {
            columnNames.add(column.getName());
        }
        List rowsData = testData.getData();
        if (rowsData == null || rowsData.isEmpty()) {
            return dataTable;
        }
        for (List rowData : rowsData) {
            HashMap<String, String> rowMap = new HashMap<String, String>();
            int i = 0;
            while (i < columnNames.size() && i < rowData.size()) {
                Object value = rowData.get(i);
                String cellValue = value == null || "null".equals(value) ? "" : value.toString();
                rowMap.put((String)columnNames.get(i), cellValue);
                ++i;
            }
            dataTable.add(rowMap);
        }
        return dataTable;
    }

    public McpServerFeatures.SyncToolSpecification createInternalTestDataTool() {
        McpSchema.Tool tool = new McpSchema.Tool("createInternalTestData", "Create Internal Test Data", "Creates a new internal test data entity in the current Katalon Studio project. NOTES: The dataTable parameter is optional and must follow a specific JSON array format where each element represents a row of data. Each row object contains column-name to value mappings. FORMAT: [{\"column1\": \"value1\", \"column2\": \"value2\"}, {\"column1\": \"value3\", \"column2\": \"value4\"}]. EXAMPLE: [{\"username\": \"user1\", \"password\": \"pass1\"}, {\"username\": \"user2\", \"password\": \"pass2\"}]. Important rules: (1) Each array element is an object representing one data row. (2) Object keys are column names, object values are cell values. (3) ALL rows MUST have exactly the same keys (column names). (4) Column names are extracted from the first row. (5) If dataTable is omitted or empty [], an empty test data will be created. VALID: [{\"name\":\"John\",\"age\":\"30\"},{\"name\":\"Jane\",\"age\":\"25\"}]. INVALID: [{\"name\":\"John\"},{\"name\":\"Jane\",\"age\":\"25\"}] (inconsistent columns).", this.createInputSchemaForCreateOrUpdateInternalTestDataTool(false), this.createOutputSchemaForCreateOrUpdateInternalTestDataTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.createInternalTestDataToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult createInternalTestDataToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        DataFileEntity newTestData = null;
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String testDataName = (String)arguments.get("testDataName");
            String description = (String)arguments.get("description");
            String folderPath = (String)arguments.get("folderPath");
            List<Map<String, Object>> dataTable = this.parseDataTableParameter(arguments.get("dataTable"));
            if (StringUtils.isBlank((CharSequence)testDataName)) {
                isError = true;
                resultContent = "testDataName parameter is required";
            } else {
                newTestData = this.createInternalTestData(testDataName, description, folderPath, dataTable);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error creating internal test data: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateOrUpdateInternalTestDataTool(newTestData);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private DataFileEntity createInternalTestData(String testDataName, String description, String folderPath, List<Map<String, Object>> dataTable) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        this.validateTestDataName(testDataName);
        String projectRoot = project.getFolderLocation();
        Object newTestDataFolderPath = "";
        FolderEntity testDataRootFolder = FolderController.getInstance().getTestDataRoot(project);
        if (StringUtils.isNotBlank((CharSequence)folderPath) && (folderPath.equals(TEST_DATA_FOLDER_ROOT) || folderPath.startsWith("Data Files/"))) {
            newTestDataFolderPath = folderPath;
        } else {
            newTestDataFolderPath = testDataRootFolder.getIdForDisplay();
            if (StringUtils.isNotBlank((CharSequence)folderPath)) {
                newTestDataFolderPath = (String)newTestDataFolderPath + "/" + folderPath;
            }
        }
        Path testDataFilePath = Paths.get(projectRoot, new String[]{newTestDataFolderPath});
        if (!Files.exists(testDataFilePath, new LinkOption[0])) {
            Files.createDirectories(testDataFilePath, new FileAttribute[0]);
        }
        FolderEntity folderToCreateTestData = FolderController.getInstance().getFolderByDisplayId(project, (String)newTestDataFolderPath);
        TestDataController testDataController = TestDataController.getInstance();
        List existingTestDataList = testDataController.getDataFileFromParentFolder(folderToCreateTestData);
        if (existingTestDataList != null) {
            for (DataFileEntity existingTestData : existingTestDataList) {
                if (!existingTestData.getName().equals(testDataName.trim())) continue;
                throw new Exception("Test data with name '" + testDataName.trim() + "' already exists in folder '" + (String)newTestDataFolderPath + "'");
            }
        }
        DataFileEntity newTestData = testDataController.newTestDataWithoutSave(folderToCreateTestData, testDataName.trim());
        newTestData.setDriver(DataFileEntity.DataFileDriverType.InternalData);
        newTestData.setDescription(description != null ? description.trim() : "");
        if (dataTable != null && !dataTable.isEmpty()) {
            this.applyDataTableToTestData(newTestData, dataTable);
        } else {
            newTestData.setInternalDataColumns(new ArrayList());
            newTestData.setData(new ArrayList());
            newTestData.setEncriptData(new ArrayList());
            newTestData.setContainsHeaders(true);
        }
        DataFileEntity newTestDataCreated = testDataController.saveNewTestData(newTestData);
        this.refreshTestDataInExplorer(newTestDataCreated);
        this.openTestDataInEditor(newTestDataCreated);
        return newTestDataCreated;
    }

    private Map<String, Object> createStructuredContentResultForCreateOrUpdateInternalTestDataTool(DataFileEntity testData) {
        HashMap<String, Object> structuredContent = new HashMap<String, Object>();
        structuredContent.put("testDataId", testData != null ? testData.getIdForDisplay() : "");
        return structuredContent;
    }

    private void refreshTestDataInExplorer(DataFileEntity dataFile) {
        try {
            FolderTreeEntity parentTreeEntity = TreeEntityUtil.getFolderTreeEntity((FolderEntity)dataFile.getParentFolder());
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)new TestDataTreeEntity(dataFile, (ITreeEntity)parentTreeEntity));
        }
        catch (Exception e) {
            logger.error("Failed to refresh test data in explorer", (Throwable)e);
        }
    }

    private void openTestDataInEditor(DataFileEntity dataFile) {
        try {
            this.eventBroker.post("TESTDATA/OPEN", (Object)dataFile);
        }
        catch (Exception e) {
            logger.error("Failed to open test data in editor", (Throwable)e);
        }
    }

    private void refreshTestDataEditor(DataFileEntity dataFile) {
        try {
            TestDataUpdatedEvent event = new TestDataUpdatedEvent(dataFile.getId(), (FileEntity)dataFile, TestDataUpdatedEvent.TriggeredBy.CONTENT_MODIFICATION);
            this.eventBroker.post("TESTDATA/UPDATE", (Object)event);
        }
        catch (Exception e) {
            logger.error("Failed to refresh test data editor", (Throwable)e);
        }
    }

    private void validateTestDataName(String testDataName) throws Exception {
        try {
            EntityService.getInstance().validateName(testDataName);
        }
        catch (Exception exception) {
            throw new Exception("Invalid test data name");
        }
    }

    private List<Map<String, Object>> parseDataTableParameter(Object dataTableParam) throws Exception {
        if (dataTableParam == null) {
            return null;
        }
        if (dataTableParam instanceof String) {
            String dataTableJson = (String)dataTableParam;
            if (StringUtils.isNotBlank((CharSequence)dataTableJson)) {
                try {
                    Type listType = new TypeToken<List<Map<String, Object>>>(){}.getType();
                    return (List)JsonUtil.fromJson((String)dataTableJson, (Type)listType);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("dataTable JSON parsing failed. Ensure it's a valid JSON array format: " + e.getMessage(), e);
                }
            }
        } else if (dataTableParam instanceof List) {
            return (List)dataTableParam;
        }
        return null;
    }

    private void applyDataTableToTestData(DataFileEntity testData, List<Map<String, Object>> dataTable) {
        if (dataTable == null) {
            return;
        }
        if (dataTable.isEmpty()) {
            testData.setInternalDataColumns(new ArrayList());
            testData.setData(new ArrayList());
            testData.setEncriptData(new ArrayList());
            testData.setContainsHeaders(true);
            return;
        }
        List<Map<String, Object>> dataRows = dataTable;
        Map<String, Object> firstRow = dataRows.get(0);
        ArrayList<String> columnNames = new ArrayList<String>(firstRow.keySet());
        ArrayList<InternalDataColumnEntity> internalDataColumns = new ArrayList<InternalDataColumnEntity>();
        int i = 0;
        while (i < columnNames.size()) {
            String columnName = (String)columnNames.get(i);
            InternalDataColumnEntity column = new InternalDataColumnEntity();
            column.setName(columnName);
            column.setColumnIndex(i);
            column.setSize(dataRows.size());
            internalDataColumns.add(column);
            ++i;
        }
        testData.setInternalDataColumns(internalDataColumns);
        ArrayList rowsData = new ArrayList();
        int rowIndex = 0;
        while (rowIndex < dataRows.size()) {
            Map<String, Object> row = dataRows.get(rowIndex);
            ArrayList<Object> rowData = new ArrayList<Object>();
            for (String columnName : columnNames) {
                Object value = row.get(columnName);
                value = StringUtils.isBlank((CharSequence)(value != null ? value.toString() : null)) ? "null" : value.toString();
                rowData.add(value);
            }
            rowsData.add(rowData);
            ++rowIndex;
        }
        testData.setData(rowsData);
        testData.setEncriptData(rowsData);
        testData.setContainsHeaders(true);
    }

    public McpServerFeatures.SyncToolSpecification updateInternalTestDataTool() {
        McpSchema.Tool tool = new McpSchema.Tool("updateInternalTestData", "Update Internal Test Data", "Updates an existing internal test data entity in the current Katalon Studio project. IMPORTANT: MUST USE getInternalTestDataDetails tool FIRST to understand the structure of the current Internal Test Data before updating. This helps you see the existing columns, data format, and current content to ensure your updates are compatible. NOTES: The dataTable parameter is optional and must follow a specific JSON array format where each element represents a row of data. Each row object contains column-name to value mappings. FORMAT: [{\"column1\": \"value1\", \"column2\": \"value2\"}, {\"column1\": \"value3\", \"column2\": \"value4\"}]. EXAMPLE: [{\"username\": \"user1\", \"password\": \"pass1\"}, {\"username\": \"user2\", \"password\": \"pass2\"}]. Important rules: (1) Each array element is an object representing one data row. (2) Object keys are column names, object values are cell values. (3) ALL rows MUST have exactly the same keys (column names). (4) Column names are extracted from the first row. (5) If dataTable is omitted or empty [], an empty test data will be created. VALID: [{\"name\":\"John\",\"age\":\"30\"},{\"name\":\"Jane\",\"age\":\"25\"}]. INVALID: [{\"name\":\"John\"},{\"name\":\"Jane\",\"age\":\"25\"}] (inconsistent columns).", this.createInputSchemaForCreateOrUpdateInternalTestDataTool(true), this.createOutputSchemaForCreateOrUpdateInternalTestDataTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.updateInternalTestDataToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult updateInternalTestDataToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        DataFileEntity updatedTestData = null;
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String testDataId = (String)arguments.get("testDataId");
            String description = (String)arguments.get("description");
            List<Map<String, Object>> dataTable = this.parseDataTableParameter(arguments.get("dataTable"));
            if (StringUtils.isBlank((CharSequence)testDataId)) {
                isError = true;
                resultContent = "testDataId parameter is required";
            } else {
                updatedTestData = this.updateInternalTestData(testDataId, description, dataTable);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error updating internal test data: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateOrUpdateInternalTestDataTool(updatedTestData);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private DataFileEntity updateInternalTestData(String testDataId, String description, List<Map<String, Object>> dataTable) throws Exception {
        DataFileEntity existingTestData;
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        String normalizedTestDataId = McpToolsUtil.normalizeData(testDataId, TEST_DATA_FOLDER_ROOT);
        TestDataController testDataController = TestDataController.getInstance();
        try {
            existingTestData = testDataController.getTestDataByDisplayId(normalizedTestDataId);
        }
        catch (Exception e) {
            throw new Exception("Failed to retrieve test data with ID '" + normalizedTestDataId + "': " + e.getMessage(), e);
        }
        if (existingTestData == null) {
            throw new Exception("Test data with ID '" + normalizedTestDataId + "' not found.");
        }
        if (existingTestData.getDriver() != DataFileEntity.DataFileDriverType.InternalData) {
            throw new Exception("Test data '" + normalizedTestDataId + "' is not an internal data type. Only internal data can be updated with this tool.");
        }
        if (description != null) {
            existingTestData.setDescription(description.trim());
        }
        if (dataTable != null) {
            this.applyDataTableToTestData(existingTestData, dataTable);
        }
        testDataController.updateTestData(existingTestData, existingTestData.getParentFolder());
        this.refreshTestDataInExplorer(existingTestData);
        this.refreshTestDataEditor(existingTestData);
        return existingTestData;
    }

    private McpSchema.JsonSchema createEmptyInputSchema() {
        return new McpSchema.JsonSchema("object", Map.of(), List.of(), null, null, null);
    }

    private McpSchema.JsonSchema createInputSchemaForGetInternalTestDataDetailsTool() {
        HashMap<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>();
        properties.put("testDataId", Map.of("type", "string", "description", "ID of the test data entity to retrieve (required, e.g., 'Data Files/LoginData')"));
        return new McpSchema.JsonSchema("object", properties, List.of("testDataId"), null, null, null);
    }

    private Map<String, Object> createOutputSchemaForGetInternalTestDataDetailsTool() {
        return Map.of("type", "object", "properties", Map.of("testDataId", Map.of("type", "string", "description", "The ID of the test data entity (e.g., 'Data Files/LoginData')"), "testDataName", Map.of("type", "string", "description", "The name of the test data entity"), "description", Map.of("type", "string", "description", "Description of the test data entity"), "location", Map.of("type", "string", "description", "File system location of the test data"), "driverType", Map.of("type", "string", "description", "Type of test data driver (e.g., 'InternalData')"), "dataTable", Map.of("type", "array", "description", "The data table as a JSON array of row objects. Each row is a map of column names to values.", "items", Map.of("type", "object", "description", "A single row of data where each key is a column name and value is cell value", "additionalProperties", true, "properties", Map.of()))), "required", List.of("testDataId", "testDataName", "description", "location", "driverType", "dataTable"));
    }

    private McpSchema.JsonSchema createInputSchemaForCreateOrUpdateInternalTestDataTool(boolean isUpdate) {
        ArrayList<String> requiredFields = new ArrayList<String>();
        HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
        properties.put("description", Map.of("type", "string", "description", "Description of the test data entity (optional)"));
        properties.put("dataTable", Map.of("type", "array", "description", DATA_TABLE_FORMAT_DESCRIPTION, "items", Map.of("type", "object", "description", "An object representing a single row of data. Each key is a column name and value", "additionalProperties", true, "properties", Map.of())));
        if (isUpdate) {
            properties.put("testDataId", Map.of("type", "string", "description", "ID of the test data entity to update (required, e.g., 'Data Files/LoginData')"));
            requiredFields.add("testDataId");
        } else {
            properties.put("testDataName", Map.of("type", "string", "description", "Name of the test data entity to create (required). Test Data Name must start with English letters or numbers, and can mix up with space or any of the following characters: ( ) . , _ -"));
            properties.put("folderPath", Map.of("type", "string", "description", "Path to the folder where the test data should be created (optional, defaults to test data root, e.g., 'Data Files/LoginData')"));
            requiredFields.add("testDataName");
        }
        return new McpSchema.JsonSchema("object", properties, requiredFields, null, null, null);
    }

    private Map<String, Object> createOutputSchemaForGetTestDataListTool() {
        return Map.of("type", "object", "properties", Map.of("results", Map.of("type", "array", "description", "List of test data entities in the current Katalon Studio project", "items", TestDataSchemaFactory.createTestDataItemsSchema())), "required", List.of("results"));
    }

    private Map<String, Object> createOutputSchemaForCreateOrUpdateInternalTestDataTool() {
        return Map.of("type", "object", "properties", Map.of("testDataId", Map.of("type", "string", "description", "The ID of the test data entity for display (e.g., 'Data Files/LoginData')")), "required", List.of("testDataId"));
    }
}

