/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools;

import com.kms.katalon.ai.mcp.enums.BrowserType;
import com.kms.katalon.ai.mcp.enums.LocatorStrategy;
import com.kms.katalon.ai.mcp.tools.schema.WebUIInputSchema;
import com.kms.katalon.ai.mcp.tools.schema.WebUIOutputSchema;
import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.aut.WebAUT;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.core.webui.driver.DriverBuilderFactory;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.session.ExecutionSession;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.execution.webui.util.WebUIExecutionUtil;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebUITools {
    private static final int DEFAULT_TIMEOUT_SECONDS = 10;

    public McpServerFeatures.SyncToolSpecification getAvailableExecutionSessionsTool() {
        McpSchema.Tool tool = new McpSchema.Tool("getAvailableExecutionSessions", "Get Available Execution Sessions", "Retrieves a list of all available execution sessions (browser instances) that are currently running and available. Enables interaction with existing browser sessions for Web UI testing", WebUIInputSchema.createSchemaForGetAvailableExecutionSessionsTool(), WebUIOutputSchema.createSchemaForGetAvailableExecutionSessionsTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.getAvailableExecutionSessionsCallHandler()).build();
    }

    private McpSchema.CallToolResult getAvailableExecutionSessionsCallHandler() {
        boolean isError = false;
        Object resultContent = "";
        ArrayList<ExecutionSession> executionSessions = new ArrayList();
        try {
            executionSessions = this.getAvailableExecutionSessions();
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error retrieving available execution sessions: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForGetAvailableExecutionSessionsTool(executionSessions);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private List<ExecutionSession> getAvailableExecutionSessions() {
        ArrayList<ExecutionSession> sessionList = new ArrayList<ExecutionSession>();
        ExecutionSessionSocketServer socketServer = ExecutionSessionSocketServer.getInstance();
        List availableSessions = socketServer.getAllAvailableExecutionSessions();
        if (availableSessions == null || availableSessions.isEmpty()) {
            return sessionList;
        }
        for (ExecutionSession session : availableSessions) {
            BrowserType browserType = BrowserType.fromBrowserTypeName(session.getDriverTypeName());
            if (browserType == null) continue;
            sessionList.add(session);
        }
        return sessionList;
    }

    private Map<String, Object> createStructuredContentResultForGetAvailableExecutionSessionsTool(List<ExecutionSession> executionSessions) {
        ArrayList<Map<String, Object>> sessionList = new ArrayList<Map<String, Object>>();
        for (ExecutionSession session : executionSessions) {
            BrowserType browserType = BrowserType.fromBrowserTypeName(session.getDriverTypeName());
            if (browserType == null) continue;
            Map<String, Object> sessionInfo = this.createStructuredContentResultForExecutionSession(session);
            sessionList.add(sessionInfo);
        }
        return Map.of("results", sessionList);
    }

    public McpServerFeatures.SyncToolSpecification navigateToUrlTool() {
        McpSchema.Tool tool = new McpSchema.Tool("webUINavigate", "Navigate to URL", "Navigates to a specified URL. If sessionId is provided, navigates the existing browser session to the URL. If sessionId is empty, opens a new browser with the specified browser type and browser options (optional), then navigates to the URL", WebUIInputSchema.createSchemaForNavigateToUrlTool(), WebUIOutputSchema.createSchemaForNavigateToUrlTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.navigateToUrlCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult navigateToUrlCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        ExecutionSession session = null;
        String url = "";
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String sessionId = (String)arguments.get("sessionId");
            url = (String)arguments.get("url");
            if (StringUtils.isBlank((CharSequence)url)) {
                throw new IllegalArgumentException("url parameter is required");
            }
            URL navigateUrl = PathUtil.getUrl((String)url, (String)"http");
            url = navigateUrl.toString();
            if (StringUtils.isNotBlank((CharSequence)sessionId)) {
                session = this.navigateExistingBrowser(sessionId, url);
            } else {
                String browserTypeStr = (String)arguments.get("browserType");
                Map options = (Map)arguments.get("options");
                if (StringUtils.isBlank((CharSequence)browserTypeStr)) {
                    browserTypeStr = BrowserType.CHROME.name();
                }
                session = this.openBrowserAndNavigate(browserTypeStr, url, options);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error navigating to URL: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForNavigateToUrlTool(session, url);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private ExecutionSession navigateExistingBrowser(String sessionId, String url) throws MalformedURLException, ConnectException, URISyntaxException {
        ExecutionSession session = this.getExecutionSessionById(sessionId);
        if (session == null || !session.isAvailable()) {
            throw new IllegalStateException("Session not found or not available: " + sessionId);
        }
        RemoteWebDriver driver = session.getExistingDriver();
        this.navigateToUrl((WebDriver)driver, url);
        session.checkStatusAndUpdateTitle();
        return session;
    }

    private ExecutionSession openBrowserAndNavigate(String browserTypeStr, String url, Map<String, Object> options) throws Exception {
        BrowserType browserType = this.parseBrowserType(browserTypeStr);
        if (browserType == null) {
            throw new IllegalArgumentException("Invalid browser type: " + browserTypeStr);
        }
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        WebUIDriverType webUIDriverType = this.convertBrowserTypeToWebUIDriverType(browserType);
        this.initializeExecutionEnvironment(webUIDriverType, project);
        MutableCapabilities capabilities = null;
        if (options != null && !options.isEmpty()) {
            capabilities = WebDriverPropertyUtil.toDesireCapabilities(options, (WebUIDriverType)webUIDriverType);
            if (capabilities == null) {
                capabilities = new MutableCapabilities();
                capabilities.asMap().putAll(options);
            }
        } else {
            capabilities = new MutableCapabilities();
        }
        WebDriver driver = DriverBuilderFactory.getDriverBuilder((WebUIDriverType)webUIDriverType).capabilities((Capabilities)capabilities).withAccessibilityTree(true).build();
        this.navigateToUrl(driver, url);
        ExecutionSession newSession = this.createExecutionSessionFromDriver((RemoteWebDriver)driver, webUIDriverType);
        newSession.checkStatusAndUpdateTitle();
        return newSession;
    }

    private void initializeExecutionEnvironment(WebUIDriverType webUIDriverType, ProjectEntity project) throws Exception {
        IDriverConnector driverConnector = WebUIExecutionUtil.getBrowserDriverConnector((WebUIDriverType)webUIDriverType, (String)project.getFolderLocation());
        if (driverConnector == null) {
            throw new IllegalStateException("Cannot get driver connector for browser type: " + String.valueOf(webUIDriverType));
        }
        HashMap<String, Map> executionProps = new HashMap<String, Map>();
        Map driverExecutionProps = ExecutionUtil.getDriverExecutionProperties((IDriverConnector)driverConnector);
        executionProps.put("drivers", driverExecutionProps);
        LinkedHashMap<String, HashMap<String, Map>> executionSettingMap = new LinkedHashMap<String, HashMap<String, Map>>();
        executionSettingMap.put("execution", executionProps);
        RunConfiguration.setExecutionSetting(executionSettingMap);
    }

    private void navigateToUrl(WebDriver driver, String url) {
        try {
            driver.navigate().to(url);
        }
        catch (Exception e) {
            String lowerCaseMessage;
            String errorMessage = e.getMessage();
            if (errorMessage != null && ((lowerCaseMessage = errorMessage.toLowerCase()).contains("err_name_not_resolved") || lowerCaseMessage.contains("name resolution") || lowerCaseMessage.contains("unknown host"))) {
                return;
            }
            throw e;
        }
    }

    private WebUIDriverType convertBrowserTypeToWebUIDriverType(BrowserType browserType) {
        switch (browserType) {
            case CHROME: {
                return WebUIDriverType.CHROME_DRIVER;
            }
            case CHROME_HEADLESS: {
                return WebUIDriverType.HEADLESS_DRIVER;
            }
            case FIREFOX: {
                return WebUIDriverType.FIREFOX_DRIVER;
            }
            case FIREFOX_HEADLESS: {
                return WebUIDriverType.FIREFOX_HEADLESS_DRIVER;
            }
            case EDGE_CHROMIUM: {
                return WebUIDriverType.EDGE_CHROMIUM_DRIVER;
            }
            case SAFARI: {
                return WebUIDriverType.SAFARI_DRIVER;
            }
        }
        throw new IllegalArgumentException("Unsupported browser type: " + String.valueOf((Object)browserType));
    }

    private BrowserType parseBrowserType(String browserType) {
        if (StringUtils.isBlank((CharSequence)browserType)) {
            return null;
        }
        try {
            return BrowserType.valueOf(browserType.trim().toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private ExecutionSession createExecutionSessionFromDriver(RemoteWebDriver driver, WebUIDriverType webUIDriverType) {
        String sessionId = driver.getSessionId().toString();
        String remoteUrl = DriverFactory.getWebDriverServerUrl((RemoteWebDriver)driver);
        String driverTypeName = webUIDriverType.toString();
        String webSocketUrl = DriverFactory.getWebSocketUrl((RemoteWebDriver)driver);
        ExecutionSession session = new ExecutionSession(sessionId, remoteUrl, driverTypeName, "", webSocketUrl);
        session.resume();
        ExecutionSessionSocketServer sessionServer = ExecutionSessionSocketServer.getInstance();
        if (sessionServer != null) {
            sessionServer.addExecutionSession(session);
            if (!sessionServer.getExecutionSessionWatcher().isAlive()) {
                if (sessionServer.getExecutionSessionWatcher().getState() == Thread.State.TERMINATED) {
                    sessionServer.newExecutionSessionWatcher();
                }
                sessionServer.setCanRun(true);
                sessionServer.getExecutionSessionWatcher().start();
            }
        }
        return session;
    }

    private ExecutionSession getExecutionSessionById(String sessionId) {
        List<ExecutionSession> sessions = this.getAvailableExecutionSessions();
        return sessions.stream().filter(session -> session.getSessionId().equals(sessionId)).findFirst().orElse(null);
    }

    private Map<String, Object> createStructuredContentResultForExecutionSession(ExecutionSession session) {
        String sessionId = "";
        String browserType = "";
        String pageTitle = "";
        if (session != null) {
            sessionId = session.getSessionId() != null ? session.getSessionId() : "";
            BrowserType bType = BrowserType.fromBrowserTypeName(session.getDriverTypeName());
            browserType = bType != null ? bType.name() : "";
            pageTitle = session.getTitle() != null ? session.getTitle() : "";
        }
        HashMap<String, Object> sessionInfo = new HashMap<String, Object>();
        sessionInfo.put("sessionId", sessionId);
        sessionInfo.put("browserType", browserType);
        sessionInfo.put("pageTitle", pageTitle);
        return sessionInfo;
    }

    private Map<String, Object> createStructuredContentResultForNavigateToUrlTool(ExecutionSession session, String url) {
        Map<String, Object> sessionInfo = this.createStructuredContentResultForExecutionSession(session);
        if (sessionInfo != null) {
            sessionInfo.put("url", url != null ? url : "");
        }
        return sessionInfo;
    }

    public McpServerFeatures.SyncToolSpecification takePageSourceTool() {
        McpSchema.Tool tool = new McpSchema.Tool("webUITakePageSource", "Take Page Source", "Retrieves the HTML page source from an existing browser session. Requires an active browser session (sessionId). If not existing browser session, use the webUINavigate tool to open a new browser. If url is provided, navigates to that URL first before taking the page source. If url is not provided, takes the page source of the current page", WebUIInputSchema.createSchemaForTakePageSourceTool(), WebUIOutputSchema.createSchemaForTakePageSourceTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.takePageSourceCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult takePageSourceCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        ExecutionSession session = null;
        String url = "";
        String pageSource = "";
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String sessionId = (String)arguments.get("sessionId");
            String requestUrl = (String)arguments.get("url");
            if (StringUtils.isBlank((CharSequence)sessionId)) {
                throw new IllegalArgumentException("sessionId parameter is required. Must have an existing browser session");
            }
            session = this.getExecutionSessionById(sessionId);
            if (session == null || !session.isAvailable()) {
                throw new IllegalStateException("Session not found or not available: " + sessionId);
            }
            RemoteWebDriver driver = session.getExistingDriver();
            if (StringUtils.isNotBlank((CharSequence)requestUrl)) {
                URL navigateUrl = PathUtil.getUrl((String)requestUrl, (String)"http");
                url = navigateUrl.toString();
                this.navigateToUrl((WebDriver)driver, url);
            } else {
                url = driver.getCurrentUrl();
            }
            WebAUT webAut = new WebAUT((WebDriver)driver);
            pageSource = webAut.getPageSource();
            session.checkStatusAndUpdateTitle();
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error taking page source: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForTakePageSourceTool(session, url, pageSource);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private Map<String, Object> createStructuredContentResultForTakePageSourceTool(ExecutionSession session, String url, String pageSource) {
        Map<String, Object> sessionInfo = this.createStructuredContentResultForExecutionSession(session);
        if (sessionInfo != null) {
            sessionInfo.put("url", url != null ? url : "");
            sessionInfo.put("pageSource", pageSource != null ? pageSource : "");
        }
        return sessionInfo;
    }

    public McpServerFeatures.SyncToolSpecification takeAccessibilityTreeSnapshotTool() {
        McpSchema.Tool tool = new McpSchema.Tool("webUITakeAccessibilityTreeSnapshot", "Take Accessibility Tree Snapshot", "Retrieves the accessibility tree snapshot from an existing browser session. Requires an active browser session (sessionId). If not existing browser session, use the webUINavigate tool to open a new browser. If url is provided, navigates to that URL first before taking the accessibility tree snapshot. If url is not provided, takes the accessibility tree snapshot of the current page. NOTE: This tool does NOT support Safari browser", WebUIInputSchema.createSchemaForTakeAccessibilityTreeSnapshotTool(), WebUIOutputSchema.createSchemaForTakeAccessibilityTreeSnapshotTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.takeAccessibilityTreeSnapshotCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult takeAccessibilityTreeSnapshotCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        ExecutionSession session = null;
        String url = "";
        String accessibilityTree = "";
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String sessionId = (String)arguments.get("sessionId");
            String requestUrl = (String)arguments.get("url");
            if (StringUtils.isBlank((CharSequence)sessionId)) {
                throw new IllegalArgumentException("sessionId parameter is required. Must have an existing browser session");
            }
            session = this.getExecutionSessionById(sessionId);
            if (session == null || !session.isAvailable()) {
                throw new IllegalStateException("Session not found or not available: " + sessionId);
            }
            BrowserType browserType = BrowserType.fromBrowserTypeName(session.getDriverTypeName());
            if (browserType == BrowserType.SAFARI) {
                throw new UnsupportedOperationException("Take Accessibility Tree Snapshot is not supported for Safari browser");
            }
            RemoteWebDriver driver = session.getExistingDriver();
            if (StringUtils.isNotBlank((CharSequence)requestUrl)) {
                URL navigateUrl = PathUtil.getUrl((String)requestUrl, (String)"http");
                url = navigateUrl.toString();
                this.navigateToUrl((WebDriver)driver, url);
            } else {
                url = driver.getCurrentUrl();
            }
            WebAUT webAut = new WebAUT((WebDriver)driver);
            accessibilityTree = webAut.getAccessibilityTree();
            if (accessibilityTree == null) {
                accessibilityTree = "";
            }
            session.checkStatusAndUpdateTitle();
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error taking accessibility tree snapshot: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForTakeAccessibilityTreeSnapshotTool(session, url, accessibilityTree);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private Map<String, Object> createStructuredContentResultForTakeAccessibilityTreeSnapshotTool(ExecutionSession session, String url, String accessibilityTree) {
        Map<String, Object> sessionInfo = this.createStructuredContentResultForExecutionSession(session);
        if (sessionInfo != null) {
            sessionInfo.put("url", url != null ? url : "");
            sessionInfo.put("accessibilityTree", accessibilityTree != null ? accessibilityTree : "");
        }
        return sessionInfo;
    }

    public McpServerFeatures.SyncToolSpecification setTextTool() {
        McpSchema.Tool tool = new McpSchema.Tool("webUISetText", "Set Text", "Sets text in an input element on the current page. Clears any existing text in the element before setting the new text. Requires an active browser session (sessionId). If url is provided, navigates to that URL first before setting the text. If url is not provided, performing sets text on the current page.\n\nIMPORTANT: Before using this tool, you should first understand the page structure to correctly identify input elements:\n1. Call 'webUITakePageSource' tool to get the HTML structure of the page and analyze the DOM to find input elements (e.g., <input>, <textarea> tags)\n2. OR call 'webUITakeAccessibilityTreeSnapshot' tool to get the accessibility tree which provides semantic information about interactive elements including their roles, names, and properties\n3. From the page structure, identify the input element you want to interact with and extract appropriate locator attributes (id, name, css selector, xpath, class name, or tag name)\n4. Choose the most reliable locator strategy (prefer ID or NAME when available, then CSS or XPATH for more complex scenarios)\n5. Then call this tool with the correct sessionId, locatorStrategy, and locatorValue to set text in the identified input element\n\nThe locatorStrategy parameter accepts: ID, NAME, XPATH, CSS, CLASS_NAME, TAG_NAME. The timeout parameter (optional, default 10 seconds) specifies how long to wait for the element to appear before throwing an error", WebUIInputSchema.createSchemaForSetTextTool(), WebUIOutputSchema.createSchemaForSetTextTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.setTextCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult setTextCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        ElementInteractionContext context = null;
        String text = "";
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            if ((text = (String)arguments.get("text")) == null) {
                throw new IllegalArgumentException("text parameter is required");
            }
            context = this.validateAndPrepareElementInteraction(request);
            if (context == null) {
                throw new IllegalStateException("Failed to prepare element interaction context");
            }
            this.setTextInElement(context, text);
            context.session.checkStatusAndUpdateTitle();
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error setting text: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForSetTextTool(context, text);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private void setTextInElement(ElementInteractionContext context, String text) {
        try {
            context.element.clear();
            context.element.sendKeys(new CharSequence[]{text});
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            throw new IllegalStateException("Element became stale: " + context.locatorValue);
        }
    }

    private Map<String, Object> createStructuredContentResultForSetTextTool(ElementInteractionContext context, String text) {
        Map<String, Object> sessionInfo = this.createStructuredContentResultForElementInteraction(context);
        String textValue = "";
        if (context != null) {
            textValue = text != null ? text : "";
        }
        sessionInfo.put("text", textValue);
        return sessionInfo;
    }

    private Map<String, Object> createStructuredContentResultForElementInteraction(ElementInteractionContext context) {
        Map<String, Object> sessionInfo = this.createStructuredContentResultForExecutionSession(context != null ? context.session : null);
        String url = "";
        String locatorStrategy = "";
        String locatorValue = "";
        if (context != null) {
            url = context.url != null ? context.url : "";
            locatorStrategy = context.locatorStrategy != null ? context.locatorStrategy.name() : "";
            locatorValue = context.locatorValue != null ? context.locatorValue : "";
        }
        sessionInfo.put("url", url);
        sessionInfo.put("locatorStrategy", locatorStrategy);
        sessionInfo.put("locatorValue", locatorValue);
        return sessionInfo;
    }

    private LocatorStrategy parseLocatorStrategy(String locatorStrategyStr) {
        if (StringUtils.isBlank((CharSequence)locatorStrategyStr)) {
            return null;
        }
        try {
            return LocatorStrategy.valueOf(locatorStrategyStr.trim().toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private int parseTimeout(Object timeoutObj) {
        if (timeoutObj == null) {
            return 10;
        }
        if (timeoutObj instanceof Number) {
            return ((Number)timeoutObj).intValue();
        }
        if (timeoutObj instanceof String) {
            try {
                return Integer.parseInt((String)timeoutObj);
            }
            catch (NumberFormatException numberFormatException) {
                return 10;
            }
        }
        return 10;
    }

    private By buildLocatorFromStrategy(LocatorStrategy strategy, String value) {
        switch (strategy) {
            case ID: {
                return By.id((String)value);
            }
            case NAME: {
                return By.name((String)value);
            }
            case XPATH: {
                if (!this.isValidXPath(value)) {
                    throw new IllegalArgumentException("Invalid XPath syntax");
                }
                return By.xpath((String)value);
            }
            case CSS: {
                return By.cssSelector((String)value);
            }
            case CLASS_NAME: {
                return By.className((String)value);
            }
            case TAG_NAME: {
                return By.tagName((String)value);
            }
        }
        throw new IllegalArgumentException("Unsupported locator strategy: " + String.valueOf((Object)strategy));
    }

    private WebElement findElementWithTimeout(WebDriver driver, By locator, int timeoutInSeconds) {
        try {
            WebDriverWait wait = new WebDriverWait(driver, Duration.ofSeconds(timeoutInSeconds));
            WebElement element = (WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)locator));
            return element;
        }
        catch (TimeoutException timeoutException) {
            return null;
        }
    }

    private boolean isValidXPath(String xpath) {
        try {
            XPathFactory.newInstance().newXPath().compile(xpath);
            return true;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return false;
        }
    }

    private ElementInteractionContext validateAndPrepareElementInteraction(McpSchema.CallToolRequest request) throws Exception {
        ElementInteractionContext context = new ElementInteractionContext();
        HashMap arguments = request.arguments();
        if (arguments == null) {
            arguments = new HashMap();
        }
        String sessionId = (String)arguments.get("sessionId");
        String requestUrl = (String)arguments.get("url");
        String locatorStrategyStr = (String)arguments.get("locatorStrategy");
        context.locatorValue = (String)arguments.get("locatorValue");
        Object timeoutObj = arguments.get("timeout");
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            throw new IllegalArgumentException("sessionId parameter is required. Must have an existing browser session");
        }
        if (StringUtils.isBlank((CharSequence)locatorStrategyStr)) {
            throw new IllegalArgumentException("locatorStrategy parameter is required");
        }
        if (StringUtils.isBlank((CharSequence)context.locatorValue)) {
            throw new IllegalArgumentException("locatorValue parameter is required");
        }
        context.session = this.getExecutionSessionById(sessionId);
        if (context.session == null || !context.session.isAvailable()) {
            throw new IllegalStateException("Session not found or not available: " + sessionId);
        }
        RemoteWebDriver driver = context.session.getExistingDriver();
        if (StringUtils.isNotBlank((CharSequence)requestUrl)) {
            URL navigateUrl = PathUtil.getUrl((String)requestUrl, (String)"http");
            context.url = navigateUrl.toString();
            this.navigateToUrl((WebDriver)driver, context.url);
        } else {
            context.url = driver.getCurrentUrl();
        }
        context.locatorStrategy = this.parseLocatorStrategy(locatorStrategyStr);
        if (context.locatorStrategy == null) {
            throw new IllegalArgumentException("Invalid locatorStrategy: " + locatorStrategyStr);
        }
        context.timeout = this.parseTimeout(timeoutObj);
        By locator = this.buildLocatorFromStrategy(context.locatorStrategy, context.locatorValue);
        context.element = this.findElementWithTimeout((WebDriver)driver, locator, context.timeout);
        if (context.element == null) {
            throw new IllegalStateException("Element not found with " + context.locatorStrategy.name() + ": " + context.locatorValue);
        }
        return context;
    }

    public McpServerFeatures.SyncToolSpecification clickTool() {
        McpSchema.Tool tool = new McpSchema.Tool("webUIClick", "Click an element", "Clicks on an element on the current page. Requires an active browser session (sessionId). If url is provided, navigates to that URL first before clicking the element. If url is not provided, performs click on the current page.\n\nIMPORTANT: Before using this tool, you should first understand the page structure to correctly identify clickable elements:\n1. Call 'webUITakePageSource' tool to get the HTML structure of the page and analyze the DOM to find clickable elements (e.g., <button>, <a>, <input type=\"button\"> tags)\n2. OR call 'webUITakeAccessibilityTreeSnapshot' tool to get the accessibility tree which provides semantic information about interactive elements including their roles, names, and properties\n3. From the page structure, identify the element you want to click and extract appropriate locator attributes (id, name, css selector, xpath, class name, or tag name)\n4. Choose the most reliable locator strategy (prefer ID or NAME when available, then CSS or XPATH for more complex scenarios)\n5. Then call this tool with the correct sessionId, locatorStrategy, and locatorValue to click the identified element\n\nThe locatorStrategy parameter accepts: ID, NAME, XPATH, CSS, CLASS_NAME, TAG_NAME. The timeout parameter (optional, default 10 seconds) specifies how long to wait for the element to appear before throwing an error", WebUIInputSchema.createSchemaForClickTool(), WebUIOutputSchema.createSchemaForClickTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.clickCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult clickCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        ElementInteractionContext context = null;
        try {
            context = this.validateAndPrepareElementInteraction(request);
            context.element.click();
            context.session.checkStatusAndUpdateTitle();
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error clicking element: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForElementInteraction(context);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private static class ElementInteractionContext {
        ExecutionSession session;
        String url;
        String locatorValue;
        LocatorStrategy locatorStrategy;
        int timeout;
        WebElement element;

        private ElementInteractionContext() {
        }
    }
}

