/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools.schema;

import com.kms.katalon.ai.mcp.enums.BrowserType;
import com.kms.katalon.ai.mcp.enums.LocatorStrategy;
import com.kms.katalon.ai.mcp.jsonschema.builder.ObjectSchemaBuilder;
import com.kms.katalon.ai.mcp.jsonschema.builder.SchemaBuilder;
import java.util.Map;

public class WebUIOutputSchema {
    public static Map<String, Object> createSchemaForGetAvailableExecutionSessionsTool() {
        return SchemaBuilder.object().property("results", SchemaBuilder.array("List of available execution sessions").items(WebUIOutputSchema.createExecutionSessionSchema())).build();
    }

    public static Map<String, Object> createSchemaForNavigateToUrlTool() {
        return WebUIOutputSchema.createExecutionSessionSchema().property("url", SchemaBuilder.string("The URL navigated to")).required("url").build();
    }

    public static Map<String, Object> createSchemaForTakePageSourceTool() {
        return WebUIOutputSchema.createExecutionSessionSchema().property("url", SchemaBuilder.string("The current URL of the page")).property("pageSource", SchemaBuilder.string("The HTML page source")).required("url", "pageSource").build();
    }

    public static Map<String, Object> createSchemaForTakeAccessibilityTreeSnapshotTool() {
        return WebUIOutputSchema.createExecutionSessionSchema().property("url", SchemaBuilder.string("The current URL of the page")).property("accessibilityTree", SchemaBuilder.string("The accessibility tree representation of the page")).required("url", "accessibilityTree").build();
    }

    public static Map<String, Object> createSchemaForSetTextTool() {
        return WebUIOutputSchema.createSchemaForElementInteraction().property("text", SchemaBuilder.string("The text that was set in the element")).required("text").build();
    }

    public static Map<String, Object> createSchemaForClickTool() {
        return WebUIOutputSchema.createSchemaForElementInteraction().build();
    }

    private static ObjectSchemaBuilder createSchemaForElementInteraction() {
        return WebUIOutputSchema.createExecutionSessionSchema().property("url", SchemaBuilder.string("The current URL of the page")).property("locatorStrategy", SchemaBuilder.string("The locator strategy used to find the element").enumValues(LocatorStrategy.ID.name(), LocatorStrategy.NAME.name(), LocatorStrategy.XPATH.name(), LocatorStrategy.CSS.name(), LocatorStrategy.CLASS_NAME.name(), LocatorStrategy.TAG_NAME.name())).property("locatorValue", SchemaBuilder.string("The locator value used to find the element")).required("url", "locatorStrategy", "locatorValue");
    }

    private static ObjectSchemaBuilder createExecutionSessionSchema() {
        return SchemaBuilder.object("An execution session representing an active browser instance").property("sessionId", SchemaBuilder.string("The unique session identifier. The session ID of the browser")).property("browserType", SchemaBuilder.string("The browser type").enumValues(BrowserType.CHROME.name(), BrowserType.CHROME_HEADLESS.name(), BrowserType.FIREFOX.name(), BrowserType.FIREFOX_HEADLESS.name(), BrowserType.EDGE_CHROMIUM.name(), BrowserType.SAFARI.name())).property("pageTitle", SchemaBuilder.string("The current page title")).required("sessionId", "browserType", "pageTitle");
    }
}

