/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.core.setting.IStudioAssistAiAutoTagSetting;
import com.kms.katalon.session.core.model.AdminControlTag;
import com.kms.katalon.session.core.model.AdministrationManagedAiAutoTag;
import com.kms.katalon.session.core.model.AiAutoTagSetting;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class AdminManagedAiAutoTagSetting
implements IStudioAssistAiAutoTagSetting {
    @Inject
    private IEclipseContext eclipseContext;
    private AiAutoTagSetting aiAutoTaggingSetting;

    @PostConstruct
    public void init() {
        ISessionController sessionController = (ISessionController)this.eclipseContext.get(ISessionController.class);
        if (sessionController != null) {
            this.aiAutoTaggingSetting = sessionController.getAdministrationManagedKsSetting().getAiAutoTagging();
        }
    }

    public boolean isCodeGeneration() {
        return this.hasAdminTag(AdminControlTag.STUDIO_ASSIST_CODE_GENERATION);
    }

    public boolean isApiTestCaseGeneration() {
        return this.hasAdminTag(AdminControlTag.API_TEST_CASE_GENERATION);
    }

    public boolean isApiTestCaseDefaultTag() {
        return false;
    }

    public boolean isApiTestCaseCustomTag() {
        return this.isApiTestCaseGeneration();
    }

    public boolean isCodeGenerationDefaultTag() {
        return false;
    }

    public boolean isCodeGenerationCustomTag() {
        return this.isCodeGeneration();
    }

    public String getApiTestCustomTag() {
        return this.getAdminTagValue(AdminControlTag.API_TEST_CASE_GENERATION);
    }

    public String getGenerateCodeCustomTag() {
        return this.getAdminTagValue(AdminControlTag.STUDIO_ASSIST_CODE_GENERATION);
    }

    public List<String> getAiAutoTags() {
        ArrayList<String> aiAutoTags = new ArrayList<String>();
        if (this.isApiTestCaseGeneration()) {
            aiAutoTags.add(this.getApiTestCustomTag());
        }
        if (this.isCodeGeneration()) {
            aiAutoTags.add(this.getGenerateCodeCustomTag());
        }
        return aiAutoTags;
    }

    private boolean hasAdminTag(AdminControlTag targetTag) {
        if (this.aiAutoTaggingSetting == null) {
            return false;
        }
        return this.aiAutoTaggingSetting.getAdministrationManagedAiAutoTag().stream().anyMatch(tag -> targetTag.equals((Object)tag.getKey()));
    }

    private String getAdminTagValue(AdminControlTag targetTag) {
        if (this.aiAutoTaggingSetting == null) {
            return "";
        }
        return this.aiAutoTaggingSetting.getAdministrationManagedAiAutoTag().stream().filter(tag -> targetTag.equals((Object)tag.getKey())).findFirst().map(AdministrationManagedAiAutoTag::getValue).orElse("");
    }
}

