/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.ai.core.model.config.AwsBedrockConfig;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.preferences.StudioAssistPreferenceStore;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class AwsBedrockPreferenceStore
extends StudioAssistPreferenceStore {
    public static final String AWS_BEDROCK_ACCESS_KEY = "aws_bedrock_access_key";
    public static final String AWS_BEDROCK_SECRET_KEY = "aws_bedrock_secret_key";
    public static final String AWS_BEDROCK_SESSION_TOKEN = "aws_bedrock_session_token";
    public static final String AWS_BEDROCK_REGION = "aws_bedrock_region";
    public static final String AWS_BEDROCK_MODEL = "aws_bedrock_model";
    public static final String AWS_BEDROCK_MAX_TOKEN = "aws_bedrock_max_token";

    @Override
    public StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException {
        try {
            String encodedAccessKey = this.store.getString(AWS_BEDROCK_ACCESS_KEY);
            String awsAccessKey = this.decode(encodedAccessKey);
            String encodedSecretKey = this.store.getString(AWS_BEDROCK_SECRET_KEY);
            String awsSecretKey = this.decode(encodedSecretKey);
            String encodedSessionToken = this.store.getString(AWS_BEDROCK_SESSION_TOKEN);
            String awsSessionToken = this.decode(encodedSessionToken);
            String encodedRegion = this.store.getString(AWS_BEDROCK_REGION);
            String awsRegion = this.decode(encodedRegion);
            String encodedModel = this.store.getString(AWS_BEDROCK_MODEL);
            String model = this.decode(encodedModel);
            int maxToken = this.store.getInt(AWS_BEDROCK_MAX_TOKEN);
            if (maxToken <= 0) {
                maxToken = 16000;
            }
            return new AwsBedrockConfig(awsAccessKey, awsSecretKey, awsSessionToken, awsRegion, model, maxToken);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new StudioAssistLoadingConfigException((Throwable)e);
        }
    }

    @Override
    public void saveConfig(StudioAssistConfig credential) throws StudioAssistSavingConfigException {
        this.store.setValue(STUDIO_ASSIST_CONFIG_TYPE, LlmConfigType.AWS_BEDROCK.toString());
        try {
            AwsBedrockConfig awsBedrockConfig = (AwsBedrockConfig)credential;
            String awsAccessKey = awsBedrockConfig.getAwsAccessKey();
            this.store.setValue(AWS_BEDROCK_ACCESS_KEY, this.encode(awsAccessKey));
            String awsSecretKey = awsBedrockConfig.getAwsSecretKey();
            this.store.setValue(AWS_BEDROCK_SECRET_KEY, this.encode(awsSecretKey));
            String awsSessionToken = awsBedrockConfig.getAwsSessionToken();
            this.store.setValue(AWS_BEDROCK_SESSION_TOKEN, this.encode(awsSessionToken));
            String awsRegion = awsBedrockConfig.getAwsRegion();
            this.store.setValue(AWS_BEDROCK_REGION, this.encode(awsRegion));
            String model = awsBedrockConfig.getModel();
            this.store.setValue(AWS_BEDROCK_MODEL, this.encode(model));
            this.store.setValue(AWS_BEDROCK_MAX_TOKEN, awsBedrockConfig.getMaxToken());
            this.store.save();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new StudioAssistSavingConfigException((Throwable)e);
        }
    }
}

