/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.ai.core.model.config.AwsBedrockConfig;
import com.kms.katalon.ai.core.model.config.AzureOpenAIConfig;
import com.kms.katalon.ai.core.model.config.GeminiConfig;
import com.kms.katalon.ai.core.model.config.GenAIConfig;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.OpenAIConfig;
import com.kms.katalon.ai.core.model.config.OpenAiCompatibleConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.preferences.StudioAssistPreferenceStore;
import com.kms.katalon.console.handlers.ArgumentOptionsHandler;
import com.kms.katalon.session.core.model.AiConfigPolicyType;
import com.kms.katalon.session.core.model.ManagedAzureOpenAiConfig;
import com.kms.katalon.session.core.model.ManagedGeminiConfig;
import com.kms.katalon.session.core.model.ManagedOpenAiCompatibleConfig;
import com.kms.katalon.session.core.model.ManagedOpenAiConfig;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistConsolePreferenceStore
extends StudioAssistPreferenceStore {
    @Inject
    private ISessionController sessionController;
    private static final Logger logger = LoggerFactory.getLogger(StudioAssistConsolePreferenceStore.class);
    private static final String WARNING_MESSAGE_PREFIX = "Unable to generate AI Failure Analysis";

    @Override
    public StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException {
        AiConfigPolicyType aiConfigPolicyType = this.sessionController.getAiConfigPolicy().getAiConfigPolicyType();
        switch (aiConfigPolicyType) {
            case ADMINISTRATION_MANAGED_OPENAI: {
                return this.buildOpenAIConfig(true);
            }
            case ADMINISTRATION_MANAGED_AZURE_OPENAI: {
                return this.buildAzureOpenAIConfig(true);
            }
            case ADMINISTRATION_MANAGED_GEMINI: {
                return this.buildGeminiConfig(true);
            }
            case ADMINISTRATION_MANAGED_OPENAI_COMPATIBLE: {
                return this.buildOpenAiCompatibleConfig(true);
            }
        }
        if (!ArgumentOptionsHandler.getInstance().hasSettingStudioAssistProviderName()) {
            return null;
        }
        String providerName = ArgumentOptionsHandler.getInstance().getStudioAssistProviderName();
        if (StringUtils.isBlank((CharSequence)providerName)) {
            logger.warn("{}. The parameter {} is required for AI Setting", (Object)WARNING_MESSAGE_PREFIX, (Object)"studioAssist.provider");
            return null;
        }
        LlmConfigType provider = LlmConfigType.parseCliProviderOption((String)providerName);
        if (provider == null) {
            logger.warn("Unsupported provider from AI Setting command-line: " + providerName);
            return null;
        }
        switch (provider) {
            case GEN_AI: {
                if (aiConfigPolicyType.equals((Object)AiConfigPolicyType.AI_DISABLED)) {
                    logger.warn("{}. The Katalon AI is disabled by administrator", (Object)WARNING_MESSAGE_PREFIX);
                    return null;
                }
                return this.buildGenAIConfig();
            }
            case OPENAI: {
                return this.buildOpenAIConfig(false);
            }
            case AZURE_OPENAI: {
                return this.buildAzureOpenAIConfig(false);
            }
            case GEMINI: {
                return this.buildGeminiConfig(false);
            }
            case OPENAI_COMPATIBLE: {
                return this.buildOpenAiCompatibleConfig(false);
            }
            case AWS_BEDROCK: {
                return this.buildAwsBedrockConfig();
            }
        }
        logger.warn("Unsupported provider from AI Setting command-line: " + providerName);
        return null;
    }

    private OpenAIConfig buildOpenAIConfig(boolean isManagedByAdmin) {
        String apiKey = "";
        String orgID = "";
        String modelName = ArgumentOptionsHandler.getInstance().getStudioAssistModel();
        int maxToken = ArgumentOptionsHandler.getInstance().getStudioAssistMaxCompletionToken();
        if (isManagedByAdmin) {
            ManagedOpenAiConfig adminManagedOpenAiConfig = this.sessionController.getAiConfigPolicy().getManagedOpenAi().orElse(new ManagedOpenAiConfig("", ""));
            if (adminManagedOpenAiConfig != null) {
                apiKey = adminManagedOpenAiConfig.getApiKey();
                orgID = adminManagedOpenAiConfig.getOrganizationId();
            }
            if (StringUtils.isBlank((CharSequence)modelName)) {
                modelName = OpenAIConfig.DEFAULT_MODEL;
            }
            if (maxToken <= 0) {
                maxToken = 16000;
            }
        } else {
            apiKey = ArgumentOptionsHandler.getInstance().getStudioAssistApiKey();
            orgID = ArgumentOptionsHandler.getInstance().getStudioAssistOrgId();
        }
        if (StringUtils.isBlank((CharSequence)apiKey) || StringUtils.isBlank((CharSequence)modelName)) {
            logger.warn("{}. Missing required parameters for OpenAI provider. Required: {}, {}", new Object[]{WARNING_MESSAGE_PREFIX, "studioAssist.apiKey", "studioAssist.model"});
            return null;
        }
        if (maxToken <= 0) {
            logger.warn("{}. The parameter {} must be a positive integer for AI Setting OpenAI provider", (Object)WARNING_MESSAGE_PREFIX, (Object)"studioAssist.maxCompletionToken");
            return null;
        }
        return new OpenAIConfig(apiKey, maxToken, orgID, modelName);
    }

    private AzureOpenAIConfig buildAzureOpenAIConfig(boolean isManagedByAdmin) {
        String baseUrl = "";
        String deploymentName = "";
        String apiKey = "";
        String apiVersion = "";
        int maxToken = ArgumentOptionsHandler.getInstance().getStudioAssistMaxCompletionToken();
        if (isManagedByAdmin) {
            ManagedAzureOpenAiConfig adminManagedAzureOpenAiConfig = this.sessionController.getAiConfigPolicy().getManagedAzureOpenAi().orElse(null);
            if (adminManagedAzureOpenAiConfig != null) {
                baseUrl = adminManagedAzureOpenAiConfig.getApiBase();
                deploymentName = adminManagedAzureOpenAiConfig.getDeploymentName();
                apiKey = adminManagedAzureOpenAiConfig.getApiKey();
                apiVersion = adminManagedAzureOpenAiConfig.getApiVersion();
            }
            if (maxToken <= 0) {
                maxToken = 16000;
            }
        } else {
            baseUrl = ArgumentOptionsHandler.getInstance().getStudioAssistBaseUrl();
            deploymentName = ArgumentOptionsHandler.getInstance().getStudioAssistDeploymentName();
            apiKey = ArgumentOptionsHandler.getInstance().getStudioAssistApiKey();
            apiVersion = ArgumentOptionsHandler.getInstance().getStudioAssistApiVersion();
        }
        if (StringUtils.isBlank((CharSequence)baseUrl) || StringUtils.isBlank((CharSequence)deploymentName) || StringUtils.isBlank((CharSequence)apiKey) || StringUtils.isBlank((CharSequence)apiVersion)) {
            logger.warn("{}. Missing required parameters for Azure OpenAI provider. Required: {}, {}, {}, {}", new Object[]{WARNING_MESSAGE_PREFIX, "studioAssist.apiKey", "studioAssist.baseUrl", "studioAssist.deploymentName", "studioAssist.apiVersion"});
            return null;
        }
        if (maxToken <= 0) {
            logger.warn("{}. The parameter {} must be a positive integer for AI Setting Azure OpenAI provider", (Object)WARNING_MESSAGE_PREFIX, (Object)"studioAssist.maxCompletionToken");
            return null;
        }
        return new AzureOpenAIConfig(baseUrl, deploymentName, apiKey, maxToken, apiVersion);
    }

    private GeminiConfig buildGeminiConfig(boolean isManagedByAdmin) {
        String baseUrl = "";
        String apiKey = "";
        String modelName = ArgumentOptionsHandler.getInstance().getStudioAssistModel();
        int maxToken = ArgumentOptionsHandler.getInstance().getStudioAssistMaxCompletionToken();
        if (isManagedByAdmin) {
            ManagedGeminiConfig adminManagedGeminiConfig = this.sessionController.getAiConfigPolicy().getManagedGeminiAiConfig().orElse(null);
            if (adminManagedGeminiConfig != null) {
                baseUrl = adminManagedGeminiConfig.getBaseUrl();
                apiKey = adminManagedGeminiConfig.getApiKey();
            }
            if (StringUtils.isBlank((CharSequence)modelName)) {
                modelName = "gemini-2.5-flash";
            }
            if (maxToken <= 0) {
                maxToken = 16000;
            }
        } else {
            baseUrl = ArgumentOptionsHandler.getInstance().getStudioAssistBaseUrl();
            apiKey = ArgumentOptionsHandler.getInstance().getStudioAssistApiKey();
        }
        if (StringUtils.isBlank((CharSequence)baseUrl) || StringUtils.isBlank((CharSequence)modelName) || StringUtils.isBlank((CharSequence)apiKey)) {
            logger.warn("{}. Missing required parameters for Gemini provider. Required: {}, {}, {}", new Object[]{WARNING_MESSAGE_PREFIX, "studioAssist.apiKey", "studioAssist.baseUrl", "studioAssist.model"});
            return null;
        }
        if (maxToken <= 0) {
            logger.warn("{}. The parameter {} must be a positive integer for AI Setting Gemini provider", (Object)WARNING_MESSAGE_PREFIX, (Object)"studioAssist.maxCompletionToken");
            return null;
        }
        return new GeminiConfig(baseUrl, apiKey, modelName, maxToken);
    }

    private OpenAiCompatibleConfig buildOpenAiCompatibleConfig(boolean isManagedByAdmin) {
        String baseUrl = "";
        String apiKey = "";
        String apiKeyHeaderName = "";
        String modelName = ArgumentOptionsHandler.getInstance().getStudioAssistModel();
        int maxToken = ArgumentOptionsHandler.getInstance().getStudioAssistMaxCompletionToken();
        if (isManagedByAdmin) {
            ManagedOpenAiCompatibleConfig adminManagedOpenAiCompatibleConfig = this.sessionController.getAiConfigPolicy().getManagedOpenAiCompatible().orElse(new ManagedOpenAiCompatibleConfig("", "", ""));
            if (adminManagedOpenAiCompatibleConfig != null) {
                baseUrl = adminManagedOpenAiCompatibleConfig.getBaseUrl();
                apiKey = adminManagedOpenAiCompatibleConfig.getApiKey();
                apiKeyHeaderName = adminManagedOpenAiCompatibleConfig.getApiKeyHeaderName();
            }
            if (StringUtils.isBlank((CharSequence)modelName)) {
                modelName = "gpt-4.1-mini";
            }
            if (maxToken <= 0) {
                maxToken = 16000;
            }
        } else {
            baseUrl = ArgumentOptionsHandler.getInstance().getStudioAssistBaseUrl();
            apiKey = ArgumentOptionsHandler.getInstance().getStudioAssistApiKey();
            apiKeyHeaderName = ArgumentOptionsHandler.getInstance().getStudioAssistApiKeyHeaderName();
        }
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            logger.warn("{}. Missing required parameters for OpenAI-compatible provider. Required: {}", (Object)WARNING_MESSAGE_PREFIX, (Object)"studioAssist.baseUrl");
            return null;
        }
        if (maxToken <= 0) {
            logger.warn("{}. The parameter {} must be a positive integer for AI Setting OpenAI-compatible provider", (Object)WARNING_MESSAGE_PREFIX, (Object)"studioAssist.maxCompletionToken");
            return null;
        }
        return new OpenAiCompatibleConfig(baseUrl, apiKey, apiKeyHeaderName, modelName, maxToken);
    }

    private AwsBedrockConfig buildAwsBedrockConfig() {
        String awsAccessKey = ArgumentOptionsHandler.getInstance().getStudioAssistAwsAccessKey();
        String awsSecretKey = ArgumentOptionsHandler.getInstance().getStudioAssistAwsSecretKey();
        String awsSessionToken = ArgumentOptionsHandler.getInstance().getStudioAssistAwsSessionToken();
        String awsRegion = ArgumentOptionsHandler.getInstance().getStudioAssistAwsRegion();
        String modelName = ArgumentOptionsHandler.getInstance().getStudioAssistModel();
        int maxToken = ArgumentOptionsHandler.getInstance().getStudioAssistMaxCompletionToken();
        if (StringUtils.isBlank((CharSequence)awsAccessKey) || StringUtils.isBlank((CharSequence)awsSecretKey) || StringUtils.isBlank((CharSequence)awsSessionToken) || StringUtils.isBlank((CharSequence)modelName) || StringUtils.isBlank((CharSequence)awsRegion)) {
            logger.warn("{}. Missing required parameters for AWS Bedrock provider. Required: {}, {}, {}, {}, {}", new Object[]{WARNING_MESSAGE_PREFIX, "studioAssist.awsAccessKey", "studioAssist.awsSecretKey", "studioAssist.awsSessionToken", "studioAssist.model", "studioAssist.awsRegion"});
            return null;
        }
        if (maxToken <= 0) {
            logger.warn("{}. The parameter {} must be a positive integer for AI Setting AWS Bedrock provider", (Object)WARNING_MESSAGE_PREFIX, (Object)"studioAssist.maxCompletionToken");
            return null;
        }
        return new AwsBedrockConfig(awsAccessKey, awsSecretKey, awsSessionToken, awsRegion, modelName, maxToken);
    }

    private GenAIConfig buildGenAIConfig() {
        return new GenAIConfig();
    }

    @Override
    public void saveConfig(StudioAssistConfig credential) throws StudioAssistSavingConfigException {
        logger.debug("Cannot save AI Setting configuration in console mode - configuration is read-only from command-line parameters");
    }
}

