/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.presentation;

import com.kms.katalon.ai.core.model.agent.AgentConversation;
import com.kms.katalon.ai.core.model.agent.Entity;
import com.kms.katalon.ai.core.model.agent.EntityModification;
import com.kms.katalon.ai.core.model.agent.EntityModificationType;
import com.kms.katalon.ai.core.model.agent.EntityType;
import com.kms.katalon.ai.core.model.chat.StudioAssistConversation;
import com.kms.katalon.ai.core.services.IEntityModificationService;
import com.kms.katalon.ai.core.services.IFileSnapshotService;
import com.kms.katalon.composer.ai.studioassist.diff.StudioAssistDiffEditorInput;
import com.kms.katalon.composer.components.impl.tree.SystemFileTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.SystemFileController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import jakarta.inject.Inject;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class OpenModifiedEntityHandler {
    private static final Logger logger = LoggerFactory.getLogger(OpenModifiedEntityHandler.class);
    @Inject
    private IFileSnapshotService fileSnapshotService;
    @Inject
    private IEntityModificationService entityModificationService;
    @Inject
    private IEventBroker eventBroker;

    public boolean open(Entity entity, StudioAssistConversation conversation, Consumer<Entity> undoHandler, Consumer<Entity> markReviewedHandler) throws Exception {
        boolean hasLineCounts;
        Objects.requireNonNull(undoHandler, "Undo handler is required");
        Objects.requireNonNull(markReviewedHandler, "Mark reviewed handler is required");
        if (entity == null) {
            logger.error("Cannot open entity diff: entity is null");
            return false;
        }
        AgentConversation agentConversation = this.asAgentConversation(conversation);
        if (agentConversation == null) {
            logger.error("Cannot open entity diff: conversation is not AgentConversation");
            return false;
        }
        EntityModification modification = this.entityModificationService.findEntityModification(agentConversation, entity.getId());
        if (modification == null) {
            logger.error("Entity modification not found for entityId={}", (Object)entity.getId());
            return false;
        }
        EntityModificationType modificationType = modification.getType();
        boolean isCreate = modificationType == EntityModificationType.CREATED;
        String filePath = this.entityModificationService.resolveFilePath(modification);
        if (filePath == null) {
            logger.error("Cannot open entity diff: filePath not found for entityId={}", (Object)entity.getId());
            return false;
        }
        File currentFile = new File(filePath);
        if (!currentFile.exists()) {
            logger.error("Cannot open entity diff: file not found at path {}", (Object)filePath);
            return false;
        }
        boolean bl = hasLineCounts = modification.getLinesAdded() > 0 || modification.getLinesRemoved() > 0;
        if (isCreate) {
            if (this.openEntityInEditor(modification.getEntity())) {
                return true;
            }
            return this.openDiffForNewFile(modification, currentFile, undoHandler, markReviewedHandler);
        }
        if (!hasLineCounts) {
            if (this.openEntityInEditor(modification.getEntity())) {
                return true;
            }
            this.openFileDirectly(filePath);
            return true;
        }
        String snapshotId = modification.getSnapshotId();
        if (StringUtils.isBlank((CharSequence)snapshotId)) {
            logger.error("Cannot open file diff: snapshotId not found for modification of entityId={}", (Object)entity.getId());
            return false;
        }
        String originalContent = this.fileSnapshotService.readSnapshot(snapshotId);
        if (originalContent == null) {
            logger.error("Cannot open file diff: snapshot not found for snapshotId={}", (Object)snapshotId);
            return false;
        }
        return this.openDiff(modification, originalContent, currentFile, undoHandler, markReviewedHandler);
    }

    public void closeAllDiffEditors() {
        Display display = Display.getDefault();
        if (display == null) {
            return;
        }
        display.asyncExec(() -> {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return;
            }
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference reference = iEditorReferenceArray[n2];
                try {
                    IEditorInput input = reference.getEditorInput();
                    if (input instanceof StudioAssistDiffEditorInput) {
                        IEditorPart editor = reference.getEditor(false);
                        if (editor != null) {
                            page.closeEditor(editor, false);
                        } else {
                            page.closeEditors(new IEditorReference[]{reference}, false);
                        }
                    }
                }
                catch (PartInitException e) {
                    logger.warn("Failed to close diff editor", (Throwable)e);
                }
                ++n2;
            }
        });
    }

    private boolean openDiffForNewFile(EntityModification modification, File currentFile, Consumer<Entity> undoHandler, Consumer<Entity> markReviewedHandler) {
        try {
            String currentContent = FileUtils.readFileToString((File)currentFile, (Charset)StandardCharsets.UTF_8);
            Display.getDefault().asyncExec(() -> this.openDiffViewer(modification, "", currentContent, undoHandler, markReviewedHandler));
            logger.info("Opened new file diff for entityId={}", (Object)modification.getEntity().getId());
            return true;
        }
        catch (Exception ex) {
            logger.error("Error opening new file diff for entityId={}", (Object)modification.getEntity().getId(), (Object)ex);
            return false;
        }
    }

    private boolean openDiff(EntityModification modification, String originalContent, File currentFile, Consumer<Entity> undoHandler, Consumer<Entity> markReviewedHandler) {
        try {
            String currentContent = FileUtils.readFileToString((File)currentFile, (Charset)StandardCharsets.UTF_8);
            Display.getDefault().asyncExec(() -> this.openDiffViewer(modification, originalContent, currentContent, undoHandler, markReviewedHandler));
            logger.info("Opened diff for entityId={}", (Object)modification.getEntity().getId());
            return true;
        }
        catch (Exception ex) {
            logger.error("Error opening diff for entityId={}", (Object)modification.getEntity().getId(), (Object)ex);
            return false;
        }
    }

    private void openDiffViewer(EntityModification modification, String originalContent, String currentContent, Consumer<Entity> undoHandler, Consumer<Entity> markReviewedHandler) {
        if (modification == null || modification.getEntity() == null) {
            logger.error("Cannot open diff viewer: modification or entity is null");
            return;
        }
        Runnable task = () -> {
            String entityId = modification.getEntity().getId();
            if (StringUtils.isBlank((CharSequence)entityId)) {
                logger.error("Cannot open diff viewer: entityId is blank");
                return;
            }
            if (this.reopenExistingDiff(modification, originalContent, currentContent, undoHandler, markReviewedHandler)) {
                logger.info("Reloaded diff editor for entityId={}", (Object)entityId);
                return;
            }
            try {
                StudioAssistDiffEditorInput editorInput = new StudioAssistDiffEditorInput(modification, originalContent, currentContent, undoHandler, markReviewedHandler, this.eventBroker);
                CompareUI.openCompareEditor((CompareEditorInput)editorInput);
            }
            catch (Exception e) {
                logger.error("Error opening diff viewer for entityId={}", (Object)entityId, (Object)e);
            }
        };
        Display current = Display.getCurrent();
        if (current != null) {
            task.run();
        } else {
            Display.getDefault().asyncExec(task);
        }
    }

    private boolean reopenExistingDiff(EntityModification modification, String originalContent, String currentContent, Consumer<Entity> undoHandler, Consumer<Entity> markReviewedHandler) {
        Entity entity = modification.getEntity();
        if (entity == null || StringUtils.isBlank((CharSequence)entity.getId())) {
            return false;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return false;
        }
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            try {
                IEditorInput input = reference.getEditorInput();
                if (input instanceof StudioAssistDiffEditorInput) {
                    StudioAssistDiffEditorInput diffInput = (StudioAssistDiffEditorInput)input;
                    if (entity.getId().equals(diffInput.getEntityId())) {
                        IEditorPart editor = reference.getEditor(false);
                        if (editor != null) {
                            page.closeEditor(editor, false);
                        } else {
                            page.closeEditors(new IEditorReference[]{reference}, false);
                        }
                        StudioAssistDiffEditorInput refreshedInput = new StudioAssistDiffEditorInput(modification, originalContent, currentContent, undoHandler, markReviewedHandler, this.eventBroker);
                        CompareUI.openCompareEditor((CompareEditorInput)refreshedInput);
                        return true;
                    }
                }
            }
            catch (PartInitException e) {
                logger.warn("Failed to refresh diff editor for entityId={}", (Object)entity.getId(), (Object)e);
            }
            ++n2;
        }
        return false;
    }

    private AgentConversation asAgentConversation(StudioAssistConversation conversation) {
        if (conversation instanceof AgentConversation) {
            AgentConversation agentConversation = (AgentConversation)conversation;
            return agentConversation;
        }
        return null;
    }

    private boolean openEntityInEditor(Entity entity) {
        if (entity == null || entity.getType() == null || StringUtils.isBlank((CharSequence)entity.getId())) {
            return false;
        }
        try {
            return switch (entity.getType()) {
                case EntityType.TEST_CASE -> this.openTestCaseEditor(entity.getId());
                case EntityType.TEST_SUITE, EntityType.DYNAMIC_TEST_SUITE -> this.openTestSuiteEditor(entity.getId());
                case EntityType.TEST_SUITE_COLLECTION -> this.openTestSuiteCollectionEditor(entity.getId());
                case EntityType.INTERNAL_TEST_DATA -> this.openTestDataEditor(entity.getId());
                case EntityType.TEST_OBJECT, EntityType.MOBILE_TEST_OBJECT, EntityType.REST_WEB_SERVICE_TEST_OBJECT, EntityType.SOAP_WEB_SERVICE_TEST_OBJECT, EntityType.WEB_TEST_OBJECT, EntityType.WINDOWS_TEST_OBJECT -> this.openTestObjectEditor(entity.getId(), entity.getType());
                case EntityType.FEATURE_FILE -> this.openBddFeatureEditor(entity.getId());
                default -> false;
            };
        }
        catch (Exception e) {
            logger.error("Failed to open entity {} of type {} in editor", new Object[]{entity.getId(), entity.getType(), e});
            return false;
        }
    }

    private boolean openTestCaseEditor(String entityId) throws Exception {
        TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(entityId);
        if (testCase == null) {
            return false;
        }
        Display.getDefault().asyncExec(() -> {
            boolean bl = this.eventBroker.send("TESTCASE/OPEN", (Object)testCase);
        });
        return true;
    }

    private boolean openBddFeatureEditor(String entityId) throws Exception {
        SystemFileEntity featureFile = SystemFileController.getInstance().getSystemFileFromDisplayId(entityId, ProjectController.getInstance().getCurrentProject());
        SystemFileTreeEntity systemFileTreeEntity = TreeEntityUtil.getSystemFileTreeEntity((SystemFileEntity)featureFile, (FolderEntity)featureFile.getParentFolder());
        this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", (Object)systemFileTreeEntity.getObject());
        return true;
    }

    private boolean openTestSuiteEditor(String entityId) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            logger.warn("Cannot open test suite {}: no project loaded", (Object)entityId);
            return false;
        }
        TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(entityId, project);
        if (testSuite == null) {
            return false;
        }
        Display.getDefault().asyncExec(() -> {
            boolean bl = this.eventBroker.send("TESTSUITE/OPEN", (Object)testSuite);
        });
        return true;
    }

    private boolean openTestSuiteCollectionEditor(String entityId) throws Exception {
        TestSuiteCollectionEntity collection = TestSuiteCollectionController.getInstance().getTestRunByDisplayId(entityId);
        if (collection == null) {
            return false;
        }
        Display.getDefault().asyncExec(() -> {
            boolean bl = this.eventBroker.send("TEST_SUITE_COLLECTION/OPEN", (Object)collection);
        });
        return true;
    }

    private boolean openTestDataEditor(String entityId) throws Exception {
        DataFileEntity dataFile = TestDataController.getInstance().getTestDataByDisplayId(entityId);
        if (dataFile == null) {
            return false;
        }
        Display.getDefault().asyncExec(() -> {
            boolean bl = this.eventBroker.post("TESTDATA/OPEN", (Object)dataFile);
        });
        return true;
    }

    private boolean openTestObjectEditor(String entityId, EntityType type) throws Exception {
        if (EntityType.WINDOWS_TEST_OBJECT.equals((Object)type)) {
            WindowsElementEntity windowsElement = WindowsElementController.getInstance().getWindowsElementByDisplayId(entityId);
            if (windowsElement == null) {
                return false;
            }
            Display.getDefault().asyncExec(() -> {
                boolean bl = this.eventBroker.send("WINDOWS_TEST_OBJECT/OPEN", (Object)windowsElement);
            });
            return true;
        }
        WebElementEntity testObject = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(entityId);
        if (testObject == null) {
            return false;
        }
        Display.getDefault().asyncExec(() -> this.dispatchTestObjectOpenEvent(testObject));
        return true;
    }

    private void dispatchTestObjectOpenEvent(WebElementEntity testObject) {
        if (testObject instanceof WebServiceRequestEntity) {
            WebServiceRequestEntity webServiceRequest = (WebServiceRequestEntity)testObject;
            this.eventBroker.send("WSOBJECT/OPEN", (Object)webServiceRequest);
        } else if (testObject instanceof MobileElementEntity) {
            MobileElementEntity mobileElement = (MobileElementEntity)testObject;
            this.eventBroker.send("MOBILE_TESTOBJECT/OPEN", (Object)mobileElement);
        } else {
            this.eventBroker.send("TESTOBJECT/OPEN", (Object)testObject);
        }
    }

    private void openFileDirectly(String filePath) {
        try {
            Path location;
            if (filePath == null) {
                logger.error("Cannot open file: filePath is null");
                return;
            }
            File file = new File(filePath);
            if (!file.exists()) {
                logger.error("Cannot open file: file not found at path {}", (Object)filePath);
                return;
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile iFile = root.getFileForLocation((IPath)(location = new Path(file.getAbsolutePath())));
            if (iFile == null) {
                logger.error("Cannot open file: IFile not found for path {}", (Object)filePath);
                return;
            }
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)iFile);
                logger.info("Opened file: {}", (Object)filePath);
            } else {
                logger.error("Cannot open file: no active workbench page");
            }
        }
        catch (Exception e) {
            logger.error("Error opening file: {}", (Object)filePath, (Object)e);
        }
    }
}

