/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.presentation;

import com.equo.chromium.swt.Browser;
import com.katalon.composer.core.webview.browserfunction.BrowserFunctionUtil;
import com.kms.katalon.ai.core.constant.StudioAssistAttachmentSource;
import com.kms.katalon.ai.core.constant.StudioAssistAttachmentStatus;
import com.kms.katalon.ai.core.constant.StudioAssistChatModeTrackingValueEnum;
import com.kms.katalon.ai.core.constant.StudioAssistFileType;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingValueEnum;
import com.kms.katalon.ai.core.context.IAgentSessionContext;
import com.kms.katalon.ai.core.context.IChatSessionContext;
import com.kms.katalon.ai.core.context.IConversationSessionContext;
import com.kms.katalon.ai.core.controller.IAgentController;
import com.kms.katalon.ai.core.controller.IChatController;
import com.kms.katalon.ai.core.controller.IStudioAssistChatController;
import com.kms.katalon.ai.core.controller.IStudioAssistReferenceContextController;
import com.kms.katalon.ai.core.dto.StudioAssistChatRateConversationRequest;
import com.kms.katalon.ai.core.event.tracking.AttachmentUsageTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatActionTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatAnswerTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatCloseTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatFileAttachmentTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ChatOpenTrackingEvent;
import com.kms.katalon.ai.core.event.tracking.ConversationRatingTrackingEvent;
import com.kms.katalon.ai.core.model.agent.AgentConversation;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.Entity;
import com.kms.katalon.ai.core.model.agent.event.AgentMessageUpdatedEvent;
import com.kms.katalon.ai.core.model.chat.AttachmentSource;
import com.kms.katalon.ai.core.model.chat.ChatMode;
import com.kms.katalon.ai.core.model.chat.ChatQuestionMessage;
import com.kms.katalon.ai.core.model.chat.ChatResponseMessage;
import com.kms.katalon.ai.core.model.chat.ConversationSession;
import com.kms.katalon.ai.core.model.chat.FocusingFileAttachment;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.ResponseMessageStatus;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatStatus;
import com.kms.katalon.ai.core.model.chat.StudioAssistConversation;
import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.presentation.IStudioAssistChatNavigator;
import com.kms.katalon.ai.core.presentation.IStudioAssistChatView;
import com.kms.katalon.ai.core.presentation.IStudioAssistSettingNavigator;
import com.kms.katalon.ai.core.presentation.dto.ChatAttachmentDTO;
import com.kms.katalon.ai.core.presentation.dto.ChatAttachmentUploadDTO;
import com.kms.katalon.ai.core.presentation.dto.ChatQuestionMessageDTO;
import com.kms.katalon.ai.core.presentation.dto.MaxedToolCallActionDTO;
import com.kms.katalon.ai.core.presentation.dto.ProcessingStatusDTO;
import com.kms.katalon.ai.core.presentation.dto.RateConversationDTO;
import com.kms.katalon.ai.core.presentation.dto.ToolCallActionDTO;
import com.kms.katalon.ai.core.presentation.listener.IStudioAssistChatListener;
import com.kms.katalon.ai.core.util.AttachmentUtil;
import com.kms.katalon.ai.presentation.OpenModifiedEntityHandler;
import com.kms.katalon.ai.presentation.StudioAssistChatView;
import com.kms.katalon.ai.services.AttachmentManager;
import com.kms.katalon.ai.util.TreeEntityFilePathExtractor;
import com.kms.katalon.ai.util.TreeEntityFileTypeResolver;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.ai.studioassist.dialog.ImagePreviewOverlayShell;
import com.kms.katalon.composer.ai.studioassist.dialog.ProjectFileSelectionDialog;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.constant.StudioAssistChatOpenOperationEnum;
import com.kms.katalon.core.setting.StudioAssistSetting;
import com.kms.katalon.session.core.model.Account;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class StudioAssistChatNavigator
implements IStudioAssistChatNavigator,
EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(StudioAssistChatNavigator.class);
    private static final String CHAT_VIEW = "chat";
    private static final String MCP_SETTING_VIEW = "mcp-settings";
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IAgentController agentController;
    @Inject
    IChatController chatController;
    @Inject
    private IConversationSessionContext conversationSessionContext;
    @Inject
    private IStudioAssistChatController studioAssistChatController;
    @Inject
    protected IStudioAssistReferenceContextController referenceContextController;
    @Inject
    private ISessionController sessionController;
    @Inject
    private AttachmentManager attachmentManager;
    @Inject
    private OpenModifiedEntityHandler openModifiedEntityHandler;
    @Inject
    private IStudioAssistSettingNavigator studioAssistSettingNavigator;
    protected IAgentSessionContext agentSessionContext;
    protected IChatSessionContext chatSessionContext;
    private final AtomicReference<Browser> mainBrowser = new AtomicReference();
    private IStudioAssistChatView studioAssistChatView;

    @PostConstruct
    public void postConstruct() {
        this.agentSessionContext = this.agentController.createSession();
        this.chatSessionContext = this.chatController.createSession();
        this.eventBroker.subscribe("ON_STUDIO_ASSIST_CONVERSATION_SESSION_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("PROJECT/OPENED", (EventHandler)this);
        this.eventBroker.subscribe("PROJECT/CLOSED", (EventHandler)this);
        this.eventBroker.subscribe("ON_CHAT_MESSAGE_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("STUDIOASSIST_AGENT_MESSAGE_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("ON_FOCUSING_FILE_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("ON_STUDIO_ASSIST_PROJECT_CONTEXT_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("ON_TRACKING_OPEN_CHAT_WINDOW", (EventHandler)this);
        this.eventBroker.subscribe("ON_AGENT_PROFILE_DELETED", (EventHandler)this);
    }

    @PreDestroy
    public void preDestroy() {
        this.eventBroker.unsubscribe((EventHandler)this);
        this.studioAssistChatView = null;
    }

    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "ON_STUDIO_ASSIST_CONVERSATION_SESSION_UPDATED": {
                this.handleConversationSessionUpdated(event);
                break;
            }
            case "ON_CHAT_MESSAGE_UPDATED": {
                this.handleChatMessageUpdated(event);
                break;
            }
            case "STUDIOASSIST_AGENT_MESSAGE_UPDATED": {
                this.handleAgentMessageUpdated(event);
                break;
            }
            case "ON_FOCUSING_FILE_UPDATED": {
                this.handleUpdateAttachments();
                break;
            }
            case "ON_STUDIO_ASSIST_PROJECT_CONTEXT_UPDATED": {
                this.handleProjectContextUpdated();
                break;
            }
            case "ON_TRACKING_OPEN_CHAT_WINDOW": {
                this.onTrackingOpenChatWindow(event);
            }
            case "ON_AGENT_PROFILE_DELETED": {
                this.syncConversationSessionSelection(this.mainBrowser.get());
                break;
            }
        }
    }

    public void init(Browser browser) {
        boolean isSessionInitialized;
        this.mainBrowser.set(browser);
        this.registerStudioAssistChatView(browser);
        ConversationSession currentSession = this.conversationSessionContext.getCurrentSession();
        boolean bl = isSessionInitialized = currentSession != null && currentSession.getStatus() != null && currentSession.getStatus() != StudioAssistChatStatus.UNAVAILABLE;
        if (isSessionInitialized) {
            this.restoreSession(currentSession, browser);
        } else {
            CompletableFuture.runAsync(() -> this.conversationSessionContext.initSession()).exceptionally(throwable -> {
                ConversationSession errorSession = new ConversationSession();
                errorSession.setStatus(StudioAssistChatStatus.UNAVAILABLE);
                errorSession.setChatMode(ChatMode.ASK);
                BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.openStudioAssistChatView", (Object[])new Object[]{errorSession});
                return null;
            });
        }
    }

    public void close() {
        ChatMode chatMode;
        StudioAssistConversation conversation;
        ConversationSession session = this.conversationSessionContext.getCurrentSession();
        if (session != null && session.getChatMode() != null && (conversation = this.getConversationByChatMode(chatMode = session.getChatMode())) != null) {
            ChatCloseTrackingEvent event = ChatCloseTrackingEvent.builder().conversation(conversation).chatMode(this.getTrackingChatMode(chatMode)).build();
            this.eventBroker.send("STUDIOASSIST_TRACK_CHAT_CLOSE", (Object)event);
        }
        this.agentSessionContext.disposeSession();
        BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.closeStudioAssistChatView", (Object[])new Object[0]);
    }

    private void restoreSession(ConversationSession session, Browser browser) {
        List attachments;
        BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.openStudioAssistChatView", (Object[])new Object[]{session});
        ChatMode chatMode = session.getChatMode();
        StudioAssistConversation conversation = this.getConversationByChatMode(chatMode);
        if (conversation != null) {
            BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{conversation});
        }
        if (!(attachments = this.referenceContextController.getCurrentAttachments()).isEmpty()) {
            this.handleUpdateAttachments();
        }
    }

    private void handleConversationSessionUpdated(Event event) {
        Object data = event.getProperty("org.eclipse.e4.data");
        if (data instanceof ConversationSession) {
            ConversationSession session = (ConversationSession)data;
            BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateStudioAssistConversationSession", (Object[])new Object[]{session});
            ChatMode chatMode = session.getChatMode();
            BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{this.getConversationByChatMode(chatMode)});
        }
    }

    private void handleProjectContextUpdated() {
        ChatMode chatMode = this.conversationSessionContext.getCurrentSession().getChatMode();
        if (chatMode.equals((Object)ChatMode.ASK)) {
            BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateProjectContext", (Object[])new Object[]{this.chatSessionContext.getProjectContexts()});
        } else if (chatMode.equals((Object)ChatMode.AGENT)) {
            BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateProjectContext", (Object[])new Object[]{List.of()});
        }
    }

    private void registerStudioAssistChatView(final Browser browser) {
        this.studioAssistChatView = new StudioAssistChatView();
        this.studioAssistChatView.init(browser);
        this.studioAssistChatView.addListener(new IStudioAssistChatListener(){

            public void onStudioAssistChatViewOpened() {
                StudioAssistChatNavigator.this.syncMcpSettings();
                ChatMode chatMode = StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode();
                if (chatMode.equals((Object)ChatMode.ASK)) {
                    BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.updateProjectContext", (Object[])new Object[]{StudioAssistChatNavigator.this.chatSessionContext.getProjectContexts()});
                }
                CompletableFuture.runAsync(() -> StudioAssistChatNavigator.this.conversationSessionContext.studioAssistChatViewOpened()).exceptionally(throwable -> {
                    ConversationSession errorSession = new ConversationSession();
                    errorSession.setStatus(StudioAssistChatStatus.UNAVAILABLE);
                    errorSession.setChatMode(ChatMode.ASK);
                    BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.updateStudioAssistConversationSession", (Object[])new Object[]{errorSession});
                    return null;
                });
            }

            public void onAskQuestion(ChatQuestionMessageDTO questionMessage) {
                List<StudioAssistChatAttachment> attachments = StudioAssistChatNavigator.this.loadAttachmentContents(questionMessage.getAttachments());
                ChatMode chatMode = StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode();
                String conversationId = StudioAssistChatNavigator.this.getConversationIdByChatMode(chatMode);
                ChatQuestionMessage question = new ChatQuestionMessage(questionMessage.getMessageId(), questionMessage.getContent(), attachments);
                StudioAssistChatNavigator.this.handleSendMessage(question, false);
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.SEND_QUESTION.getValue(), question.getMessageId());
                if (!attachments.isEmpty()) {
                    StudioAssistChatNavigator.this.eventBroker.post("STUDIOASSIST_TRACK_ATTACHMENT_USAGE", (Object)AttachmentUsageTrackingEvent.create((String)conversationId, (String)question.getMessageId(), attachments, (String)StudioAssistChatNavigator.this.getTrackingChatMode(chatMode)));
                }
            }

            public void onRetryMessage(ChatQuestionMessageDTO questionMessage) {
                List<StudioAssistChatAttachment> attachments = StudioAssistChatNavigator.this.loadAttachmentContents(questionMessage.getAttachments());
                ChatQuestionMessage question = new ChatQuestionMessage(questionMessage.getMessageId(), questionMessage.getContent(), attachments);
                StudioAssistChatNavigator.this.handleSendMessage(question, true);
                ChatMode chatMode = StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode();
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.RETRY.getValue(), question.getMessageId());
                if (!attachments.isEmpty()) {
                    StudioAssistChatNavigator.this.eventBroker.post("STUDIOASSIST_TRACK_ATTACHMENT_USAGE", (Object)AttachmentUsageTrackingEvent.create((String)StudioAssistChatNavigator.this.getConversationIdByChatMode(chatMode), (String)questionMessage.getMessageId(), attachments, (String)StudioAssistChatNavigator.this.getTrackingChatMode(chatMode)));
                }
            }

            public void onOpenStudioAssistSetting() {
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.OPEN_SETTINGS.getValue());
                StudioAssistChatNavigator.this.eventBroker.post("KATALON/PREFERENCES", (Object)"com.kms.katalon.composer.preferences.GeneralPreferencePage/com.kms.katalon.composer.ai.AiConfigurationPage");
            }

            public void onChatModeChange(ChatMode chatMode) {
                StudioAssistChatNavigator.this.agentSessionContext.updateAppliedAgentProfile(null);
                StudioAssistChatNavigator.this.conversationSessionContext.changeChatMode(chatMode);
                StudioAssistChatNavigator.this.syncConversationSessionSelection(browser);
                StudioAssistChatNavigator.this.trackStudioAssistAction(String.format(StudioAssistTrackingValueEnum.SWITCH_MODE.getValue(), chatMode.getName().toLowerCase()));
            }

            public void onAgentProfileSelected(String profileName) {
                StudioAssistChatNavigator.this.conversationSessionContext.changeChatMode(ChatMode.AGENT);
                StudioAssistChatNavigator.this.agentSessionContext.updateAppliedAgentProfile(profileName);
                StudioAssistChatNavigator.this.syncConversationSessionSelection(browser);
                StudioAssistChatNavigator.this.syncMcpSettings();
                StudioAssistChatNavigator.this.trackStudioAssistAction(String.format(StudioAssistTrackingValueEnum.SWITCH_MODE.getValue(), StudioAssistChatModeTrackingValueEnum.CUSTOM_AGENT.getValue()));
            }

            public void onClearConversation() {
                StudioAssistChatNavigator.this.referenceContextController.clear();
                ChatMode chatMode = StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode();
                if (chatMode.equals((Object)ChatMode.AGENT)) {
                    StudioAssistChatNavigator.this.agentSessionContext.clearConversation();
                } else {
                    StudioAssistChatNavigator.this.chatSessionContext.clearConversation();
                }
                BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{StudioAssistChatNavigator.this.getConversationByChatMode(chatMode)});
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.CLEAR_CONVERSATION.getValue());
            }

            public void onRateAnswer(RateConversationDTO rate) {
                ChatMode chatMode = StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode();
                StudioAssistConversation conversation = StudioAssistChatNavigator.this.getConversationByChatMode(chatMode);
                if (conversation != null) {
                    StudioAssistChatPair chatPair = conversation.getValidChatItems().stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> (StudioAssistChatPair)item).filter(item -> rate.getMessageId().equals(item.getRequest().getMessageId())).findFirst().orElse(null);
                    if (chatPair != null && chatPair.getResponse() != null) {
                        ResponseMessage answer = chatPair.getResponse();
                        if (answer instanceof ChatResponseMessage) {
                            ((ChatResponseMessage)answer).setRated(true);
                        } else if (answer instanceof AgentMessage) {
                            ((AgentMessage)answer).setRated(true);
                        }
                        chatPair.setResponse(answer);
                        BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{conversation});
                    }
                    String conversationId = StudioAssistChatNavigator.this.getConversationIdByChatMode(chatMode);
                    StudioAssistChatRateConversationRequest conversationRateRequest = new StudioAssistChatRateConversationRequest();
                    conversationRateRequest.setLatestQuestionId(rate.getMessageId());
                    conversationRateRequest.setThumb(rate.isHelpful());
                    conversationRateRequest.setConversationId(conversationId);
                    StudioAssistChatNavigator.this.eventBroker.post("STUDIOASSIST_TRACK_CONVERSATION_RATING", (Object)ConversationRatingTrackingEvent.create((StudioAssistChatRateConversationRequest)conversationRateRequest, (StudioAssistConversation)conversation, (String)StudioAssistChatNavigator.this.getTrackingChatMode(chatMode)));
                }
            }

            public void approveToolCall(ToolCallActionDTO toolCallAction) {
                if (StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode().equals((Object)ChatMode.ASK)) {
                    return;
                }
                AgentMessage agentMessage = StudioAssistChatNavigator.this.agentSessionContext.findAgentMessageById(toolCallAction.getMessageId());
                StudioAssistChatNavigator.this.agentSessionContext.approveToolCall(agentMessage, toolCallAction.getApproval());
            }

            public void denyToolCall(ToolCallActionDTO toolCallAction) {
                if (StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode().equals((Object)ChatMode.ASK)) {
                    return;
                }
                AgentMessage agentMessage = StudioAssistChatNavigator.this.agentSessionContext.findAgentMessageById(toolCallAction.getMessageId());
                StudioAssistChatNavigator.this.agentSessionContext.denyToolCall(agentMessage);
            }

            public void acknowledgeMaxedToolCall(MaxedToolCallActionDTO maxedToolCallAction) {
                if (StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode().equals((Object)ChatMode.ASK)) {
                    return;
                }
                AgentMessage agentMessage = StudioAssistChatNavigator.this.agentSessionContext.findAgentMessageById(maxedToolCallAction.getMessageId());
                StudioAssistChatNavigator.this.agentSessionContext.acknowledgeMaxedToolCall(agentMessage);
            }

            public void rejectMaxedToolCall(MaxedToolCallActionDTO maxedToolCallAction) {
                if (StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode().equals((Object)ChatMode.ASK)) {
                    return;
                }
                AgentMessage agentMessage = StudioAssistChatNavigator.this.agentSessionContext.findAgentMessageById(maxedToolCallAction.getMessageId());
                StudioAssistChatNavigator.this.agentSessionContext.rejectMaxedToolCall(agentMessage);
            }

            public void stopGeneration(String messageId) {
                ChatMode chatMode = StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode();
                if (chatMode.equals((Object)ChatMode.AGENT)) {
                    AgentMessage agentMessage = StudioAssistChatNavigator.this.agentSessionContext.findAgentMessageById(messageId);
                    StudioAssistChatNavigator.this.agentSessionContext.stopGeneration(agentMessage);
                } else {
                    ChatResponseMessage chatMessage = StudioAssistChatNavigator.this.chatSessionContext.findAnswerMessageById(messageId);
                    if (chatMessage == null) {
                        chatMessage = new ChatResponseMessage(messageId);
                    }
                    StudioAssistChatNavigator.this.chatSessionContext.stopGeneration(chatMessage);
                }
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.STOP_GENERATING.getValue(), messageId);
            }

            public void onUploadAttachments(ChatAttachmentUploadDTO attachment) {
                List<StudioAssistChatAttachment> newAttachments = switch (attachment.getAttachmentSource()) {
                    case AttachmentSource.PROJECT -> StudioAssistChatNavigator.this.handleUploadAttachmentsFromProject();
                    case AttachmentSource.EXTERNAL -> StudioAssistChatNavigator.this.handleUploadAttachmentsFromExternal();
                    default -> throw new IncompatibleClassChangeError();
                };
                StudioAssistChatNavigator.this.referenceContextController.addAttachments(newAttachments);
                StudioAssistChatNavigator.this.handleUpdateAttachments();
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.UPLOAD_ATTACHMENT.getValue());
            }

            public void onRemoveAttachment(String filePath) {
                StudioAssistChatNavigator.this.referenceContextController.removeAttachment(filePath);
                StudioAssistChatNavigator.this.handleUpdateAttachments();
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.REMOVE_ATTACHMENT.getValue());
            }

            public void onNavigateBackToChat() {
                StudioAssistChatNavigator.this.navigateView(StudioAssistChatNavigator.CHAT_VIEW);
            }

            public void onClickFollowUpQuestion(ChatQuestionMessageDTO questionMessageDTO) {
                ChatQuestionMessage question = new ChatQuestionMessage(questionMessageDTO.getMessageId(), questionMessageDTO.getContent(), List.of());
                StudioAssistChatNavigator.this.handleSendMessage(question, false);
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.CLICK_FOLLOW_UP.getValue());
            }

            public void onCopyMessage(String messageId) {
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.COPY_ANSWER.getValue());
            }

            public void onCopyCodeBlock(String messageId) {
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.COPY_CODE.getValue());
            }

            public void onRequestAiAccess() {
                try {
                    String myServerUrl = ApplicationInfo.getMyServerUrl();
                    Session session = StudioAssistChatNavigator.this.sessionController.getSession();
                    Account account = session.getAccount();
                    String accountId = String.valueOf(account.getId());
                    String url = "%s/enable-ai-settings?accountId=%s".formatted(myServerUrl, accountId);
                    ComponentUtil.triggerLink((String)url);
                    StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.REQUEST_ACCESS.getValue());
                }
                catch (Exception e) {
                    logger.error("Exception while handle ON_CHAT_REQUEST_AI_ACCESS event", (Throwable)e);
                }
            }

            public void onReloadChatView() {
                StudioAssistChatNavigator.this.init(browser);
            }

            public void onPasteAttachmentFromClipboard() {
                List<StudioAssistChatAttachment> attachments = StudioAssistChatNavigator.this.attachmentManager.createImageAttachmentsFromClipboard(AttachmentUtil::checkAttachmentStatus);
                if (attachments.isEmpty()) {
                    return;
                }
                StudioAssistChatNavigator.this.referenceContextController.addAttachments(attachments);
                StudioAssistChatNavigator.this.handleUpdateAttachments();
            }

            public void onPreviewAttachment(String filePath) {
                File file = new File(filePath);
                if (file.exists()) {
                    Image image = new Image((Device)Display.getCurrent(), filePath);
                    ImagePreviewOverlayShell overlay = new ImagePreviewOverlayShell(Display.getCurrent());
                    overlay.setPreviewContent(image);
                    overlay.open();
                } else {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Preview Attachment", (String)"The file does not exist or has been moved.");
                }
            }

            public void onClickFileAttachment() {
                ChatMode chatMode = StudioAssistChatNavigator.this.conversationSessionContext.getCurrentSession().getChatMode();
                StudioAssistChatNavigator.this.eventBroker.post("STUDIOASSIST_FILE_ATTACHMENT", (Object)ChatFileAttachmentTrackingEvent.builder().chatMode(StudioAssistChatNavigator.this.getTrackingChatMode(chatMode)).build());
            }

            public void onUndoFileModification(Entity entity) {
                StudioAssistChatNavigator.this.handleUndoFileModification(entity);
            }

            public void onMarkFileReviewed(Entity entity) {
                StudioAssistChatNavigator.this.handleMarkFileReviewed(entity);
            }

            public void onOpenFileDiff(Entity entity) {
                StudioAssistChatNavigator.this.handleOpenFileDiff(entity);
            }

            public void onUndoAllModifications(String messageId) {
                StudioAssistChatNavigator.this.handleUndoAllModifications(messageId);
            }

            public void onMarkAllFilesReviewed(String messageId) {
                StudioAssistChatNavigator.this.handleMarkAllFilesReviewed(messageId);
            }

            public void onOpenMcpToolSettings() {
                StudioAssistChatNavigator.this.openMcpSetting();
            }

            public void onClickCreateAgentProfile() {
                StudioAssistChatNavigator.this.trackStudioAssistAction(StudioAssistTrackingValueEnum.CREATE_PROFILE.getValue());
                StudioAssistChatNavigator.this.eventBroker.post("ON_AGENT_PROFILE_CREATE_REQUESTED", null);
            }
        });
    }

    private List<StudioAssistChatAttachment> handleUploadAttachmentsFromProject() {
        this.eventBroker.post("STUDIOASSIST_FILE_ATTACHMENT", (Object)ChatFileAttachmentTrackingEvent.builder().chatMode(this.getTrackingChatMode(this.conversationSessionContext.getCurrentSession().getChatMode())).attachmentSource(AttachmentSource.PROJECT).build());
        try {
            ProjectFileSelectionDialog dialog = new ProjectFileSelectionDialog(Display.getCurrent().getActiveShell());
            dialog.open();
            ArrayList<StudioAssistChatAttachment> attachments = new ArrayList<StudioAssistChatAttachment>();
            if (dialog.getReturnCode() == 0) {
                List selectedEntities = dialog.getSelectedItems();
                for (ITreeEntity entity : selectedEntities) {
                    String filePath = TreeEntityFilePathExtractor.extractFilePath(entity);
                    StudioAssistFileType fileType = TreeEntityFileTypeResolver.resolveFileType(entity.getClass().getSimpleName(), filePath);
                    StudioAssistChatAttachment attachment = this.attachmentManager.createProjectFileAttachment(filePath, fileType, (arg_0, arg_1) -> ((IStudioAssistReferenceContextController)this.referenceContextController).validateAttachment(arg_0, arg_1));
                    if (attachment == null) continue;
                    attachments.add(attachment);
                }
                return attachments;
            }
        }
        catch (Exception e) {
            logger.error("Error uploading attachments from project", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private List<StudioAssistChatAttachment> handleUploadAttachmentsFromExternal() {
        this.eventBroker.post("STUDIOASSIST_FILE_ATTACHMENT", (Object)ChatFileAttachmentTrackingEvent.builder().chatMode(this.getTrackingChatMode(this.conversationSessionContext.getCurrentSession().getChatMode())).attachmentSource(AttachmentSource.EXTERNAL).build());
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 2);
        dialog.open();
        if (dialog.getFileNames() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> filePaths = new ArrayList<String>();
        Path currentPath = Path.of(dialog.getFilterPath(), new String[0]);
        String[] stringArray = dialog.getFileNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            String filePath = fileName = stringArray[n2];
            if (!new File(fileName).exists()) {
                Path pathToFile = currentPath.resolve(fileName);
                filePath = pathToFile.toString();
            }
            filePaths.add(filePath);
            ++n2;
        }
        return this.attachmentManager.createExternalFileAttachments(filePaths, AttachmentUtil::checkAttachmentStatus);
    }

    private void handleSendMessage(ChatQuestionMessage question, boolean isRetry) {
        ChatMode chatMode = this.conversationSessionContext.getCurrentSession().getChatMode();
        String conversationId = this.getConversationIdByChatMode(chatMode);
        CompletableFuture.supplyAsync(() -> {
            this.handleUpdateProcessingStatus(conversationId, question);
            return null;
        }).thenRun(() -> {
            CompletableFuture future;
            if (chatMode.equals((Object)ChatMode.AGENT)) {
                future = isRetry ? this.agentSessionContext.retryMessage(question) : this.agentSessionContext.sendMessage(question);
                AgentConversation conversation = this.agentSessionContext.getConversation();
                BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{conversation});
            } else {
                future = isRetry ? this.chatSessionContext.retryMessage(question) : this.chatSessionContext.sendMessage(question);
                StudioAssistConversation conversation = this.chatSessionContext.getConversation();
                BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{conversation});
            }
            future.thenRun(this::cleanUpAttachments);
        });
    }

    private void cleanUpAttachments() {
        try {
            List currentAttachments = this.referenceContextController.getCurrentAttachments();
            StudioAssistChatAttachment focusingFile = currentAttachments.stream().filter(a -> a.getFileSource() == StudioAssistAttachmentSource.FOCUSING_FILE).findFirst().orElse(null);
            this.referenceContextController.clearAttachments();
            if (focusingFile != null && new File(focusingFile.getFilePath()).exists()) {
                this.referenceContextController.setFocusingFile(focusingFile);
            }
            this.handleUpdateAttachments();
        }
        catch (Exception e) {
            logger.error("Error clearing attachments after send", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    @Optional
    private void checkFocusingFile(@UIEventTopic(value="EXPLORER/SET_SELECTED_ITEM") Object object) {
        if (!(object instanceof ITreeEntity)) {
            this.referenceContextController.setFocusingFile(null);
            this.handleUpdateAttachments();
            return;
        }
        ITreeEntity iTreeEntity = (ITreeEntity)object;
        try {
            void treeEntity;
            String filePath = TreeEntityFilePathExtractor.extractFilePath((ITreeEntity)treeEntity);
            FocusingFileAttachment focusingFile = this.attachmentManager.createFocusingFileAttachment(filePath, TreeEntityFileTypeResolver.resolveFileType(treeEntity.getClass().getSimpleName(), filePath));
            if (focusingFile != null) {
                StudioAssistChatAttachment loadedAttachment = this.referenceContextController.loadAttachmentContent((StudioAssistChatAttachment)focusingFile);
                if (loadedAttachment != null) {
                    this.referenceContextController.setFocusingFile(loadedAttachment);
                    this.handleUpdateAttachments();
                }
            } else {
                this.referenceContextController.setFocusingFile(null);
                this.handleUpdateAttachments();
            }
        }
        catch (Exception e) {
            logger.error("Error handling focusing file update", (Throwable)e);
            this.referenceContextController.setFocusingFile(null);
            this.handleUpdateAttachments();
        }
    }

    private void handleUpdateAttachments() {
        Browser browser = this.mainBrowser.get();
        if (browser == null || browser.isDisposed()) {
            return;
        }
        try {
            List currentAttachments = this.referenceContextController.getCurrentAttachments();
            List<ChatAttachmentDTO> attachmentDTOs = currentAttachments.stream().map(ChatAttachmentDTO::from).toList();
            BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.uploadChatAttachments", (Object[])new Object[]{attachmentDTOs});
        }
        catch (Exception e) {
            logger.error("Error broadcasting attachments to webview", (Throwable)e);
        }
    }

    private void handleUpdateProcessingStatus(String conversationId, ChatQuestionMessage question) {
        boolean shouldAnalyzeFile;
        this.updateProcessingStatus(ProcessingStatusDTO.Status.SYNC_CONTEXT, conversationId, question.getMessageId());
        ChatMode chatMode = this.conversationSessionContext.getCurrentSession().getChatMode();
        boolean bl = shouldAnalyzeFile = chatMode == ChatMode.ASK && !this.chatSessionContext.getProjectContexts().isEmpty() || !question.getAttachments().isEmpty();
        if (shouldAnalyzeFile) {
            this.updateProcessingStatus(ProcessingStatusDTO.Status.ANALYZE_FILE, conversationId, question.getMessageId());
        }
        this.updateProcessingStatus(ProcessingStatusDTO.Status.GENERATE_RESPONSE, conversationId, question.getMessageId());
    }

    private void generateFollowUpQuestions(ChatMode chatMode, String conversationId, String questionMessageId) {
        if (!StudioAssistSetting.isFollowUpQuestionEnabled()) {
            return;
        }
        if (chatMode.equals((Object)ChatMode.AGENT)) {
            try {
                this.agentSessionContext.getFollowUpQuestions(conversationId, questionMessageId);
            }
            catch (StudioAssistBaseException e) {
                logger.error("agentSessionContext.getFollowUpQuestions(conversationId, questionMessageId);", (Throwable)e);
            }
        } else {
            this.chatSessionContext.getFollowUpQuestions(conversationId, questionMessageId).exceptionally(throwable -> {
                logger.error("Error generating follow-up questions", throwable);
                return null;
            });
        }
    }

    private void updateProcessingStatus(ProcessingStatusDTO.Status status, String conversationId, String questionMessageId) {
        ProcessingStatusDTO dto = new ProcessingStatusDTO(status, conversationId, questionMessageId);
        BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateProcessingStatus", (Object[])new Object[]{dto});
    }

    private void handleChatMessageUpdated(Event event) {
        Object data = event.getProperty("org.eclipse.e4.data");
        if (data instanceof ResponseMessage) {
            ResponseMessage answerMessage = (ResponseMessage)data;
            StudioAssistConversation conversation = this.chatSessionContext.getConversation();
            if (answerMessage instanceof ChatResponseMessage) {
                ChatResponseMessage chatMessage = (ChatResponseMessage)answerMessage;
                if (chatMessage.getStatus().equals((Object)ResponseMessageStatus.COMPLETED)) {
                    this.generateFollowUpQuestions(ChatMode.ASK, conversation.getConversationId(), answerMessage.getMessageId());
                }
                this.eventBroker.post("STUDIOASSIST_TRACK_CHAT_ANSWER", (Object)ChatAnswerTrackingEvent.builder().responseMessage((ResponseMessage)chatMessage).conversationId(conversation.getConversationId()).chatMode(this.getTrackingChatMode(ChatMode.ASK)).build());
            }
            this.updateProcessingStatus(ProcessingStatusDTO.Status.COMPLETED, conversation.getConversationId(), answerMessage.getMessageId());
            BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{conversation});
        }
    }

    private void handleAgentMessageUpdated(Event event) {
        Object data = event.getProperty("org.eclipse.e4.data");
        if (data instanceof AgentMessageUpdatedEvent) {
            AgentMessageUpdatedEvent agentEvent = (AgentMessageUpdatedEvent)data;
            AgentMessage agentMessage = agentEvent.getMessage();
            AgentConversation conversation = this.agentSessionContext.getConversation();
            if (agentMessage.isFinished()) {
                this.updateProcessingStatus(ProcessingStatusDTO.Status.COMPLETED, conversation.getConversationId(), agentMessage.getMessageId());
                this.generateFollowUpQuestions(ChatMode.AGENT, conversation.getConversationId(), agentMessage.getMessageId());
                this.eventBroker.post("STUDIOASSIST_TRACK_CHAT_ANSWER", (Object)ChatAnswerTrackingEvent.builder().responseMessage((ResponseMessage)agentMessage).conversationId(conversation.getConversationId()).chatMode(this.getTrackingChatMode(ChatMode.AGENT)).build());
            }
            BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{conversation});
        }
    }

    private List<StudioAssistChatAttachment> loadAttachmentContents(List<ChatAttachmentDTO> attachmentDTOs) {
        if (attachmentDTOs == null || attachmentDTOs.isEmpty()) {
            return List.of();
        }
        ArrayList<StudioAssistChatAttachment> loadedAttachments = new ArrayList<StudioAssistChatAttachment>();
        for (ChatAttachmentDTO dto : attachmentDTOs) {
            try {
                StudioAssistChatAttachment attachment = new StudioAssistChatAttachment(StudioAssistFileType.valueOf((String)dto.fileType()), dto.filePath(), StudioAssistAttachmentStatus.valueOf((String)dto.status()), StudioAssistAttachmentSource.valueOf((String)dto.fileSource()));
                StudioAssistChatAttachment loadedAttachment = this.referenceContextController.loadAttachmentContent(attachment);
                if (loadedAttachment == null) continue;
                loadedAttachments.add(loadedAttachment);
            }
            catch (Exception e) {
                logger.warn("Error loading attachment {}: {}", (Object)dto.filePath(), (Object)e.getMessage());
            }
        }
        return loadedAttachments;
    }

    private StudioAssistConversation getConversationByChatMode(ChatMode chatMode) {
        if (chatMode.equals((Object)ChatMode.ASK)) {
            return this.chatSessionContext.getConversation();
        }
        if (chatMode.equals((Object)ChatMode.AGENT)) {
            return this.agentSessionContext.getConversation();
        }
        return null;
    }

    private String getConversationIdByChatMode(ChatMode chatMode) {
        if (chatMode.equals((Object)ChatMode.ASK)) {
            return this.chatSessionContext.getConversation().getConversationId();
        }
        if (chatMode.equals((Object)ChatMode.AGENT)) {
            return this.agentSessionContext.getConversation().getConversationId();
        }
        return null;
    }

    private void trackStudioAssistAction(String action) {
        this.trackStudioAssistAction(action, null);
    }

    private void trackStudioAssistAction(String action, String messageId) {
        ChatMode chatMode = this.conversationSessionContext.getCurrentSession().getChatMode();
        ChatActionTrackingEvent.Builder trackingData = ChatActionTrackingEvent.builder().action(action).conversationId(this.getConversationIdByChatMode(chatMode)).chatMode(this.getTrackingChatMode(chatMode));
        if (messageId != null) {
            trackingData.questionId(messageId);
        }
        if (chatMode.equals((Object)ChatMode.AGENT)) {
            trackingData.agentSessionContext(this.agentSessionContext);
        }
        this.eventBroker.post("STUDIOASSIST_TRACK_CHAT_ACTION", (Object)trackingData.build());
    }

    private void openMcpSetting() {
        try {
            this.studioAssistSettingNavigator.openMcpSetting();
            this.navigateView(MCP_SETTING_VIEW);
        }
        catch (Exception e) {
            logger.debug("Exception while handle ON_STUDIO_ASSIST_OPEN_MCP_SETTING event", (Throwable)e);
        }
    }

    private void navigateView(String view) {
        Browser browser = this.mainBrowser.get();
        if (browser == null || browser.isDisposed()) {
            return;
        }
        try {
            BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.navigate", (Object[])new Object[]{view});
        }
        catch (Exception e) {
            logger.warn("Failed to navigate to view: {}", (Object)view, (Object)e);
        }
    }

    private void syncMcpSettings() {
        Browser browser = this.mainBrowser.get();
        if (browser == null || browser.isDisposed()) {
            return;
        }
        this.studioAssistSettingNavigator.syncSettings(browser, this.agentSessionContext);
    }

    private void syncConversationSessionSelection(Browser browser) {
        if (browser == null || browser.isDisposed()) {
            return;
        }
        ConversationSession session = this.conversationSessionContext.getCurrentSession();
        if (session == null) {
            return;
        }
        if (!ChatMode.AGENT.equals((Object)session.getChatMode())) {
            session.setAgentProfile(null);
        } else {
            session.setAgentProfile(this.agentSessionContext.getAppliedAgentProfile());
        }
        BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.updateStudioAssistConversationSession", (Object[])new Object[]{session});
        StudioAssistConversation conversation = this.getConversationByChatMode(session.getChatMode());
        if (conversation != null) {
            BrowserFunctionUtil.execute((Browser)browser, (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{conversation});
        }
    }

    private void onTrackingOpenChatWindow(Event event) {
        Object data = event.getProperty("org.eclipse.e4.data");
        if (data instanceof StudioAssistChatOpenOperationEnum) {
            StudioAssistChatOpenOperationEnum operation = (StudioAssistChatOpenOperationEnum)data;
            StudioAssistChatStatus validateFunctionAvailability = this.studioAssistChatController.validateFunctionAvailability();
            String operationStr = operation.toString();
            String availabilityStr = validateFunctionAvailability.toString();
            ChatMode preferredChatMode = this.conversationSessionContext.getUserPreference().getCurrentChatMode();
            if (preferredChatMode == null) {
                preferredChatMode = ChatMode.ASK;
            }
            String chatMode = this.getTrackingChatMode(preferredChatMode);
            this.eventBroker.post("STUDIOASSIST_TRACK_CHAT_OPEN", (Object)new ChatOpenTrackingEvent(operationStr, availabilityStr, chatMode));
        }
    }

    private void handleUndoFileModification(Entity entity) {
        try {
            boolean success = this.agentSessionContext.undoEntityModification(entity);
            if (!success) {
                logger.debug("Failed to undo modification for entityId={}", (Object)(entity != null ? entity.getId() : "unknown"));
                return;
            }
            try {
                this.publishCloseDiffEvent(entity);
                BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{this.agentSessionContext.getConversation()});
                this.eventBroker.post("EXPLORER/REFRESH_ALL_ITEMS", null);
            }
            catch (Exception e) {
                logger.debug("Error undoing file modification for entityId={}", (Object)(entity != null ? entity.getId() : "unknown"), (Object)e);
                Display.getDefault().asyncExec(() -> MessageDialog.openError(null, (String)"Undo Failed", (String)("Failed to undo file modification: " + e.getMessage())));
            }
        }
        finally {
            this.trackStudioAssistAction(StudioAssistTrackingValueEnum.UNDO.getValue());
        }
    }

    private void handleMarkFileReviewed(Entity entity) {
        try {
            boolean success = this.agentSessionContext.markEntityModificationReviewed(entity);
            if (!success) {
                logger.error("Failed to mark file reviewed for entityId={}", (Object)(entity != null ? entity.getId() : "unknown"));
                return;
            }
            try {
                this.publishCloseDiffEvent(entity);
                BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{this.agentSessionContext.getConversation()});
            }
            catch (Exception e) {
                logger.debug("Error marking file as reviewed for entityId={}", (Object)(entity != null ? entity.getId() : "unknown"), (Object)e);
            }
        }
        finally {
            this.trackStudioAssistAction(StudioAssistTrackingValueEnum.REVIEWED.getValue());
        }
    }

    private void publishCloseDiffEvent(Entity entity) {
        if (entity == null || StringUtils.isBlank((CharSequence)entity.getId())) {
            return;
        }
        this.eventBroker.post("ON_STUDIO_ASSIST_CLOSE_ENTITY_DIFF", (Object)entity.getId());
    }

    private void handleOpenFileDiff(Entity entity) {
        try {
            ChatMode chatMode = this.conversationSessionContext.getCurrentSession().getChatMode();
            StudioAssistConversation conversation = this.getConversationByChatMode(chatMode);
            boolean opened = this.openModifiedEntityHandler.open(entity, conversation, this::handleUndoFileModification, this::handleMarkFileReviewed);
            if (!opened) {
                logger.debug("Failed to open modified entity for entityId={}", (Object)(entity != null ? entity.getId() : "unknown"));
            }
        }
        catch (Exception e) {
            String entityId = entity != null ? entity.getId() : "unknown";
            logger.debug("Error opening file diff for entityId={}", (Object)entityId, (Object)e);
        }
    }

    private void handleUndoAllModifications(String messageId) {
        try {
            try {
                boolean success = this.agentSessionContext.undoAllEntityModifications(messageId);
                if (!success) {
                    logger.debug("Undo all modifications completed with partial failures");
                }
                BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{this.agentSessionContext.getConversation()});
                this.openModifiedEntityHandler.closeAllDiffEditors();
                this.eventBroker.post("EXPLORER/REFRESH_ALL_ITEMS", null);
            }
            catch (Exception e) {
                logger.debug("Error undoing all modifications", (Throwable)e);
                Display.getDefault().asyncExec(() -> MessageDialog.openError(null, (String)"Undo All Failed", (String)("Failed to undo all modifications: " + e.getMessage())));
                this.trackStudioAssistAction(StudioAssistTrackingValueEnum.UNDO_ALL.getValue());
            }
        }
        finally {
            this.trackStudioAssistAction(StudioAssistTrackingValueEnum.UNDO_ALL.getValue());
        }
    }

    private void handleMarkAllFilesReviewed(String messageId) {
        try {
            try {
                boolean success = this.agentSessionContext.markAllEntityModificationsReviewed(messageId);
                if (!success) {
                    logger.debug("Mark all files reviewed completed with partial failures");
                }
                BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistChatView.updateConversation", (Object[])new Object[]{this.agentSessionContext.getConversation()});
                this.openModifiedEntityHandler.closeAllDiffEditors();
            }
            catch (Exception e) {
                logger.debug("Error marking all files as reviewed", (Throwable)e);
                Display.getDefault().asyncExec(() -> MessageDialog.openError(null, (String)"Mark All Reviewed Failed", (String)("Failed to mark all files as reviewed: " + e.getMessage())));
                this.trackStudioAssistAction(StudioAssistTrackingValueEnum.REVIEWED_ALL.getValue());
            }
        }
        finally {
            this.trackStudioAssistAction(StudioAssistTrackingValueEnum.REVIEWED_ALL.getValue());
        }
    }

    private String getTrackingChatMode(ChatMode chatMode) {
        String appliedProfileName = this.agentSessionContext.getAppliedAgentProfile() != null ? this.agentSessionContext.getAppliedAgentProfile().getName() : null;
        return StudioAssistChatModeTrackingValueEnum.resolve((ChatMode)chatMode, (String)appliedProfileName);
    }
}

