/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.presentation;

import com.equo.chromium.swt.Browser;
import com.katalon.composer.core.webview.browserfunction.BrowserFunctionUtil;
import com.katalon.network.oauth.core.model.AuthorizationRequest;
import com.kms.katalon.ai.core.constant.StudioAssistChatModeTrackingValueEnum;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingKeyEnum;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingValueEnum;
import com.kms.katalon.ai.core.context.IAgentSessionContext;
import com.kms.katalon.ai.core.event.tracking.McpSettingActionTrackingEvent;
import com.kms.katalon.ai.core.model.agent.AgentSetting;
import com.kms.katalon.ai.core.model.agent.config.McpHttpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpSetting;
import com.kms.katalon.ai.core.model.agent.config.McpSseServerDefinition;
import com.kms.katalon.ai.core.model.agent.event.McpClientAuthorizedEvent;
import com.kms.katalon.ai.core.model.agent.event.McpClientUpdatedEvent;
import com.kms.katalon.ai.core.model.chat.AgentProfile;
import com.kms.katalon.ai.core.model.chat.ChatMode;
import com.kms.katalon.ai.core.presentation.IStudioAssistSettingAgentProfileView;
import com.kms.katalon.ai.core.presentation.IStudioAssistSettingMcpToolView;
import com.kms.katalon.ai.core.presentation.IStudioAssistSettingNavigator;
import com.kms.katalon.ai.core.presentation.IStudioAssistSettingToolExecutionView;
import com.kms.katalon.ai.core.presentation.listener.IStudioAssistSettingAgentProfileListener;
import com.kms.katalon.ai.core.presentation.listener.IStudioAssistSettingMcpToolListener;
import com.kms.katalon.ai.core.presentation.listener.IStudioAssistSettingToolExecutionListener;
import com.kms.katalon.ai.core.services.IAgentPreferences;
import com.kms.katalon.ai.core.services.IAgentProfileManager;
import com.kms.katalon.ai.core.services.IProjectAgentProfilePreferences;
import com.kms.katalon.ai.presentation.StudioAssistSettingAgentProfileView;
import com.kms.katalon.ai.presentation.StudioAssistSettingMcpToolView;
import com.kms.katalon.ai.presentation.StudioAssistSettingToolExecutionView;
import com.kms.katalon.composer.ai.constants.ComposerStudioAssistConstants;
import com.kms.katalon.composer.ai.studioassist.dialog.AgentProfileAddingDialog;
import com.kms.katalon.composer.ai.studioassist.dialog.McpServerAddingDialog;
import com.kms.katalon.composer.ai.studioassist.dialog.McpToolApprovalResetDialog;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.UserFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class StudioAssistSettingNavigator
implements IStudioAssistSettingNavigator,
EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(StudioAssistSettingNavigator.class);
    private final AtomicReference<Browser> mainBrowser = new AtomicReference<Object>(null);
    private final AtomicBoolean mcpToolViewRegistered = new AtomicBoolean(false);
    private final AtomicBoolean agentProfileViewRegistered = new AtomicBoolean(false);
    private IAgentSessionContext agentSessionContext;
    private IStudioAssistSettingMcpToolView mcpToolView;
    private IStudioAssistSettingToolExecutionView toolExecutionView;
    private IStudioAssistSettingAgentProfileView agentProfileView;
    @Inject
    private IAgentPreferences agentPreferences;
    @Inject
    private IAgentProfileManager agentProfileManager;
    @Inject
    private IProjectAgentProfilePreferences projectAgentProfilePreferences;
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void postConstruct() {
        this.eventBroker.subscribe("STUDIOASSIST_MCP_CLIENT_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("STUDIOASSIST_MCP_CLIENT_AUTHORIZED", (EventHandler)this);
        this.eventBroker.subscribe("ON_STUDIO_ASSIST_CONVERSATION_SESSION_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("ON_AGENT_PROFILES_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("ON_STUDIO_ASSIST_AGENT_PROFILE_UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("ON_AGENT_PROFILE_CREATE_REQUESTED", (EventHandler)this);
    }

    @PreDestroy
    public void preDestroy() {
        this.eventBroker.unsubscribe((EventHandler)this);
        if (this.mcpToolView != null) {
            this.mcpToolView.removeListener();
        }
        if (this.toolExecutionView != null) {
            this.toolExecutionView.removeListener();
        }
        if (this.agentProfileView != null) {
            this.agentProfileView.removeListener();
        }
    }

    public void handleEvent(Event event) {
        String topic;
        switch (topic = event.getTopic()) {
            case "STUDIOASSIST_MCP_CLIENT_UPDATED": {
                Object eventData = event.getProperty("org.eclipse.e4.data");
                if (!(eventData instanceof McpClientUpdatedEvent)) break;
                McpClientUpdatedEvent mcpClientUpdatedEvent = (McpClientUpdatedEvent)eventData;
                this.syncMcpSettingsAndClients(mcpClientUpdatedEvent.getAgentProfileName());
                break;
            }
            case "STUDIOASSIST_MCP_CLIENT_AUTHORIZED": {
                Object data = event.getProperty("org.eclipse.e4.data");
                if (!(data instanceof McpClientAuthorizedEvent)) break;
                McpClientAuthorizedEvent clientData = (McpClientAuthorizedEvent)data;
                this.agentSessionContext.authorizeClient(clientData.getState(), clientData.getAuthorizationCode());
                break;
            }
            case "ON_AGENT_PROFILES_UPDATED": {
                this.updateAgentProfiles();
                break;
            }
            case "ON_STUDIO_ASSIST_AGENT_PROFILE_UPDATED": {
                String profileName = (String)event.getProperty("org.eclipse.e4.data");
                this.syncMcpToolSelectedAgentProfile(profileName);
                this.syncAllSettings(profileName);
                break;
            }
            case "ON_AGENT_PROFILE_CREATE_REQUESTED": {
                this.handleOpenCreateAgentProfileDialog();
                break;
            }
        }
    }

    public void openMcpSetting() {
        this.trackMcpSettingAction(StudioAssistTrackingValueEnum.CLICK_AGENT_MODE_SETTING);
    }

    public synchronized void syncSettings(Browser browser, IAgentSessionContext agentSessionContext) {
        if (agentSessionContext == null || browser == null || browser.isDisposed()) {
            return;
        }
        this.agentSessionContext = agentSessionContext;
        this.mainBrowser.set(browser);
        if (this.mcpToolViewRegistered.compareAndSet(false, true)) {
            this.registerMcpToolView();
        }
        if (this.agentProfileViewRegistered.compareAndSet(false, true)) {
            this.registerAgentProfileView();
        }
        this.updateAgentProfiles();
        AgentProfile appliedProfile = agentSessionContext.getAppliedAgentProfile();
        String appliedProfileName = appliedProfile != null ? appliedProfile.getName() : null;
        this.syncAllSettings(appliedProfileName);
    }

    private void registerMcpToolView() {
        this.mcpToolView = new StudioAssistSettingMcpToolView();
        this.toolExecutionView = new StudioAssistSettingToolExecutionView();
        IStudioAssistSettingMcpToolListener mcpToolListener = new IStudioAssistSettingMcpToolListener(){

            public void onStudioAssistSettingMcpToolOpened(String agentProfileName) {
                StudioAssistSettingNavigator.this.syncMcpToolSelectedAgentProfile(agentProfileName);
                StudioAssistSettingNavigator.this.syncAllSettings(agentProfileName);
            }

            public void onAddMcpServer(String agentProfileName) {
                StudioAssistSettingNavigator.this.handleAddMcpServer(agentProfileName);
                StudioAssistSettingNavigator.this.syncAllSettings(agentProfileName);
            }

            public void onToolSelected(String toolName, String serverName, String agentProfileName) {
                StudioAssistSettingNavigator.this.agentSessionContext.selectTool(serverName, toolName, agentProfileName);
                StudioAssistSettingNavigator.this.updateAgentSetting(agentProfileName);
            }

            public void onToolDeselected(String toolName, String serverName, String agentProfileName) {
                StudioAssistSettingNavigator.this.agentSessionContext.deselectTool(serverName, toolName, agentProfileName);
                StudioAssistSettingNavigator.this.updateAgentSetting(agentProfileName);
            }

            public void onAllToolsSelected(String serverName, String agentProfileName) {
                StudioAssistSettingNavigator.this.agentSessionContext.selectAllTools(serverName, agentProfileName);
                StudioAssistSettingNavigator.this.updateAgentSetting(agentProfileName);
            }

            public void onAllToolsDeselected(String serverName, String agentProfileName) {
                StudioAssistSettingNavigator.this.agentSessionContext.deselectAllTools(serverName, agentProfileName);
                StudioAssistSettingNavigator.this.updateAgentSetting(agentProfileName);
            }

            public void onMcpClientAdded(McpServerDefinition mcpServerDefinition) {
                StudioAssistSettingNavigator.this.syncMcpSettingsAndClients("__GENERIC__");
            }

            public void onServerRefreshed(String serverName, String agentProfileName) {
                StudioAssistSettingNavigator.this.agentSessionContext.refreshClient(serverName, agentProfileName);
                StudioAssistSettingNavigator.this.syncMcpSettingsAndClients(agentProfileName);
                StudioAssistSettingNavigator.this.trackMcpSettingAction(StudioAssistTrackingValueEnum.RELOAD_MCP_SERVER);
            }

            public void onServerRemoved(String serverName, String agentProfileName) {
                StudioAssistSettingNavigator.this.handleRemoveMcpServer(serverName, agentProfileName);
                StudioAssistSettingNavigator.this.syncAllSettings(agentProfileName);
                StudioAssistSettingNavigator.this.trackMcpSettingAction(StudioAssistTrackingValueEnum.DELETE_MCP_SERVER);
            }

            public void onServerEnabled(String serverName, boolean isEnabled, String agentProfileName) {
                if (isEnabled) {
                    StudioAssistSettingNavigator.this.agentSessionContext.enableServer(serverName, agentProfileName);
                } else {
                    StudioAssistSettingNavigator.this.agentSessionContext.disableServer(serverName, agentProfileName);
                }
                StudioAssistSettingNavigator.this.syncAllSettings(agentProfileName);
            }

            public void onServerAuthorizationRequested(String serverName, String agentProfileName) {
                AuthorizationRequest authRequest = StudioAssistSettingNavigator.this.agentSessionContext.requestServerAuthorization(serverName, agentProfileName);
                if (authRequest == null || authRequest.getUri() == null) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"MCP Server Authorization", (String)"Unable to start authorization flow.");
                    return;
                }
                Program.launch((String)authRequest.getUri().toString());
            }

            public void onSearchToolInputClicked() {
                StudioAssistSettingNavigator.this.trackMcpSettingAction(StudioAssistTrackingValueEnum.SEARCH_TOOL);
            }

            public void onAgentProfileSelected(String agentProfileName) {
                if (StudioAssistSettingNavigator.this.agentSessionContext != null) {
                    StudioAssistSettingNavigator.this.agentSessionContext.syncMcpClientsForProfile(agentProfileName);
                }
                StudioAssistSettingNavigator.this.syncMcpToolSelectedAgentProfile(agentProfileName);
                StudioAssistSettingNavigator.this.syncAllSettings(agentProfileName);
            }
        };
        IStudioAssistSettingToolExecutionListener toolExecutionListener = new IStudioAssistSettingToolExecutionListener(){

            public void onMaxToolCallRequested(int maxToolCall) {
                AgentSetting agentSetting = StudioAssistSettingNavigator.this.agentPreferences.loadAgentSetting();
                agentSetting.setMaxToolCalls(maxToolCall);
                StudioAssistSettingNavigator.this.agentPreferences.saveAgentSetting(agentSetting);
                StudioAssistSettingNavigator.this.updateToolExecutionAgentSetting();
            }

            public void onAutoToolApprovalRequested(boolean isAutoApproved) {
                AgentSetting agentSetting = StudioAssistSettingNavigator.this.agentPreferences.loadAgentSetting();
                agentSetting.setAutoToolApproval(isAutoApproved);
                StudioAssistSettingNavigator.this.agentPreferences.saveAgentSetting(agentSetting);
                StudioAssistSettingNavigator.this.updateToolExecutionAgentSetting();
            }

            public void onMcpToolApprovalReset() {
                StudioAssistSettingNavigator.this.handleToolApprovalReset();
                StudioAssistSettingNavigator.this.updateToolExecutionAgentSetting();
            }
        };
        this.mcpToolView.addListener(mcpToolListener);
        this.toolExecutionView.addListener(toolExecutionListener);
    }

    private void registerAgentProfileView() {
        this.agentProfileView = new StudioAssistSettingAgentProfileView();
        IStudioAssistSettingAgentProfileListener agentProfileListener = new IStudioAssistSettingAgentProfileListener(){

            public void onListAgentProfilesRequested() {
                StudioAssistSettingNavigator.this.updateAgentProfiles();
            }

            public void onOpenCreateAgentProfileDialog() {
                StudioAssistSettingNavigator.this.trackMcpSettingAction(StudioAssistTrackingValueEnum.CLICK_NEW_AGENT_PROFILE);
                StudioAssistSettingNavigator.this.handleOpenCreateAgentProfileDialog();
            }

            public void onDeleteAgentProfileRequested(String name) {
                StudioAssistSettingNavigator.this.trackMcpSettingAction(StudioAssistTrackingValueEnum.DELETE_AGENT_PROFILE);
                StudioAssistSettingNavigator.this.handleDeleteAgentProfileRequested(name);
                StudioAssistSettingNavigator.this.syncMcpToolSelectedAgentProfile("__GENERIC__");
                StudioAssistSettingNavigator.this.updateAgentProfiles();
            }

            public void onSetAgentProfileEnabledRequested(AgentProfile request) {
                StudioAssistSettingNavigator.this.handleSetAgentProfileEnabledRequested(request.getName(), request.isEnabled());
                if (StudioAssistSettingNavigator.this.agentSessionContext.getAppliedAgentProfile() != null && StudioAssistSettingNavigator.this.agentSessionContext.getAppliedAgentProfile().getName().equals(request.getName())) {
                    StudioAssistSettingNavigator.this.syncAllSettings("__GENERIC__");
                    StudioAssistSettingNavigator.this.agentSessionContext.updateAppliedAgentProfile(null);
                }
                StudioAssistSettingNavigator.this.updateAgentProfiles();
            }

            public void onOpenAgentPromptRequested(String name) {
                StudioAssistSettingNavigator.this.handleOpenAgentPromptRequested(name);
            }
        };
        this.agentProfileView.addListener(agentProfileListener);
    }

    private void handleOpenCreateAgentProfileDialog() {
        try {
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            if (project == null || project.getLocation() == null || project.getLocation().isBlank()) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Create Agent Profiles", (String)"Please open a project to create an agent profile.");
                return;
            }
            List<String> existingNames = this.agentProfileManager.listProfiles(true).stream().map(AgentProfile::getName).filter(Objects::nonNull).toList();
            AgentProfileAddingDialog dialog = new AgentProfileAddingDialog(Display.getCurrent().getActiveShell(), existingNames);
            int result = dialog.open();
            if (result != 0) {
                return;
            }
            AgentProfile createdProfile = this.agentProfileManager.createProfile(dialog.getProfileName(), dialog.getDescription());
            this.updateAgentProfiles();
            if (createdProfile != null) {
                if (this.agentSessionContext != null) {
                    this.agentSessionContext.syncMcpClientsForProfile(createdProfile.getName());
                }
                this.eventBroker.post("EXPLORER/REFRESH", null);
                this.eventBroker.post("ON_AGENT_PROFILE_CREATED", null);
                this.handleOpenAgentPromptRequested(createdProfile.getName());
                this.updateAgentProfiles();
            }
        }
        catch (Exception e) {
            logger.error("Exception while creating agent profile", (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Unable to create agent profile.");
        }
    }

    private void updateAgentProfiles() {
        if (this.mainBrowser.get() == null || this.mainBrowser.get().isDisposed()) {
            return;
        }
        List agentProfiles = this.agentProfileManager.listProfiles(true);
        BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistSettingView.updateAgentProfiles", (Object[])new Object[]{agentProfiles});
    }

    private void handleDeleteAgentProfileRequested(String name) {
        try {
            AgentProfile appliedProfile;
            MessageDialog dialog = StudioAssistSettingNavigator.getDeleteAgentProfileDialog(name);
            if (dialog.open() != 1) {
                return;
            }
            if (this.agentSessionContext != null && (appliedProfile = this.agentSessionContext.getAppliedAgentProfile()) != null && Objects.equals(appliedProfile.getName(), name)) {
                this.agentSessionContext.updateAppliedAgentProfile(null);
                this.syncAllSettings("__GENERIC__");
            }
            this.agentProfileManager.deleteProfile(name);
            this.updateAgentProfiles();
            this.eventBroker.post("ON_AGENT_PROFILE_DELETED", (Object)name);
        }
        catch (Exception e) {
            logger.error("Exception while deleting agent profile", (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Unable to delete agent profile.");
        }
    }

    private static MessageDialog getDeleteAgentProfileDialog(String profileName) {
        String message = MessageFormat.format("This action will permanently remove the Agent Profile \"{0}\".\nYou won''t be able to undo this action.\nDo you want to remove the Agent Profile \"{0}\"?", profileName);
        return new MessageDialog(Display.getCurrent().getActiveShell(), "Remove Agent Profile", null, message, 3, new String[]{"Cancel", "Remove"}, 1){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Button deleteButton = this.getButton(1);
                if (deleteButton != null) {
                    deleteButton.setBackground(ColorUtil.REMOVE_BUTTON_COLOR);
                    deleteButton.setForeground(ColorUtil.WHITE_COLOR);
                }
            }
        };
    }

    private void handleSetAgentProfileEnabledRequested(String name, boolean enabled) {
        try {
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            if (project == null || project.getLocation() == null || project.getLocation().isBlank()) {
                return;
            }
            this.agentProfileManager.setProfileEnabled(name, enabled);
        }
        catch (Exception e) {
            logger.error("Exception while updating agent profile enabled state", (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Unable to update agent profile.");
        }
    }

    private void handleOpenAgentPromptRequested(String name) {
        try {
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            if (project == null || project.getLocation() == null || project.getLocation().isBlank()) {
                return;
            }
            File promptFile = this.agentProfileManager.getPromptFile(name);
            if (promptFile != null && promptFile.exists()) {
                UserFileEntity promptEntity = new UserFileEntity(promptFile);
                promptEntity.setProject(project);
                FolderEntity agentsFolder = new FolderEntity();
                agentsFolder.setProject(project);
                agentsFolder.setName("Agents");
                FolderEntity profileFolder = new FolderEntity();
                profileFolder.setProject(project);
                profileFolder.setParentFolder(agentsFolder);
                File profileDir = promptFile.getParentFile();
                profileFolder.setName(profileDir != null ? profileDir.getName() : name);
                promptEntity.setParentFolder(profileFolder);
                this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", (Object)promptEntity);
            } else {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Prompt file not found.");
            }
        }
        catch (Exception e) {
            logger.error("Exception while opening agent profile prompt", (Throwable)e);
        }
    }

    private void updateMcpClients(String agentProfileName) {
        if (this.mainBrowser.get() == null || this.mainBrowser.get().isDisposed()) {
            return;
        }
        BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistSettingView.updateMcpClients", (Object[])new Object[]{this.agentSessionContext.getMcpClients(agentProfileName)});
    }

    private void updateAgentSetting(String agentProfileName) {
        if (this.mainBrowser.get() == null || this.mainBrowser.get().isDisposed()) {
            return;
        }
        BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistSettingView.updateAgentSetting", (Object[])new Object[]{this.agentSessionContext.getAgentSetting(agentProfileName)});
    }

    private void updateToolExecutionAgentSetting() {
        if (this.mainBrowser.get() == null || this.mainBrowser.get().isDisposed()) {
            return;
        }
        try {
            BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistSettingView.updateToolExecutionAgentSetting", (Object[])new Object[]{this.agentPreferences.loadAgentSetting()});
        }
        catch (Exception e) {
            logger.debug("Unable to update Tool Execution setting view.", (Throwable)e);
        }
    }

    private void updateMcpSetting(String agentProfileName) {
        if (this.mainBrowser.get() == null || this.mainBrowser.get().isDisposed()) {
            return;
        }
        BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistSettingView.updateMcpSetting", (Object[])new Object[]{this.agentSessionContext.getMcpSetting(agentProfileName)});
    }

    private void syncMcpToolSelectedAgentProfile(String agentProfileName) {
        BrowserFunctionUtil.execute((Browser)this.mainBrowser.get(), (String)"studioAssistSettingView.updateSelectedAgentProfile", (Object[])new Object[]{agentProfileName});
    }

    private void syncAllSettings(String agentProfileName) {
        this.updateMcpSetting(agentProfileName);
        this.updateAgentSetting(agentProfileName);
        this.updateToolExecutionAgentSetting();
        this.updateMcpClients(agentProfileName);
    }

    private void syncMcpSettingsAndClients(String agentProfileName) {
        this.updateMcpSetting(agentProfileName);
        this.updateMcpClients(agentProfileName);
    }

    private void handleAddMcpServer(String agentProfileName) {
        try {
            try {
                BundleContext bundleContext = FrameworkUtil.getBundle(McpServerAddingDialog.class).getBundleContext();
                IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
                McpServerAddingDialog dialog = new McpServerAddingDialog(Display.getCurrent().getActiveShell(), this.agentProfileManager.getProfileByName(agentProfileName));
                ContextInjectionFactory.inject((Object)dialog, (IEclipseContext)context);
                int result = dialog.open();
                if (result == 0) {
                    McpServerDefinition server = dialog.getServer();
                    this.agentSessionContext.addServer(server, agentProfileName);
                    this.syncAllSettings(agentProfileName);
                }
            }
            catch (Exception e) {
                logger.error("Exception while handle ON_STUDIO_ASSIST_ADD_MCP_SERVER event", (Throwable)e);
                this.trackMcpSettingAction(StudioAssistTrackingValueEnum.ADD_MCP_SERVER);
            }
        }
        finally {
            this.trackMcpSettingAction(StudioAssistTrackingValueEnum.ADD_MCP_SERVER);
        }
    }

    private void handleToolApprovalReset() {
        BundleContext bundleContext = FrameworkUtil.getBundle(McpToolApprovalResetDialog.class).getBundleContext();
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        String projectLocation = project != null ? project.getLocation() : null;
        List<String> profileNames = this.agentProfileManager.listProfiles(true).stream().map(AgentProfile::getName).filter(StringUtils::isNotBlank).toList();
        AgentProfile appliedProfile = this.agentSessionContext != null ? this.agentSessionContext.getAppliedAgentProfile() : null;
        String appliedProfileName = appliedProfile != null ? appliedProfile.getName() : null;
        McpToolApprovalResetDialog dialog = new McpToolApprovalResetDialog(Display.getCurrent().getActiveShell(), projectLocation, profileNames, appliedProfileName);
        ContextInjectionFactory.inject((Object)dialog, (IEclipseContext)context);
        int result = dialog.open();
        if (result == 0) {
            AgentSetting agentSetting = dialog.getAgentSetting();
            String selectedProfileName = dialog.getSelectedProfileName();
            if (StringUtils.isNotBlank((CharSequence)selectedProfileName) && this.projectAgentProfilePreferences != null && StringUtils.isNotBlank((CharSequence)projectLocation)) {
                this.projectAgentProfilePreferences.saveProfileAgentSetting(projectLocation, selectedProfileName, agentSetting);
            } else if (this.agentPreferences != null) {
                this.agentPreferences.saveAgentSetting(agentSetting);
            }
            boolean matchesApplied = Objects.equals(StringUtils.trimToNull((String)selectedProfileName), StringUtils.trimToNull((String)appliedProfileName));
            if (matchesApplied && this.agentSessionContext != null) {
                List mcpServerSettings = agentSetting.getMcpServerSettings();
                this.agentSessionContext.resetApprovedTools(mcpServerSettings);
                if (this.agentSessionContext.getConversation() != null && this.agentSessionContext.getConversation().getApprovedTools() != null) {
                    this.agentSessionContext.getConversation().getApprovedTools().clear();
                }
            }
            this.syncAllSettings(selectedProfileName);
            this.trackMcpToolApprovalReset(dialog.getNoOfResetTools());
        }
    }

    private void handleRemoveMcpServer(String serverName, String agentProfileName) {
        McpSetting mcpSetting = this.agentSessionContext.getMcpSetting(agentProfileName);
        McpServerDefinition serverDefinition = mcpSetting.getServers().stream().filter(server -> serverName.equals(server.getName())).findFirst().orElse(null);
        String serverTitle = serverDefinition != null ? serverDefinition.getTitle() : "";
        String serverUrl = "";
        if (serverDefinition instanceof McpHttpServerDefinition) {
            McpHttpServerDefinition httpServer = (McpHttpServerDefinition)serverDefinition;
            serverUrl = httpServer.getUrl();
        } else if (serverDefinition instanceof McpSseServerDefinition) {
            McpSseServerDefinition sseServer = (McpSseServerDefinition)serverDefinition;
            serverUrl = sseServer.getUrl();
        }
        boolean hasTitle = StringUtils.isNotBlank((CharSequence)serverTitle);
        String detailedMessage = MessageFormat.format(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_DELETE_MESSAGE, hasTitle ? serverTitle : serverName);
        String serverDisplayName = hasTitle ? String.format("%s: %s (%s)", serverName, serverTitle, serverUrl) : String.format("%s (%s)", serverName, serverUrl);
        MessageDialog dialog = StudioAssistSettingNavigator.getMessageDialog(serverDisplayName, detailedMessage);
        if (dialog.open() == 1) {
            this.agentSessionContext.removeServer(serverName, agentProfileName);
            this.syncMcpSettingsAndClients(agentProfileName);
        }
    }

    private static MessageDialog getMessageDialog(String serverDisplayName, String detailedMessage) {
        String warningQuestion = MessageFormat.format(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_DELETE_WARNING, serverDisplayName);
        String fullMessage = detailedMessage + "\n" + warningQuestion;
        return new MessageDialog(Display.getCurrent().getActiveShell(), ComposerStudioAssistConstants.DIALOG_MCP_SERVER_DELETE_TITLE, null, fullMessage, 3, new String[]{ComposerStudioAssistConstants.DIALOG_MCP_SERVER_CANCEL_BUTTON_LABEL, ComposerStudioAssistConstants.DIALOG_MCP_SERVER_REMOVE_BUTTON_LABEL}, 1){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Button removeButton = this.getButton(1);
                if (removeButton != null) {
                    removeButton.setBackground(ColorUtil.REMOVE_BUTTON_COLOR);
                    removeButton.setForeground(ColorUtil.WHITE_COLOR);
                }
            }
        };
    }

    private void trackMcpToolApprovalReset(int noOfResetTools) {
        McpSettingActionTrackingEvent.Builder builder = this.createMcpSettingEventBuilder(StudioAssistTrackingValueEnum.RESET_TOOL_APPROVAL).addData(StudioAssistTrackingKeyEnum.NUMBER_OF_SUCCESSFUL_TOOL_RESET.getValue(), (Object)noOfResetTools);
        this.eventBroker.post("STUDIOASSIST_TRACK_MCP_SETTING_ACTION", (Object)builder.build());
    }

    private void trackMcpSettingAction(StudioAssistTrackingValueEnum action) {
        this.eventBroker.post("STUDIOASSIST_TRACK_MCP_SETTING_ACTION", (Object)this.createMcpSettingEventBuilder(action).build());
    }

    private McpSettingActionTrackingEvent.Builder createMcpSettingEventBuilder(StudioAssistTrackingValueEnum action) {
        McpSettingActionTrackingEvent.Builder builder = McpSettingActionTrackingEvent.builder().action(action);
        String appliedProfileName = this.agentSessionContext != null && this.agentSessionContext.getAppliedAgentProfile() != null ? this.agentSessionContext.getAppliedAgentProfile().getName() : null;
        builder.chatMode(StudioAssistChatModeTrackingValueEnum.resolve((ChatMode)ChatMode.AGENT, appliedProfileName));
        return builder;
    }
}

