/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.kms.katalon.ai.constants.StudioAssistConstants;
import com.kms.katalon.ai.core.model.agent.AgentSetting;
import com.kms.katalon.ai.core.model.agent.config.McpSetting;
import com.kms.katalon.ai.core.model.chat.AgentProfile;
import com.kms.katalon.ai.core.services.IAgentProfileManager;
import com.kms.katalon.ai.core.services.IProjectAgentProfilePreferences;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import jakarta.inject.Inject;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class AgentProfileManager
implements IAgentProfileManager {
    private static final Logger logger = LoggerFactory.getLogger(AgentProfileManager.class);
    private static final String AGENTS_DIR_NAME = "Agents";
    private static final String PROMPT_FILE_NAME = "prompt.md";
    private static final String DEFAULT_PROMPT_TEMPLATE = "\n";
    @Inject
    private IProjectAgentProfilePreferences projectAgentProfilePreferences;

    public List<AgentProfile> listProfiles(boolean includeDisabled) {
        String projectLocation = this.getCurrentProjectLocation();
        if (projectLocation == null) {
            return Collections.emptyList();
        }
        File agentsRoot = this.resolveAgentsRoot(projectLocation);
        if (agentsRoot == null || !agentsRoot.exists() || !agentsRoot.isDirectory()) {
            return Collections.emptyList();
        }
        File[] agentDirs = agentsRoot.listFiles(File::isDirectory);
        if (agentDirs == null || agentDirs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<AgentProfile> profiles = new ArrayList<AgentProfile>();
        File[] fileArray = agentDirs;
        int n = agentDirs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentProfile profile;
            File agentDir = fileArray[n2];
            String folderName = agentDir.getName();
            File agentJson = new File(agentDir, "agent.json");
            File mcpJson = new File(agentDir, "mcp.json");
            File promptMd = new File(agentDir, PROMPT_FILE_NAME);
            if (agentJson.isFile() && mcpJson.isFile() && promptMd.isFile() && (profile = this.projectAgentProfilePreferences.loadAgentProfile(projectLocation, folderName)) != null && profile.getName() != null && !profile.getName().isBlank() && folderName.equals(profile.getName()) && (includeDisabled || profile.isEnabled())) {
                profiles.add(profile);
            }
            ++n2;
        }
        profiles.sort(Comparator.comparing(AgentProfile::getName, String.CASE_INSENSITIVE_ORDER));
        return profiles;
    }

    public AgentProfile createProfile(String desiredName, String description) {
        String name;
        String projectLocation = this.getCurrentProjectLocation();
        String string = name = desiredName != null ? desiredName.trim() : null;
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Profile name is required");
        }
        if (name.contains("/") || name.contains("\\") || name.contains("..")) {
            throw new IllegalArgumentException("Invalid profile name: " + name);
        }
        boolean exists = this.listProfiles(true).stream().map(AgentProfile::getName).filter(Objects::nonNull).anyMatch(existing -> existing.trim().equalsIgnoreCase(name));
        if (exists) {
            throw new IllegalStateException("Agent profile already exists: " + name);
        }
        File agentDir = this.resolveAgentDir(projectLocation, name);
        if (agentDir == null) {
            throw new IllegalArgumentException("Invalid project location");
        }
        if (agentDir.exists()) {
            throw new IllegalStateException("Agent profile folder already exists: " + name);
        }
        if (!agentDir.mkdirs()) {
            throw new IllegalStateException("Unable to create agent profile folder: " + agentDir.getAbsolutePath());
        }
        AgentProfile profile = new AgentProfile();
        profile.setName(name);
        profile.setDescription(description);
        profile.setEnabled(true);
        this.projectAgentProfilePreferences.saveAgentProfile(projectLocation, profile);
        this.projectAgentProfilePreferences.saveProfileAgentSetting(projectLocation, name, new AgentSetting());
        this.projectAgentProfilePreferences.saveProfileMcpSetting(projectLocation, name, new McpSetting());
        Path promptPath = new File(agentDir, PROMPT_FILE_NAME).toPath();
        try {
            Files.writeString(promptPath, (CharSequence)DEFAULT_PROMPT_TEMPLATE, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e) {
            logger.error(StudioAssistConstants.ERROR_IO_EXCEPTION, (Throwable)e);
        }
        return profile;
    }

    public AgentProfile getProfileByName(String profileName) {
        block4: {
            if (StringUtils.isBlank((CharSequence)profileName)) {
                return null;
            }
            try {
                String projectLocation = this.getCurrentProjectLocation();
                if (projectLocation != null) break block4;
                return null;
            }
            catch (Exception e) {
                logger.warn("Unable to resolve agent profile: {}", (Object)profileName, (Object)e);
                return null;
            }
        }
        return this.listProfiles(false).stream().filter(p -> profileName.equals(p.getName())).findFirst().orElse(null);
    }

    public void deleteProfile(String profileName) {
        String projectLocation = this.getCurrentProjectLocation();
        if (StringUtils.isBlank((CharSequence)profileName)) {
            return;
        }
        File agentDir = this.resolveAgentDir(projectLocation, profileName);
        if (agentDir == null || !agentDir.exists()) {
            return;
        }
        this.deleteRecursively(agentDir.toPath());
    }

    public void setProfileEnabled(String profileName, boolean enabled) {
        if (StringUtils.isBlank((CharSequence)profileName)) {
            return;
        }
        String projectLocation = this.getCurrentProjectLocation();
        AgentProfile profile = this.projectAgentProfilePreferences.loadAgentProfile(projectLocation, profileName);
        if (profile == null || profile.getName() == null || profile.getName().isBlank()) {
            return;
        }
        if (!profileName.equals(profile.getName())) {
            return;
        }
        profile.setEnabled(enabled);
        this.projectAgentProfilePreferences.saveAgentProfile(projectLocation, profile);
    }

    public File getPromptFile(String profileName) {
        if (StringUtils.isBlank((CharSequence)profileName)) {
            return null;
        }
        String projectLocation = this.getCurrentProjectLocation();
        File agentDir = this.resolveAgentDir(projectLocation, profileName);
        if (agentDir == null) {
            return null;
        }
        return new File(agentDir, PROMPT_FILE_NAME);
    }

    private File resolveAgentsRoot(String projectLocation) {
        File projectRoot = this.resolveProjectRoot(projectLocation);
        if (projectRoot == null) {
            return null;
        }
        return new File(projectRoot, AGENTS_DIR_NAME);
    }

    private File resolveAgentDir(String projectLocation, String agentName) {
        File agentsRoot = this.resolveAgentsRoot(projectLocation);
        if (agentsRoot == null) {
            return null;
        }
        return new File(agentsRoot, agentName);
    }

    private File resolveProjectRoot(String projectLocation) {
        if (projectLocation == null || projectLocation.isBlank()) {
            return null;
        }
        File location = new File(projectLocation);
        if (location.isDirectory()) {
            return location;
        }
        File parent = location.getParentFile();
        return parent != null ? parent : location;
    }

    private void deleteRecursively(Path root) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (Exception e) {
                        logger.error(StudioAssistConstants.ERROR_IO_EXCEPTION, (Throwable)e);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error(StudioAssistConstants.ERROR_IO_EXCEPTION, (Throwable)e);
        }
    }

    private String getCurrentProjectLocation() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        return project != null ? project.getLocation() : null;
    }
}

