/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.kms.katalon.ai.core.model.agent.AgentSetting;
import com.kms.katalon.ai.core.model.agent.config.McpSetting;
import com.kms.katalon.ai.core.model.chat.AgentProfile;
import com.kms.katalon.ai.core.services.IAgentPreferences;
import com.kms.katalon.ai.core.services.IAgentSettingsStore;
import com.kms.katalon.ai.core.services.IProjectAgentProfilePreferences;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AgentSettingsStore
implements IAgentSettingsStore {
    @Inject
    private IAgentPreferences agentPreferences;
    @Inject
    private IProjectAgentProfilePreferences projectAgentProfilePreferences;

    public AgentSetting loadAgentSetting(String projectLocation, AgentProfile selectedAgentProfile) {
        String selectedProfileName;
        String string = selectedProfileName = selectedAgentProfile != null ? selectedAgentProfile.getName() : null;
        if (this.isProjectAgentScope(projectLocation, selectedProfileName)) {
            return this.projectAgentProfilePreferences.loadProfileAgentSetting(projectLocation, selectedProfileName);
        }
        return this.agentPreferences.loadAgentSetting();
    }

    public void saveAgentSetting(String projectLocation, AgentProfile selectedAgentProfile, AgentSetting agentSetting) {
        String selectedProfileName;
        String string = selectedProfileName = selectedAgentProfile != null ? selectedAgentProfile.getName() : null;
        if (this.isProjectAgentScope(projectLocation, selectedProfileName)) {
            this.projectAgentProfilePreferences.saveProfileAgentSetting(projectLocation, selectedProfileName, agentSetting);
            return;
        }
        this.agentPreferences.saveAgentSetting(agentSetting);
    }

    public McpSetting loadMcpSetting(String projectLocation, AgentProfile selectedAgentProfile) {
        String selectedProfileName;
        String string = selectedProfileName = selectedAgentProfile != null ? selectedAgentProfile.getName() : null;
        if (this.isProjectAgentScope(projectLocation, selectedProfileName)) {
            return this.projectAgentProfilePreferences.loadProfileMcpSetting(projectLocation, selectedProfileName);
        }
        return this.agentPreferences.loadMcpSetting();
    }

    public void saveMcpSetting(String projectLocation, AgentProfile selectedAgentProfile, McpSetting mcpSetting) {
        String selectedProfileName;
        String string = selectedProfileName = selectedAgentProfile != null ? selectedAgentProfile.getName() : null;
        if (this.isProjectAgentScope(projectLocation, selectedProfileName)) {
            this.projectAgentProfilePreferences.saveProfileMcpSetting(projectLocation, selectedProfileName, mcpSetting);
            return;
        }
        this.agentPreferences.saveMcpSetting(mcpSetting);
    }

    private boolean isProjectAgentScope(String projectLocation, String profileName) {
        return StringUtils.isNotBlank((CharSequence)projectLocation) && StringUtils.isNotBlank((CharSequence)profileName);
    }
}

