/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.kms.katalon.ai.core.model.config.AzureOpenAIConfig;
import com.kms.katalon.ai.core.model.llm.CompletionOptions;
import com.kms.katalon.ai.core.model.llm.LlmMessage;
import com.kms.katalon.ai.services.BaseOpenAiService;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.InvalidRequestException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;

public class AzureOpenAiService
extends BaseOpenAiService {
    private final String AZURE_OPENAI_CHAT_COMPLETION_PATH = "/openai/deployments/{0}/chat/completions";
    protected AzureOpenAIConfig config;

    public AzureOpenAiService(AzureOpenAIConfig config) {
        this.config = config;
        this.maxCompletionTokens = config.getMaxToken();
    }

    @Override
    protected BaseOpenAiService.ChatCompletionsData sendRequest(ChatCompletionsOptions completionsOptions) throws URISyntaxException, HttpException {
        URI baseUri = new URI(this.config.getBaseUrl());
        URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(MessageFormat.format("/openai/deployments/{0}/chat/completions", this.config.getDeploymentName())).setParameter("api-version", this.config.getApiVersion()).build();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("api-key", this.config.getApiKey());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        try {
            StringEntity entity = new StringEntity(completionsOptions.toJsonString(), StandardCharsets.UTF_8);
            HttpResponse response = this.httpClient.post(uri, (HttpEntity)entity, httpOptions);
            return new BaseOpenAiService.ChatCompletionsData(uri, httpOptions, response);
        }
        catch (IOException e) {
            throw new InvalidRequestException((Throwable)e);
        }
    }

    @Override
    protected ChatCompletionsOptions buildRequest(List<LlmMessage> messages, CompletionOptions options) throws IOException {
        ChatCompletionsOptions completionsOptions = super.buildRequest(messages, options);
        completionsOptions.setTemperature(null);
        return completionsOptions;
    }
}

