/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.ai.core.model.agent.AgentConversation;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.AgentSession;
import com.kms.katalon.ai.core.model.agent.Entity;
import com.kms.katalon.ai.core.model.agent.EntityModification;
import com.kms.katalon.ai.core.model.agent.EntityModificationStatus;
import com.kms.katalon.ai.core.model.agent.EntityModificationType;
import com.kms.katalon.ai.core.model.agent.EntityType;
import com.kms.katalon.ai.core.model.agent.ToolCallMessage;
import com.kms.katalon.ai.core.services.IEntityModificationService;
import com.kms.katalon.ai.core.services.IFileSnapshotService;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class EntityModificationService
implements IEntityModificationService {
    private static final Logger logger = LoggerFactory.getLogger(EntityModificationService.class);
    private static final String FEATURE_FOLDER_ROOT = "Include/features";
    private static final String INCLUDE_FOLDER = "Include";
    private static final String FEATURE_SUBFOLDER = "features";
    private static final String KEYWORD_FOLDER_ROOT = "Keywords";
    private static final String TEST_OBJECT_ROOT = "Object Repository";
    private static final String TEST_OBJECT_ROOT_PREFIX = "Object Repository/";
    private static final String TEST_DATA_ROOT = "Data Files";
    private static final String TEST_DATA_ROOT_PREFIX = "Data Files/";
    private static final String GROOVY_EXTENSION = ".groovy";
    private static final String TEST_CASE_ROOT = "Test Cases";
    private static final String TEST_CASE_ROOT_PREFIX = "Test Cases/";
    private static final String TEST_SUITE_ROOT = "Test Suites";
    private static final String TEST_SUITE_ROOT_PREFIX = "Test Suites/";
    private static final String FEATURE_EXTENSION = ".feature";
    private static final String FIELD_TEST_CASE_ID = "testCaseId";
    private static final String FIELD_TEST_SUITE_ID = "testSuiteId";
    private static final String FIELD_TEST_OBJECT_ID = "testObjectId";
    private static final String FIELD_TEST_DATA_ID = "testDataId";
    private static final String UPDATE_TEST_CASE_SCRIPT = "updateTestCaseScript";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, EntityModificationStrategy> toolStrategies = new HashMap<String, EntityModificationStrategy>();
    private final EntityResolver entityResolver = new EntityResolver();
    @Inject
    private IFileSnapshotService fileSnapshotService;

    private void registerToolStrategy(String toolName, EntityModificationStrategy strategy) {
        if (StringUtils.isBlank((CharSequence)toolName) || strategy == null) {
            return;
        }
        this.toolStrategies.put(toolName, strategy);
    }

    @PostConstruct
    void initializeStrategies() {
        this.registerToolStrategy(UPDATE_TEST_CASE_SCRIPT, (input, result, call, resultText) -> this.buildTestCaseModification(input, EntityModificationType.UPDATED));
        this.registerToolStrategy("updateTestCase", (input, result, call, resultText) -> this.buildTestCaseModification(input, EntityModificationType.UPDATED));
        this.registerToolStrategy("createTestCase", (input, result, call, resultText) -> this.buildTestCaseModification(result, EntityModificationType.CREATED));
        this.registerToolStrategy("updateBddFeatureFile", (input, result, call, resultText) -> this.buildBddFeatureModification(input, false));
        this.registerToolStrategy("createBddFeatureFile", (input, result, call, resultText) -> this.buildBddFeatureModification(result, true));
        this.registerToolStrategy("updateCustomKeyword", (input, result, call, resultText) -> this.buildCustomKeywordUpdateModification(input));
        this.registerToolStrategy("createCustomKeyword", (input, result, call, resultText) -> this.buildCustomKeywordCreateModification(result));
        this.registerToolStrategy("createTestSuite", (input, result, call, resultText) -> this.buildTestSuiteModification(this.readText(result, FIELD_TEST_SUITE_ID), EntityType.TEST_SUITE, EntityModificationType.CREATED));
        this.registerToolStrategy("updateTestSuite", (input, result, call, resultText) -> this.buildTestSuiteModification(this.readText(input, FIELD_TEST_SUITE_ID), EntityType.TEST_SUITE, EntityModificationType.UPDATED));
        this.registerToolStrategy("createTestSuiteCollection", (input, result, call, resultText) -> this.buildTestSuiteModification(this.readText(result, FIELD_TEST_SUITE_ID), EntityType.TEST_SUITE_COLLECTION, EntityModificationType.CREATED));
        this.registerToolStrategy("updateTestSuiteCollection", (input, result, call, resultText) -> this.buildTestSuiteModification(this.readText(input, FIELD_TEST_SUITE_ID), EntityType.TEST_SUITE_COLLECTION, EntityModificationType.UPDATED));
        this.registerToolStrategy("createDynamicTestSuite", (input, result, call, resultText) -> this.buildTestSuiteModification(this.readText(result, FIELD_TEST_SUITE_ID), EntityType.DYNAMIC_TEST_SUITE, EntityModificationType.CREATED));
        this.registerToolStrategy("updateDynamicTestSuite", (input, result, call, resultText) -> this.buildTestSuiteModification(this.readText(input, FIELD_TEST_SUITE_ID), EntityType.DYNAMIC_TEST_SUITE, EntityModificationType.UPDATED));
        this.registerToolStrategy("createWebTestObject", (input, result, call, resultText) -> this.buildTestObjectModification(this.readText(result, FIELD_TEST_OBJECT_ID), EntityType.WEB_TEST_OBJECT, EntityModificationType.CREATED));
        this.registerToolStrategy("updateWebTestObject", (input, result, call, resultText) -> this.buildTestObjectModification(this.readText(input, FIELD_TEST_OBJECT_ID), EntityType.WEB_TEST_OBJECT, EntityModificationType.UPDATED));
        this.registerToolStrategy("createMobileTestObject", (input, result, call, resultText) -> this.buildTestObjectModification(this.readText(result, FIELD_TEST_OBJECT_ID), EntityType.MOBILE_TEST_OBJECT, EntityModificationType.CREATED));
        this.registerToolStrategy("updateMobileTestObject", (input, result, call, resultText) -> this.buildTestObjectModification(this.readText(input, FIELD_TEST_OBJECT_ID), EntityType.MOBILE_TEST_OBJECT, EntityModificationType.UPDATED));
        this.registerToolStrategy("createWindowsTestObject", (input, result, call, resultText) -> this.buildTestObjectModification(this.readText(result, FIELD_TEST_OBJECT_ID), EntityType.WINDOWS_TEST_OBJECT, EntityModificationType.CREATED));
        this.registerToolStrategy("updateWindowsTestObject", (input, result, call, resultText) -> this.buildTestObjectModification(this.readText(input, FIELD_TEST_OBJECT_ID), EntityType.WINDOWS_TEST_OBJECT, EntityModificationType.UPDATED));
        this.registerToolStrategy("createRestWebServiceTestObject", (input, result, call, resultText) -> this.buildTestObjectModification(this.readText(result, FIELD_TEST_OBJECT_ID), EntityType.REST_WEB_SERVICE_TEST_OBJECT, EntityModificationType.CREATED));
        this.registerToolStrategy("updateRestWebServiceTestObject", (input, result, call, resultText) -> this.buildTestObjectModification(this.readText(input, FIELD_TEST_OBJECT_ID), EntityType.REST_WEB_SERVICE_TEST_OBJECT, EntityModificationType.UPDATED));
        this.registerToolStrategy("createSoapWebServiceTestObject", (input, result, call, resultText) -> this.buildTestObjectModification(this.readText(result, FIELD_TEST_OBJECT_ID), EntityType.SOAP_WEB_SERVICE_TEST_OBJECT, EntityModificationType.CREATED));
        this.registerToolStrategy("updateSoapWebServiceTestObject", (input, result, call, resultText) -> this.buildTestObjectModification(this.readText(input, FIELD_TEST_OBJECT_ID), EntityType.SOAP_WEB_SERVICE_TEST_OBJECT, EntityModificationType.UPDATED));
        this.registerToolStrategy("createInternalTestData", (input, result, call, resultText) -> this.buildTestDataModification(this.readText(result, FIELD_TEST_DATA_ID), EntityModificationType.CREATED));
        this.registerToolStrategy("updateInternalTestData", (input, result, call, resultText) -> this.buildTestDataModification(this.readText(input, FIELD_TEST_DATA_ID), EntityModificationType.UPDATED));
    }

    public void recordEntityModification(AgentSession session, AgentMessage agentMessage, ToolCallMessage toolCallMessage, String toolResultText) {
        if (agentMessage == null || toolCallMessage == null) {
            return;
        }
        try {
            EntityModification modification;
            JsonNode inputNode = this.parseJson(toolCallMessage.getInput());
            JsonNode resultNode = this.parseJson(toolResultText);
            String toolName = toolCallMessage.getName();
            if (StringUtils.isBlank((CharSequence)toolName)) {
                logger.info("Tool call missing name, skipping modification persistence");
                return;
            }
            EntityModificationStrategy strategy = this.toolStrategies.get(toolName);
            EntityModification entityModification = modification = strategy != null ? strategy.build(inputNode, resultNode, toolCallMessage, toolResultText) : null;
            if (modification != null && modification.getEntity() != null) {
                this.persistEntityModification(session, agentMessage, modification, false, false);
            } else {
                logger.info("Failed to build modification for tool {}", (Object)toolName);
            }
        }
        catch (Exception e) {
            logger.info("Failed to record entity modification for tool {}", (Object)toolCallMessage.getName(), (Object)e);
        }
    }

    public boolean undoEntityModification(AgentSession session, Entity entity) {
        return this.processSingleUndo(session, entity);
    }

    public boolean markEntityModificationReviewed(AgentSession session, Entity entity) {
        return this.processSingleReview(session, entity);
    }

    public boolean undoAllEntityModifications(AgentSession session, AgentMessage agentMessage) {
        AgentConversation conversation;
        AgentConversation agentConversation = conversation = session != null ? session.getConversation() : null;
        if (conversation == null) {
            return false;
        }
        boolean success = true;
        List<EntityModification> snapshot = this.resolveSnapshot(conversation, agentMessage);
        for (EntityModification modification : snapshot) {
            Entity modEntity = modification.getEntity();
            if (modEntity != null && this.processSingleUndo(session, modEntity)) continue;
            success = false;
        }
        return success;
    }

    public boolean markAllEntityModificationsReviewed(AgentSession session, AgentMessage agentMessage) {
        AgentConversation conversation;
        AgentConversation agentConversation = conversation = session != null ? session.getConversation() : null;
        if (conversation == null) {
            return false;
        }
        boolean success = true;
        List<EntityModification> snapshot = this.resolveSnapshot(conversation, agentMessage);
        for (EntityModification modification : snapshot) {
            Entity modEntity = modification.getEntity();
            if (modEntity != null && this.processSingleReview(session, modEntity)) continue;
            success = false;
        }
        return success;
    }

    public EntityModification findEntityModification(AgentConversation conversation, String entityId) {
        if (conversation == null || conversation.getEntityModifications() == null || StringUtils.isBlank((CharSequence)entityId)) {
            return null;
        }
        return conversation.getEntityModifications().stream().filter(mod -> mod.getEntity() != null && entityId.equals(mod.getEntity().getId())).findFirst().orElse(null);
    }

    public String resolveFilePath(EntityModification modification) {
        if (modification == null) {
            return null;
        }
        return this.resolveEntityFilePathInternal(modification.getEntity(), modification);
    }

    public void persistEntityModification(AgentSession session, AgentMessage agentMessage, EntityModification modification, boolean recomputeDiffStats, boolean compareMetadata) {
        EntityModification conversationEntry;
        if (modification == null || modification.getEntity() == null) {
            return;
        }
        if (recomputeDiffStats) {
            this.recomputeLineStatistics(modification);
            if (modification.getLinesAdded() == 0 && modification.getLinesRemoved() == 0) {
                this.clearPendingModificationIfNoChanges(session, modification);
                return;
            }
        }
        if (compareMetadata && this.hasUnchangedMetadata(modification)) {
            return;
        }
        EntityModification target = modification;
        if (session != null && session.getConversation() != null && (conversationEntry = session.getConversation().addEntityModification(modification)) != null) {
            target = conversationEntry;
        }
        if (agentMessage != null) {
            agentMessage.addEntityModification(target);
        }
    }

    public Optional<EntityModification> prepareModificationSnapshot(AgentSession session, ToolCallMessage toolCallMessage) {
        if (toolCallMessage == null) {
            return Optional.empty();
        }
        String toolName = toolCallMessage.getName();
        if (StringUtils.isBlank((CharSequence)toolName)) {
            return Optional.empty();
        }
        EntityModificationStrategy strategy = this.toolStrategies.get(toolName);
        if (strategy == null) {
            return Optional.empty();
        }
        JsonNode inputNode = this.parseJson(toolCallMessage.getInput());
        if (inputNode == null) {
            return Optional.empty();
        }
        try {
            EntityModification modification = strategy.build(inputNode, null, toolCallMessage, null);
            if (modification == null) {
                return Optional.empty();
            }
            Optional<EntityModification> existing = this.resolveExistingPendingModification(session, modification);
            if (existing.isPresent()) {
                return existing;
            }
            return this.captureSnapshotForModification(toolName, modification);
        }
        catch (Exception e) {
            logger.error("Failed to prepare snapshot for tool {}", (Object)toolName, (Object)e);
            return Optional.empty();
        }
    }

    private Optional<EntityModification> resolveExistingPendingModification(AgentSession session, EntityModification modification) {
        AgentConversation conversation;
        AgentConversation agentConversation = conversation = session != null ? session.getConversation() : null;
        if (conversation == null || modification == null || modification.getEntity() == null) {
            return Optional.empty();
        }
        EntityModification existing = this.findEntityModification(conversation, modification.getEntity().getId());
        if (existing == null || StringUtils.isBlank((CharSequence)existing.getSnapshotId())) {
            return Optional.empty();
        }
        modification.setSnapshotId(existing.getSnapshotId());
        return Optional.of(modification);
    }

    private void clearPendingModificationIfNoChanges(AgentSession session, EntityModification modification) {
        if (modification.getEntity() == null) {
            return;
        }
        try {
            AgentConversation conversation;
            EntityModification existing;
            String entityId = modification.getEntity().getId();
            if (StringUtils.isNotBlank((CharSequence)entityId) && (existing = this.findEntityModification(conversation = session.getConversation(), entityId)) != null) {
                String snapshotId = existing.getSnapshotId();
                if (StringUtils.isNotBlank((CharSequence)snapshotId)) {
                    this.fileSnapshotService.deleteSnapshot(snapshotId);
                }
                conversation.removeEntityModification(entityId);
                return;
            }
            String snapshotId = modification.getSnapshotId();
            if (StringUtils.isNotBlank((CharSequence)snapshotId)) {
                this.fileSnapshotService.deleteSnapshot(snapshotId);
            }
        }
        catch (Exception e) {
            logger.info("Failed to cleanup no-op modification for entity {}", (Object)(modification.getEntity() != null ? modification.getEntity().getId() : "unknown"), (Object)e);
        }
    }

    private boolean processSingleUndo(AgentSession session, Entity entity) {
        boolean restored;
        AgentConversation conversation;
        AgentConversation agentConversation = conversation = session != null ? session.getConversation() : null;
        if (!this.isUndoInputsValid(conversation, entity)) {
            return false;
        }
        EntityModification modification = this.findEntityModification(conversation, entity.getId());
        if (modification == null) {
            logger.error("Cannot undo file modification: entityId {} not found", (Object)entity.getId());
            return false;
        }
        String filePath = this.resolveEntityFilePathInternal(modification.getEntity(), modification);
        if (filePath == null) {
            logger.error("Cannot undo file modification: missing filePath for entityId {}", (Object)entity.getId());
            return false;
        }
        boolean bl = restored = modification.getType() == EntityModificationType.CREATED ? this.deleteCreatedAsset(filePath) : this.restoreSnapshot(modification, entity.getId(), filePath);
        if (!restored) {
            return false;
        }
        modification.setStatus(EntityModificationStatus.REJECTED);
        conversation.removeEntityModification(entity.getId());
        return true;
    }

    private boolean isUndoInputsValid(AgentConversation conversation, Entity entity) {
        return conversation != null && entity != null && StringUtils.isNotBlank((CharSequence)entity.getId());
    }

    private boolean deleteCreatedAsset(String filePath) {
        try {
            java.nio.file.Path createdPath = java.nio.file.Path.of(filePath, new String[0]);
            if (Files.exists(createdPath, new LinkOption[0])) {
                Files.delete(createdPath);
            }
            this.refreshWorkspaceFile(filePath);
            return true;
        }
        catch (IOException ioException) {
            logger.error("Failed to delete created file {}", (Object)filePath, (Object)ioException);
            return false;
        }
    }

    private boolean restoreSnapshot(EntityModification modification, String entityId, String filePath) {
        String snapshotId;
        String string = snapshotId = modification != null ? modification.getSnapshotId() : null;
        if (StringUtils.isBlank((CharSequence)snapshotId)) {
            logger.error("Cannot undo update: snapshotId missing for entityId {}", (Object)entityId);
            return false;
        }
        try {
            this.fileSnapshotService.restoreSnapshot(snapshotId, filePath);
            this.fileSnapshotService.deleteSnapshot(snapshotId);
            this.refreshWorkspaceFile(filePath);
            return true;
        }
        catch (Exception exception) {
            logger.error("Failed to restore snapshot {} for entity {}", new Object[]{snapshotId, entityId, exception});
            return false;
        }
    }

    private boolean processSingleReview(AgentSession session, Entity entity) {
        String snapshotId;
        EntityModification modification;
        AgentConversation conversation;
        block8: {
            block7: {
                block6: {
                    try {
                        AgentConversation agentConversation = conversation = session != null ? session.getConversation() : null;
                        if (conversation != null && entity != null && !StringUtils.isBlank((CharSequence)entity.getId())) break block6;
                        return false;
                    }
                    catch (Exception e) {
                        logger.error("Failed to mark reviewed entity {}", (Object)(entity != null ? entity.getId() : "unknown"), (Object)e);
                        return false;
                    }
                }
                modification = this.findEntityModification(conversation, entity.getId());
                if (modification != null) break block7;
                logger.error("Cannot mark reviewed: entityId {} not found", (Object)entity.getId());
                return false;
            }
            boolean isCreate = modification.getType() == EntityModificationType.CREATED;
            snapshotId = modification.getSnapshotId();
            if (isCreate || !StringUtils.isBlank((CharSequence)snapshotId)) break block8;
            logger.error("Cannot mark reviewed: snapshotId missing for entityId {}", (Object)entity.getId());
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)snapshotId)) {
            this.fileSnapshotService.deleteSnapshot(snapshotId);
        }
        modification.setStatus(EntityModificationStatus.APPROVED);
        conversation.removeEntityModification(entity.getId());
        return true;
    }

    private List<EntityModification> resolveSnapshot(AgentConversation conversation, AgentMessage agentMessage) {
        if (agentMessage != null) {
            List entityModifications = agentMessage.getEntityModifications();
            return entityModifications == null ? List.of() : List.copyOf(entityModifications);
        }
        if (conversation == null) {
            return List.of();
        }
        return List.copyOf(conversation.getEntityModifications());
    }

    private JsonNode parseJson(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return this.objectMapper.readTree(json);
        }
        catch (Exception e) {
            logger.info("Failed to parse JSON payload", (Throwable)e);
            return null;
        }
    }

    private String readText(JsonNode node, String fieldName) {
        if (node == null || StringUtils.isBlank((CharSequence)fieldName)) {
            return null;
        }
        JsonNode valueNode = node.path(fieldName);
        return valueNode.isMissingNode() || valueNode.isNull() ? null : valueNode.asText();
    }

    private EntityModification buildTestCaseModification(JsonNode inputNode, EntityModificationType type) {
        if (inputNode == null) {
            return null;
        }
        String testCaseId = this.readText(inputNode, FIELD_TEST_CASE_ID);
        if (StringUtils.isBlank((CharSequence)testCaseId)) {
            return null;
        }
        return this.resolveTestCase(testCaseId).map(testCase -> this.buildEntityModification(testCase.getIdForDisplay(), EntityType.TEST_CASE, type)).orElse(null);
    }

    private Optional<TestCaseEntity> resolveTestCase(String testCaseId) {
        if (StringUtils.isBlank((CharSequence)testCaseId)) {
            return Optional.empty();
        }
        Optional<TestCaseEntity> direct = this.entityResolver.findTestCase(testCaseId);
        if (direct.isPresent()) {
            return direct;
        }
        String normalized = this.normalizeTestCaseId(testCaseId);
        if (normalized.equals(testCaseId)) {
            logger.debug("Unable to resolve test case '{}'", (Object)testCaseId);
            return Optional.empty();
        }
        Optional<TestCaseEntity> fallback = this.entityResolver.findTestCase(normalized);
        if (fallback.isEmpty()) {
            logger.debug("Unable to resolve test case '{}' even after normalization '{}'", (Object)testCaseId, (Object)normalized);
        } else {
            logger.debug("Resolved test case '{}' via normalized id '{}'", (Object)testCaseId, (Object)normalized);
        }
        return fallback;
    }

    private String normalizeTestCaseId(String rawTestCaseId) {
        String normalized = rawTestCaseId.trim().replace("\\", "/");
        if (normalized.startsWith("/")) {
            normalized = normalized.substring(1);
        }
        return this.ensurePrefix(normalized, TEST_CASE_ROOT_PREFIX);
    }

    private String ensurePrefix(String value, String prefix) {
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.isBlank((CharSequence)prefix)) {
            return value;
        }
        return value.startsWith(prefix) ? value : prefix + value;
    }

    private Optional<WebElementEntity> resolveTestObject(String testObjectId) {
        return this.resolveEntity(testObjectId, this::normalizeTestObjectId, this.entityResolver::findTestObject);
    }

    private Optional<WindowsElementEntity> resolveWindowsTestObject(String testObjectId) {
        return this.resolveEntity(testObjectId, this::normalizeTestObjectId, this.entityResolver::findWindowsTestObject);
    }

    private Optional<DataFileEntity> resolveTestData(String testDataId) {
        return this.resolveEntity(testDataId, this::normalizeTestDataId, this.entityResolver::findTestData);
    }

    private Optional<TestSuiteEntity> resolveTestSuite(String testSuiteId) {
        return this.resolveEntity(testSuiteId, this::normalizeTestSuiteId, this.entityResolver::findTestSuite);
    }

    private Optional<TestSuiteCollectionEntity> resolveTestSuiteCollection(String collectionId) {
        return this.resolveEntity(collectionId, this::normalizeTestSuiteCollectionId, this.entityResolver::findTestSuiteCollection);
    }

    private <T> Optional<T> resolveEntity(String rawId, UnaryOperator<String> normalizer, Function<String, Optional<T>> resolver) {
        if (StringUtils.isBlank((CharSequence)rawId)) {
            return Optional.empty();
        }
        Optional<T> direct = resolver.apply(rawId);
        if (direct.isPresent()) {
            return direct;
        }
        String normalized = (String)normalizer.apply(rawId);
        if (rawId.equals(normalized)) {
            return Optional.empty();
        }
        return resolver.apply(normalized);
    }

    private String normalizeTestObjectId(String testObjectId) {
        String normalized = testObjectId.trim().replace("\\", "/");
        if (normalized.startsWith("/")) {
            normalized = normalized.substring(1);
        }
        return this.ensurePrefix(normalized, TEST_OBJECT_ROOT_PREFIX);
    }

    private String normalizeTestDataId(String testDataId) {
        String normalized = testDataId.trim().replace("\\", "/");
        if (normalized.startsWith("/")) {
            normalized = normalized.substring(1);
        }
        return this.ensurePrefix(normalized, TEST_DATA_ROOT_PREFIX);
    }

    private String normalizeTestSuiteId(String testSuiteId) {
        String normalized = testSuiteId.trim().replace("\\", "/");
        if (normalized.startsWith("/")) {
            normalized = normalized.substring(1);
        }
        return this.ensurePrefix(normalized, TEST_SUITE_ROOT_PREFIX);
    }

    private String normalizeTestSuiteCollectionId(String collectionId) {
        String normalized = collectionId.trim().replace("\\", "/");
        if (normalized.startsWith("/")) {
            normalized = normalized.substring(1);
        }
        return this.ensurePrefix(normalized, TEST_SUITE_ROOT_PREFIX);
    }

    private EntityModification buildBddFeatureModification(JsonNode node, boolean isCreate) {
        if (node == null) {
            return null;
        }
        String featurePath = isCreate ? this.readText(node, "filePath") : this.normalizeFeaturePath(this.readText(node, "featureFileId"));
        if (StringUtils.isBlank((CharSequence)featurePath)) {
            return null;
        }
        return this.buildEntityModification(featurePath, EntityType.FEATURE_FILE, isCreate ? EntityModificationType.CREATED : EntityModificationType.UPDATED);
    }

    private EntityModification buildCustomKeywordUpdateModification(JsonNode inputNode) {
        if (inputNode == null) {
            return null;
        }
        String keywordIdentifier = this.readText(inputNode, "fullyQualifiedName");
        if (StringUtils.isBlank((CharSequence)keywordIdentifier)) {
            return null;
        }
        String normalizedId = this.normalizeCustomKeywordIdentifier(keywordIdentifier);
        if (normalizedId == null) {
            return null;
        }
        return this.buildEntityModification(normalizedId, EntityType.CUSTOM_KEYWORD, EntityModificationType.UPDATED);
    }

    private EntityModification buildCustomKeywordCreateModification(JsonNode resultNode) {
        if (resultNode == null) {
            return null;
        }
        String keywordIdentifier = this.readText(resultNode, "keywordRelativePath");
        if (StringUtils.isBlank((CharSequence)keywordIdentifier)) {
            return null;
        }
        String normalizedId = this.normalizeCustomKeywordIdentifier(keywordIdentifier);
        if (normalizedId == null) {
            return null;
        }
        return this.buildEntityModification(normalizedId, EntityType.CUSTOM_KEYWORD, EntityModificationType.CREATED);
    }

    private EntityModification buildTestSuiteModification(String rawId, EntityType entityType, EntityModificationType type) {
        if (StringUtils.isBlank((CharSequence)rawId) || entityType == null) {
            return null;
        }
        if (entityType == EntityType.TEST_SUITE_COLLECTION) {
            return this.resolveTestSuiteCollection(rawId).map(collection -> this.buildEntityModification(collection.getIdForDisplay(), entityType, type)).orElse(null);
        }
        TestSuiteEntity testSuite = this.resolveTestSuite(rawId).orElse(null);
        if (testSuite == null) {
            return null;
        }
        return this.buildEntityModification(testSuite.getIdForDisplay(), entityType, type);
    }

    private EntityModification buildTestObjectModification(String rawId, EntityType entityType, EntityModificationType type) {
        if (StringUtils.isBlank((CharSequence)rawId) || entityType == null) {
            return null;
        }
        String resolvedId = null;
        resolvedId = entityType == EntityType.WINDOWS_TEST_OBJECT ? (String)this.resolveWindowsTestObject(rawId).map(FileEntity::getIdForDisplay).orElse(resolvedId) : this.resolveTestObject(rawId).map(FileEntity::getIdForDisplay).orElse(rawId);
        return this.buildEntityModification(resolvedId, entityType, type);
    }

    private EntityModification buildTestDataModification(String rawId, EntityModificationType type) {
        if (StringUtils.isBlank((CharSequence)rawId)) {
            return null;
        }
        String resolvedId = this.resolveTestData(rawId).map(FileEntity::getIdForDisplay).orElse(rawId);
        return this.buildEntityModification(resolvedId, EntityType.INTERNAL_TEST_DATA, type);
    }

    private EntityModification buildEntityModification(String entityId, EntityType entityType, EntityModificationType modificationType) {
        if (StringUtils.isBlank((CharSequence)entityId) || entityType == null) {
            return null;
        }
        Entity entity = new Entity(entityId, entityType);
        EntityModification modification = new EntityModification();
        modification.setEntity(entity);
        modification.setType(modificationType);
        modification.setSnapshotId(null);
        modification.setLinesAdded(0);
        modification.setLinesRemoved(0);
        return modification;
    }

    private String normalizeFeaturePath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return path;
        }
        Object normalized = path.trim().replace("\\", "/");
        if (((String)normalized).startsWith("/")) {
            normalized = ((String)normalized).substring(1);
        }
        if (!((String)normalized).startsWith(FEATURE_FOLDER_ROOT)) {
            normalized = ((String)normalized).startsWith(FEATURE_SUBFOLDER) ? "Include/" + (String)normalized : "Include/features/" + (String)normalized;
        }
        return this.appendExtension((String)normalized, FEATURE_EXTENSION);
    }

    private String normalizeCustomKeywordIdentifier(String identifier) {
        boolean alreadyPath;
        if (StringUtils.isBlank((CharSequence)identifier)) {
            return null;
        }
        String normalized = identifier.trim();
        if (normalized.contains("\\") || normalized.contains("../")) {
            normalized = normalized.replace("\\", "/");
        }
        if (alreadyPath = normalized.contains("/")) {
            return this.ensureKeywordPath(normalized);
        }
        String dotted = normalized.replace(".", "/");
        return this.ensureKeywordPath(dotted);
    }

    private String ensureKeywordPath(String path) {
        Object normalized = this.appendExtension(path, GROOVY_EXTENSION);
        if (!((String)normalized).startsWith("Keywords/")) {
            normalized = "Keywords/" + (String)normalized;
        }
        return normalized;
    }

    private String appendExtension(String path, String extension) {
        if (StringUtils.isBlank((CharSequence)path) || StringUtils.isBlank((CharSequence)extension)) {
            return path;
        }
        if (path.endsWith(extension)) {
            return path;
        }
        if (extension.charAt(0) == '.') {
            return path + extension;
        }
        return path + "." + extension;
    }

    private String resolveWorkspacePath(String path) {
        java.nio.file.Path projectPath;
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        String normalized = path.replace("\\", "/");
        java.nio.file.Path normalizedPath = Paths.get(normalized, new String[0]);
        if (normalizedPath.isAbsolute()) {
            return normalizedPath.normalize().toString();
        }
        String projectRoot = null;
        try {
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            if (project != null) {
                projectRoot = project.getFolderLocation();
            }
        }
        catch (Exception e) {
            logger.info("Failed to resolve project path", (Throwable)e);
        }
        if (StringUtils.isBlank(projectRoot)) {
            return normalized;
        }
        java.nio.file.Path resolvedPath = Paths.get(projectRoot, normalized).normalize();
        if (!resolvedPath.startsWith(projectPath = Paths.get(projectRoot, new String[0]).normalize())) {
            logger.warn("Path traversal attempt detected: {} resolves outside project root", (Object)path);
            return null;
        }
        return resolvedPath.toString();
    }

    private String resolveEntityFilePathInternal(Entity entity, EntityModification modification) {
        if (entity == null || entity.getType() == null) {
            return null;
        }
        return switch (entity.getType()) {
            case EntityType.TEST_CASE -> this.resolveTestCaseFile(entity.getId(), modification);
            case EntityType.FEATURE_FILE -> this.resolveFeatureFilePath(entity.getId());
            case EntityType.CUSTOM_KEYWORD -> this.resolveCustomKeywordFile(entity.getId());
            case EntityType.TEST_SUITE -> this.resolveTestSuiteFile(entity.getId(), EntityType.TEST_SUITE);
            case EntityType.TEST_SUITE_COLLECTION -> this.resolveTestSuiteFile(entity.getId(), EntityType.TEST_SUITE_COLLECTION);
            case EntityType.DYNAMIC_TEST_SUITE -> this.resolveTestSuiteFile(entity.getId(), EntityType.DYNAMIC_TEST_SUITE);
            case EntityType.INTERNAL_TEST_DATA -> this.resolveTestDataFile(entity.getId());
            case EntityType.TEST_OBJECT, EntityType.MOBILE_TEST_OBJECT, EntityType.REST_WEB_SERVICE_TEST_OBJECT, EntityType.SOAP_WEB_SERVICE_TEST_OBJECT, EntityType.WEB_TEST_OBJECT -> this.resolveTestObjectFile(entity.getId(), entity.getType());
            case EntityType.WINDOWS_TEST_OBJECT -> this.resolveTestObjectFile(entity.getId(), EntityType.WINDOWS_TEST_OBJECT);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private String resolveTestCaseFile(String entityId, EntityModification modification) {
        return this.resolveTestCaseFile(entityId, modification, false);
    }

    private String resolveTestCaseFile(String entityId, EntityModification modification, boolean preferScriptFile) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return null;
        }
        boolean scriptModification = preferScriptFile || this.hasDiffLines(modification);
        Optional<TestCaseEntity> testCaseOpt = this.entityResolver.findTestCase(entityId);
        if (scriptModification) {
            if (testCaseOpt.isPresent()) {
                try {
                    return Objects.requireNonNull(GroovyUtil.getTestCaseScriptFile((TestCaseEntity)testCaseOpt.get())).getLocation().toFile().getAbsolutePath();
                }
                catch (Exception ex) {
                    logger.info("Unable to resolve script path for test case {}", (Object)entityId, (Object)ex);
                }
            }
            return null;
        }
        return testCaseOpt.map(FileEntity::getLocation).orElse(null);
    }

    private String resolveFeatureFilePath(String relativePath) {
        if (StringUtils.isBlank((CharSequence)relativePath)) {
            return null;
        }
        return this.resolveWorkspacePath(this.normalizeFeaturePath(relativePath));
    }

    private String resolveCustomKeywordFile(String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            return null;
        }
        String relativePath = this.normalizeCustomKeywordIdentifier(identifier);
        return this.resolveWorkspacePath(relativePath);
    }

    private String resolveTestSuiteFile(String displayId, EntityType entityType) {
        if (StringUtils.isBlank((CharSequence)displayId) || entityType == null) {
            return null;
        }
        try {
            if (entityType == EntityType.TEST_SUITE_COLLECTION) {
                TestSuiteCollectionEntity collection = TestSuiteCollectionController.getInstance().getTestRunByDisplayId(displayId);
                if (collection != null) {
                    return collection.getLocation();
                }
            } else {
                TestSuiteEntity testSuite;
                ProjectEntity project = ProjectController.getInstance().getCurrentProject();
                if (project != null && (testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(displayId, project)) != null) {
                    return testSuite.getLocation();
                }
            }
        }
        catch (Exception ex) {
            logger.info("Unable to resolve test suite {} for {}", new Object[]{displayId, entityType, ex});
        }
        return null;
    }

    private String resolveTestObjectFile(String testObjectId, EntityType entityType) {
        if (StringUtils.isBlank((CharSequence)testObjectId)) {
            return null;
        }
        if (entityType == EntityType.WINDOWS_TEST_OBJECT) {
            return this.resolveWindowsTestObject(testObjectId).map(FileEntity::getLocation).orElse(null);
        }
        return this.resolveTestObject(testObjectId).map(FileEntity::getLocation).orElse(null);
    }

    private String resolveTestDataFile(String testDataId) {
        if (StringUtils.isBlank((CharSequence)testDataId)) {
            return null;
        }
        return this.resolveTestData(testDataId).map(FileEntity::getLocation).orElse(null);
    }

    private boolean hasDiffLines(EntityModification modification) {
        return modification != null && (modification.getLinesAdded() != 0 || modification.getLinesRemoved() != 0);
    }

    private void refreshWorkspaceFile(String filePath) {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path location = new Path(filePath);
            IFile file = root.getFileForLocation((IPath)location);
            if (file != null && file.exists()) {
                file.refreshLocal(0, null);
                if (file.getParent() != null) {
                    file.getParent().refreshLocal(1, null);
                }
            }
        }
        catch (Exception e) {
            logger.info("Failed to refresh workspace file: {}", (Object)filePath, (Object)e);
        }
    }

    private Optional<EntityModification> captureSnapshotForModification(String toolName, EntityModification modification) {
        if (modification == null || modification.getEntity() == null) {
            return Optional.empty();
        }
        String filePath = this.resolveSnapshotFilePath(toolName, modification);
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return Optional.empty();
        }
        try {
            Optional snapshotId = this.fileSnapshotService.captureSnapshot(modification.getEntity().getId(), modification.getEntity().getType().name(), Paths.get(filePath, new String[0]));
            if (snapshotId.isEmpty()) {
                return Optional.empty();
            }
            modification.setSnapshotId((String)snapshotId.get());
            return Optional.of(modification);
        }
        catch (Exception e) {
            logger.info("Failed to capture snapshot for tool {} entity {}", new Object[]{toolName, modification.getEntity().getId(), e});
            return Optional.empty();
        }
    }

    private String resolveSnapshotFilePath(String toolName, EntityModification modification) {
        if (modification == null) {
            return null;
        }
        boolean forceScriptPath = UPDATE_TEST_CASE_SCRIPT.equals(toolName) && modification.getLinesAdded() == 0 && modification.getLinesRemoved() == 0;
        int originalLinesAdded = modification.getLinesAdded();
        if (forceScriptPath) {
            modification.setLinesAdded(1);
        }
        String filePath = this.resolveFilePath(modification);
        if (forceScriptPath) {
            modification.setLinesAdded(originalLinesAdded);
        }
        return filePath;
    }

    private void recomputeLineStatistics(EntityModification modification) {
        try {
            String originalContent = this.getOriginalContentForSnapshot(modification);
            if (originalContent == null) {
                return;
            }
            String currentContent = this.getCurrentContentForSnapshot(modification, originalContent);
            if (currentContent == null) {
                return;
            }
            int[] deltas = this.computeLineDeltas(originalContent, currentContent);
            modification.setLinesAdded(deltas[0]);
            modification.setLinesRemoved(deltas[1]);
        }
        catch (Exception e) {
            logger.info("Failed to recompute line statistics for entity {}", (Object)modification.getEntity().getId(), (Object)e);
        }
    }

    private boolean hasUnchangedMetadata(EntityModification modification) {
        String currentContent;
        String originalContent;
        block5: {
            block4: {
                try {
                    originalContent = this.getOriginalContentForSnapshot(modification);
                    if (originalContent != null) break block4;
                    return false;
                }
                catch (Exception e) {
                    logger.info("Failed to compare metadata for entity {}", (Object)modification.getEntity().getId(), (Object)e);
                    return false;
                }
            }
            currentContent = this.getCurrentContentForSnapshot(modification, originalContent);
            if (currentContent != null) break block5;
            return false;
        }
        return originalContent.equals(currentContent);
    }

    private String getOriginalContentForSnapshot(EntityModification modification) {
        if (modification == null || modification.getEntity() == null) {
            return null;
        }
        String snapshotId = modification.getSnapshotId();
        if (StringUtils.isBlank((CharSequence)snapshotId)) {
            return null;
        }
        try {
            return this.fileSnapshotService.readSnapshot(snapshotId);
        }
        catch (Exception e) {
            logger.info("Unable to read original snapshot for entity {}: {}", (Object)(modification.getEntity() != null ? modification.getEntity().getId() : "unknown"), (Object)e.getMessage());
            return null;
        }
    }

    private String getCurrentContentForSnapshot(EntityModification modification, String originalContent) {
        if (modification == null || modification.getEntity() == null) {
            return null;
        }
        String filePath = this.resolveFilePathForSnapshot(modification, originalContent);
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return null;
        }
        return this.readCurrentFile(filePath);
    }

    private String resolveFilePathForSnapshot(EntityModification modification, String originalContent) {
        Entity entity;
        Entity entity2 = entity = modification != null ? modification.getEntity() : null;
        if (entity == null) {
            return null;
        }
        if (entity.getType() == EntityType.TEST_CASE) {
            boolean scriptSnapshot = this.isTestCaseScriptSnapshot(originalContent);
            return this.resolveTestCaseFile(entity.getId(), modification, scriptSnapshot);
        }
        return this.resolveEntityFilePathInternal(entity, modification);
    }

    private boolean isTestCaseScriptSnapshot(String content) {
        if (content == null) {
            return false;
        }
        String normalized = this.trimLeadingWhitespace(content);
        if (StringUtils.isBlank((CharSequence)normalized)) {
            return false;
        }
        return normalized.charAt(0) != '<';
    }

    private String trimLeadingWhitespace(String content) {
        int length = content.length();
        int index = 0;
        while (index < length && this.isLeadingWhitespace(content.charAt(index))) {
            ++index;
        }
        return content.substring(index);
    }

    private boolean isLeadingWhitespace(char current) {
        return current == '\ufeff' || Character.isWhitespace(current);
    }

    private String readCurrentFile(String filePath) {
        try {
            return Files.readString(java.nio.file.Path.of(filePath, new String[0]), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.info("Unable to read current file {}: {}", (Object)filePath, (Object)e.getMessage());
            return null;
        }
    }

    private int[] computeLineDeltas(String originalContent, String currentContent) {
        LineComparator original = new LineComparator(originalContent);
        LineComparator current = new LineComparator(currentContent);
        RangeDifference[] diffs = RangeDifferencer.findDifferences((IRangeComparator)original, (IRangeComparator)current);
        int added = 0;
        int removed = 0;
        RangeDifference[] rangeDifferenceArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            RangeDifference diff = rangeDifferenceArray[n2];
            added += diff.rightLength();
            removed += diff.leftLength();
            ++n2;
        }
        return new int[]{added, removed};
    }

    @FunctionalInterface
    private static interface EntityModificationStrategy {
        public EntityModification build(JsonNode var1, JsonNode var2, ToolCallMessage var3, String var4);
    }

    private static final class EntityResolver {
        private EntityResolver() {
        }

        Optional<TestCaseEntity> findTestCase(String testCaseId) {
            if (StringUtils.isBlank((CharSequence)testCaseId)) {
                return Optional.empty();
            }
            try {
                return Optional.ofNullable(TestCaseController.getInstance().getTestCaseByDisplayId(testCaseId));
            }
            catch (Exception ex) {
                logger.info("Unable to locate test case {}", (Object)testCaseId, (Object)ex);
                return Optional.empty();
            }
        }

        Optional<TestSuiteEntity> findTestSuite(String testSuiteId) {
            if (StringUtils.isBlank((CharSequence)testSuiteId)) {
                return Optional.empty();
            }
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            if (project == null) {
                return Optional.empty();
            }
            try {
                return Optional.ofNullable(TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteId, project));
            }
            catch (Exception ex) {
                logger.info("Unable to locate test suite {}", (Object)testSuiteId, (Object)ex);
                return Optional.empty();
            }
        }

        Optional<TestSuiteCollectionEntity> findTestSuiteCollection(String collectionId) {
            if (StringUtils.isBlank((CharSequence)collectionId)) {
                return Optional.empty();
            }
            try {
                return Optional.ofNullable(TestSuiteCollectionController.getInstance().getTestRunByDisplayId(collectionId));
            }
            catch (Exception ex) {
                logger.info("Unable to locate test suite collection {}", (Object)collectionId, (Object)ex);
                return Optional.empty();
            }
        }

        Optional<WebElementEntity> findTestObject(String testObjectId) {
            if (StringUtils.isBlank((CharSequence)testObjectId)) {
                return Optional.empty();
            }
            try {
                return Optional.ofNullable(ObjectRepositoryController.getInstance().getWebElementByDisplayPk(testObjectId));
            }
            catch (Exception ex) {
                logger.info("Unable to locate test object {}", (Object)testObjectId, (Object)ex);
                return Optional.empty();
            }
        }

        Optional<WindowsElementEntity> findWindowsTestObject(String windowsObjectId) {
            if (StringUtils.isBlank((CharSequence)windowsObjectId)) {
                return Optional.empty();
            }
            try {
                return Optional.ofNullable(WindowsElementController.getInstance().getWindowsElementByDisplayId(windowsObjectId));
            }
            catch (ControllerException ex) {
                logger.info("Unable to locate Windows test object {}", (Object)windowsObjectId, (Object)ex);
                return Optional.empty();
            }
        }

        Optional<DataFileEntity> findTestData(String testDataId) {
            if (StringUtils.isBlank((CharSequence)testDataId)) {
                return Optional.empty();
            }
            try {
                return Optional.ofNullable(TestDataController.getInstance().getTestDataByDisplayId(testDataId));
            }
            catch (Exception ex) {
                logger.info("Unable to locate test data {}", (Object)testDataId, (Object)ex);
                return Optional.empty();
            }
        }
    }

    private static final class LineComparator
    implements IRangeComparator {
        private final List<String> lines;

        private LineComparator(String content) {
            this.lines = Arrays.asList(content.split("\\R", -1));
        }

        public int getRangeCount() {
            return this.lines.size();
        }

        /*
         * WARNING - void declaration
         */
        public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
            void that;
            if (!(other instanceof LineComparator)) {
                return false;
            }
            LineComparator lineComparator = (LineComparator)other;
            return this.lines.get(thisIndex).equals(that.lines.get(otherIndex));
        }

        public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
            return false;
        }
    }
}

