/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.genai.types.Candidate;
import com.google.genai.types.Content;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.GenerateContentResponse;
import com.google.genai.types.Part;
import com.google.genai.types.Schema;
import com.google.genai.types.Tool;
import com.kms.katalon.ai.constants.AIConstants;
import com.kms.katalon.ai.core.model.config.GeminiConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistChatIncompleteResponseMessageException;
import com.kms.katalon.ai.core.model.exception.StudioAssistException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiAuthenticationException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiClientException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiNoInternetException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiProxyException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiResourceExhaustedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiRuntimeException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerContentViolatedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerNoAnswerException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerTimeoutException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerTokenExceededException;
import com.kms.katalon.ai.core.model.llm.AssistantMessage;
import com.kms.katalon.ai.core.model.llm.CompletionOptions;
import com.kms.katalon.ai.core.model.llm.CompositeUserMessage;
import com.kms.katalon.ai.core.model.llm.InlineFileInput;
import com.kms.katalon.ai.core.model.llm.InlineImageInput;
import com.kms.katalon.ai.core.model.llm.LlmMessage;
import com.kms.katalon.ai.core.model.llm.SystemMessage;
import com.kms.katalon.ai.core.model.llm.TextInput;
import com.kms.katalon.ai.core.model.llm.ToolCall;
import com.kms.katalon.ai.core.model.llm.UserInput;
import com.kms.katalon.ai.core.model.llm.UserMessage;
import com.kms.katalon.ai.core.services.ILlmService;
import com.kms.katalon.ai.dto.GoogleAiErrorDto;
import com.kms.katalon.ai.dto.GoogleErrorDetailDto;
import com.kms.katalon.ai.services.gemini.GeminiChatCompleteOptions;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiService
implements ILlmService {
    private static final Logger logger = LoggerFactory.getLogger(GeminiService.class);
    @Inject
    protected INetworkPreferences networkPreferences;
    @Inject
    protected IHttpClient httpClient;
    @Inject
    protected IDiscoveryService discoveryService;
    protected GeminiConfig config;
    private ObjectMapper objectMapper = new ObjectMapper();

    public GeminiService(GeminiConfig config) {
        this.config = config;
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        this.objectMapper.registerModule((Module)new Jdk8Module());
    }

    public AssistantMessage getChatCompletions(List<LlmMessage> messages, CompletionOptions options) {
        try {
            GeminiChatCompleteOptions request = this.buildRequest(messages, options);
            HttpResponse response = this.sendRequest(request);
            if (response == null) {
                throw new StudioAssistException("Failed to fetch response from GEMINI");
            }
            this.handleResponseError(response);
            GenerateContentResponse completionResponse = (GenerateContentResponse)response.json(GenerateContentResponse.class);
            return this.parseResponse(completionResponse);
        }
        catch (HttpException e) {
            logger.error("HTTP communication error during Gemini chat completion request - check network connectivity and API endpoint", (Throwable)e);
            throw new StudioAssistLlmApiRuntimeException(e.getMessage());
        }
        catch (StudioAssistLlmApiNoInternetException e) {
            logger.error("No internet connection detected during Gemini chat completion request - verify network connectivity", (Throwable)e);
            throw e;
        }
        catch (StudioAssistException e) {
            logger.error("Gemini API error during chat completion request - check API configuration and request parameters", (Throwable)e);
            throw new StudioAssistLlmApiRuntimeException(e.getMessage());
        }
        catch (StudioAssistLlmApiResourceExhaustedException e) {
            logger.error("Resource exhausted while handle Katalon AI chat question", (Throwable)e);
            throw new StudioAssistLlmApiResourceExhaustedException(e.getMessage());
        }
        catch (NullPointerException e) {
            logger.error("Null pointer exception during Gemini chat completion request - possible missing data in request or response", (Throwable)e);
            throw new StudioAssistChatIncompleteResponseMessageException();
        }
        catch (Exception e) {
            logger.error("Unexpected error during Gemini chat completion request", (Throwable)e);
            throw new StudioAssistLlmApiRuntimeException(e.getMessage());
        }
    }

    private HttpResponse sendRequest(GeminiChatCompleteOptions geminiRequest) throws StudioAssistException {
        HttpResponse response;
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().proxy(proxyConfig).build();
        try {
            URI uri = this.buildUri();
            String body = this.objectMapper.writeValueAsString((Object)geminiRequest);
            response = this.httpClient.jsonPost(uri, body, httpOptions);
        }
        catch (NetworkErrorException e) {
            if (!this.discoveryService.isOnline(this.discoveryService.getServerUrl(ServerType.TESTOPS))) {
                logger.error("Internet disconnected while execute generate content", (Throwable)e);
                throw new StudioAssistLlmApiNoInternetException((Throwable)e);
            }
            throw new StudioAssistLlmApiRuntimeException((Throwable)e);
        }
        catch (JsonProcessingException | HttpException e) {
            logger.error("Failed to generate content with Gemini", e);
            throw new StudioAssistLlmApiRuntimeException(e);
        }
        return response;
    }

    private void handleResponseError(HttpResponse httpResponse) throws MalformedContentException {
        int statusCode = httpResponse.getStatusCode();
        Optional<GoogleAiErrorDto> error = Optional.ofNullable((GoogleAiErrorDto)httpResponse.json(GoogleAiErrorDto.class));
        String errorMessage = error.map(GoogleAiErrorDto::getError).map(GoogleErrorDetailDto::getMessage).orElse("");
        if (statusCode >= 400 && statusCode < 500) {
            switch (statusCode) {
                case 407: {
                    throw new StudioAssistLlmApiProxyException(errorMessage);
                }
                case 401: 
                case 403: {
                    throw new StudioAssistLlmApiAuthenticationException(errorMessage);
                }
                case 404: {
                    if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        throw new StudioAssistLlmApiClientException(errorMessage);
                    }
                    throw new StudioAssistLlmApiClientException(AIConstants.MSG_INVALID_BASE_URL);
                }
                case 429: {
                    throw new StudioAssistLlmApiResourceExhaustedException();
                }
            }
            throw new StudioAssistLlmApiClientException(errorMessage);
        }
        if (statusCode >= 500) {
            if (statusCode == 504) {
                throw new StudioAssistLlmApiServerTimeoutException(errorMessage);
            }
            throw new StudioAssistLlmApiServerException(errorMessage);
        }
    }

    private URI buildUri() {
        try {
            URI baseUri = new URI(this.config.getBaseUrl());
            String apiVersion = baseUri.getPath().isBlank() ? "v1beta" : baseUri.getPath();
            String path = String.format("%s/models/%s:generateContent", apiVersion, this.config.getModel());
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(path).setParameter("key", this.config.getApiKey()).build();
            return uri;
        }
        catch (URISyntaxException e) {
            logger.error("Failed to build URI Gemini from base URL", (Throwable)e);
            throw new StudioAssistLlmApiRuntimeException((Throwable)e);
        }
    }

    private GeminiChatCompleteOptions buildRequest(List<LlmMessage> messages, CompletionOptions options) {
        GenerateContentConfig.Builder configBuilder = GenerateContentConfig.builder().maxOutputTokens(Integer.valueOf(this.config.getMaxToken())).candidateCount(Integer.valueOf(1));
        if (options.getTemperature() != null) {
            configBuilder = configBuilder.temperature(Float.valueOf(options.getTemperature().floatValue()));
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getResponseSchema())) {
            configBuilder = configBuilder.responseSchema(Schema.fromJson((String)options.getResponseSchema()));
            if (options.getTools().isEmpty()) {
                configBuilder = configBuilder.responseMimeType("application/json");
            }
        }
        List<Part> systemMessageParts = messages.stream().filter(message -> message instanceof SystemMessage).map(message -> (SystemMessage)message).map(SystemMessage::getContent).map(Part::fromText).toList();
        Content systemMessageContent = null;
        if (!CollectionUtils.isEmpty(systemMessageParts)) {
            systemMessageContent = Content.builder().parts(systemMessageParts).build();
        }
        List<Content> userContents = messages.stream().filter(message -> !(message instanceof SystemMessage)).flatMap(message -> this.mapToContents((LlmMessage)message).stream()).toList();
        if (CollectionUtils.isEmpty((Collection)options.getTools())) {
            return new GeminiChatCompleteOptions(systemMessageContent, userContents, configBuilder.build(), this.config.getModel());
        }
        List<FunctionDeclaration> functions = options.getTools().stream().map(tool -> FunctionDeclaration.builder().name(tool.name()).description(StringUtils.defaultString((String)tool.description())).parameters(Schema.fromJson((String)this.jsonSchemaToString(tool.inputSchema()))).build()).toList();
        Tool tool2 = Tool.builder().functionDeclarations(functions).build();
        return new GeminiChatCompleteOptions(systemMessageContent, userContents, configBuilder.build(), this.config.getModel(), List.of(tool2));
    }

    private List<Content> mapToContents(LlmMessage message) {
        if (message instanceof AssistantMessage) {
            AssistantMessage assistantMessage = (AssistantMessage)message;
            if (StringUtils.isNotBlank((CharSequence)assistantMessage.getContent())) {
                return List.of(Content.builder().role("model").parts(List.of(Part.fromText((String)assistantMessage.getContent()))).build());
            }
            return assistantMessage.getToolCalls().stream().flatMap(this::mapToContents).toList();
        }
        if (message instanceof CompositeUserMessage) {
            CompositeUserMessage compositeUserMessage = (CompositeUserMessage)message;
            List<Part> parts = this.buildCompositeParts(compositeUserMessage);
            return List.of(Content.builder().role("user").parts(parts).build());
        }
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            return List.of(Content.builder().role("user").parts(List.of(Part.fromText((String)userMessage.getContent()))).build());
        }
        throw new IllegalArgumentException("Unsupported message type: " + message.getClass().getName());
    }

    protected List<Part> buildCompositeParts(CompositeUserMessage message) {
        ArrayList<Part> parts = new ArrayList<Part>();
        for (UserInput input : message.getInputs()) {
            if (input instanceof TextInput) {
                TextInput textInput = (TextInput)input;
                parts.add(Part.fromText((String)textInput.getText()));
                continue;
            }
            if (input instanceof InlineImageInput) {
                InlineImageInput inlineImageInput = (InlineImageInput)input;
                parts.add(this.buildImagePart(inlineImageInput));
                continue;
            }
            if (input instanceof InlineFileInput) {
                InlineFileInput inlineFileInput = (InlineFileInput)input;
                parts.add(this.buildInlineFileDataPart(inlineFileInput));
                continue;
            }
            throw new IllegalArgumentException("Unsupported user input type: " + input.getClass().getName());
        }
        return parts;
    }

    private Part buildImagePart(InlineImageInput input) {
        byte[] bytes = this.decodeBase64(input.getData());
        return Part.fromBytes((byte[])bytes, (String)input.getFormat().getMimeType());
    }

    private Part buildFileParts(InlineFileInput input) {
        StringBuilder builder = new StringBuilder();
        builder.append("[FILE name=").append((String)StringUtils.defaultIfBlank((CharSequence)input.getFileName(), (CharSequence)"attachment")).append(" format=").append(input.getFormat()).append("]");
        String content = (String)StringUtils.defaultIfBlank((CharSequence)this.getTextContent(input), (CharSequence)"(no content)");
        builder.append(System.lineSeparator()).append(content);
        return Part.fromText((String)builder.toString());
    }

    private Part buildInlineFileDataPart(InlineFileInput input) {
        byte[] bytes = this.decodeBase64(input.getData());
        return Part.fromBytes((byte[])bytes, (String)input.getMimeType());
    }

    private String getTextContent(InlineFileInput input) {
        if (StringUtils.isBlank((CharSequence)input.getData())) {
            return "";
        }
        try {
            byte[] decoded = Base64.getDecoder().decode(input.getData());
            return new String(decoded, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException exception) {
            logger.error("Unable to decode inline file for " + input.getFileName(), (Throwable)exception);
            return "";
        }
    }

    private byte[] decodeBase64(String data) {
        try {
            return Base64.getDecoder().decode(data);
        }
        catch (IllegalArgumentException exception) {
            throw new StudioAssistLlmApiClientException("Invalid base64 payload", (Throwable)exception);
        }
    }

    private Stream<Content> mapToContents(ToolCall toolCall) {
        if (toolCall.getOutput() == null) {
            return Stream.of(new Content[0]);
        }
        FunctionResponse.Builder responseBuilder = FunctionResponse.builder().name(toolCall.getName()).response(Map.of("result", toolCall.getOutput()));
        if (StringUtils.isNotBlank((CharSequence)toolCall.getCallId())) {
            responseBuilder = responseBuilder.id(toolCall.getCallId());
        }
        FunctionResponse response = responseBuilder.build();
        Part part = Part.builder().functionResponse(response).build();
        return Stream.of(Content.builder().role("function").parts(List.of(part)).build());
    }

    private String jsonSchemaToString(McpSchema.JsonSchema schema) {
        String jsonSchemaString = "{}";
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            jsonSchemaString = mapper.writeValueAsString((Object)schema);
        }
        catch (JsonProcessingException exception) {
            logger.warn("Error while getting parameters for tool definition " + schema.toString(), (Throwable)exception);
        }
        return jsonSchemaString;
    }

    private AssistantMessage parseResponse(GenerateContentResponse response) {
        boolean hasToolCall;
        StringBuilder result = new StringBuilder();
        result.append(response.text());
        String finishReason = response.candidates().flatMap(candidates -> candidates.stream().findFirst().flatMap(Candidate::finishReason)).orElse("");
        if (finishReason.equals("MAX_TOKENS")) {
            throw new StudioAssistLlmApiServerTokenExceededException("Token exceeded");
        }
        if (finishReason.equals("PROHIBITED_CONTENT")) {
            throw new StudioAssistLlmApiServerContentViolatedException("Content violated filtered by LLM");
        }
        boolean bl = hasToolCall = !response.functionCalls().isEmpty();
        if (StringUtils.isBlank((CharSequence)result) && !hasToolCall) {
            throw new StudioAssistLlmApiServerNoAnswerException("Empty answer from LLM");
        }
        if (hasToolCall) {
            List<ToolCall> toolCalls = response.functionCalls().stream().map(this::mapToToolCall).toList();
            return AssistantMessage.of(toolCalls);
        }
        return AssistantMessage.of((String)result.toString());
    }

    private ToolCall mapToToolCall(FunctionCall functionCall) {
        ToolCall tool = new ToolCall();
        tool.setCallId((String)functionCall.id().orElse(null));
        tool.setName(functionCall.name().orElse(""));
        try {
            tool.setInput(this.objectMapper.writeValueAsString(functionCall.args().get()));
        }
        catch (JsonProcessingException e) {
            logger.warn("Error while serialize function call arguments", (Throwable)e);
        }
        return tool;
    }
}

