/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.kms.katalon.ai.constants.AIConstants;
import com.kms.katalon.ai.core.dto.ChatCompletionRequest;
import com.kms.katalon.ai.core.dto.Configuration;
import com.kms.katalon.ai.core.dto.GeneralPromptExecuteRequest;
import com.kms.katalon.ai.core.dto.Prompt;
import com.kms.katalon.ai.core.dto.StudioAssistRequest;
import com.kms.katalon.ai.core.dto.StudioAssistResponse;
import com.kms.katalon.ai.core.model.exception.StudioAssistException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiAuthenticationException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiClientException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiNoInternetException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiProxyException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiResourceExhaustedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiRuntimeException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerTimeoutException;
import com.kms.katalon.ai.core.model.exception.StudioAssistServiceUnreachableException;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.internal.IGenAiClient;
import com.kms.katalon.ai.internal.model.AskForUploadFileRequest;
import com.kms.katalon.ai.internal.model.AskForUploadFileResponse;
import com.kms.katalon.ai.internal.model.GenAiCancelQuestionRequest;
import com.kms.katalon.ai.internal.model.GenAiGetAnswerRequest;
import com.kms.katalon.ai.internal.model.GenAiGetAnswerResponse;
import com.kms.katalon.ai.internal.model.GenAiSubmitQuestionRequest;
import com.kms.katalon.ai.internal.model.GenAiSubmitQuestionResponse;
import com.kms.katalon.common.About;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.BearerAuthentication;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.network.core.model.exception.TokenExpiredException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.session.core.model.Account;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.User;
import com.kms.katalon.session.core.services.ISessionManager;
import com.kms.katalon.testops.core.services.ITestOpsController;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenAiClient
implements IGenAiClient {
    protected static final String X_CLIENT_APP_NAME = "X-Client-App-Name";
    protected static final String X_CLIENT_APP_MODULE = "X-Client-App-Module";
    protected static final String X_CLIENT_APP_VERSION = "X-Client-App-Version";
    protected static final String X_ORGANIZATION_ID = "X-Organization-Id";
    protected static final String X_ACCOUNT_ID = "X-Account-Id";
    protected static final String X_USER_ID = "X-User-Id";
    protected static final String APP_MODULE_STUDIO_ASSIST_PROMPT = "studioassist";
    protected static final String CLIENT_APP_NAME = "katalon_studio";
    protected final Logger logger = LoggerFactory.getLogger(GenAiClient.class);
    protected ObjectMapper objectMapper = new ObjectMapper();
    @Inject
    protected IDiscoveryService discoveryService;
    @Inject
    protected ISessionManager sessionManager;
    @Inject
    protected INetworkPreferences networkPreferences;
    @Inject
    protected IHttpClient httpClient;
    @Inject
    protected ITestOpsController testOpsController;
    protected static String CLIENT_ID = "studio-g4";
    protected static String USER_INPUT_PLACEHOLDER_VARIABLE = "user_input";

    @Override
    public String executePrompt(PromptType promptType, Map<String, Object> parameters) throws StudioAssistException, NetworkErrorException, MalformedContentException {
        try {
            Configuration config = new Configuration(CLIENT_ID, promptType.toString(), parameters);
            ChatCompletionRequest chatCompletion = new ChatCompletionRequest(config);
            Prompt prompt = new Prompt(chatCompletion);
            StudioAssistRequest request = new StudioAssistRequest();
            request.setPrompt(prompt);
            String body = this.objectMapper.writeValueAsString((Object)request);
            HttpResponse response = this.sendPostRequest("v1/llm/prompt/execute", new HashMap<String, String>(), body);
            int statusCode = response.getStatusCode();
            if (statusCode >= 400 && statusCode < 500) {
                this.handleError(statusCode, response.getBody());
            } else if (statusCode >= 500 && statusCode < 600) {
                this.handleServerError(statusCode, response.getBody());
            }
            StudioAssistResponse studioAssistResponse = (StudioAssistResponse)response.json(StudioAssistResponse.class);
            String outputContent = studioAssistResponse.getResponse().getChatCompletion().getChatCompletionChoice(0).getMessage().getContent();
            return outputContent;
        }
        catch (IOException | URISyntaxException exception) {
            if (exception instanceof UnknownHostException || exception instanceof SocketException) {
                throw new StudioAssistServiceUnreachableException((Throwable)exception);
            }
            if (exception instanceof TokenExpiredException) {
                throw new StudioAssistException(AIConstants.MSG_SESSION_NOT_ACTIVE, 0);
            }
            throw new StudioAssistException(exception.getMessage() != null ? exception.getMessage() : exception.getMessage(), 0);
        }
    }

    protected HttpResponse sendPostRequest(String path, Map<String, String> headers, String body) throws URISyntaxException, NetworkErrorException {
        URI uri = this.buildUri(path);
        HttpOptions httpOptions = this.buildHttpOptions(headers);
        HttpResponse response = null;
        try {
            StringEntity entity = new StringEntity(body, StandardCharsets.UTF_8);
            response = this.httpClient.post(uri, (HttpEntity)entity, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        return response;
    }

    protected HttpResponse sendGetRequest(String path, Map<String, String> headers) throws URISyntaxException, NetworkErrorException {
        URI uri = this.buildUri(path);
        HttpOptions httpOptions = this.buildHttpOptions(headers);
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        return response;
    }

    protected HttpResponse sendDeleteRequest(String path, Map<String, String> headers) throws URISyntaxException, NetworkErrorException {
        URI uri = this.buildUri(path);
        HttpOptions httpOptions = this.buildHttpOptions(headers);
        HttpResponse response = null;
        try {
            response = this.httpClient.delete(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        return response;
    }

    protected HttpOptions buildHttpOptions(Map<String, String> headers) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.putIfAbsent(X_CLIENT_APP_NAME, CLIENT_APP_NAME);
        headers.putIfAbsent(X_CLIENT_APP_MODULE, APP_MODULE_STUDIO_ASSIST_PROMPT);
        headers.computeIfAbsent(X_ACCOUNT_ID, k -> Optional.ofNullable(this.sessionManager.getAccount()).map(Account::getId).map(String::valueOf).orElse(null));
        headers.computeIfAbsent(X_ORGANIZATION_ID, k -> Optional.ofNullable(this.sessionManager.getOrganization()).map(Organization::getId).map(String::valueOf).orElse(null));
        headers.computeIfAbsent(X_USER_ID, k -> Optional.ofNullable(this.sessionManager.getUser()).map(User::getId).map(String::valueOf).orElse(null));
        String appVersion = About.releaseVersion();
        headers.putIfAbsent(X_CLIENT_APP_VERSION, StringUtils.defaultString((String)appVersion));
        AuthenticationToken katOneToken = this.sessionManager.getKatOneToken();
        BearerAuthentication authenticate = Authentication.BearerAuthentication((String)katOneToken.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        return new HttpOptions.Builder().headers(headers).authentication((Authentication)authenticate).proxy(proxyConfig).build();
    }

    protected URI buildUri(String path) throws URISyntaxException {
        String baseUrl = this.discoveryService.getServerUrl(ServerType.PLATFORM);
        URI baseUri = new URI(baseUrl);
        URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(path);
        URI uri = uriBuilder.build();
        return uri;
    }

    protected void handleError(int statusCode, String responseBody) throws NetworkErrorException {
        throw new NetworkErrorException(this.extractErrorMessage(responseBody));
    }

    protected void handleServerError(int statusCode, String responseBody) throws NetworkErrorException {
        throw new NetworkErrorException(this.extractErrorMessage(responseBody));
    }

    protected String extractErrorMessage(String responseBody) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(responseBody);
            String message = rootNode.path("message").asText(null);
            if (message != null) {
                return message;
            }
            message = rootNode.path("error_description").asText(null);
            if (message != null) {
                return message;
            }
            return responseBody;
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
            return responseBody;
        }
    }

    @Override
    public GenAiSubmitQuestionResponse submitQuestion(GenAiSubmitQuestionRequest request) {
        try {
            this.logger.debug("submitQuestion request -> %s".formatted(new Gson().toJson((Object)request)));
            String body = this.objectMapper.writeValueAsString((Object)request);
            HttpResponse httpResponse = this.sendPostRequest("v1/llm/chatJobs", new HashMap<String, String>(), body);
            this.handleLlmResponseErrorIfAny(httpResponse);
            this.logger.debug("submitQuestion response body -> %s".formatted(httpResponse.getBody()));
            return (GenAiSubmitQuestionResponse)httpResponse.json(GenAiSubmitQuestionResponse.class);
        }
        catch (JsonProcessingException | NetworkErrorException | URISyntaxException e) {
            this.logger.error("Exception while submit studio assist chat job", e);
            if (!this.testOpsController.isOnline()) {
                throw new StudioAssistLlmApiNoInternetException(e);
            }
            throw new StudioAssistLlmApiRuntimeException(e);
        }
        catch (MalformedContentException e) {
            this.logger.error("Exception while parsing response data", (Throwable)e);
            throw new StudioAssistLlmApiRuntimeException((Throwable)e);
        }
    }

    @Override
    public GenAiGetAnswerResponse getAnswer(GenAiGetAnswerRequest request) {
        try {
            HttpResponse httpResponse = this.sendGetRequest("%s/%s".formatted("v1/llm/chatJobs", request.getChatJobId()), new HashMap<String, String>());
            this.handleLlmResponseErrorIfAny(httpResponse);
            this.logger.debug("getAnswer response body -> %s".formatted(httpResponse.getBody()));
            return (GenAiGetAnswerResponse)httpResponse.json(GenAiGetAnswerResponse.class);
        }
        catch (NetworkErrorException | URISyntaxException e) {
            this.logger.error("Exception while get studio assist chat job", e);
            throw new StudioAssistLlmApiRuntimeException(e);
        }
        catch (MalformedContentException e) {
            this.logger.error("Exception while parsing response data", (Throwable)e);
            throw new StudioAssistLlmApiRuntimeException((Throwable)e);
        }
    }

    @Override
    public void cancelQuestion(GenAiCancelQuestionRequest request) {
        try {
            HttpResponse httpResponse = this.sendDeleteRequest("%s/%s".formatted("v1/llm/chatJobs", request.getChatJobId()), new HashMap<String, String>());
            this.handleLlmResponseErrorIfAny(httpResponse);
        }
        catch (NetworkErrorException | URISyntaxException e) {
            this.logger.error("Exception while get studio assist chat job", e);
            throw new StudioAssistLlmApiRuntimeException(e);
        }
    }

    protected HttpResponse handleLlmResponseErrorIfAny(HttpResponse httpResponse) {
        int statusCode = httpResponse.getStatusCode();
        String errorMessage = httpResponse.getBody();
        if (400 <= statusCode && statusCode < 500) {
            if (407 == statusCode) {
                throw new StudioAssistLlmApiProxyException(errorMessage);
            }
            if (401 == statusCode || 403 == statusCode) {
                throw new StudioAssistLlmApiAuthenticationException(errorMessage);
            }
            if (429 == statusCode) {
                throw new StudioAssistLlmApiResourceExhaustedException();
            }
            throw new StudioAssistLlmApiClientException(errorMessage);
        }
        if (500 <= statusCode) {
            if (504 == statusCode) {
                throw new StudioAssistLlmApiServerTimeoutException(errorMessage);
            }
            throw new StudioAssistLlmApiServerException(errorMessage);
        }
        return httpResponse;
    }

    @Override
    public AskForUploadFileResponse askForUploadFiles(AskForUploadFileRequest request) {
        try {
            this.logger.debug("askForUploadFiles request -> %s".formatted(new Gson().toJson((Object)request)));
            String body = this.objectMapper.writeValueAsString((Object)request);
            HttpResponse httpResponse = this.sendPostRequest("/v1/llm/files/uploadUrl", new HashMap<String, String>(), body);
            this.handleLlmResponseErrorIfAny(httpResponse);
            this.logger.debug("askForUploadFiles response body -> %s".formatted(httpResponse.getBody()));
            return (AskForUploadFileResponse)httpResponse.json(AskForUploadFileResponse.class);
        }
        catch (JsonProcessingException | NetworkErrorException | URISyntaxException e) {
            this.logger.error("Exception while ask for upload file", e);
            throw new StudioAssistLlmApiRuntimeException(e);
        }
        catch (MalformedContentException e) {
            this.logger.error("Exception while parsing response data", (Throwable)e);
            throw new StudioAssistLlmApiRuntimeException((Throwable)e);
        }
    }

    @Override
    public String executeGeneralPrompt(GeneralPromptExecuteRequest request) throws JsonProcessingException, NetworkErrorException, URISyntaxException, MalformedContentException {
        String body = this.objectMapper.writeValueAsString((Object)request);
        HttpResponse response = this.sendPostRequest("v1/llm/prompt/execute", new HashMap<String, String>(), body);
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        StudioAssistResponse studioAssistResponse = (StudioAssistResponse)response.json(StudioAssistResponse.class);
        if (studioAssistResponse.getResponse() == null || studioAssistResponse.getResponse().getChatCompletion() == null || CollectionUtils.isEmpty(studioAssistResponse.getResponse().getChatCompletion().getChoices())) {
            this.logger.error(" Invalid response from LLM | response %s".formatted(response.getBody()));
            throw new MalformedContentException("The response from LLM is malformed.");
        }
        return studioAssistResponse.getResponse().getChatCompletion().getChatCompletionChoice(0).getMessage().getContent();
    }
}

