/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.kms.katalon.ai.constants.ChatMLRole;
import com.kms.katalon.ai.core.dto.ChatCompletionRequest;
import com.kms.katalon.ai.core.dto.ChatML;
import com.kms.katalon.ai.core.dto.GeneralPromptExecuteRequest;
import com.kms.katalon.ai.core.dto.Prompt;
import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiRuntimeException;
import com.kms.katalon.ai.core.model.llm.AssistantMessage;
import com.kms.katalon.ai.core.model.llm.CompletionOptions;
import com.kms.katalon.ai.core.model.llm.CompositeUserMessage;
import com.kms.katalon.ai.core.model.llm.InlineFileInput;
import com.kms.katalon.ai.core.model.llm.InlineImageInput;
import com.kms.katalon.ai.core.model.llm.LlmMessage;
import com.kms.katalon.ai.core.model.llm.SystemMessage;
import com.kms.katalon.ai.core.model.llm.TextInput;
import com.kms.katalon.ai.core.model.llm.UserMessage;
import com.kms.katalon.ai.core.services.ILlmService;
import com.kms.katalon.ai.internal.IGenAiClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenAiService
implements ILlmService {
    private static final Logger logger = LoggerFactory.getLogger(GenAiService.class);
    private final IGenAiClient genAiClient;

    public GenAiService(IGenAiClient genAiClient) {
        this.genAiClient = genAiClient;
    }

    public AssistantMessage getChatCompletions(List<LlmMessage> messages, CompletionOptions options) throws StudioAssistBaseException {
        try {
            GeneralPromptExecuteRequest request = GeneralPromptExecuteRequest.builder().prompt(Prompt.builder().chatCompletion(ChatCompletionRequest.builder().messages(this.from(messages)).build()).build()).build();
            return AssistantMessage.of((String)this.genAiClient.executeGeneralPrompt(request));
        }
        catch (Exception e) {
            logger.error("Unexpected error during GenAI chat completion request", (Throwable)e);
            throw new StudioAssistLlmApiRuntimeException(e.getMessage());
        }
    }

    private List<ChatML> from(List<LlmMessage> messages) {
        if (messages == null || messages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ChatML> chatMLList = new ArrayList<ChatML>();
        for (LlmMessage message : messages) {
            if (message instanceof SystemMessage) {
                SystemMessage systemMessage = (SystemMessage)message;
                chatMLList.add(ChatML.builder().role(ChatMLRole.ROLE_SYSTEM).content(systemMessage.getContent()).build());
                continue;
            }
            if (message instanceof AssistantMessage) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                chatMLList.add(ChatML.builder().role(ChatMLRole.ROLE_ASSISTANT).content(assistantMessage.getContent()).build());
                continue;
            }
            if (message instanceof UserMessage) {
                UserMessage userMessage = (UserMessage)message;
                chatMLList.add(ChatML.builder().role(ChatMLRole.ROLE_USER).content(userMessage.getContent()).build());
                continue;
            }
            if (message instanceof CompositeUserMessage) {
                CompositeUserMessage compositeUserMessage = (CompositeUserMessage)message;
                List inputs = compositeUserMessage.getInputs();
                if (inputs == null || inputs.isEmpty()) continue;
                inputs.forEach(input -> {
                    if (input instanceof TextInput) {
                        TextInput textUserInput = (TextInput)input;
                        chatMLList.add(ChatML.builder().role(ChatMLRole.ROLE_USER).name(textUserInput.getInputType().name()).content(textUserInput.getText()).build());
                    } else if (input instanceof InlineFileInput) {
                        InlineFileInput inlineFileInput = (InlineFileInput)input;
                    } else if (input instanceof InlineImageInput) {
                        InlineImageInput inlineImageInput = (InlineImageInput)input;
                    } else {
                        logger.warn("Unsupported UserInput type: {}", (Object)input.getClass().getName());
                    }
                });
                continue;
            }
            logger.warn("Unsupported LlmMessage type: {}", (Object)message.getClass().getName());
        }
        return chatMLList;
    }
}

