/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.ai.core.model.agent.McpClient;
import com.kms.katalon.ai.core.model.agent.ToolCallMessage;
import com.kms.katalon.ai.core.model.agent.config.McpHttpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpSseServerDefinition;
import com.kms.katalon.ai.core.model.exception.McpClientException;
import com.kms.katalon.ai.core.model.exception.McpClientUnauthorizedException;
import com.kms.katalon.ai.core.services.IMcpService;
import com.kms.katalon.ai.mcp.client.McpTransportUnauthorizedException;
import com.kms.katalon.ai.mcp.client.transport.CustomHttpClientSseClientTransport;
import com.kms.katalon.ai.mcp.client.transport.CustomHttpClientStreamableHttpTransport;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.apache.services.HttpProxyConfigurator;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.util.collections.Pair;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.client.ClientInformation;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.jackson.JacksonMcpJsonMapper;
import io.modelcontextprotocol.json.schema.jackson.JacksonJsonSchemaValidatorSupplier;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class McpService
implements IMcpService {
    private static final Logger logger = LoggerFactory.getLogger(McpService.class);
    private static final String OAUTH_CLIENT_ID_KEY = "client.id";
    private static final String OAUTH_CLIENT_SECRET_KEY = "client.secret";
    private static final String OAUTH_CLIENT_REDIRECT_URI_KEY = "client.redirectUri";
    private static final String TOKENS_REFRESH_TOKEN_KEY = "tokens.refreshToken";
    private Map<String, McpAsyncClient> servers = new HashMap<String, McpAsyncClient>();
    private Map<String, McpClient> clients = new HashMap<String, McpClient>();
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Inject
    private INetworkPreferences networkPreferences;
    @Inject
    private IHttpClient httpClient;

    public ClientInformation loadOAuthClient(String serverName) throws McpClientException {
        String clientSecret;
        String clientId;
        ISecurePreferences preferences;
        block5: {
            preferences = this.loadSecurePreferences(serverName);
            try {
                clientId = preferences.get(OAUTH_CLIENT_ID_KEY, "");
                if (!StringUtils.isEmpty((CharSequence)clientId)) break block5;
                return null;
            }
            catch (Exception e) {
                throw new McpClientException("Failed to load OAuth client information for server: " + serverName, (Throwable)e);
            }
        }
        ClientMetadata clientMetadata = new ClientMetadata();
        String redirectUri = preferences.get(OAUTH_CLIENT_REDIRECT_URI_KEY, "");
        if (StringUtils.isNotEmpty((CharSequence)redirectUri)) {
            clientMetadata.setRedirectionURI(URI.create(redirectUri));
        }
        if (StringUtils.isEmpty((CharSequence)(clientSecret = preferences.get(OAUTH_CLIENT_SECRET_KEY, "")))) {
            return new ClientInformation(new ClientID(clientId), clientMetadata);
        }
        return new ClientInformation(new ClientID(clientId), null, clientMetadata, new Secret(clientSecret));
    }

    public void saveOAuthClient(String serverName, ClientInformation client) throws McpClientException {
        ISecurePreferences preferences = this.loadSecurePreferences(serverName);
        try {
            preferences.put(OAUTH_CLIENT_ID_KEY, client.getID().toString(), true);
            preferences.put(OAUTH_CLIENT_REDIRECT_URI_KEY, client.getMetadata().getRedirectionURI().toString(), true);
            preferences.flush();
        }
        catch (Exception e) {
            throw new McpClientException("Failed to save OAuth client information for server: " + serverName, (Throwable)e);
        }
    }

    public Tokens loadOauthTokens(String serverName) throws McpClientException {
        String refreshToken;
        block3: {
            ISecurePreferences preferences = this.loadSecurePreferences(serverName);
            try {
                refreshToken = preferences.get(TOKENS_REFRESH_TOKEN_KEY, "");
                if (!StringUtils.isEmpty((CharSequence)refreshToken)) break block3;
                return null;
            }
            catch (Exception e) {
                throw new McpClientException("Failed to load OAuth client tokens for server: " + serverName, (Throwable)e);
            }
        }
        return new Tokens((AccessToken)new BearerAccessToken(), new RefreshToken(refreshToken));
    }

    public void saveOAuthTokens(String serverName, Tokens tokens) throws McpClientException {
        ISecurePreferences preferences = this.loadSecurePreferences(serverName);
        try {
            RefreshToken refreshToken = tokens.getRefreshToken();
            if (refreshToken == null) {
                return;
            }
            preferences.put(TOKENS_REFRESH_TOKEN_KEY, refreshToken.getValue(), true);
            preferences.flush();
        }
        catch (Exception e) {
            throw new McpClientException("Failed to save OAuth client tokens for server: " + serverName, (Throwable)e);
        }
    }

    public void removeOAuthInfo(String serverName) throws McpClientException {
        ISecurePreferences securePreferences = this.loadSecurePreferences(serverName);
        try {
            securePreferences.clear();
            securePreferences.flush();
        }
        catch (IOException e) {
            throw new McpClientException("Failed to remove MCP session preferences for server: " + serverName, (Throwable)e);
        }
    }

    public McpClient connectServer(McpServerDefinition server) throws McpClientException {
        return this.connectServer(server, "");
    }

    public McpClient connectServer(McpServerDefinition server, String accessToken) throws McpClientException {
        Object transport = null;
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpClient.Builder clientBuilder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).sslContext(ApacheHttpClient.getSslContext());
        if (server instanceof McpHttpServerDefinition) {
            McpHttpServerDefinition httpServer = (McpHttpServerDefinition)server;
            try {
                URL url = new URL(httpServer.getUrl());
                String baseUri = String.format("%s://%s:%d", url.getProtocol(), url.getHost(), url.getPort());
                if (url.getPort() == -1) {
                    baseUri = String.format("%s://%s", url.getProtocol(), url.getHost());
                }
                HttpProxyConfigurator.getInstance().configureProxy(clientBuilder, proxyConfig, url.toURI());
                CustomHttpClientStreamableHttpTransport.Builder builder = CustomHttpClientStreamableHttpTransport.builder(baseUri).clientBuilder(clientBuilder);
                if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
                    builder.customizeRequest(requestCustomizer -> requestCustomizer.header("Authorization", "Bearer " + accessToken));
                }
                if (StringUtils.isNotEmpty((CharSequence)url.getPath())) {
                    builder.endpoint(url.getPath());
                } else {
                    builder.endpoint("/");
                }
                transport = builder.jsonMapper((McpJsonMapper)new JacksonMcpJsonMapper(new ObjectMapper())).build();
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new McpClientException((Throwable)e);
            }
        }
        if (server instanceof McpSseServerDefinition) {
            McpSseServerDefinition sseServer = (McpSseServerDefinition)server;
            try {
                URL url = new URL(sseServer.getUrl());
                String baseUri = String.format("%s://%s:%d", url.getProtocol(), url.getHost(), url.getPort());
                if (url.getPort() == -1) {
                    baseUri = String.format("%s://%s", url.getProtocol(), url.getHost());
                }
                if (StringUtils.isEmpty((CharSequence)accessToken)) {
                    HttpResponse httpResponse = null;
                    try {
                        httpResponse = this.httpClient.get(url.toURI(), HttpOptions.builder().proxy(proxyConfig).build());
                    }
                    catch (Exception exception) {}
                    if (httpResponse != null && httpResponse.getStatusCode() == 401) {
                        throw new McpClientUnauthorizedException();
                    }
                }
                HttpProxyConfigurator.getInstance().configureProxy(clientBuilder, proxyConfig, url.toURI());
                CustomHttpClientSseClientTransport.Builder builder = CustomHttpClientSseClientTransport.builder(baseUri).clientBuilder(clientBuilder);
                if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
                    builder.customizeRequest(requestCustomizer -> requestCustomizer.header("Authorization", "Bearer " + accessToken));
                }
                if (StringUtils.isNotEmpty((CharSequence)url.getPath())) {
                    builder.sseEndpoint(url.getPath());
                } else {
                    builder.sseEndpoint("/");
                }
                transport = builder.build();
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new McpClientException((Throwable)e);
            }
        }
        if (transport == null) {
            throw new McpClientException("Mcp server type is not supported: " + server.getClass().getName());
        }
        McpAsyncClient mcpClient = io.modelcontextprotocol.client.McpClient.async(transport).jsonSchemaValidator(new JacksonJsonSchemaValidatorSupplier().get()).build();
        this.servers.put(server.getName(), mcpClient);
        McpClient client = new McpClient(server.getName());
        client.setBuiltin(server.isBuiltin());
        this.clients.put(server.getName(), client);
        return client;
    }

    public CompletableFuture<Boolean> initialize(String serverName) {
        McpAsyncClient mcpClient = this.servers.get(serverName);
        if (mcpClient == null) {
            return CompletableFuture.failedFuture(new McpClientException("Server not found: " + serverName));
        }
        return mcpClient.initialize().map(result -> true).onErrorMap(throwable -> {
            if (throwable.getCause() instanceof McpTransportUnauthorizedException) {
                return new McpClientUnauthorizedException();
            }
            return new McpClientException(throwable);
        }).toFuture();
    }

    public CompletableFuture<List<McpSchema.Tool>> getTools(String server) {
        McpAsyncClient client = this.servers.get(server);
        if (client == null) {
            return CompletableFuture.failedFuture(new McpClientException("Server not found: " + server));
        }
        return client.listTools().map(McpSchema.ListToolsResult::tools).onErrorMap(McpClientException::new).toFuture();
    }

    public CompletableFuture<Pair<String, Boolean>> callTool(ToolCallMessage tool) {
        Map arguments;
        McpAsyncClient client = this.servers.get(tool.getServer());
        if (client == null) {
            return CompletableFuture.failedFuture(new McpClientException("Server not found: " + tool.getServer()));
        }
        try {
            arguments = StringUtils.isBlank((CharSequence)tool.getInput()) ? new HashMap() : (Map)this.objectMapper.readValue(tool.getInput(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(new McpClientException("Failed to parse tool input: " + e.getMessage(), (Throwable)e));
        }
        McpSchema.CallToolRequest toolRequest = new McpSchema.CallToolRequest(tool.getName(), arguments);
        return client.callTool(toolRequest).map(callResult -> Pair.of((Object)callResult.content().stream().filter(content -> content instanceof McpSchema.TextContent).map(content -> ((McpSchema.TextContent)content).text()).collect(Collectors.joining("\n")), (Object)callResult.isError())).onErrorMap(McpClientException::new).toFuture();
    }

    public void disconnectServer(String server) {
        if (this.servers.containsKey(server)) {
            McpAsyncClient mcpClient = this.servers.get(server);
            mcpClient.closeGracefully().toFuture();
            this.servers.remove(server);
        }
        this.clients.remove(server);
    }

    private ISecurePreferences loadRootSecurePreferences() throws McpClientException {
        File secureStorageFolder = Paths.get(SystemUtils.getUserHome().toString(), ".katalon", "studioassist").toFile();
        File secureStorageFile = new File(secureStorageFolder, "session.properties");
        try {
            return SecurePreferencesFactory.open((URL)secureStorageFile.toURI().toURL(), null);
        }
        catch (IOException e) {
            throw new McpClientException("Failed to load MCP session preferences", (Throwable)e);
        }
    }

    private ISecurePreferences loadSecurePreferences(String serverName) throws McpClientException {
        ISecurePreferences securePreferences = this.loadRootSecurePreferences();
        return securePreferences != null ? securePreferences.node(serverName) : null;
    }
}

