/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kms.katalon.ai.constants.StudioAssistConstants;
import com.kms.katalon.ai.core.model.agent.AgentSetting;
import com.kms.katalon.ai.core.model.agent.config.McpHttpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpSetting;
import com.kms.katalon.ai.core.model.agent.config.McpSseServerDefinition;
import com.kms.katalon.ai.core.model.chat.AgentProfile;
import com.kms.katalon.ai.core.services.IProjectAgentProfilePreferences;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class ProjectAgentProfilePreferences
implements IProjectAgentProfilePreferences {
    private static final Logger logger = LoggerFactory.getLogger(ProjectAgentProfilePreferences.class);
    private static final ObjectMapper objectMapper = ProjectAgentProfilePreferences.createObjectMapper();
    private static final String PROFILE_METADATA_FILE_NAME = "profile.json";
    private static final String AGENT_PROFILE_FILE_NAME = "agent.json";
    private static final String MCP_SETTING_FILE_NAME = "mcp.json";
    private static final String AGENTS_DIRECTORY_NAME = "Agents";
    private static final String JSON_FIELD_DESCRIPTION = "description";
    private static final String JSON_FIELD_ENABLED = "enabled";
    private static final String JSON_FIELD_SERVERS = "servers";

    static {
        objectMapper.registerSubtypes(new Class[]{McpHttpServerDefinition.class, McpSseServerDefinition.class});
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        return mapper;
    }

    public AgentProfile loadAgentProfile(String projectLocation, String agentName) {
        AgentProfile profile = new AgentProfile();
        profile.setName(agentName);
        File metadataFile = this.getAgentProfileMetadataFile(projectLocation, agentName);
        if (metadataFile != null && metadataFile.exists()) {
            try {
                JsonNode root = objectMapper.readTree(metadataFile);
                if (root != null) {
                    if (root.hasNonNull(JSON_FIELD_DESCRIPTION)) {
                        profile.setDescription(root.get(JSON_FIELD_DESCRIPTION).asText());
                    }
                    if (root.has(JSON_FIELD_ENABLED)) {
                        profile.setEnabled(root.get(JSON_FIELD_ENABLED).asBoolean(true));
                    } else {
                        profile.setEnabled(true);
                    }
                }
                return profile;
            }
            catch (IOException e) {
                logger.error(StudioAssistConstants.ERROR_IO_EXCEPTION, (Throwable)e);
                profile.setEnabled(true);
                return profile;
            }
        }
        profile.setEnabled(true);
        return profile;
    }

    public void saveAgentProfile(String projectLocation, AgentProfile profile) {
        if (profile == null) {
            return;
        }
        String agentName = profile.getName();
        File file = this.getAgentProfileMetadataFile(projectLocation, agentName);
        if (file == null) {
            return;
        }
        try {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            ObjectNode root = objectMapper.createObjectNode();
            if (profile.getDescription() != null) {
                root.put(JSON_FIELD_DESCRIPTION, profile.getDescription());
            }
            root.put(JSON_FIELD_ENABLED, profile.isEnabled());
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)root);
        }
        catch (IOException e) {
            logger.error(StudioAssistConstants.ERROR_IO_EXCEPTION, (Throwable)e);
        }
    }

    public AgentSetting loadProfileAgentSetting(String projectLocation, String agentName) {
        File file = this.getAgentProfileFile(projectLocation, agentName);
        if (file == null || !file.exists()) {
            return new AgentSetting();
        }
        try {
            JsonNode root = objectMapper.readTree(file);
            AgentSetting setting = (AgentSetting)objectMapper.treeToValue((TreeNode)root, AgentSetting.class);
            return setting != null ? setting : new AgentSetting();
        }
        catch (IOException e) {
            logger.error(StudioAssistConstants.ERROR_IO_EXCEPTION, (Throwable)e);
            return new AgentSetting();
        }
    }

    public void saveProfileAgentSetting(String projectLocation, String agentName, AgentSetting setting) {
        if (setting == null) {
            return;
        }
        File file = this.getAgentProfileFile(projectLocation, agentName);
        if (file == null) {
            return;
        }
        try {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            ObjectNode settingNode = (ObjectNode)objectMapper.valueToTree((Object)setting);
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)settingNode);
        }
        catch (IOException e) {
            logger.error(StudioAssistConstants.ERROR_IO_EXCEPTION, (Throwable)e);
        }
    }

    public McpSetting loadProfileMcpSetting(String projectLocation, String agentName) {
        File file = this.getProfileMcpSettingFile(projectLocation, agentName);
        if (file == null || !file.exists()) {
            return new McpSetting();
        }
        try {
            JsonNode root = objectMapper.readTree(file);
            McpSetting setting = new McpSetting();
            if (root.has(JSON_FIELD_SERVERS) && root.get(JSON_FIELD_SERVERS).isObject()) {
                JsonNode serversNode = root.get(JSON_FIELD_SERVERS);
                ArrayList<McpServerDefinition> servers = new ArrayList<McpServerDefinition>();
                Iterator fieldNames = serversNode.fieldNames();
                while (fieldNames.hasNext()) {
                    String name = (String)fieldNames.next();
                    JsonNode serverNode = serversNode.get(name);
                    McpServerDefinition server = (McpServerDefinition)objectMapper.treeToValue((TreeNode)serverNode, McpServerDefinition.class);
                    if (server == null) continue;
                    servers.add(server);
                }
                setting.setServers(servers);
            }
            return setting;
        }
        catch (Exception e) {
            logger.error(StudioAssistConstants.ERROR_IO_EXCEPTION, (Throwable)e);
            return new McpSetting();
        }
    }

    public void saveProfileMcpSetting(String projectLocation, String agentName, McpSetting setting) {
        if (setting == null) {
            return;
        }
        File file = this.getProfileMcpSettingFile(projectLocation, agentName);
        if (file == null) {
            return;
        }
        try {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            ObjectNode root = objectMapper.createObjectNode();
            ObjectNode serversNode = objectMapper.createObjectNode();
            List servers = setting.getServers();
            if (servers != null) {
                for (McpServerDefinition server : servers) {
                    String name = server.getName();
                    serversNode.set(name, objectMapper.valueToTree((Object)server));
                }
            }
            root.set(JSON_FIELD_SERVERS, (JsonNode)serversNode);
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)root);
        }
        catch (Exception e) {
            logger.error(StudioAssistConstants.ERROR_IO_EXCEPTION, (Throwable)e);
        }
    }

    private File getAgentProfileFile(String projectLocation, String agentName) {
        File agentDir = this.getAgentDirectory(projectLocation, agentName);
        return agentDir != null ? new File(agentDir, AGENT_PROFILE_FILE_NAME) : null;
    }

    private File getAgentProfileMetadataFile(String projectLocation, String agentName) {
        File agentDir = this.getAgentDirectory(projectLocation, agentName);
        return agentDir != null ? new File(agentDir, PROFILE_METADATA_FILE_NAME) : null;
    }

    private File getProfileMcpSettingFile(String projectLocation, String agentName) {
        File agentDir = this.getAgentDirectory(projectLocation, agentName);
        return agentDir != null ? new File(agentDir, MCP_SETTING_FILE_NAME) : null;
    }

    private File getAgentDirectory(String projectLocation, String agentName) {
        if (projectLocation == null || projectLocation.isBlank() || agentName == null || agentName.isBlank()) {
            return null;
        }
        File projectRoot = this.resolveProjectRoot(projectLocation);
        return new File(new File(projectRoot, AGENTS_DIRECTORY_NAME), agentName);
    }

    private File resolveProjectRoot(String projectLocation) {
        File location = new File(projectLocation);
        if (location.isDirectory()) {
            return location;
        }
        File parent = location.getParentFile();
        return parent != null ? parent : location;
    }
}

