/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.kms.katalon.ai.core.constant.LLMModelDefaultPrompt;
import com.kms.katalon.ai.core.constant.StudioAssistAttachmentStatus;
import com.kms.katalon.ai.core.constant.StudioAssistFileType;
import com.kms.katalon.ai.core.model.chat.ImageChatAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatReferenceContextMessage;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadAttachmentException;
import com.kms.katalon.ai.core.model.llm.ImageFormat;
import com.kms.katalon.ai.core.model.llm.InlineImageInput;
import com.kms.katalon.ai.core.services.IStudioAssistReferenceContextService;
import com.kms.katalon.ai.core.util.AttachmentUtil;
import com.kms.katalon.ai.util.ImageAttachmentUtil;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.webservice.common.VerificationScriptSnippetFactory;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.global.GlobalVariableEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.ast.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistReferenceContextService
implements IStudioAssistReferenceContextService {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistReferenceContextService.class);

    public StudioAssistChatReferenceContextMessage getObjectRepository(ProjectEntity project, String conversationId) throws Exception {
        FolderEntity folder = FolderController.getInstance().getObjectRepositoryRoot(project);
        List descendantEntities = FolderController.getInstance().getAllDescentdantEntities(folder);
        StringBuilder builder = new StringBuilder(LLMModelDefaultPrompt.PROJECT_CONTEXT_OBJECT_REPOSITORY_TEMPLATE);
        for (Object each : descendantEntities) {
            if (!(each instanceof WebElementEntity) && !(each instanceof WindowsElementEntity)) continue;
            FileEntity entity = (FileEntity)each;
            builder.append(entity.getIdForDisplay()).append(System.lineSeparator());
        }
        return new StudioAssistChatReferenceContextMessage(conversationId, builder.toString());
    }

    public StudioAssistChatReferenceContextMessage getCustomKeywordsFromCurrentProject(ProjectEntity project, String conversationId) {
        List customKeywords = KeywordController.getInstance().getCustomKeywords(project);
        if (customKeywords == null || customKeywords.size() <= 0) {
            return null;
        }
        StringBuilder contentBuilder = new StringBuilder(LLMModelDefaultPrompt.PROJECT_CONTEXT_CUSTOM_KEYWORDS_TEMPLATE);
        for (MethodNode keyword : customKeywords) {
            contentBuilder.append(keyword.getTypeDescriptor()).append(System.lineSeparator());
        }
        return new StudioAssistChatReferenceContextMessage(conversationId, contentBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StudioAssistChatAttachment fulfillAttachmentContent(StudioAssistChatAttachment attachment) throws IOException {
        String content = attachment.getFileContent();
        Date dateModified = attachment.getDateModified();
        if (StringUtils.isNotBlank((CharSequence)attachment.getFileContent())) {
            return attachment;
        }
        Map<String, String> declaredVars = attachment.getDeclaredVariables();
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        try {
            switch (attachment.getFileType()) {
                case TEST_CASE: {
                    TestCaseEntity testCase = TestCaseController.getInstance().getTestCase(attachment.getFilePath());
                    if (testCase == null) {
                        return attachment;
                    }
                    try {
                        content = new String(testCase.getScriptContents(), StandardCharsets.UTF_8.toString());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        return null;
                    }
                    dateModified = testCase.getDateModified();
                    declaredVars = testCase.getVariables().stream().collect(Collectors.toMap(VariableEntity::getName, VariableEntity::getDefaultValue));
                    return new StudioAssistChatAttachment(attachment.getFileType(), attachment.getFileSource(), attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), (Map)declaredVars, content, dateModified);
                }
                case TEST_SUITE: {
                    TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuite(attachment.getFilePath());
                    if (testSuite == null) {
                        return attachment;
                    }
                    StringBuilder tsContentBuilder = new StringBuilder();
                    if (!testSuite.isPageLoadTimeoutDefault() && testSuite.getPageLoadTimeout() > 0) {
                        tsContentBuilder.append("Page load time out=" + String.valueOf(testSuite.getPageLoadTimeout()));
                    } else if (testSuite.isPageLoadTimeoutDefault()) {
                        tsContentBuilder.append("Using default page load time out=30");
                    }
                    if (testSuite.getNumberOfRerun() > 0) {
                        tsContentBuilder.append(System.lineSeparator() + "Should retry=" + testSuite.getIsRerun()).append(System.lineSeparator() + "Maximum retry number=" + testSuite.getNumberOfRerun());
                    }
                    if (testSuite.isRerunFailedTestCasesOnly()) {
                        tsContentBuilder.append(System.lineSeparator() + "Retry when failed strategy=Retry failed Test Cases after complete running Test Suite");
                    } else if (testSuite.isRerunFailedTestCasesAndTestDataOnly()) {
                        tsContentBuilder.append(System.lineSeparator() + "Retry when failed strategy=Retry failed Test Datas of each Test Cases after complete running Test Suite");
                    } else if (testSuite.isRerunImmediately()) {
                        tsContentBuilder.append(System.lineSeparator() + "Retry when failed strategy=Retry failed Test Cases immediately");
                    } else {
                        tsContentBuilder.append(System.lineSeparator() + "Retry when failed strategy=Retry this the entire Test Cases in Test Suite after complete running Test Suite");
                    }
                    if (StringUtils.isNotBlank((CharSequence)testSuite.getMailRecipient())) {
                        tsContentBuilder.append(System.lineSeparator() + "Mail recipient=" + testSuite.getMailRecipient());
                    }
                    if (testSuite.getTestSuiteTestCaseLinks() != null && testSuite.getTestSuiteTestCaseLinks().size() > 0) {
                        tsContentBuilder.append(System.lineSeparator() + "The listed test cases are run in order:");
                        for (TestSuiteTestCaseLink each : testSuite.getTestSuiteTestCaseLinks()) {
                            tsContentBuilder.append(System.lineSeparator()).append(each.getTestCaseId());
                        }
                    }
                    if (testSuite instanceof FilteringTestSuiteEntity) {
                        FilteringTestSuiteEntity filteringTestSuite = (FilteringTestSuiteEntity)testSuite;
                        String filteringText = filteringTestSuite.getFilteringText();
                        tsContentBuilder.append(System.lineSeparator() + "Here is the filtering test case script: ").append(filteringText);
                        attachment.setFileType(StudioAssistFileType.DYNAMIC_TEST_SUITE);
                    }
                    tsContentBuilder.append(System.lineSeparator() + "Below is set up script in Groovy:" + System.lineSeparator());
                    File setupSuiteContent = TestSuiteController.getInstance().getTestSuiteScriptFile(testSuite);
                    String setupContent = Files.readAllLines(Paths.get(setupSuiteContent.getAbsolutePath(), new String[0])).stream().collect(Collectors.joining(System.lineSeparator()));
                    tsContentBuilder.append(setupContent);
                    content = tsContentBuilder.toString();
                    dateModified = testSuite.getDateModified();
                    return new StudioAssistChatAttachment(attachment.getFileType(), attachment.getFileSource(), attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), (Map)declaredVars, content, dateModified);
                }
                case TEST_SUITE_COLLECTION: {
                    TestSuiteCollectionEntity testSuiteCollection = TestSuiteCollectionController.getInstance().getTestSuiteCollection(attachment.getFilePath());
                    if (testSuiteCollection == null) {
                        return attachment;
                    }
                    StringBuilder tscContentBuilder = new StringBuilder();
                    if (testSuiteCollection.getExecutionMode() == TestSuiteCollectionEntity.ExecutionMode.PARALLEL) {
                        tscContentBuilder.append("Parallel execution mode with " + testSuiteCollection.getMaxConcurrentInstances() + " max concurrent instances.").append(System.lineSeparator() + "Delay between instances is " + testSuiteCollection.getDelayBetweenInstances() + "s");
                    } else {
                        tscContentBuilder.append("Sequential execution mode");
                    }
                    if (testSuiteCollection.getTestSuiteRunConfigurations() != null && testSuiteCollection.getTestSuiteRunConfigurations().size() > 0) {
                        tscContentBuilder.append(System.lineSeparator() + "Below is the ordered Test Suites:");
                        for (TestSuiteRunConfiguration each : testSuiteCollection.getTestSuiteRunConfigurations()) {
                            tscContentBuilder.append(System.lineSeparator()).append(each.getTestSuiteEntity().getIdForDisplay());
                        }
                    }
                    content = tscContentBuilder.toString();
                    dateModified = testSuiteCollection.getDateModified();
                    return new StudioAssistChatAttachment(attachment.getFileType(), attachment.getFileSource(), attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), (Map)declaredVars, content, dateModified);
                }
                case GROOVY: 
                case JAVA: {
                    File groovyFile = new File(attachment.getFilePath());
                    if (!groovyFile.exists()) {
                        return attachment;
                    }
                    content = Files.readAllLines(Paths.get(attachment.getFilePath(), new String[0])).stream().collect(Collectors.joining(System.lineSeparator()));
                    dateModified = new Date(new File(attachment.getFilePath()).lastModified());
                    if (this.isCustomKeyword(content)) {
                        attachment.setFileType(StudioAssistFileType.CUSTOM_KEYWORD);
                        return new StudioAssistChatAttachment(attachment.getFileType(), attachment.getFileSource(), attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), (Map)declaredVars, content, dateModified);
                    }
                    if (this.isStepDefinition(content)) {
                        attachment.setFileType(StudioAssistFileType.STEP_DEFINITION);
                        return new StudioAssistChatAttachment(attachment.getFileType(), attachment.getFileSource(), attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), (Map)declaredVars, content, dateModified);
                    }
                    if (!this.isTestListener(attachment)) return new StudioAssistChatAttachment(attachment.getFileType(), attachment.getFileSource(), attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), (Map)declaredVars, content, dateModified);
                    attachment.setFileType(StudioAssistFileType.LISTENER);
                    return new StudioAssistChatAttachment(attachment.getFileType(), attachment.getFileSource(), attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), (Map)declaredVars, content, dateModified);
                }
                case CUSTOM_KEYWORD: 
                case LISTENER: 
                case STEP_DEFINITION: {
                    File customGroovyFile = new File(attachment.getFilePath());
                    if (!customGroovyFile.exists()) {
                        return attachment;
                    }
                    content = Files.readAllLines(Paths.get(attachment.getFilePath(), new String[0])).stream().collect(Collectors.joining(System.lineSeparator()));
                    dateModified = new Date(new File(attachment.getFilePath()).lastModified());
                    return new StudioAssistChatAttachment(attachment.getFileType(), attachment.getFileSource(), attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), (Map)declaredVars, content, dateModified);
                }
                case PROFILE: {
                    ExecutionProfileEntity profile = GlobalVariableController.getInstance().getExecutionProfileById(attachment.getFilePath(), currentProject);
                    if (profile == null) {
                        return attachment;
                    }
                    String variables = profile.getGlobalVariableEntities().stream().collect(Collectors.toMap(GlobalVariableEntity::getName, GlobalVariableEntity::getInitValue, (first, second) -> second)).entrySet().stream().map(entry -> "- %s: %s".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining(System.lineSeparator()));
                    StringBuilder stringBuilder = new StringBuilder("List of global variables in the profile:" + System.lineSeparator());
                    stringBuilder.append(variables);
                    content = stringBuilder.toString();
                    dateModified = profile.getDateModified();
                    return new StudioAssistChatAttachment(attachment.getFileType(), attachment.getFileSource(), attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), (Map)declaredVars, content, dateModified);
                }
                case FEATURE_FILE: {
                    File featureFile = new File(attachment.getFilePath());
                    if (!featureFile.exists()) {
                        return attachment;
                    }
                    Path featurePath = Paths.get(attachment.getFilePath(), new String[0]);
                    content = Files.readAllLines(featurePath).stream().collect(Collectors.joining(System.lineSeparator()));
                    dateModified = new Date(featureFile.lastModified());
                    return new StudioAssistChatAttachment(attachment.getFileType(), attachment.getFileSource(), attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), (Map)declaredVars, content, dateModified);
                }
                case WEB_SERVICE_OBJECT: {
                    File wsFile = new File(attachment.getFilePath());
                    if (!wsFile.exists()) {
                        return attachment;
                    }
                    Path wsPath = Paths.get(attachment.getFilePath(), new String[0]);
                    StringBuilder wsContentBuilder = new StringBuilder();
                    wsContentBuilder.append(Files.readAllLines(wsPath).stream().collect(Collectors.joining(System.lineSeparator())));
                    dateModified = new Date(new File(attachment.getFilePath()).lastModified());
                    WebElementEntity entity = ObjectRepositoryController.getInstance().getWebElement(attachment.getFilePath());
                    if (!(entity instanceof WebServiceRequestEntity)) return new StudioAssistChatAttachment(attachment.getFileType(), attachment.getFileSource(), attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), (Map)declaredVars, content, dateModified);
                    WebServiceRequestEntity wsEntity = (WebServiceRequestEntity)entity;
                    wsContentBuilder.append(System.lineSeparator()).append("Bellow is WebService Request Verification script:" + System.lineSeparator());
                    String verificationScript = wsEntity.getVerificationScript();
                    wsContentBuilder.append(StringUtils.isNotBlank((CharSequence)verificationScript) ? verificationScript : VerificationScriptSnippetFactory.getCommonScriptSnippet().getScript());
                    content = wsContentBuilder.toString();
                    return new StudioAssistChatAttachment(attachment.getFileType(), attachment.getFileSource(), attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), (Map)declaredVars, content, dateModified);
                }
                case IMAGE: {
                    try {
                        String base64Content = ImageAttachmentUtil.toBase64String(attachment.getFilePath());
                        ImageFormat format = ImageAttachmentUtil.getImageFormat(attachment.getFilePath());
                        InlineImageInput imageInput = InlineImageInput.builder().data(base64Content).format(format).build();
                        dateModified = new Date(new File(attachment.getFilePath()).lastModified());
                        return new ImageChatAttachment(attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), imageInput, dateModified, attachment.getStatus(), attachment.getFileSource());
                    }
                    catch (Exception exception) {
                        throw new StudioAssistLoadAttachmentException(String.format("Error processing image '%s': %s", attachment.getFilePath(), exception.getMessage()), (Throwable)exception);
                    }
                }
                case OTHER: {
                    File otherFile = new File(attachment.getFilePath());
                    if (!otherFile.exists()) {
                        return attachment;
                    }
                    Path path = Paths.get(attachment.getFilePath(), new String[0]);
                    content = Files.readAllLines(path).stream().collect(Collectors.joining(System.lineSeparator()));
                    dateModified = new Date(new File(attachment.getFilePath()).lastModified());
                    return new StudioAssistChatAttachment(attachment.getFileType(), attachment.getFileSource(), attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), (Map)declaredVars, content, dateModified);
                }
            }
            return new StudioAssistChatAttachment(attachment.getFileType(), attachment.getFileSource(), attachment.getFileId(), attachment.getFileClientId(), attachment.getFilePath(), (Map)declaredVars, content, dateModified);
        }
        catch (Exception e) {
            this.logger.error("Exception while fulfillAttachmentContent", (Throwable)e);
            return null;
        }
    }

    private boolean isTestListener(StudioAssistChatAttachment attachment) {
        return attachment.getFilePath().contains(System.getProperty("file.separator") + "Test Listeners" + System.getProperty("file.separator"));
    }

    private boolean isStepDefinition(String content) {
        return content.contains("import io.cucumber.java.en.Given") && content.contains("@Given") || content.contains("import io.cucumber.java.en.And") && content.contains("@And") || content.contains("import io.cucumber.java.en.But") && content.contains("@But") || content.contains("import io.cucumber.java.en.When") && content.contains("@When") || content.contains("import io.cucumber.java.en.Then") && content.contains("@Then");
    }

    private boolean isCustomKeyword(String content) {
        return content.contains("import com.kms.katalon.core.annotation.Keyword") && content.contains("@Keyword");
    }

    public StudioAssistAttachmentStatus validateAttachment(String attachmentFilePath, StudioAssistFileType attachmentFileType) throws Exception {
        if (StringUtils.isBlank((CharSequence)attachmentFilePath)) {
            return StudioAssistAttachmentStatus.NOT_EXIST;
        }
        switch (attachmentFileType) {
            case TEST_CASE: {
                TestCaseEntity testCase = TestCaseController.getInstance().getTestCase(attachmentFilePath);
                if (testCase == null) {
                    return StudioAssistAttachmentStatus.NOT_EXIST;
                }
                String scriptFilePath = GroovyUtil.getTestCaseScriptFile((TestCaseEntity)testCase).getRawLocation().toOSString();
                File scriptFile = new File(scriptFilePath);
                if (!scriptFile.exists()) {
                    return StudioAssistAttachmentStatus.NOT_EXIST;
                }
                if (!((double)scriptFile.length() > 1.048576E7)) break;
                return StudioAssistAttachmentStatus.TOO_LARGE;
            }
            case TEST_SUITE: {
                TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuite(attachmentFilePath);
                if (testSuite == null) {
                    return StudioAssistAttachmentStatus.NOT_EXIST;
                }
                File setupSuiteFile = TestSuiteController.getInstance().getTestSuiteScriptFile(testSuite);
                if (!setupSuiteFile.exists()) {
                    return StudioAssistAttachmentStatus.NOT_EXIST;
                }
                if (!((double)setupSuiteFile.length() > 1.048576E7)) break;
                return StudioAssistAttachmentStatus.TOO_LARGE;
            }
            case IMAGE: {
                File image = new File(attachmentFilePath);
                if (!image.exists()) {
                    return StudioAssistAttachmentStatus.NOT_EXIST;
                }
                if ((double)image.length() > 1.048576E7) {
                    return StudioAssistAttachmentStatus.TOO_LARGE;
                }
                ImageFormat format = ImageAttachmentUtil.getImageFormat(image.getName());
                if (format == null) {
                    return StudioAssistAttachmentStatus.UNSUPPORTED;
                }
                return StudioAssistAttachmentStatus.VALID;
            }
            case DYNAMIC_TEST_SUITE: 
            case TEST_SUITE_COLLECTION: 
            case WEB_SERVICE_OBJECT: 
            case GROOVY: 
            case JAVA: 
            case CUSTOM_KEYWORD: 
            case LISTENER: 
            case STEP_DEFINITION: 
            case FEATURE_FILE: 
            case PROFILE: {
                File file = new File(attachmentFilePath);
                if (!((double)file.length() > 1.048576E7)) break;
                return StudioAssistAttachmentStatus.TOO_LARGE;
            }
            default: {
                return AttachmentUtil.checkAttachmentStatus((String)attachmentFilePath, (StudioAssistFileType)attachmentFileType);
            }
        }
        return StudioAssistAttachmentStatus.VALID;
    }
}

