/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.kms.katalon.ai.core.constant.LLMModelDefaultPrompt;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingKeyEnum;
import com.kms.katalon.ai.core.dto.StudioAssistChatRateConversationRequest;
import com.kms.katalon.ai.core.model.StudioAssistChatAnswerMessageFuture;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.chat.ChatMode;
import com.kms.katalon.ai.core.model.chat.ChatQuestionMessage;
import com.kms.katalon.ai.core.model.chat.ChatResponseMessage;
import com.kms.katalon.ai.core.model.chat.ImageChatAttachment;
import com.kms.katalon.ai.core.model.chat.PromptRole;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAnswerMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatItem;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatReferenceContextMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistConversation;
import com.kms.katalon.ai.core.model.chat.UserChatMessageName;
import com.kms.katalon.ai.core.model.config.AiAutoTagConfig;
import com.kms.katalon.ai.core.model.config.GenAIConfig;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistAvailabilityException;
import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.model.exception.StudioAssistConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistConfigUnavailableException;
import com.kms.katalon.ai.core.model.exception.StudioAssistDisabledException;
import com.kms.katalon.ai.core.model.exception.StudioAssistException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.core.model.llm.AssistantMessage;
import com.kms.katalon.ai.core.model.llm.CompletionOptions;
import com.kms.katalon.ai.core.model.llm.CompositeUserMessage;
import com.kms.katalon.ai.core.model.llm.InlineImageInput;
import com.kms.katalon.ai.core.model.llm.LlmMessage;
import com.kms.katalon.ai.core.model.llm.SystemMessage;
import com.kms.katalon.ai.core.model.llm.ToolCall;
import com.kms.katalon.ai.core.model.llm.UserMessage;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.core.model.prompt.SupportedStringTemplateVariableName;
import com.kms.katalon.ai.core.model.prompt.TemplateVariable;
import com.kms.katalon.ai.core.model.prompt.UserSelectionVariable;
import com.kms.katalon.ai.core.preferences.IStudioAssistPreferences;
import com.kms.katalon.ai.core.services.ILlmService;
import com.kms.katalon.ai.core.services.IStringTemplateEngine;
import com.kms.katalon.ai.core.services.IStudioAssistService;
import com.kms.katalon.ai.core.services.internal.IChatAnswerLlmService;
import com.kms.katalon.ai.factory.AiAutoTagSettingFactory;
import com.kms.katalon.ai.factory.LlmServiceFactory;
import com.kms.katalon.ai.internal.IGenAiClient;
import com.kms.katalon.ai.services.internal.StudioAssistChatAnswerGenAIService;
import com.kms.katalon.ai.services.internal.StudioAssistChatAnswerGenAiClientFuture;
import com.kms.katalon.ai.services.internal.StudioAssistChatAnswerLlmServiceFuture;
import com.kms.katalon.ai.services.internal.StudioAssistChatAnswerService;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.setting.IStudioAssistAiAutoTagSetting;
import com.kms.katalon.core.setting.service.AiAutoTagSettingRegistry;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.session.core.model.AdministrationManagedKsSetting;
import com.kms.katalon.session.core.model.AiAutoTagPolicyType;
import com.kms.katalon.session.core.model.AiConfigPolicyType;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.collections.Pair;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class StudioAssistService
implements IStudioAssistService {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistService.class);
    private static final String SA_KATALON_AI_INTERVAL_FETCHING_ANSWER = "kaiIntervalFetchingAnswer";
    private static final String SA_KATALON_AI_MAX_FETCHING_TIMES = "kaiMaxFetchingTimes";
    private static final int GENAI_INTERVAL_FETCHING_ANSWER = 1000;
    private static final int GENAI_MAX_FETCHING_TIMES = 120;
    private static final int CORE_POOL_SIZE = 2;
    private static final int MAX_POOL_SIZE = 4;
    private static final long KEEP_ALIVE_TIME = 0L;
    private static final int MAX_WORK_QUEUE_SIZE = 20;
    private static final int MAX_CONVERSATION_PAYLOAD_SIZE_BYTES = 28672;
    private static final ExecutorService executorService = new ThreadPoolExecutor(2, 4, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(20));
    private static String USER_INPUT_PLACEHOLDER_VARIABLE = "user_input";
    private volatile IChatAnswerLlmService currentChatService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private LlmServiceFactory llmServiceFactory;
    @Inject
    private IStudioAssistPreferences preferences;
    @Inject
    private IStringTemplateEngine templateEngine;
    @Inject
    private IEclipseContext eclipseContext;
    @Inject
    private ISessionController sessionController;

    public boolean canExecute() throws StudioAssistConfigException, StudioAssistAvailabilityException {
        StudioAssistConfig config = this.preferences.getConfig();
        return this.validateAvailability(config);
    }

    public String executePrompt(PromptType promptType, List<UserMessage> messages) throws StudioAssistBaseException {
        StudioAssistConfig config = this.preferences.getConfig();
        this.validateAvailability(config);
        this.onExecutePromptCalled(promptType, config.getType());
        this.shouldShowFeedbackDialogAfterExecuted(promptType, UserProfileHelper.getCurrentProfile().getNumberOfTimeGenerateCodeUsed());
        return this.executePrompt(promptType, messages, config);
    }

    public StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException {
        return this.preferences.getConfig();
    }

    public void saveConfig(StudioAssistConfig config) throws StudioAssistSavingConfigException {
        this.preferences.saveConfig(config);
    }

    @Deprecated
    public StudioAssistChatAnswerMessageFuture askQuestion(PromptType promptType, List<StudioAssistChatItem> conversation, ChatQuestionMessage question, Map<String, List<McpSchema.Tool>> availableTools) throws StudioAssistBaseException {
        StudioAssistConfig config = this.preferences.getConfig();
        this.validateAvailability(config);
        StudioAssistChatAnswerMessageFuture future = null;
        String systemIntervalFetchingStr = System.getProperty(SA_KATALON_AI_INTERVAL_FETCHING_ANSWER);
        String systemMaxFetchingTimesStr = System.getProperty(SA_KATALON_AI_MAX_FETCHING_TIMES);
        MultiValuedMap<PromptRole, String> prompts = this.buildPrompts(promptType, List.of(), List.of());
        List<SystemMessage> messages = Stream.concat(prompts.get((Object)PromptRole.SYSTEM).stream().map(SystemMessage::of), this.buildConversationMessages(conversation, question).stream()).toList();
        if (config.getType() == LlmConfigType.GEN_AI) {
            future = new StudioAssistChatAnswerGenAiClientFuture(executorService, promptType == PromptType.AGENT ? ChatMode.AGENT : ChatMode.ASK, conversation, question, availableTools, StringUtils.isNotBlank((CharSequence)systemIntervalFetchingStr) ? Integer.valueOf(systemIntervalFetchingStr) : 1000, StringUtils.isNotBlank((CharSequence)systemMaxFetchingTimesStr) ? Integer.valueOf(systemMaxFetchingTimesStr) : 120);
            ContextInjectionFactory.inject((Object)future, (IEclipseContext)this.eclipseContext);
        } else {
            future = new StudioAssistChatAnswerLlmServiceFuture(messages, question, availableTools, config);
            ContextInjectionFactory.inject((Object)future, (IEclipseContext)this.eclipseContext);
        }
        future.start();
        return future;
    }

    public String getDefaultPromptContentTemplate(PromptType promptType) {
        switch (promptType) {
            case CODE_GENERATE: {
                return "You are an expert code generation tool. Your primary task is to write a script based on the user's requirement.\n**Prior to receiving the user's specific request, you will be provided with relevant codebase context. It is imperative that you thoroughly analyze and consult this codebase context to inform and guide your script generation, ensuring the most appropriate and effective code is produced.**\nEnsure you adhere to the following rules for script generation:\n                1. Prioritize to use Katalon Studio keywords\n                2. May allow to import some libraries\n                3. Use the findTestObject keyword inline rather than creating a separate test object\n                4. Do not use code blocks\n                5. When implementing custom keyword, generate as the following format: CustomKeywords.'<custom keyword name>'(<parameters>)\n                6. Do not generate methods or functions if the requirement does not ask for, explain each line of code as follows:\n                   // <Only explain the keyword purpose>\n                   <Your generated keyword>\n                7. Only generate functions when requirement asks to create new `keyword`, `method` or `function`, remember to generate Javadoc for that function as follows:\n                   /*\n                    *  <Purpose of the method or keyword>\n                    *\n                    *  @param <first param name> <Explanation of the first param>\n                    *  @param <second param name> <Explanation of the second param>\n                    *  @return <Explanation of the returned value, if no return value, do not generate this line>\n                    */\n                8. If creating new `keyword`, use `@Keyword` annotation as follows:\n                    @Keyword\n                    def <keyword name>(<parameters>) {\n                        <content of the method>\n                    }\n                9. Use Groovy 3 syntax by default unless the user specifically mentions a different version\n                10. Avoid using Groovy 4 or Selenium 4 specific features that are not compatible with Katalon Studio\n- Do not format any part of your response as markdown.\n- Before you finish, double check your result to make sure that they meet the rules\n ${userSelection}";
            }
            case CODE_EXPLAIN: {
                return LLMModelDefaultPrompt.EXPLAIN_CODE_TEMPLATE;
            }
            case CHATBOT: {
                return "You are StudioAssist - a software quality assurance engineer with the following capabilities:\n  - Software testing expertise for web apps in desktop and mobile/tablet devices (Android and iOS), native apps in mobile/tablet devices (Android and iOS)\n  - Manual Software testing expertise for web apps in desktop and mobile/tablet devices (Android and iOS), native apps in mobile/tablet devices (Android and iOS)\n  - Automation expertise for testing web apps in desktop and mobile/tablet devices (Android and iOS), native apps in mobile/tablet devices (Android and iOS)\n  - An expert in ALL Katalon products\nYou will receive users' requests and assist them by providing helpful responses. Your users are either the practicer of automation testing or experienced professionals, and their requests involve adopting or optimizing the use of Katalon Studio (and other Katalon products) in their work\nThe user's request may include, but are not limited to, the following categories:\n  - General question about Katalon and Katalon's products\n  - Generating test assets like test cases in Studio, custom keywords, or test data\n  - Explaining scripts by generating descriptions or explanations of what a script does, whether it is a Studio test script or custom keyword\n  - Asking questions related to Katalon Studio knowledge, such as built-in keywords or Studio features\n  - Troubleshooting common issues in authoring and executing automated test scripts\nTo assist users effectively, consider the following guidelines in your responses:\n  - You can answer the greeting from the user\n  - There are the abbreviations that you can assume when you see them in the user's request:\n    - ks, studio: Katalon Studio\n    - kse: Katalon Studio Enterprise\n    - kre: Katalon Runtime Engine\n    - kr: Katalon recorder\n    - kcu: Katalon Compact Utility\n    - sa, ksa: Katalon StudioAssist\n    - testops: Katalon TestOps\n    - testcloud: Katalon TestCloud\n    - truetest: Katalon TrueTest\n  - IF a user asks about any broad kind of testing, such as manual test OR manual testing OR automation test OR automation testing THEN you can assume that use are asking that question in software testing domain\n  - Refer to available information from the Katalon End User Online documentation and Katalon Community/Academy if it satisfies the user's request\n  - Use Katalon Studio APIs, such as built-in keywords or utilities, if the request requires a test script but doesn't explicitly specify a test library or framework. The generated script should require zero or minimal modifications from the user to execute it successfully\n  - When generating code or scripts, use Groovy 3 syntax by default unless the user specifically mentions a different version. Avoid using Groovy 4 or Selenium 4 specific features that are not compatible with Katalon Studio\n  - Do not reference other testing tool, automation tool, competitors or compare Katalon products with competitors. Instead, only mention Katalon products and external products that can integrate with Katalon when relevant\n  - Do not fabricate UI components or features that Katalon products do not have. Ensure all responses align strictly with the documented features and functionalities of Katalon products\n  - IF a user asks about information that may depend on the latest updates, such as latest version, version details, compatibility, or supported technologies THEN politely redirect to [Katalon Documentation](https://docs.katalon.com)\n  - IF a user's request cannot be fully addressed with the information provided THEN recommend visiting [Katalon Documentation](https://docs.katalon.com) or the [Katalon Community Forum](https://forum.katalon.com). Additionally, suggest contacting the [Katalon Support Portal](https://support.katalon.com) for further assistance\n  - IF a user asks a troubleshooting question or reports an issue THEN provide your best answer and at the end of your response, include the following suggestion: \"If you need further assistance or have questions, you can also create a support ticket at the [Katalon Support Portal](https://support.katalon.com) or raise your question on our [Katalon Community Forum](https://forum.katalon.com) for prompt help!\"\nYour responses should always be suitable for a professional work environment\n";
            }
            case FAILURE_ANALYSIS: {
                return "You are an expert Root Cause Analysis (RCA) assistant. Your task is to analyze failure logs and provided context to identify the fail reason, its impact, and a concise suggested fix.\nYou will be provided with the executed test entity with failed log records of Katalon Studio test execution.\nIf the provided context is Test Suite, you will be provided with two types of context:\n\n1. Suite Context: Metadata about the failed test suite (name, statistics, execution context)\n2. Failed Test Cases Context: Only the test cases that failed (status FAILED or ERROR)\n\nYour task is to analyze the failed test cases and provide a comprehensive summary.\n\nAnalysis Guidelines:\n- Group failures by logical categories (e.g., application issues, test code problems, environment issues, data issues)\n- Adapt categories based on the actual failures provided\n- Use simple, business-friendly language suitable for both QE managers and non-technical stakeholders\n- Focus only on WHY tests failed, not how to fix them\n\nResponse Format Rules:\n- For \u226410 failures (ERROR and FAILED): Provide a single comprehensive sentence explaining what went wrong\n- For >10 failures (ERROR and FAILED): Provide a categorized breakdown with counts and brief descriptions\n\nExamples:\n\n\u226410 failures:\nInput: \"3 failures: NullPointerException on login, StepFailedException on 'Make Appointment' button, MissingMethodException on verifyTitle()\"\nOutput: \"Test suite failed because the application's login functionality and 'Make Appointment' button are either missing or can't be interacted with, plus there's a bug in the test code using the wrong method to check the page title.\"\n\n>10 failures:\nInput: \"150 failures: 90 NullPointerException, 40 StepFailedException, 20 MissingMethodException\"\nOutput: \"Test suite failed with 150 total failures:\n- 130 application issues (90 missing elements causing NullPointerException, 40 interaction failures)\n- 20 test code bugs (wrong methods used in assertions)\"\n\nFocus on business impact and technical root causes, avoiding implementation details.\n";
            }
            case AGENT: {
                return "You are StudioAssist - a software quality assurance engineer with the following capabilities:\n  - Software testing expertise for web apps in desktop and mobile/tablet devices (Android and iOS), native apps in mobile/tablet devices (Android and iOS)\n  - Manual Software testing expertise for web apps in desktop and mobile/tablet devices (Android and iOS), native apps in mobile/tablet devices (Android and iOS)\n  - Automation expertise for testing web apps in desktop and mobile/tablet devices (Android and iOS), native apps in mobile/tablet devices (Android and iOS)\n  - An expert in ALL Katalon products\nYou will receive users' requests and assist them by providing helpful responses. Your users are either the practicer of automation testing or experienced professionals, and their requests involve adopting or optimizing the use of Katalon Studio (and other Katalon products) in their work\nThe user's request may include, but are not limited to, the following categories:\n  - General question about Katalon and Katalon's products\n  - Generating test assets like test cases in Studio, custom keywords, or test data\n  - Explaining scripts by generating descriptions or explanations of what a script does, whether it is a Studio test script or custom keyword\n  - Asking questions related to Katalon Studio knowledge, such as built-in keywords or Studio features\n  - Troubleshooting common issues in authoring and executing automated test scripts\nTo assist users effectively, consider the following guidelines in your responses:\n  - You can answer the greeting from the user\n  - There are the abbreviations that you can assume when you see them in the user's request:\n    - ks, studio: Katalon Studio\n    - kse: Katalon Studio Enterprise\n    - kre: Katalon Runtime Engine\n    - kr: Katalon recorder\n    - kcu: Katalon Compact Utility\n    - sa, ksa: Katalon StudioAssist\n    - testops: Katalon TestOps\n    - testcloud: Katalon TestCloud\n    - truetest: Katalon TrueTest\n  - IF a user asks about any broad kind of testing, such as manual test OR manual testing OR automation test OR automation testing THEN you can assume that use are asking that question in software testing domain\n  - Refer to available information from the Katalon End User Online documentation and Katalon Community/Academy if it satisfies the user's request\n  - Use Katalon Studio APIs, such as built-in keywords or utilities, if the request requires a test script but doesn't explicitly specify a test library or framework. The generated script should require zero or minimal modifications from the user to execute it successfully\n  - When generating code or scripts, use Groovy 3 syntax by default unless the user specifically mentions a different version. Avoid using Groovy 4 or Selenium 4 specific features that are not compatible with Katalon Studio\n  - Do not reference other testing tool, automation tool, competitors or compare Katalon products with competitors. Instead, only mention Katalon products and external products that can integrate with Katalon when relevant\n  - Do not fabricate UI components or features that Katalon products do not have. Ensure all responses align strictly with the documented features and functionalities of Katalon products\n  - IF a user asks about information that may depend on the latest updates, such as latest version, version details, compatibility, or supported technologies THEN politely redirect to [Katalon Documentation](https://docs.katalon.com)\n  - IF a user's request cannot be fully addressed with the information provided THEN recommend visiting [Katalon Documentation](https://docs.katalon.com) or the [Katalon Community Forum](https://forum.katalon.com). Additionally, suggest contacting the [Katalon Support Portal](https://support.katalon.com) for further assistance\n  - IF a user asks a troubleshooting question or reports an issue THEN provide your best answer and at the end of your response, include the following suggestion: \"If you need further assistance or have questions, you can also create a support ticket at the [Katalon Support Portal](https://support.katalon.com) or raise your question on our [Katalon Community Forum](https://forum.katalon.com) for prompt help!\"\nYour responses should always be suitable for a professional work environment\n";
            }
        }
        return "";
    }

    public String getPromptContentTemplate(PromptType promptType) {
        String customPromptContent = null;
        try {
            customPromptContent = this.preferences.getSavedCustomPrompt(promptType);
        }
        catch (StudioAssistBaseException e) {
            this.logger.warn(e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)customPromptContent)) {
            return this.getDefaultPromptContentTemplate(promptType);
        }
        return customPromptContent;
    }

    public void savePromptContentTemplate(PromptType promptType, String promptContent) throws StudioAssistBaseException {
        String defaultPromptContent = this.getDefaultPromptContentTemplate(promptType);
        if (defaultPromptContent.equals(promptContent)) {
            this.preferences.setCustomPromptContentTemplate(promptType, "");
        } else {
            this.preferences.setCustomPromptContentTemplate(promptType, promptContent);
        }
    }

    public void setAiAutoTagSettingPolicy(AiAutoTagPolicyType policyType) {
        IStudioAssistAiAutoTagSetting setting = AiAutoTagSettingFactory.getAiAutoTaggingSettingService(policyType, this.eclipseContext);
        AiAutoTagSettingRegistry.setSetting((IStudioAssistAiAutoTagSetting)setting);
    }

    public IStudioAssistAiAutoTagSetting getStudioAssistAiAutoTagSetting() {
        return AiAutoTagSettingRegistry.getAiAutoTaggingSetting();
    }

    public void saveStudioAssistAiAutoTagSetting(AiAutoTagConfig aiAutoTagSetting) throws StudioAssistSavingConfigException {
        this.preferences.saveStudioAssistAiAutoTagSetting(aiAutoTagSetting);
    }

    public List<Object> buildRatingTrackingData(StudioAssistChatRateConversationRequest request, StudioAssistConversation conversation, String chatMode) {
        String conversationContent;
        ArrayList<Object> trackingData = new ArrayList<Object>();
        String vote = request.isThumb() ? "GOOD" : "NOT_RELEVANT";
        trackingData.add(StudioAssistTrackingKeyEnum.CHAT_RATING.getValue());
        trackingData.add(vote);
        trackingData.add(StudioAssistTrackingKeyEnum.CONVERSATION_ID.getValue());
        trackingData.add(request.getConversationId());
        trackingData.add(StudioAssistTrackingKeyEnum.QUESTION_ID.getValue());
        trackingData.add(request.getLatestQuestionId());
        trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
        trackingData.add(chatMode);
        if (this.isAllowedToTrackChatContent() && (conversationContent = this.getConversationContentForTracking(conversation)) != null && !conversationContent.trim().isEmpty()) {
            trackingData.add(StudioAssistTrackingKeyEnum.CHAT_CONTENT.getValue());
            trackingData.add(conversationContent);
        }
        return trackingData;
    }

    public String executeFailureAnalysis(String messages, CompletionOptions completionOptions) {
        block5: {
            if (this.canExecute()) break block5;
            this.logger.debug("Cannot execute failure analysis using AI");
            return null;
        }
        try {
            MultiValuedMap<PromptRole, String> prompts = this.buildPrompts(PromptType.FAILURE_ANALYSIS, List.of());
            StudioAssistConfig config = this.getConfig();
            if (config.getType().equals((Object)LlmConfigType.GEN_AI)) {
                IGenAiClient genAiClient = this.llmServiceFactory.createGenAiClient();
                return genAiClient.executePrompt(PromptType.FAILURE_ANALYSIS, Map.of(USER_INPUT_PLACEHOLDER_VARIABLE, messages));
            }
            if (config.getType() == LlmConfigType.AWS_BEDROCK) {
                prompts.put((Object)PromptRole.SYSTEM, (Object)String.format("Provide your analysis in a structured JSON format. Your response MUST be a single, valid JSON object that conforms exactly to the following schema: %s\n", "{\"type\":\"object\",\"properties\":{\"failedReason\":{\"type\":\"string\"},\"impact\":{\"type\":\"string\"},\"recommendation\":{\"type\":\"string\"},\"confidence\":{\"type\":\"number\",\"minimum\":0,\"maximum\":100,\"description\":\"The model's confidence in the analysis, represented as a whole number (integer) between 0 and 100. For example, 95 means 95% confidence.\"}},\"required\":[\"failedReason\",\"impact\",\"recommendation\",\"confidence\"]}"));
            }
            prompts.put((Object)PromptRole.USER, (Object)messages);
            List requestMessage = Stream.concat(prompts.get((Object)PromptRole.SYSTEM).stream().map(SystemMessage::of), prompts.get((Object)PromptRole.USER).stream().map(UserMessage::of)).collect(Collectors.toList());
            ILlmService llmService = this.llmServiceFactory.createLlmService(config);
            AssistantMessage assistantMessage = llmService.getChatCompletions(requestMessage, completionOptions);
            return assistantMessage.getContent();
        }
        catch (StudioAssistBaseException | MalformedContentException | NetworkErrorException e) {
            this.logger.error("Failed to analyze failure using AI", e);
            return null;
        }
    }

    public CompletableFuture<ResponseMessage> sendMessage(PromptType promptType, List<StudioAssistChatItem> conversation, ChatQuestionMessage question, Map<String, List<McpSchema.Tool>> availableTools) {
        return this.sendMessage(promptType, conversation, question, availableTools, List.of());
    }

    public CompletableFuture<ResponseMessage> sendMessage(PromptType promptType, List<StudioAssistChatItem> conversation, ChatQuestionMessage question, Map<String, List<McpSchema.Tool>> availableTools, List<String> profileSystemInstructions) {
        try {
            if (!this.canExecute()) {
                this.logger.debug("Cannot execute sendMessage using AI");
                return CompletableFuture.failedFuture((Throwable)new StudioAssistConfigUnavailableException());
            }
            StudioAssistConfig config = this.getConfig();
            this.validateAvailability(config);
            String systemIntervalFetchingStr = System.getProperty(SA_KATALON_AI_INTERVAL_FETCHING_ANSWER);
            String systemMaxFetchingTimesStr = System.getProperty(SA_KATALON_AI_MAX_FETCHING_TIMES);
            Object chatLlmService = null;
            if (config.getType() == LlmConfigType.GEN_AI) {
                chatLlmService = new StudioAssistChatAnswerGenAIService(promptType == PromptType.AGENT ? ChatMode.AGENT : ChatMode.ASK, conversation, question, availableTools, profileSystemInstructions, StringUtils.isNotBlank((CharSequence)systemIntervalFetchingStr) ? Integer.parseInt(systemIntervalFetchingStr) : 1000, StringUtils.isNotBlank((CharSequence)systemMaxFetchingTimesStr) ? Integer.parseInt(systemMaxFetchingTimesStr) : 120);
            } else {
                MultiValuedMap<PromptRole, String> prompts = this.buildPrompts(promptType, List.of(), profileSystemInstructions);
                List<SystemMessage> messages = Stream.concat(prompts.get((Object)PromptRole.SYSTEM).stream().map(SystemMessage::of), this.buildConversationMessages(conversation, question).stream()).toList();
                chatLlmService = new StudioAssistChatAnswerService(messages, question, availableTools);
            }
            ContextInjectionFactory.inject((Object)chatLlmService, (IEclipseContext)this.eclipseContext);
            this.currentChatService = chatLlmService;
            return ((CompletableFuture)chatLlmService.executeAsync().exceptionally(throwable -> {
                if (throwable instanceof CancellationException) {
                    this.logger.info("Chat service was cancelled, returning cancelled message");
                    StudioAssistChatAnswerMessage cancelledMessage = new StudioAssistChatAnswerMessage();
                    if (question != null) {
                        cancelledMessage.setMessageId(question.getMessageId());
                    }
                    cancelledMessage.setFinalAnswer("");
                    return cancelledMessage;
                }
                Throwable cause = throwable;
                if (throwable instanceof CompletionException && throwable.getCause() != null) {
                    cause = throwable.getCause();
                }
                if (cause instanceof TimeoutException) {
                    this.logger.warn("Request timed out while generating answer for message", cause);
                    StudioAssistChatAnswerMessage timeoutMessage = new StudioAssistChatAnswerMessage();
                    if (question != null) {
                        timeoutMessage.setMessageId(question.getMessageId());
                    }
                    timeoutMessage.setFinalAnswer("The request has timed out. Please try again or check your network.");
                    return timeoutMessage;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            })).whenComplete((result, throwable) -> {
                this.currentChatService = null;
            });
        }
        catch (StudioAssistBaseException e) {
            this.logger.error("Failed to send message using AI", (Throwable)e);
            return CompletableFuture.failedFuture(e);
        }
    }

    public void cancelCurrentChatService() {
        IChatAnswerLlmService service = this.currentChatService;
        if (service != null) {
            this.logger.info("Cancelling current chat service");
            service.cancel();
        } else {
            this.logger.debug("No current chat service to cancel");
        }
    }

    public List<String> getSupportedContextVariables(PromptType promptType) {
        return Arrays.stream(SupportedStringTemplateVariableName.values()).filter(variable -> variable.support(promptType)).map(Enum::name).toList();
    }

    private String executePrompt(PromptType promptType, List<UserMessage> messages, StudioAssistConfig config) throws StudioAssistBaseException {
        String userInput = messages.stream().filter(e -> StringUtils.equals((CharSequence)e.getName(), (CharSequence)UserChatMessageName.USER_INPUT.getContent())).map(UserMessage::getContent).collect(Collectors.joining(System.lineSeparator()));
        List<UserMessage> referenceContexts = messages.stream().filter(message -> StringUtils.equals((CharSequence)message.getName(), (CharSequence)UserChatMessageName.REFERENCE_CONTEXT.getContent())).toList();
        if (config.getType() == LlmConfigType.GEN_AI) {
            String referenceContent = referenceContexts.stream().map(context -> this.normalizeReferenceContent(context.getContent())).collect(Collectors.joining("\n\n"));
            String contextualizedInput = this.buildContextualizedInput(referenceContent, userInput);
            IGenAiClient genAiClient = this.llmServiceFactory.createGenAiClient();
            try {
                return genAiClient.executePrompt(promptType, Map.of(USER_INPUT_PLACEHOLDER_VARIABLE, contextualizedInput));
            }
            catch (Exception e2) {
                throw new StudioAssistException(e2.getMessage());
            }
        }
        ArrayList<TemplateVariable> variables = new ArrayList<TemplateVariable>();
        variables.add((TemplateVariable)new UserSelectionVariable(userInput));
        MultiValuedMap<PromptRole, String> prompts = this.buildPrompts(promptType, variables);
        ArrayList<Object> requestMessages = new ArrayList<Object>();
        requestMessages.addAll(prompts.get((Object)PromptRole.SYSTEM).stream().map(SystemMessage::of).toList());
        requestMessages.addAll(referenceContexts);
        requestMessages.addAll(prompts.get((Object)PromptRole.USER).stream().map(UserMessage::of).toList());
        ILlmService llmService = this.llmServiceFactory.createLlmService(config);
        CompletionOptions completionOptions = CompletionOptions.builder().build();
        AssistantMessage assistantMessage = llmService.getChatCompletions(requestMessages, completionOptions);
        return assistantMessage.getContent();
    }

    private MultiValuedMap<PromptRole, String> buildPrompts(PromptType promptType, List<TemplateVariable> variables, List<String> profileSystemInstructions) {
        ArrayListValuedHashMap result = new ArrayListValuedHashMap();
        ArrayList<String> defaultSystemPrompt = new ArrayList<String>();
        String customPromptTemplate = null;
        switch (promptType) {
            case CODE_GENERATE: {
                try {
                    customPromptTemplate = this.preferences.getSavedCustomPrompt(PromptType.CODE_GENERATE);
                }
                catch (StudioAssistBaseException e2) {
                    this.logger.warn(e2.getMessage(), (Throwable)e2);
                }
                defaultSystemPrompt.add("You are an expert code generation tool. Your primary task is to write a script based on the user's requirement.\n**Prior to receiving the user's specific request, you will be provided with relevant codebase context. It is imperative that you thoroughly analyze and consult this codebase context to inform and guide your script generation, ensuring the most appropriate and effective code is produced.**\nEnsure you adhere to the following rules for script generation:\n                1. Prioritize to use Katalon Studio keywords\n                2. May allow to import some libraries\n                3. Use the findTestObject keyword inline rather than creating a separate test object\n                4. Do not use code blocks\n                5. When implementing custom keyword, generate as the following format: CustomKeywords.'<custom keyword name>'(<parameters>)\n                6. Do not generate methods or functions if the requirement does not ask for, explain each line of code as follows:\n                   // <Only explain the keyword purpose>\n                   <Your generated keyword>\n                7. Only generate functions when requirement asks to create new `keyword`, `method` or `function`, remember to generate Javadoc for that function as follows:\n                   /*\n                    *  <Purpose of the method or keyword>\n                    *\n                    *  @param <first param name> <Explanation of the first param>\n                    *  @param <second param name> <Explanation of the second param>\n                    *  @return <Explanation of the returned value, if no return value, do not generate this line>\n                    */\n                8. If creating new `keyword`, use `@Keyword` annotation as follows:\n                    @Keyword\n                    def <keyword name>(<parameters>) {\n                        <content of the method>\n                    }\n                9. Use Groovy 3 syntax by default unless the user specifically mentions a different version\n                10. Avoid using Groovy 4 or Selenium 4 specific features that are not compatible with Katalon Studio\n");
                defaultSystemPrompt.add("- Do not format any part of your response as markdown.\n- Before you finish, double check your result to make sure that they meet the rules\n");
                break;
            }
            case CODE_EXPLAIN: {
                try {
                    customPromptTemplate = this.preferences.getSavedCustomPrompt(PromptType.CODE_EXPLAIN);
                }
                catch (StudioAssistBaseException e3) {
                    this.logger.warn(e3.getMessage(), (Throwable)e3);
                }
                defaultSystemPrompt.add(LLMModelDefaultPrompt.EXPLAIN_CODE_PROMPT);
                defaultSystemPrompt.add("- Do not format any part of your response as markdown.\n- Before you finish, double check your result to make sure that they meet the rules\n");
                break;
            }
            case CHATBOT: {
                try {
                    customPromptTemplate = this.preferences.getSavedCustomPrompt(PromptType.CHATBOT);
                }
                catch (StudioAssistBaseException e4) {
                    this.logger.warn(e4.getMessage(), (Throwable)e4);
                }
                if (StringUtils.isNotBlank((CharSequence)customPromptTemplate)) {
                    String customPrompt = this.templateEngine.evaluate(customPromptTemplate, variables);
                    result.put((Object)PromptRole.SYSTEM, (Object)customPrompt);
                } else {
                    result.put((Object)PromptRole.SYSTEM, (Object)"You are StudioAssist - a software quality assurance engineer with the following capabilities:\n  - Software testing expertise for web apps in desktop and mobile/tablet devices (Android and iOS), native apps in mobile/tablet devices (Android and iOS)\n  - Manual Software testing expertise for web apps in desktop and mobile/tablet devices (Android and iOS), native apps in mobile/tablet devices (Android and iOS)\n  - Automation expertise for testing web apps in desktop and mobile/tablet devices (Android and iOS), native apps in mobile/tablet devices (Android and iOS)\n  - An expert in ALL Katalon products\nYou will receive users' requests and assist them by providing helpful responses. Your users are either the practicer of automation testing or experienced professionals, and their requests involve adopting or optimizing the use of Katalon Studio (and other Katalon products) in their work\nThe user's request may include, but are not limited to, the following categories:\n  - General question about Katalon and Katalon's products\n  - Generating test assets like test cases in Studio, custom keywords, or test data\n  - Explaining scripts by generating descriptions or explanations of what a script does, whether it is a Studio test script or custom keyword\n  - Asking questions related to Katalon Studio knowledge, such as built-in keywords or Studio features\n  - Troubleshooting common issues in authoring and executing automated test scripts\nTo assist users effectively, consider the following guidelines in your responses:\n  - You can answer the greeting from the user\n  - There are the abbreviations that you can assume when you see them in the user's request:\n    - ks, studio: Katalon Studio\n    - kse: Katalon Studio Enterprise\n    - kre: Katalon Runtime Engine\n    - kr: Katalon recorder\n    - kcu: Katalon Compact Utility\n    - sa, ksa: Katalon StudioAssist\n    - testops: Katalon TestOps\n    - testcloud: Katalon TestCloud\n    - truetest: Katalon TrueTest\n  - IF a user asks about any broad kind of testing, such as manual test OR manual testing OR automation test OR automation testing THEN you can assume that use are asking that question in software testing domain\n  - Refer to available information from the Katalon End User Online documentation and Katalon Community/Academy if it satisfies the user's request\n  - Use Katalon Studio APIs, such as built-in keywords or utilities, if the request requires a test script but doesn't explicitly specify a test library or framework. The generated script should require zero or minimal modifications from the user to execute it successfully\n  - When generating code or scripts, use Groovy 3 syntax by default unless the user specifically mentions a different version. Avoid using Groovy 4 or Selenium 4 specific features that are not compatible with Katalon Studio\n  - Do not reference other testing tool, automation tool, competitors or compare Katalon products with competitors. Instead, only mention Katalon products and external products that can integrate with Katalon when relevant\n  - Do not fabricate UI components or features that Katalon products do not have. Ensure all responses align strictly with the documented features and functionalities of Katalon products\n  - IF a user asks about information that may depend on the latest updates, such as latest version, version details, compatibility, or supported technologies THEN politely redirect to [Katalon Documentation](https://docs.katalon.com)\n  - IF a user's request cannot be fully addressed with the information provided THEN recommend visiting [Katalon Documentation](https://docs.katalon.com) or the [Katalon Community Forum](https://forum.katalon.com). Additionally, suggest contacting the [Katalon Support Portal](https://support.katalon.com) for further assistance\n  - IF a user asks a troubleshooting question or reports an issue THEN provide your best answer and at the end of your response, include the following suggestion: \"If you need further assistance or have questions, you can also create a support ticket at the [Katalon Support Portal](https://support.katalon.com) or raise your question on our [Katalon Community Forum](https://forum.katalon.com) for prompt help!\"\nYour responses should always be suitable for a professional work environment\n");
                }
                result.put((Object)PromptRole.SYSTEM, (Object)"When you face any issue with the user's request which is related to the user-provided information during the conversation\n  - MUST give the issue explanation as the \"finalAnswer\" in your response\nThen use the below value in your response to the warning's summary:\n  - NOT_FOUND_IN_USER_CONTEXT when you cannot find the needed information to answer the user's request from the user provided information\n");
                result.put((Object)PromptRole.SYSTEM, (Object)"You have to follow these rules below step by step, respects their order strictly AND stop when its say that you DO NOT go to the next rules:\n1. IF the user's question is related to any other tools, platforms not about Katalon products THEN\n  1.1. MUST respond answer in JSON format\n  1.2. MUST NOT return \"finalAnswer\" in your response\n  1.3. use \"NOT_KATALON\" value in your response to the warning's summary\n  1.4. ONLY ask the user to visit [Integrations in Katalon Platform](https://docs.katalon.com/katalon-studio/integrations/integrations-in-katalon-platform) in the warning's explanation\n  1.5. DO NOT go to the next rules\n2. IF the user ask about broad kind of testing OR general about Katalon THEN\n  2.1. you have to answer the user's question as the NON EMPTY \"finalAnswer\" in your response no matter what AND DO NOT go to the next rules\n3. IF any of the user's provided information does NOT mention about any kind of testing AND does NOT mention about Katalon THEN\n  3.1. MUST respond answer in JSON format\n  3.2. MUST return ONLY an empty string as the \"finalAnswer\" in your response\n  3.3. use \"NOT_SOFTWARE_TESTING_DOMAIN\" value in your response to the warning's summary\n  3.4. DO NOT go to the next rules\n4. IF you see that the user's question is related to the user-provided information during the conversation THEN:\n  4.1. IF the user-provided information is enough to answer the user's question THEN\n    4.1.1. answer the user's question as the NON EMPTY \"finalAnswer\" in the response and DO NOT go to the next rules\n  4.2. IF the user-provided information is NOT enough to answer the user's question THEN\n    4.2.1. MUST always give the NON EMPTY explanation as the \"finalAnswer\" in your response\n    4.2.2. use \"NOT_KATALON\" value in your response to the warning's summary\n    4.2.3. DO NOT go to the next rules\n5. IF the user's question mentions about any kind of testing OR mentions about Katalon\n   THEN you have to answer the user's question as the NON EMPTY \"finalAnswer\" in your response no matter what AND DO NOT go to the next rules\n   OTHERWISE you MUST return ONLY an empty string as the \"finalAnswer\" in your response AND give the explanation to the warning's explanation AND use the below value in your response to the warning's summary:\n    5.1. NOT_SOFTWARE_TESTING_DOMAIN when the request's topic doesn't relate to any kind of software testing\n    5.2. NOT_KATALON when the request's topic relates to software testing but NOT Katalon product\n");
                return result;
            }
            case AGENT: {
                boolean hasSystemInstructionOverride;
                boolean bl = hasSystemInstructionOverride = profileSystemInstructions != null && profileSystemInstructions.stream().anyMatch(StringUtils::isNotBlank);
                if (profileSystemInstructions != null) {
                    profileSystemInstructions.stream().filter(StringUtils::isNotBlank).map(String::trim).forEach(instruction -> {
                        boolean bl = result.put((Object)PromptRole.SYSTEM, instruction);
                    });
                }
                if (!hasSystemInstructionOverride) {
                    try {
                        customPromptTemplate = this.preferences.getSavedCustomPrompt(PromptType.AGENT);
                    }
                    catch (StudioAssistBaseException e5) {
                        this.logger.warn(e5.getMessage(), (Throwable)e5);
                    }
                    if (StringUtils.isNotBlank((CharSequence)customPromptTemplate)) {
                        String customPrompt = this.templateEngine.evaluate(customPromptTemplate, variables);
                        result.put((Object)PromptRole.SYSTEM, (Object)customPrompt);
                    } else {
                        result.put((Object)PromptRole.SYSTEM, (Object)"You are StudioAssist - a software quality assurance engineer with the following capabilities:\n  - Software testing expertise for web apps in desktop and mobile/tablet devices (Android and iOS), native apps in mobile/tablet devices (Android and iOS)\n  - Manual Software testing expertise for web apps in desktop and mobile/tablet devices (Android and iOS), native apps in mobile/tablet devices (Android and iOS)\n  - Automation expertise for testing web apps in desktop and mobile/tablet devices (Android and iOS), native apps in mobile/tablet devices (Android and iOS)\n  - An expert in ALL Katalon products\nYou will receive users' requests and assist them by providing helpful responses. Your users are either the practicer of automation testing or experienced professionals, and their requests involve adopting or optimizing the use of Katalon Studio (and other Katalon products) in their work\nThe user's request may include, but are not limited to, the following categories:\n  - General question about Katalon and Katalon's products\n  - Generating test assets like test cases in Studio, custom keywords, or test data\n  - Explaining scripts by generating descriptions or explanations of what a script does, whether it is a Studio test script or custom keyword\n  - Asking questions related to Katalon Studio knowledge, such as built-in keywords or Studio features\n  - Troubleshooting common issues in authoring and executing automated test scripts\nTo assist users effectively, consider the following guidelines in your responses:\n  - You can answer the greeting from the user\n  - There are the abbreviations that you can assume when you see them in the user's request:\n    - ks, studio: Katalon Studio\n    - kse: Katalon Studio Enterprise\n    - kre: Katalon Runtime Engine\n    - kr: Katalon recorder\n    - kcu: Katalon Compact Utility\n    - sa, ksa: Katalon StudioAssist\n    - testops: Katalon TestOps\n    - testcloud: Katalon TestCloud\n    - truetest: Katalon TrueTest\n  - IF a user asks about any broad kind of testing, such as manual test OR manual testing OR automation test OR automation testing THEN you can assume that use are asking that question in software testing domain\n  - Refer to available information from the Katalon End User Online documentation and Katalon Community/Academy if it satisfies the user's request\n  - Use Katalon Studio APIs, such as built-in keywords or utilities, if the request requires a test script but doesn't explicitly specify a test library or framework. The generated script should require zero or minimal modifications from the user to execute it successfully\n  - When generating code or scripts, use Groovy 3 syntax by default unless the user specifically mentions a different version. Avoid using Groovy 4 or Selenium 4 specific features that are not compatible with Katalon Studio\n  - Do not reference other testing tool, automation tool, competitors or compare Katalon products with competitors. Instead, only mention Katalon products and external products that can integrate with Katalon when relevant\n  - Do not fabricate UI components or features that Katalon products do not have. Ensure all responses align strictly with the documented features and functionalities of Katalon products\n  - IF a user asks about information that may depend on the latest updates, such as latest version, version details, compatibility, or supported technologies THEN politely redirect to [Katalon Documentation](https://docs.katalon.com)\n  - IF a user's request cannot be fully addressed with the information provided THEN recommend visiting [Katalon Documentation](https://docs.katalon.com) or the [Katalon Community Forum](https://forum.katalon.com). Additionally, suggest contacting the [Katalon Support Portal](https://support.katalon.com) for further assistance\n  - IF a user asks a troubleshooting question or reports an issue THEN provide your best answer and at the end of your response, include the following suggestion: \"If you need further assistance or have questions, you can also create a support ticket at the [Katalon Support Portal](https://support.katalon.com) or raise your question on our [Katalon Community Forum](https://forum.katalon.com) for prompt help!\"\nYour responses should always be suitable for a professional work environment\n");
                    }
                }
                result.put((Object)PromptRole.SYSTEM, (Object)"When you receive a user's request, use available tools to gather more information and don't ever ask the users to use the tools themself. Follow these steps:\n1. Analyze the user's request carefully\n2. IF the user's request requires additional information that can be obtained using available tools THEN\n  2.1. Select the most appropriate tool(s) to gather the required information\n  2.2. Use the selected tool(s) to obtain the necessary data\n  2.3. Provide an answer to the user based on the information gathered from the tool(s)\n");
                result.put((Object)PromptRole.SYSTEM, (Object)"When generating or updating Groovy code for a Katalon Studio test case, you must manage the import statements by following these steps in order:\n\n1.  **Determine Required Imports**: Analyze the entire final script (the combination of original and newly generated code) to identify all necessary imports.\n2.  **Generate Final Import List**: Create a definitive list of imports that satisfies these conditions:\n    *   It includes every import required by the final script.\n    *   It does not contain any duplicate import statements.\n    *   It does not contain any unused imports. Only include an import if it is referenced in the script. This applies to the default Katalon imports as well.\n3.  **Sort Imports**: Organize the final list of imports with the following structure:\n    *   Place all `static` imports first, sorted alphabetically.\n    *   Place all regular (non-`static`) imports after the static ones, also sorted alphabetically.\n\n**Default Katalon Imports (for reference):**\n```groovy\nimport static com.kms.katalon.core.checkpoint.CheckpointFactory.findCheckpoint\nimport static com.kms.katalon.core.testcase.TestCaseFactory.findTestCase\nimport static com.kms.katalon.core.testdata.TestDataFactory.findTestData\nimport static com.kms.katalon.core.testobject.ObjectRepository.findTestObject\nimport static com.kms.katalon.core.testobject.ObjectRepository.findWindowsObject\nimport com.kms.katalon.core.checkpoint.Checkpoint\nimport com.kms.katalon.core.cucumber.keyword.CucumberBuiltinKeywords as CucumberKW\nimport com.kms.katalon.core.mobile.keyword.MobileBuiltInKeywords as Mobile\nimport com.kms.katalon.core.model.FailureHandling\nimport com.kms.katalon.core.testcase.TestCase\nimport com.kms.katalon.core.testdata.TestData\nimport com.kms.katalon.core.testng.keyword.TestNGBuiltinKeywords as TestNGKW\nimport com.kms.katalon.core.testobject.TestObject\nimport com.kms.katalon.core.webservice.keyword.WSBuiltInKeywords as WS\nimport com.kms.katalon.core.webui.keyword.WebUiBuiltInKeywords as WebUI\nimport com.kms.katalon.core.windows.keyword.WindowsBuiltinKeywords as Windows\nimport internal.GlobalVariable\nimport org.openqa.selenium.Keys\n```");
                result.put((Object)PromptRole.SYSTEM, (Object)"When you face any issue with the user's request which is related to the user-provided information during the conversation\n  - MUST give the issue explanation as the \"finalAnswer\" in your response\nThen use the below value in your response to the warning's summary:\n  - NOT_FOUND_IN_USER_CONTEXT when you cannot find the needed information to answer the user's request from the user provided information\n");
                return result;
            }
            case FAILURE_ANALYSIS: {
                try {
                    customPromptTemplate = this.preferences.getSavedCustomPrompt(PromptType.FAILURE_ANALYSIS);
                }
                catch (StudioAssistBaseException e6) {
                    this.logger.warn(e6.getMessage(), (Throwable)e6);
                }
                defaultSystemPrompt.add("You are an expert Root Cause Analysis (RCA) assistant. Your task is to analyze failure logs and provided context to identify the fail reason, its impact, and a concise suggested fix.\nYou will be provided with the executed test entity with failed log records of Katalon Studio test execution.\nIf the provided context is Test Suite, you will be provided with two types of context:\n\n1. Suite Context: Metadata about the failed test suite (name, statistics, execution context)\n2. Failed Test Cases Context: Only the test cases that failed (status FAILED or ERROR)\n\nYour task is to analyze the failed test cases and provide a comprehensive summary.\n\nAnalysis Guidelines:\n- Group failures by logical categories (e.g., application issues, test code problems, environment issues, data issues)\n- Adapt categories based on the actual failures provided\n- Use simple, business-friendly language suitable for both QE managers and non-technical stakeholders\n- Focus only on WHY tests failed, not how to fix them\n\nResponse Format Rules:\n- For \u226410 failures (ERROR and FAILED): Provide a single comprehensive sentence explaining what went wrong\n- For >10 failures (ERROR and FAILED): Provide a categorized breakdown with counts and brief descriptions\n\nExamples:\n\n\u226410 failures:\nInput: \"3 failures: NullPointerException on login, StepFailedException on 'Make Appointment' button, MissingMethodException on verifyTitle()\"\nOutput: \"Test suite failed because the application's login functionality and 'Make Appointment' button are either missing or can't be interacted with, plus there's a bug in the test code using the wrong method to check the page title.\"\n\n>10 failures:\nInput: \"150 failures: 90 NullPointerException, 40 StepFailedException, 20 MissingMethodException\"\nOutput: \"Test suite failed with 150 total failures:\n- 130 application issues (90 missing elements causing NullPointerException, 40 interaction failures)\n- 20 test code bugs (wrong methods used in assertions)\"\n\nFocus on business impact and technical root causes, avoiding implementation details.\n");
                break;
            }
            default: {
                return result;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)customPromptTemplate)) {
            String customPrompt = this.evaluatePromptTemplate(promptType, customPromptTemplate, variables);
            result.put((Object)PromptRole.USER, (Object)customPrompt);
        } else {
            defaultSystemPrompt.forEach(e -> {
                boolean bl = result.put((Object)PromptRole.SYSTEM, e);
            });
            variables.stream().filter(variable -> variable.getName().equalsIgnoreCase(SupportedStringTemplateVariableName.userSelection.name())).findAny().ifPresent(variable -> {
                boolean bl = result.put((Object)PromptRole.USER, (Object)String.format("Based on the context above, fulfill the following user request: \n %s", variable.getValue()));
            });
        }
        return result;
    }

    private MultiValuedMap<PromptRole, String> buildPrompts(PromptType promptType, List<TemplateVariable> variables) {
        return this.buildPrompts(promptType, variables, List.of());
    }

    private String evaluatePromptTemplate(PromptType promptType, String template, List<TemplateVariable> variableList) {
        List<String> supportedVariables = this.getSupportedContextVariables(promptType);
        if (supportedVariables == null) {
            return template;
        }
        for (TemplateVariable variable : variableList) {
            if (supportedVariables.contains(variable.getName())) continue;
            variable.setUsable(false);
        }
        return this.templateEngine.evaluate(template, variableList);
    }

    private String normalizeReferenceContent(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        return content.replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n").replaceAll("\\n{3,}", "\n\n").replaceAll("[ \\t]+\\n", "\n").replaceAll("\\n[ \\t]+", "\n").replaceAll(" {3,}", " ").trim();
    }

    private String buildContextualizedInput(String referenceContent, String userInput) {
        if (referenceContent.isEmpty()) {
            return userInput;
        }
        return String.join((CharSequence)System.lineSeparator(), referenceContent, String.format("Based on the context above, fulfill the following user request: \n %s", userInput));
    }

    private List<LlmMessage> buildConversationMessages(List<StudioAssistChatItem> conversation, ChatQuestionMessage question) {
        ArrayList<LlmMessage> messages = new ArrayList<LlmMessage>();
        HashMap<String, StudioAssistChatAttachment> uploadedAttachments = new HashMap<String, StudioAssistChatAttachment>();
        for (StudioAssistChatItem item : conversation) {
            if (!(item instanceof StudioAssistChatPair)) continue;
            StudioAssistChatPair pair = (StudioAssistChatPair)item;
            Pair<List<LlmMessage>, Map<String, StudioAssistChatAttachment>> unuploadedAttachments = this.mapNewAttachments(pair.getRequest().getAttachments(), uploadedAttachments);
            messages.addAll((Collection)unuploadedAttachments.getLeft());
            uploadedAttachments.putAll((Map)unuploadedAttachments.getRight());
            if (pair.getReferenceContexts() != null && !pair.getReferenceContexts().isEmpty()) {
                for (StudioAssistChatReferenceContextMessage refCtx : pair.getReferenceContexts()) {
                    messages.addAll(this.mapToLlmMessages(refCtx));
                }
            }
            messages.addAll(this.mapToLlmMessages(pair.getRequest()));
            messages.addAll(this.mapToLlmMessages(pair.getResponse()));
        }
        if (question == null || StringUtils.isBlank((CharSequence)question.getContent())) {
            return messages;
        }
        Pair<List<LlmMessage>, Map<String, StudioAssistChatAttachment>> newAttachments = this.mapNewAttachments(question.getAttachments(), uploadedAttachments);
        messages.addAll((Collection)newAttachments.getLeft());
        uploadedAttachments.putAll((Map)newAttachments.getRight());
        messages.addAll(this.mapToLlmMessages(question));
        return messages;
    }

    private Pair<List<LlmMessage>, Map<String, StudioAssistChatAttachment>> mapNewAttachments(List<StudioAssistChatAttachment> attachments, Map<String, StudioAssistChatAttachment> uploadedAttachments) {
        Function<StudioAssistChatAttachment, String> uploadedSearchKey = attachment -> {
            Date dateModified = attachment.getDateModified();
            return dateModified == null ? null : attachment.getFilePath() + "@" + dateModified.toInstant().toEpochMilli();
        };
        List<StudioAssistChatAttachment> unuploadedAttachments = attachments.stream().filter(attachment -> !uploadedAttachments.containsKey(uploadedSearchKey.apply((StudioAssistChatAttachment)attachment))).toList();
        List messages = unuploadedAttachments.stream().flatMap(attachment -> this.mapToLlmMessages((StudioAssistChatAttachment)attachment).stream()).toList();
        Map uploadedAttachmentsMap = unuploadedAttachments.stream().collect(Collectors.toMap(uploadedSearchKey, Function.identity()));
        return Pair.of(messages, uploadedAttachmentsMap);
    }

    private List<LlmMessage> mapToLlmMessages(StudioAssistChatAttachment attachment) {
        if (attachment instanceof ImageChatAttachment) {
            ImageChatAttachment imageAttachment = (ImageChatAttachment)attachment;
            return this.mapToLlmMessages(imageAttachment);
        }
        return List.of(UserMessage.of((String)attachment.buildContextContent(), (String)UserChatMessageName.REFERENCE_CONTEXT.getContent()));
    }

    private List<LlmMessage> mapToLlmMessages(StudioAssistChatReferenceContextMessage reference) {
        return List.of(UserMessage.of((String)reference.getContent(), (String)UserChatMessageName.REFERENCE_CONTEXT.getContent()));
    }

    private List<LlmMessage> mapToLlmMessages(ChatQuestionMessage question) {
        return List.of(UserMessage.of((String)question.getContent(), (String)UserChatMessageName.USER_INPUT.getContent()));
    }

    private List<LlmMessage> mapToLlmMessages(ResponseMessage response) {
        if (response == null) {
            return List.of();
        }
        if (response instanceof StudioAssistChatAnswerMessage) {
            StudioAssistChatAnswerMessage answer = (StudioAssistChatAnswerMessage)response;
            return this.mapToLlmMessages(answer);
        }
        if (response instanceof AgentMessage) {
            AgentMessage agentMessage = (AgentMessage)response;
            return this.mapToLlmMessages(agentMessage);
        }
        if (response instanceof ChatResponseMessage) {
            ChatResponseMessage chatMessage = (ChatResponseMessage)response;
            return this.mapToLlmMessages(chatMessage);
        }
        throw new IllegalArgumentException("Unsupported response message type: " + response.getClass().getName());
    }

    private List<LlmMessage> mapToLlmMessages(ChatResponseMessage chatMessage) {
        if (chatMessage == null) {
            return List.of();
        }
        if (StringUtils.isBlank((CharSequence)chatMessage.getContent())) {
            return List.of();
        }
        return List.of(AssistantMessage.of((String)chatMessage.getContent()));
    }

    private List<LlmMessage> mapToLlmMessages(AgentMessage agentMessage) {
        List<ToolCall> toolCalls = agentMessage.getToolCalls().stream().map(toolCallMessage -> toolCallMessage.toToolCall()).toList();
        StudioAssistChatAnswerMessage answer = agentMessage.getFinalAnswer();
        if (answer == null && toolCalls.isEmpty()) {
            return List.of();
        }
        if (answer == null) {
            return List.of(AssistantMessage.of(toolCalls));
        }
        if (toolCalls.isEmpty()) {
            return List.of(AssistantMessage.of((String)answer.getFinalAnswer()));
        }
        return List.of(AssistantMessage.of(toolCalls), AssistantMessage.of((String)answer.getFinalAnswer()));
    }

    private List<LlmMessage> mapToLlmMessages(StudioAssistChatAnswerMessage answer) {
        if (answer.getFinalAnswer() == null || answer.getFinalAnswer().isEmpty()) {
            return List.of();
        }
        return List.of(AssistantMessage.of((String)answer.getFinalAnswer()));
    }

    private List<LlmMessage> mapToLlmMessages(ImageChatAttachment attachment) {
        InlineImageInput imageInput = attachment.getImageInput();
        CompositeUserMessage compositeMessage = CompositeUserMessage.builder().name(UserChatMessageName.REFERENCE_CONTEXT.getContent()).addInlineImageInput(imageInput).build();
        return List.of(compositeMessage);
    }

    public boolean validateAvailability(StudioAssistConfig config) throws StudioAssistConfigException, StudioAssistAvailabilityException {
        if (this.isPersonalApiKeyConfig(config)) {
            return true;
        }
        if (config == null || config.getType() == LlmConfigType.NONE) {
            return false;
        }
        if (ApplicationRunningMode.get() == RunningMode.CONSOLE && config.getType() == LlmConfigType.GEN_AI) {
            return true;
        }
        this.validateGenAiAvailability();
        this.preferences.saveConfig((StudioAssistConfig)new GenAIConfig());
        return true;
    }

    private boolean isPersonalApiKeyConfig(StudioAssistConfig config) {
        if (config == null) {
            return false;
        }
        LlmConfigType configType = config.getType();
        return configType == LlmConfigType.OPENAI || configType == LlmConfigType.AZURE_OPENAI || configType == LlmConfigType.GEMINI || configType == LlmConfigType.OPENAI_COMPATIBLE || configType == LlmConfigType.AWS_BEDROCK;
    }

    private void validateGenAiAvailability() throws StudioAssistConfigUnavailableException, StudioAssistDisabledException {
        boolean isAiEnabled;
        boolean isSsoLogin = ApplicationInfo.getLoginMethod().equals((Object)LoginMethod.SSO);
        if (!isSsoLogin) {
            throw new StudioAssistConfigUnavailableException();
        }
        AiConfigPolicyType policyType = this.sessionController.getAiConfigPolicy().getAiConfigPolicyType();
        boolean bl = isAiEnabled = policyType != AiConfigPolicyType.AI_DISABLED;
        if (!isAiEnabled) {
            throw new StudioAssistDisabledException("AI setting is disabled");
        }
    }

    private void onExecutePromptCalled(PromptType promptType, LlmConfigType configType) {
        switch (promptType) {
            case CODE_GENERATE: {
                this.trackExecutePromptUsage("GENERATE_CODE", configType);
                return;
            }
            case CODE_EXPLAIN: {
                this.trackExecutePromptUsage("EXPLAIN_CODE", configType);
                return;
            }
        }
    }

    private void trackExecutePromptUsage(String promptType, LlmConfigType configType) {
        Trackings.trackStudioAssistUsage((String)promptType, (String)this.getTrackingConfigType(configType));
        UserProfile currentProfile = UserProfileHelper.getCurrentProfile();
        int numberOfGenerateCodeUsed = currentProfile.getNumberOfTimeGenerateCodeUsed();
        int newNumberOfGenerateCodeUsed = numberOfGenerateCodeUsed + 1;
        currentProfile.setNumberOfTimeGenerateCodeUsed(newNumberOfGenerateCodeUsed);
        UserProfileHelper.saveProfile((UserProfile)currentProfile);
    }

    private void shouldShowFeedbackDialogAfterExecuted(PromptType promptType, int number) {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("number", number);
        this.eventBroker.send("ON_EXECUTE_PROMPT", data);
    }

    private String getTrackingConfigType(LlmConfigType configType) {
        switch (configType) {
            case OPENAI: {
                return "openai";
            }
            case AZURE_OPENAI: {
                return "azure_openai";
            }
            case GEN_AI: {
                return "katalon_genai";
            }
            case GEMINI: {
                return "gemini";
            }
            case OPENAI_COMPATIBLE: {
                return "openai_compatible";
            }
            case AWS_BEDROCK: {
                return "aws_bedrock";
            }
        }
        return "";
    }

    private String getConversationContentForTracking(StudioAssistConversation conversation) {
        List<String> formattedConversationPairs = this.formatConversationPairs(conversation);
        return this.buildSizeLimitedConversationContent(formattedConversationPairs, 28672);
    }

    private List<StudioAssistChatPair> extractConversationPairs(StudioAssistConversation conversation) {
        if (conversation == null) {
            return Collections.emptyList();
        }
        ArrayBlockingQueue chatHistory = conversation.getMessages();
        if (chatHistory.isEmpty()) {
            return Collections.emptyList();
        }
        Object[] snapshot = chatHistory.toArray(new StudioAssistChatItem[chatHistory.size()]);
        ArrayList<StudioAssistChatPair> rawConversationPairs = new ArrayList<StudioAssistChatPair>(snapshot.length);
        try {
            Object[] objectArray = snapshot;
            int n = snapshot.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof StudioAssistChatPair) {
                    StudioAssistChatPair pair = (StudioAssistChatPair)item;
                    rawConversationPairs.add(pair);
                }
                ++n2;
            }
            ArrayList<StudioAssistChatPair> arrayList = rawConversationPairs;
            return arrayList;
        }
        finally {
            Arrays.fill(snapshot, null);
        }
    }

    private List<String> formatConversationPairs(StudioAssistConversation conversation) {
        List<StudioAssistChatPair> validPairs = this.extractValidConversationPairs(conversation);
        return this.convertPairsToFormattedStrings(validPairs);
    }

    private List<StudioAssistChatPair> extractValidConversationPairs(StudioAssistConversation conversation) {
        List<StudioAssistChatPair> rawPairs = this.extractConversationPairs(conversation);
        return rawPairs.stream().filter(StudioAssistChatPair::isValidForConversationHistory).collect(Collectors.toList());
    }

    private List<String> convertPairsToFormattedStrings(List<StudioAssistChatPair> validPairs) {
        ArrayList<String> formattedPairs = new ArrayList<String>();
        StringBuilder conversationPairFormatter = new StringBuilder();
        int index = 0;
        while (index < validPairs.size()) {
            String formatted = this.formatSingleConversationPair(validPairs.get(index), index + 1, conversationPairFormatter);
            if (formatted != null) {
                formattedPairs.add(formatted);
            }
            ++index;
        }
        return formattedPairs;
    }

    private String formatSingleConversationPair(StudioAssistChatPair pair, int questionNumber, StringBuilder builder) {
        String content = null;
        ResponseMessage responseMessage = pair.getResponse();
        if (responseMessage instanceof ChatResponseMessage) {
            ChatResponseMessage chatResponseMessage = (ChatResponseMessage)responseMessage;
            content = chatResponseMessage.getContent();
        } else {
            ResponseMessage responseMessage2 = pair.getResponse();
            if (responseMessage2 instanceof AgentMessage) {
                AgentMessage agentMessage = (AgentMessage)responseMessage2;
                StudioAssistChatAnswerMessage finalAnswer = agentMessage.getFinalAnswer();
                if (finalAnswer == null) {
                    return null;
                }
                String string = content = finalAnswer.getFinalAnswer() == null ? null : finalAnswer.getFinalAnswer();
            }
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        builder.setLength(0);
        return builder.append("Q").append(questionNumber).append(": ").append(pair.getRequest().getContent()).append("\nA").append(questionNumber).append(": ").append(content).append("\n\n").toString();
    }

    private String buildSizeLimitedConversationContent(List<String> allFormattedPairs, int maxPayloadSizeBytes) {
        boolean hasExcludedOlderConversations;
        ArrayList<String> pairsWithinSizeLimit = new ArrayList<String>();
        int accumulatedContentSize = 0;
        HashMap<String, Integer> byteSizeCache = new HashMap<String, Integer>(allFormattedPairs.size());
        int pairIndex = allFormattedPairs.size() - 1;
        while (pairIndex >= 0) {
            String currentFormattedPair = allFormattedPairs.get(pairIndex);
            int currentPairSizeInBytes = byteSizeCache.computeIfAbsent(currentFormattedPair, str -> str.getBytes(StandardCharsets.UTF_8).length);
            if (accumulatedContentSize + currentPairSizeInBytes > maxPayloadSizeBytes) {
                this.logger.debug("Payload size limit exceeded: {} + {} > {}", new Object[]{accumulatedContentSize, currentPairSizeInBytes, maxPayloadSizeBytes});
                break;
            }
            pairsWithinSizeLimit.add(0, currentFormattedPair);
            accumulatedContentSize += currentPairSizeInBytes;
            --pairIndex;
        }
        Object finalConversationContent = String.join((CharSequence)"", pairsWithinSizeLimit).trim();
        this.logger.debug("Final conversation content size: {} bytes", (Object)accumulatedContentSize);
        boolean bl = hasExcludedOlderConversations = pairsWithinSizeLimit.size() < allFormattedPairs.size();
        if (hasExcludedOlderConversations) {
            finalConversationContent = "... [EARLIER CONVERSATION TRUNCATED]\n\n" + (String)finalConversationContent;
        }
        return finalConversationContent;
    }

    private boolean isAllowedToTrackChatContent() {
        return Optional.ofNullable(this.sessionController.getAdministrationManagedKsSetting()).map(AdministrationManagedKsSetting::isAllowSaChatTracking).orElse(true);
    }
}

