/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services.internal;

import com.kms.katalon.ai.core.services.IFileSnapshotService;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSnapshotService
implements IFileSnapshotService {
    private static final Logger logger = LoggerFactory.getLogger(FileSnapshotService.class);
    private static final String SNAPSHOT_EXTENSION = ".snapshot";
    private final AtomicReference<Path> snapshotDirectory = new AtomicReference();
    @Inject
    private IEventBroker eventBroker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path getSnapshotDirectory() {
        Path cachedSnapshotDirectory = this.snapshotDirectory.get();
        if (cachedSnapshotDirectory == null) {
            FileSnapshotService fileSnapshotService = this;
            synchronized (fileSnapshotService) {
                cachedSnapshotDirectory = this.snapshotDirectory.get();
                if (cachedSnapshotDirectory == null) {
                    try {
                        String tempDir = System.getProperty("java.io.tmpdir");
                        Path snapshotDir = Paths.get(tempDir, "katalon", "snapshots");
                        if (!Files.exists(snapshotDir, new LinkOption[0])) {
                            Files.createDirectories(snapshotDir, new FileAttribute[0]);
                            logger.info("Created snapshot directory: {}", (Object)snapshotDir);
                        }
                        this.snapshotDirectory.set(snapshotDir);
                        cachedSnapshotDirectory = snapshotDir;
                    }
                    catch (Exception e) {
                        logger.error("Failed to initialize snapshot directory", (Throwable)e);
                        throw new RuntimeException("Failed to initialize snapshot directory", e);
                    }
                }
            }
        }
        return cachedSnapshotDirectory;
    }

    public Optional<String> captureSnapshot(String entityId, String entityType, Path filePath) throws Exception {
        if (filePath == null || !Files.exists(filePath, new LinkOption[0])) {
            return Optional.empty();
        }
        String content = Files.readString(filePath, StandardCharsets.UTF_8);
        return Optional.ofNullable(this.createSnapshot(entityId, entityType, filePath.toString(), content));
    }

    public String createSnapshot(String entityId, String entityType, String filePath, String content) throws Exception {
        if (entityId == null || entityId.trim().isEmpty()) {
            throw new IllegalArgumentException("Entity ID cannot be null or empty");
        }
        if (entityType == null || entityType.trim().isEmpty()) {
            throw new IllegalArgumentException("Entity type cannot be null or empty");
        }
        if (filePath == null || filePath.trim().isEmpty()) {
            throw new IllegalArgumentException("File path cannot be null or empty");
        }
        if (content == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
        String snapshotId = UUID.randomUUID().toString();
        try {
            Path entityDirectory = this.getEntityDirectory(entityId);
            if (!Files.exists(entityDirectory, new LinkOption[0])) {
                Files.createDirectories(entityDirectory, new FileAttribute[0]);
            }
            String fileName = this.buildSnapshotFileName(snapshotId);
            Path snapshotFile = entityDirectory.resolve(fileName);
            FileUtils.writeStringToFile((File)snapshotFile.toFile(), (String)content, (Charset)StandardCharsets.UTF_8);
            logger.info("Created snapshot {} for entity {} (type: {})", new Object[]{snapshotFile, entityId, entityType});
            return snapshotFile.toAbsolutePath().toString();
        }
        catch (IOException e) {
            logger.error("Failed to create snapshot for entity {}", (Object)entityId, (Object)e);
            throw new Exception("Failed to create snapshot: " + e.getMessage(), e);
        }
    }

    public String readSnapshot(String snapshotId) throws Exception {
        if (snapshotId == null || snapshotId.trim().isEmpty()) {
            throw new IllegalArgumentException("Snapshot ID cannot be null or empty");
        }
        Path snapshotFile = this.resolveSnapshotPath(snapshotId);
        if (snapshotFile == null || !Files.exists(snapshotFile, new LinkOption[0])) {
            throw new Exception("Snapshot not found: " + snapshotId);
        }
        try {
            String content = FileUtils.readFileToString((File)snapshotFile.toFile(), (Charset)StandardCharsets.UTF_8);
            logger.info("Read snapshot {}", (Object)snapshotId);
            return content;
        }
        catch (IOException e) {
            logger.error("Failed to read snapshot {}", (Object)snapshotId, (Object)e);
            throw new Exception("Failed to read snapshot: " + e.getMessage(), e);
        }
    }

    public void restoreSnapshot(String snapshotId, String targetPath) throws Exception {
        if (snapshotId == null || snapshotId.trim().isEmpty()) {
            throw new IllegalArgumentException("Snapshot ID cannot be null or empty");
        }
        if (targetPath == null || targetPath.trim().isEmpty()) {
            throw new IllegalArgumentException("Target path cannot be null or empty");
        }
        String content = this.readSnapshot(snapshotId);
        try {
            try {
                File targetFile = new File(targetPath);
                FileUtils.writeStringToFile((File)targetFile, (String)content, (Charset)StandardCharsets.UTF_8);
                logger.info("Restored snapshot {} to {}", (Object)snapshotId, (Object)targetPath);
            }
            catch (IOException e) {
                logger.error("Failed to restore snapshot {} to {}", new Object[]{snapshotId, targetPath, e});
                throw new Exception("Failed to restore snapshot: " + e.getMessage(), e);
            }
        }
        finally {
            this.eventBroker.post("EXPLORER/REFRESH_ALL_ITEMS", null);
        }
    }

    public void deleteSnapshot(String snapshotId) throws Exception {
        if (snapshotId == null || snapshotId.trim().isEmpty()) {
            throw new IllegalArgumentException("Snapshot ID cannot be null or empty");
        }
        try {
            Path snapshotFile = this.resolveSnapshotPath(snapshotId);
            boolean deleted = false;
            if (snapshotFile != null && Files.exists(snapshotFile, new LinkOption[0])) {
                Files.delete(snapshotFile);
                deleted = true;
            }
            if (snapshotFile != null) {
                this.cleanupParentDirectories(snapshotFile.getParent());
            }
            if (deleted) {
                logger.info("Deleted snapshot {}", (Object)snapshotId);
            } else {
                logger.info("Snapshot not found for deletion: {}", (Object)snapshotId);
            }
        }
        catch (IOException e) {
            logger.error("Failed to delete snapshot {}", (Object)snapshotId, (Object)e);
            throw new Exception("Failed to delete snapshot: " + e.getMessage(), e);
        }
    }

    private Path getEntityDirectory(String entityId) {
        String encoded = Base64.getUrlEncoder().withoutPadding().encodeToString(entityId.getBytes(StandardCharsets.UTF_8));
        return this.getSnapshotDirectory().resolve(encoded);
    }

    private Path resolveSnapshotPath(String snapshotId) throws IOException {
        if (StringUtils.isBlank((CharSequence)snapshotId)) {
            return null;
        }
        Path snapshotPath = Paths.get(snapshotId, new String[0]);
        if (Files.exists(snapshotPath, new LinkOption[0])) {
            return snapshotPath;
        }
        if (!snapshotPath.isAbsolute() && Files.exists(snapshotPath = this.getSnapshotDirectory().resolve(snapshotPath).normalize(), new LinkOption[0])) {
            return snapshotPath;
        }
        String expectedName = snapshotId + SNAPSHOT_EXTENSION;
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<Path> files = Files.walk(this.getSnapshotDirectory(), new FileVisitOption[0]);){
            return files.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> expectedName.equals(path.getFileName().toString())).findFirst().orElse(null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String buildSnapshotFileName(String snapshotId) {
        long timestamp = Instant.now().toEpochMilli();
        return timestamp + "-" + snapshotId + SNAPSHOT_EXTENSION;
    }

    private void cleanupParentDirectories(Path directory) {
        block13: {
            if (directory == null || directory.equals(this.getSnapshotDirectory())) {
                return;
            }
            try {
                if (!Files.isDirectory(directory, new LinkOption[0])) break block13;
                Throwable throwable = null;
                Object var3_5 = null;
                try (Stream<Path> children = Files.list(directory);){
                    if (children.findAny().isEmpty()) {
                        Files.delete(directory);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                logger.debug("Failed to cleanup directory {}", (Object)directory, (Object)e);
            }
        }
    }
}

