/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services.internal;

import com.kms.katalon.ai.core.constant.MessageConstants;
import com.kms.katalon.ai.core.constant.StudioAssistChatViolationTypeEnum;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.ToolCallMessage;
import com.kms.katalon.ai.core.model.agent.ToolCallStatus;
import com.kms.katalon.ai.core.model.chat.ChatConversationAnswerWarning;
import com.kms.katalon.ai.core.model.chat.ChatQuestionMessage;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAnswerMessage;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiRuntimeException;
import com.kms.katalon.ai.core.model.llm.AssistantMessage;
import com.kms.katalon.ai.core.model.llm.CompletionOptions;
import com.kms.katalon.ai.core.model.llm.LlmMessage;
import com.kms.katalon.ai.core.model.llm.ToolCall;
import com.kms.katalon.ai.core.services.ILlmService;
import com.kms.katalon.ai.core.services.ILlmServiceFactory;
import com.kms.katalon.ai.core.services.IStudioAssistController;
import com.kms.katalon.ai.core.services.internal.IChatAnswerLlmService;
import com.kms.katalon.ai.core.util.ToolUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistChatAnswerService
implements IChatAnswerLlmService {
    private static final Logger logger = LoggerFactory.getLogger(StudioAssistChatAnswerService.class);
    private static final int TOOL_NAME_MAX_LENGTH = 64;
    private static final int DEFAULT_TIMEOUT_SECONDS = 120;
    private final ChatQuestionMessage question;
    private final List<LlmMessage> messages;
    private final Map<String, List<McpSchema.Tool>> availableTools;
    private volatile boolean cancelled = false;
    private volatile CompletableFuture<ResponseMessage> currentFuture;
    @Inject
    private ILlmServiceFactory llmServiceFactory;
    @Inject
    private IStudioAssistController studioAssistController;

    public StudioAssistChatAnswerService(List<LlmMessage> messages, ChatQuestionMessage question, Map<String, List<McpSchema.Tool>> availableTools) {
        this.messages = messages;
        this.question = question;
        this.availableTools = Objects.requireNonNullElseGet(availableTools, Map::of);
    }

    public CompletableFuture<ResponseMessage> executeAsync() {
        this.currentFuture = CompletableFuture.supplyAsync(() -> {
            try {
                StudioAssistConfig config = this.studioAssistController.getConfig();
                ILlmService llmService = this.llmServiceFactory.createLlmService(config);
                CompletionOptions.Builder completionOptionsBuilder = CompletionOptions.builder().tools(this.getLlmTools());
                if (config.getType() == LlmConfigType.GEMINI) {
                    completionOptionsBuilder.responseSchema("{\"type\":\"object\",\"properties\":{\"finalAnswer\":{\"anyOf\":[{\"type\":\"null\"},{\"type\":\"string\"}],\"additionalProperties\":false,\"description\":\"The answer to the user's request, use the Markdown format to style or layout the content. Extra notes:\\n- In the fenced code, specify the language block if possible\\n- In the link, specify the title if possible\\n- In the list, use the unordered list if no explicit order is the request\\n\"},\"warning\":{\"anyOf\":[{\"type\":\"null\"},{\"type\":\"object\",\"properties\":{\"explanation\":{\"anyOf\":[{\"type\":\"null\"},{\"type\":\"string\"}],\"additionalProperties\":false,\"description\":\"Explain the warning in detail, use the Markdown format to style or layout the content\"},\"shortSummary\":{\"anyOf\":[{\"type\":\"null\"},{\"type\":\"string\"}],\"additionalProperties\":false,\"description\":\"A short summary to indicate the warning type\"}},\"description\":\"Warning information structure\",\"additionalProperties\":false}],\"description\":\"The warning information about safety violation from the user's request that can't present in the answer\"},\"suggestedQuestions\":{\"anyOf\":[{\"type\":\"null\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"},\"description\":\"A list of helpful questions the user may want to ask next based on the current answer\"}],\"description\":\"Suggestions for follow-up questions the user can ask next\"}},\"description\":\"Response structure for the user's request\",\"additionalProperties\":false,\"required\":[]}");
                } else {
                    completionOptionsBuilder.responseSchema("{\"type\":\"json_schema\",\"json_schema\":{\"name\":\"response-message-schema\",\"strict\":false,\"schema\":{\"type\":\"object\",\"properties\":{\"finalAnswer\":{\"anyOf\":[{\"type\":\"null\"},{\"type\":\"string\"}],\"additionalProperties\":false,\"description\":\"The answer to the user's request, use the Markdown format to style or layout the content. Extra notes:\\n- In the fenced code, specify the language block if possible\\n- In the link, specify the title if possible\\n- In the list, use the unordered list if no explicit order is the request\\n\"},\"warning\":{\"anyOf\":[{\"type\":\"null\"},{\"type\":\"object\",\"properties\":{\"explanation\":{\"anyOf\":[{\"type\":\"null\"},{\"type\":\"string\"}],\"additionalProperties\":false,\"description\":\"Explain the warning in detail, use the Markdown format to style or layout the content\"},\"shortSummary\":{\"anyOf\":[{\"type\":\"null\"},{\"type\":\"string\"}],\"additionalProperties\":false,\"description\":\"A short summary to indicate the warning type\"}},\"description\":\"Warning information structure\",\"additionalProperties\":false}],\"description\":\"The warning information about safety violation from the user's request that can't present in the answer\"},\"suggestedQuestions\":{\"anyOf\":[{\"type\":\"null\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"},\"description\":\"A list of helpful questions the user may want to ask next based on the current answer\"}],\"description\":\"Suggestions for follow-up questions the user can ask next\"}},\"description\":\"Response structure for the user's request\",\"additionalProperties\":false,\"required\":[]}}}");
                }
                CompletionOptions completionOptions = completionOptionsBuilder.build();
                AssistantMessage assistantMessage = llmService.getChatCompletions(this.messages, completionOptions);
                return this.mapFromAssistantMessage(assistantMessage);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new StudioAssistLlmApiRuntimeException(e.getMessage(), (Throwable)e);
            }
        }).orTimeout(120L, TimeUnit.SECONDS);
        return this.currentFuture;
    }

    public void cancel() {
        logger.info("Cancelling execution | messageId: {}", (Object)this.getMessageId());
        this.cancelled = true;
        if (this.currentFuture != null && !this.currentFuture.isDone()) {
            this.currentFuture.cancel(true);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    protected List<McpSchema.Tool> getLlmTools() {
        return this.availableTools.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().filter(tool -> ToolUtil.formatLlmToolName((String)((String)entry.getKey()), (String)tool.name()).length() <= 64).map(tool -> McpSchema.Tool.builder().name(ToolUtil.formatLlmToolName((String)((String)entry.getKey()), (String)tool.name())).description(tool.description()).inputSchema(tool.inputSchema()).outputSchema(tool.outputSchema()).build())).toList();
    }

    public String getMessageId() {
        return this.question == null ? "" : this.question.getMessageId();
    }

    protected ResponseMessage mapFromAssistantMessage(AssistantMessage assistantMessage) {
        String assistantAnswer = assistantMessage.getContent();
        if (StringUtils.isNotEmpty((CharSequence)assistantAnswer)) {
            StudioAssistChatAnswerMessage answer = new StudioAssistChatAnswerMessage();
            try {
                StudioAssistChatAnswerMessage chatAnswerMessage = (StudioAssistChatAnswerMessage)JsonUtil.fromJson((String)assistantAnswer, StudioAssistChatAnswerMessage.class);
                if (StringUtils.isNotEmpty((CharSequence)chatAnswerMessage.getFinalAnswer())) {
                    answer.setFinalAnswer(chatAnswerMessage.getFinalAnswer());
                } else {
                    answer.setFinalAnswer(MessageConstants.STUDIO_ASSIST_INLINE_SCOPE_VIOLATION_ERROR_MSG);
                    ChatConversationAnswerWarning warning = new ChatConversationAnswerWarning();
                    warning.setShortSummary(StudioAssistChatViolationTypeEnum.NOT_KATALON);
                    warning.setExplanation(MessageConstants.STUDIO_ASSIST_INLINE_SCOPE_VIOLATION_ERROR_MSG);
                    answer.setWarning(warning);
                }
                answer.setMessageId(this.getMessageId());
                answer.setSuggestedQuestions(chatAnswerMessage.getSuggestedQuestions());
            }
            catch (Exception exception) {
                answer.setFinalAnswer(assistantAnswer);
                answer.setMessageId(this.getMessageId());
            }
            return answer;
        }
        List<ResponseMessage> toolCalls = assistantMessage.getToolCalls().stream().map(this::mapToToolCallMessage).filter(Objects::nonNull).map(toolCallMessage -> toolCallMessage).toList();
        AgentMessage agentMessage = new AgentMessage(this.getMessageId());
        agentMessage.setChildren(toolCalls);
        return agentMessage;
    }

    protected ToolCallMessage mapToToolCallMessage(ToolCall toolCall) {
        String toolName;
        String toolCallName = toolCall.getName();
        String serverName = ToolUtil.parseServerNameFromToolCall((String)toolCallName);
        McpSchema.Tool foundTool = this.getToolFromServerNameAndToolName(serverName, toolName = ToolUtil.parseToolNameFromToolCall((String)toolCallName));
        if (foundTool == null) {
            logger.debug("Tool not found for tool call name: {} ", (Object)toolCallName);
            return null;
        }
        ToolCallMessage tool = new ToolCallMessage(foundTool);
        tool.setCallId(toolCall.getCallId());
        tool.setServer(serverName);
        tool.setStatus(ToolCallStatus.REQUESTED);
        tool.setInput(toolCall.getInput());
        return tool;
    }

    protected McpSchema.Tool getToolFromServerNameAndToolName(String mcpServerName, String toolName) {
        return this.availableTools.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(mcpServerName)).flatMap(entry -> ((List)entry.getValue()).stream()).filter(tool -> toolName.equals(tool.name())).findFirst().orElse(null);
    }
}

