/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.tool;

import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.AgentSession;
import com.kms.katalon.ai.core.model.agent.EntityModification;
import com.kms.katalon.ai.core.model.agent.ToolCallMessage;
import com.kms.katalon.ai.core.registry.ToolDefinition;
import com.kms.katalon.ai.core.registry.ToolProcessingAction;
import com.kms.katalon.ai.core.registry.ToolRegistry;
import com.kms.katalon.ai.core.services.IEntityModificationService;
import com.kms.katalon.ai.core.services.IToolManager;
import jakarta.inject.Inject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class ToolManager
implements IToolManager {
    private static final Logger logger = LoggerFactory.getLogger(ToolManager.class);
    private final ConcurrentMap<ToolCallMessage, EntityModification> pendingModifications = new ConcurrentHashMap<ToolCallMessage, EntityModification>();
    @Inject
    private ToolRegistry toolRegistry;
    @Inject
    private IEntityModificationService entityModificationService;

    public void onToolExecutionStarting(AgentSession session, AgentMessage agentMessage, ToolCallMessage toolCallMessage) {
        if (toolCallMessage == null) {
            return;
        }
        ToolDefinition definition = this.toolRegistry.find(toolCallMessage.getName()).orElse(null);
        if (definition == null) {
            return;
        }
        if (definition.getActions().contains(ToolProcessingAction.CAPTURE_SNAPSHOT) && this.entityModificationService != null) {
            this.entityModificationService.prepareModificationSnapshot(session, toolCallMessage).ifPresentOrElse(modification -> {
                EntityModification entityModification = this.pendingModifications.put(toolCallMessage, (EntityModification)modification);
            }, () -> logger.warn("[ToolManager] Snapshot preparation failed for tool {}", (Object)definition.getToolName()));
        }
    }

    public void onToolExecutionFinished(AgentSession session, AgentMessage agentMessage, ToolCallMessage toolCallMessage, String rawOutput, boolean isError) {
        EntityModification modification;
        EntityModification entityModification = modification = toolCallMessage != null ? (EntityModification)this.pendingModifications.remove(toolCallMessage) : null;
        if (toolCallMessage == null || isError) {
            return;
        }
        ToolDefinition definition = this.toolRegistry.find(toolCallMessage.getName()).orElse(null);
        if (definition == null) {
            return;
        }
        try {
            if (definition.getActions().contains(ToolProcessingAction.TRACK_MODIFICATION) && modification != null) {
                boolean computeDiffStats = definition.isDiffComputationEnabled();
                boolean compareMetadata = definition.isCompareMetadata();
                this.entityModificationService.persistEntityModification(session, agentMessage, modification, computeDiffStats, compareMetadata);
            } else {
                this.entityModificationService.recordEntityModification(session, agentMessage, toolCallMessage, rawOutput);
            }
        }
        catch (Exception e) {
            logger.error("[ToolManager] Failed to process modification for tool {}", (Object)definition.getToolName(), (Object)e);
        }
    }
}

