/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.util;

import com.kms.katalon.ai.core.model.llm.ImageFormat;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageAttachmentUtil {
    private static final Logger logger = LoggerFactory.getLogger(ImageAttachmentUtil.class);

    public static String toBase64String(String filePath) {
        if (filePath == null) {
            return "";
        }
        try {
            File image = new File(filePath);
            byte[] imageBytes = Files.readAllBytes(image.toPath());
            return Base64.getEncoder().encodeToString(imageBytes);
        }
        catch (IOException exception) {
            logger.error("Failed to read image file content for attachment", (Throwable)exception);
            return "";
        }
    }

    public static boolean isImageFile(String filePath) {
        String extension = ImageAttachmentUtil.getFileExtension(filePath);
        return ImageFormat.fromExtension((String)extension) != null;
    }

    public static ImageFormat getImageFormat(String filePath) {
        return ImageFormat.fromExtension((String)ImageAttachmentUtil.getFileExtension(filePath));
    }

    private static String getFileExtension(String filePath) {
        Path path = Paths.get(filePath, new String[0]).normalize();
        if (path.toString().contains("..")) {
            throw new SecurityException("Invalid file path detected");
        }
        String fileName = path.getFileName().toString().toLowerCase();
        int lastDot = fileName.lastIndexOf(46);
        return lastDot > 0 ? fileName.substring(lastDot + 1) : "";
    }
}

