/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.plugin.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.activation.plugin.constant.ActivationMessageConstants;
import com.kms.katalon.activation.plugin.models.KStoreClientException;
import com.kms.katalon.activation.plugin.models.KStoreClientExceptionWithInfo;
import com.kms.katalon.activation.plugin.models.KStoreCredentials;
import com.kms.katalon.activation.plugin.models.KStorePlugin;
import com.kms.katalon.activation.plugin.models.KStoreProduct;
import com.kms.katalon.activation.plugin.models.KStoreProductID;
import com.kms.katalon.activation.plugin.service.KStorePluginDeserialization;
import com.kms.katalon.activation.plugin.service.LogService;
import com.kms.katalon.activation.plugin.util.KStoreUrls;
import com.kms.katalon.core.model.KatalonPackage;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.eclipse.service.EclipseNetworkPreferences;
import com.kms.katalon.session.core.model.LicenseType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.program.Program;

public class KStoreRestClient {
    private KStoreCredentials credentials;
    ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    IHttpClient httpClient = ApacheHttpClient.getInstance();
    INetworkPreferences networkPreferences = EclipseNetworkPreferences.getInstance();

    public KStoreRestClient(KStoreCredentials credentials) {
        this.credentials = credentials;
    }

    public List<KStorePlugin> getLatestPlugins(String appVersion, KatalonPackage katalonPackage, LicenseType licenseType) throws KStoreClientExceptionWithInfo {
        AtomicReference plugins = new AtomicReference();
        String url = KStoreUrls.getPluginsAPIUrl(appVersion, katalonPackage, licenseType);
        try {
            this.executeGetRequest(url, this.credentials, response -> {
                try {
                    if (StringUtils.isBlank((CharSequence)response)) {
                        throw new KStoreClientException("Failed to get latest plugin. No content returned from server.");
                    }
                    LogUtil.writeOutputLine((String)("Latest plugins response: " + response));
                    response = response.replace("{}", "null");
                    LogService.getInstance().logInfo("Katalon version: " + appVersion);
                    LogService.getInstance().logInfo("Plugin info URL: " + url);
                    plugins.set(this.parsePluginListJson(response));
                }
                catch (Exception e) {
                    this.propagateIfInstanceOf(e, KStoreClientException.class);
                    throw new KStoreClientException("Unexpected error occurs during executing get latest plugins", e);
                }
            });
        }
        catch (Exception e) {
            if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)ActivationMessageConstants.KStore_ERROR_INVALID_CREDENTAILS)) {
                throw new KStoreClientExceptionWithInfo(e.getMessage(), this.credentials, url);
            }
            this.propagateIfInstanceOf(e, KStoreClientExceptionWithInfo.class);
            throw new KStoreClientExceptionWithInfo("Unexpected error occurs during executing get latest plugins", this.credentials, url, e);
        }
        return (List)plugins.get();
    }

    public List<KStoreProduct> getRecommendPlugins() throws KStoreClientException {
        AtomicReference products = new AtomicReference();
        try {
            this.executeGetRequest(KStoreUrls.getRecommendedPluginsAPIUrl(), this.credentials, response -> {
                try {
                    if (StringUtils.isBlank((CharSequence)response)) {
                        throw new KStoreClientException("Failed to get recommended plugin. No content returned from server.");
                    }
                    LogService.getInstance().logInfo("Recommended plugins response: " + response);
                    response = response.replace("{}", "null");
                    products.set(this.parseProductListJson(response));
                }
                catch (Exception e) {
                    this.propagateIfInstanceOf(e, KStoreClientException.class);
                    throw new KStoreClientException("Unexpected error occurs during executing get recommended plugins", e);
                }
            });
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during executing get recommended plugins", e);
        }
        return (List)products.get();
    }

    private List<KStorePlugin> parsePluginListJson(String json) throws ParseException {
        Gson gson = new GsonBuilder().registerTypeAdapter(KStorePlugin.class, (Object)new KStorePluginDeserialization()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Type listType = new TypeToken<List<KStorePlugin>>(){}.getType();
        return (List)gson.fromJson(json, listType);
    }

    private List<KStoreProduct> parseProductListJson(String json) throws ParseException {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Type listType = new TypeToken<List<KStoreProduct>>(){}.getType();
        return (List)gson.fromJson(json, listType);
    }

    public void downloadPlugin(KStorePlugin plugin, File downloadFile) throws KStoreClientException {
        URI uri = null;
        try {
            uri = new URI(KStoreUrls.getPluginDownloadAPIUrl(plugin));
        }
        catch (URISyntaxException e) {
            throw new KStoreClientException(e.getMessage());
        }
        HashMap headers = new HashMap();
        this.credentials.getAuthHeaders().entrySet().stream().forEach(entry -> {
            String string = headers.put((String)entry.getKey(), (String)entry.getValue());
        });
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        FileOutputStream outstream = null;
        try {
            outstream = new FileOutputStream(downloadFile);
        }
        catch (FileNotFoundException e) {
            throw new KStoreClientException(e.getMessage());
        }
        try {
            this.httpClient.download(uri, (OutputStream)outstream, httpOptions, null);
        }
        catch (HttpException e) {
            throw new KStoreClientException(e.getMessage());
        }
    }

    public AuthenticationResult authenticate() throws KStoreClientException {
        URI uri = null;
        try {
            uri = new URI(KStoreUrls.getAuthenticateAPIUrl());
        }
        catch (URISyntaxException e) {
            throw new KStoreClientException(e.getMessage());
        }
        HashMap headers = new HashMap();
        this.credentials.getAuthHeaders().entrySet().stream().forEach(entry -> {
            String string = headers.put((String)entry.getKey(), (String)entry.getValue());
        });
        String content = this.credentials.toJSON();
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.jsonPost(uri, content, httpOptions);
        }
        catch (HttpException e) {
            throw new KStoreClientException(e.getMessage());
        }
        int statusCode = response.getStatusCode();
        if (statusCode == 200) {
            AuthenticationResult result = new AuthenticationResult();
            result.setAuthenticated(true);
            String token = response.getBody();
            result.setToken(token);
            return result;
        }
        throw new KStoreClientException(String.format("Invalid Request. Status Code: %d. Message: %s", response.getStatusCode(), response.getBody()));
    }

    public void postRecommended(List<Long> productsID) throws KStoreClientException {
        URI uri = null;
        try {
            uri = new URI(KStoreUrls.getInstallRecommendedPluginsAPIUrl());
        }
        catch (URISyntaxException e) {
            throw new KStoreClientException(e.getMessage());
        }
        HashMap headers = new HashMap();
        this.credentials.getAuthHeaders().entrySet().stream().forEach(entry -> {
            String string = headers.put((String)entry.getKey(), (String)entry.getValue());
        });
        KStoreProductID ksProductId = new KStoreProductID(productsID);
        String content = null;
        try {
            content = this.objectMapper.writeValueAsString((Object)ksProductId);
        }
        catch (JsonProcessingException e) {
            throw new KStoreClientException(e.getMessage());
        }
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.jsonPost(uri, content, httpOptions);
        }
        catch (HttpException e) {
            throw new KStoreClientException(e.getMessage());
        }
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            throw new KStoreClientException(String.format("Invalid Request. Status Code: %d. Message: %s", response.getStatusCode(), response.getBody()));
        }
        LogUtil.logInfo((String)"Successful");
    }

    public void goToManagePluginsPage() throws KStoreClientException {
        try {
            Program.launch((String)KStoreUrls.getManagePluginPageUrl());
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Manage Plugins page", e);
        }
    }

    public void goToManageApiKeysPage() throws KStoreClientException {
        try {
            Program.launch((String)KStoreUrls.getManageApiKeysPageUrl());
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Manage API Keys page", e);
        }
    }

    public void goToProductPage(KStoreProduct product) throws KStoreClientException {
        try {
            Program.launch((String)KStoreUrls.getProductPageUrl(product));
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Manage Plugins page", e);
        }
    }

    public void goToProductReviewPage(KStoreProduct product) throws KStoreClientException {
        try {
            Program.launch((String)KStoreUrls.getProductReviewPageUrl(product));
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Manage Plugins page", e);
        }
    }

    public void goToProductPricingPage(KStoreProduct product) throws KStoreClientException {
        try {
            Program.launch((String)KStoreUrls.getProductPricingPageUrl(product));
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Manage Plugins page", e);
        }
    }

    private void executeGetRequest(String url, KStoreCredentials credentials, OnRequestSuccessHandler requestSuccessHandler) throws URISyntaxException, IOException, GeneralSecurityException, KStoreClientException {
        HttpResponse response;
        URI uri = new URI(url);
        HashMap headers = new HashMap();
        credentials.getAuthHeaders().entrySet().stream().forEach(entry -> {
            String string = headers.put((String)entry.getKey(), (String)entry.getValue());
        });
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new KStoreClientException(e.getMessage());
        }
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            if (statusCode == 401) {
                throw new KStoreClientException(ActivationMessageConstants.KStore_ERROR_INVALID_CREDENTAILS);
            }
            throw new KStoreClientException(String.format("Invalid Request. Status Code: %d. Message: %s", statusCode, response.getBody()));
        }
        requestSuccessHandler.handleRequestSuccess(response.getBody());
    }

    private <X extends Throwable> void propagateIfInstanceOf(Throwable throwable, Class<X> declaredType) throws X {
        if (throwable != null && declaredType.isInstance(throwable)) {
            throw (Throwable)declaredType.cast(throwable);
        }
    }

    public class AuthenticationResult {
        private boolean isAuthenticated;
        private String token;

        public boolean isAuthenticated() {
            return this.isAuthenticated;
        }

        public void setAuthenticated(boolean isAuthenticated) {
            this.isAuthenticated = isAuthenticated;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }
    }

    private static interface OnRequestSuccessHandler {
        public void handleRequestSuccess(String var1) throws KStoreClientException;
    }
}

