/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.ExecutionInput;
import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.execution.CoercedVariables;
import graphql.execution.DataLoaderDispatchStrategy;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStrategy;
import graphql.execution.ValueUnboxer;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLSchema;
import java.util.Locale;
import java.util.Map;
import org.dataloader.DataLoaderRegistry;

@PublicApi
public class ExecutionContextBuilder {
    Instrumentation instrumentation;
    ExecutionId executionId;
    InstrumentationState instrumentationState;
    GraphQLSchema graphQLSchema;
    ExecutionStrategy queryStrategy;
    ExecutionStrategy mutationStrategy;
    ExecutionStrategy subscriptionStrategy;
    Object context;
    GraphQLContext graphQLContext;
    Object root;
    Document document;
    OperationDefinition operationDefinition;
    CoercedVariables coercedVariables = CoercedVariables.emptyVariables();
    ImmutableMap<String, FragmentDefinition> fragmentsByName = ImmutableKit.emptyMap();
    DataLoaderRegistry dataLoaderRegistry;
    Locale locale;
    ImmutableList<GraphQLError> errors = ImmutableKit.emptyList();
    ValueUnboxer valueUnboxer;
    Object localContext;
    ExecutionInput executionInput;
    DataLoaderDispatchStrategy dataLoaderDispatcherStrategy = DataLoaderDispatchStrategy.NO_OP;

    public static ExecutionContextBuilder newExecutionContextBuilder() {
        return new ExecutionContextBuilder();
    }

    public static ExecutionContextBuilder newExecutionContextBuilder(ExecutionContext other) {
        return new ExecutionContextBuilder(other);
    }

    @Internal
    public ExecutionContextBuilder() {
    }

    @Internal
    ExecutionContextBuilder(ExecutionContext other) {
        this.instrumentation = other.getInstrumentation();
        this.executionId = other.getExecutionId();
        this.instrumentationState = other.getInstrumentationState();
        this.graphQLSchema = other.getGraphQLSchema();
        this.queryStrategy = other.getQueryStrategy();
        this.mutationStrategy = other.getMutationStrategy();
        this.subscriptionStrategy = other.getSubscriptionStrategy();
        this.context = other.getContext();
        this.graphQLContext = other.getGraphQLContext();
        this.localContext = other.getLocalContext();
        this.root = other.getRoot();
        this.document = other.getDocument();
        this.operationDefinition = other.getOperationDefinition();
        this.coercedVariables = other.getCoercedVariables();
        this.fragmentsByName = ImmutableMap.copyOf(other.getFragmentsByName());
        this.dataLoaderRegistry = other.getDataLoaderRegistry();
        this.locale = other.getLocale();
        this.errors = ImmutableList.copyOf(other.getErrors());
        this.valueUnboxer = other.getValueUnboxer();
        this.executionInput = other.getExecutionInput();
        this.dataLoaderDispatcherStrategy = other.getDataLoaderDispatcherStrategy();
    }

    public ExecutionContextBuilder instrumentation(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        return this;
    }

    public ExecutionContextBuilder instrumentationState(InstrumentationState instrumentationState) {
        this.instrumentationState = instrumentationState;
        return this;
    }

    public ExecutionContextBuilder executionId(ExecutionId executionId) {
        this.executionId = executionId;
        return this;
    }

    public ExecutionContextBuilder graphQLSchema(GraphQLSchema graphQLSchema) {
        this.graphQLSchema = graphQLSchema;
        return this;
    }

    public ExecutionContextBuilder queryStrategy(ExecutionStrategy queryStrategy) {
        this.queryStrategy = queryStrategy;
        return this;
    }

    public ExecutionContextBuilder mutationStrategy(ExecutionStrategy mutationStrategy) {
        this.mutationStrategy = mutationStrategy;
        return this;
    }

    public ExecutionContextBuilder subscriptionStrategy(ExecutionStrategy subscriptionStrategy) {
        this.subscriptionStrategy = subscriptionStrategy;
        return this;
    }

    @Deprecated(since="2021-07-05")
    public ExecutionContextBuilder context(Object context) {
        this.context = context;
        return this;
    }

    public ExecutionContextBuilder graphQLContext(GraphQLContext context) {
        this.graphQLContext = context;
        return this;
    }

    public ExecutionContextBuilder localContext(Object localContext) {
        this.localContext = localContext;
        return this;
    }

    public ExecutionContextBuilder root(Object root) {
        this.root = root;
        return this;
    }

    @Deprecated(since="2022-05-24")
    public ExecutionContextBuilder variables(Map<String, Object> variables) {
        this.coercedVariables = CoercedVariables.of(variables);
        return this;
    }

    public ExecutionContextBuilder coercedVariables(CoercedVariables coercedVariables) {
        this.coercedVariables = coercedVariables;
        return this;
    }

    public ExecutionContextBuilder fragmentsByName(Map<String, FragmentDefinition> fragmentsByName) {
        this.fragmentsByName = ImmutableMap.copyOf(fragmentsByName);
        return this;
    }

    public ExecutionContextBuilder document(Document document) {
        this.document = document;
        return this;
    }

    public ExecutionContextBuilder operationDefinition(OperationDefinition operationDefinition) {
        this.operationDefinition = operationDefinition;
        return this;
    }

    public ExecutionContextBuilder dataLoaderRegistry(DataLoaderRegistry dataLoaderRegistry) {
        this.dataLoaderRegistry = Assert.assertNotNull(dataLoaderRegistry);
        return this;
    }

    public ExecutionContextBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public ExecutionContextBuilder valueUnboxer(ValueUnboxer valueUnboxer) {
        this.valueUnboxer = valueUnboxer;
        return this;
    }

    public ExecutionContextBuilder executionInput(ExecutionInput executionInput) {
        this.executionInput = executionInput;
        return this;
    }

    @Internal
    public ExecutionContextBuilder dataLoaderDispatcherStrategy(DataLoaderDispatchStrategy dataLoaderDispatcherStrategy) {
        this.dataLoaderDispatcherStrategy = dataLoaderDispatcherStrategy;
        return this;
    }

    public ExecutionContextBuilder resetErrors() {
        this.errors = ImmutableKit.emptyList();
        return this;
    }

    public ExecutionContext build() {
        Assert.assertNotNull(this.executionId, () -> "You must provide a query identifier");
        return new ExecutionContext(this);
    }
}

