/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.filters;

import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testsuite.filters.AlreadyAddedTestCaseFilter;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class AlreadyAddedTestCaseViewerFilter
extends EntityViewerFilter {
    private boolean needToCheckAlreadyAddedTestCases = false;
    private AlreadyAddedTestCaseFilter alreadyAddedTestCaseFilter = new AlreadyAddedTestCaseFilter();
    private ITreeEntity[] treeEntities;

    public AlreadyAddedTestCaseViewerFilter(EntityProvider entityProvider, ITreeEntity[] treeEntities) {
        super(entityProvider);
        this.treeEntities = treeEntities;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ITreeEntity) {
            try {
                String entityId;
                if (this.needToCheckAlreadyAddedTestCases && this.alreadyAddedTestCaseFilter.isEntityAlreadyAddedToTestSuites(entityId = this.getEntityIdForDisplay((ITreeEntity)element))) {
                    return false;
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return super.select(viewer, parentElement, element);
    }

    private void setAlreadyAddedTestCasesCondition(boolean val) {
        this.needToCheckAlreadyAddedTestCases = val;
    }

    public void enableAlreadyAddedTestCases() {
        this.setAlreadyAddedTestCasesCondition(true);
        if (!this.alreadyAddedTestCaseFilter.isResultNotEmpty()) {
            try {
                new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        AlreadyAddedTestCaseViewerFilter.this.initializeAlreadyAddedEntitiesCache(monitor);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e1) {
                LoggerSingleton.logError((Throwable)e1);
            }
        }
    }

    public void disableAlreadyAddedTestCases() {
        this.setAlreadyAddedTestCasesCondition(false);
    }

    private void initializeAlreadyAddedEntitiesCache(IProgressMonitor monitor) {
        monitor.beginTask("Check if entities are added to any Test Suite", this.treeEntities.length);
        this.alreadyAddedTestCaseFilter.filterElements(this.treeEntities, monitor);
        monitor.done();
    }

    private String getEntityIdForDisplay(ITreeEntity entity) throws Exception {
        FolderEntity folderEntity;
        String entityId = "";
        if (entity instanceof FolderTreeEntity && (folderEntity = ((FolderTreeEntity)entity).getObject()).getFolderType() == FolderEntity.FolderType.TESTCASE) {
            entityId = folderEntity.getIdForDisplay();
        }
        if (entity instanceof TestCaseTreeEntity) {
            TestCaseEntity tcEntity = ((TestCaseTreeEntity)entity).getObject();
            entityId = tcEntity.getIdForDisplay();
        }
        return entityId;
    }

    public boolean isEntityAlreadyAdded(String entityId) {
        return this.alreadyAddedTestCaseFilter.isEntityAlreadyAddedToTestSuites(entityId);
    }
}

