/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.parts;

import com.equo.chromium.swt.Browser;
import com.katalon.composer.core.webview.browserfunction.BrowserFunctionBridge;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.core.event.EventEmitter;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.helper.UIEventController;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.webserver.WebViewController;
import com.kms.katalon.webserver.handlers.KatalonActionRpcHandler;
import com.kms.katalon.webserver.handlers.KatalonInfoRpcHandler;
import com.kms.katalon.webserver.handlers.TestOpsProjectInfoRpcHandler;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class TestSuiteAnalyticsPart {
    private Composite mainComposite;
    private TestSuiteEntity testSuite;
    private Browser browser;
    private EventEmitter.EventSubscriber settingsChangeSubscriber;
    @Inject
    private ITestOpsController testOpsController;
    @Inject
    private IDiscoveryController discoveryController;
    @Inject
    private ISessionController sessionController;

    public void setTestSuite(TestSuiteEntity testSuite) {
        this.testSuite = testSuite;
        this.browser.setUrl(this.getUrlForTestSuiteAnalytics());
    }

    @PostConstruct
    public void init(Composite parent) {
        this.createControls(parent);
        this.settingsChangeSubscriber = UIEventController.getInstance().onSettingsChange(page -> {
            if (page != UIEventController.SettingPage.TESTOPS) {
                return;
            }
            try {
                this.browser.refresh();
            }
            catch (Exception error) {
                LoggerSingleton.logError((Throwable)error);
            }
        });
    }

    @PreDestroy
    public void destroy() {
        EventEmitter.safeUnsubscribe((EventEmitter.EventSubscriber)this.settingsChangeSubscriber);
    }

    private void createControls(Composite parent) {
        if (!ControlUtil.isDisposed((Widget)this.mainComposite) && this.mainComposite != null) {
            this.mainComposite.dispose();
        }
        this.mainComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent).build();
        this.browser = (Browser)ComponentBuilder.browser((Composite)this.mainComposite).defaultBrowserConfig().fill().build();
        final BrowserFunctionBridge browserFunctionBridge = new BrowserFunctionBridge();
        KatalonActionRpcHandler katalonActionRpcHandler = new KatalonActionRpcHandler();
        katalonActionRpcHandler.registerBrowserfunctions(browserFunctionBridge, this.browser);
        KatalonInfoRpcHandler katalonInfoRpcHandler = new KatalonInfoRpcHandler(this.sessionController, this.discoveryController);
        katalonInfoRpcHandler.registerBrowserfunctions(browserFunctionBridge, this.browser);
        TestOpsProjectInfoRpcHandler testOpsProjectInfoRpcHandler = new TestOpsProjectInfoRpcHandler(this.testOpsController);
        testOpsProjectInfoRpcHandler.registerBrowserfunctions(browserFunctionBridge, this.browser);
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                browserFunctionBridge.bind(TestSuiteAnalyticsPart.this.browser);
            }
        });
    }

    private String getUrlForTestSuiteAnalytics() {
        String testSuiteName = "";
        String testSuitePathWithoutName = "";
        if (this.testSuite != null) {
            String testSuitePath = this.testSuite.getIdForDisplay();
            testSuitePathWithoutName = testSuitePath.substring(0, testSuitePath.lastIndexOf("/"));
            testSuiteName = this.testSuite.getName();
        }
        return WebViewController.getInstance().getPage("TestSuiteAnalytics.html?testSuitePath=" + testSuitePathWithoutName + "&testSuiteName=" + testSuiteName);
    }
}

