/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.providers;

import com.kms.katalon.composer.components.impl.providers.CellLayoutInfo;
import com.kms.katalon.composer.components.impl.providers.DefaultCellLayoutInfo;
import com.kms.katalon.composer.components.impl.providers.MouseCursorColumnLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testsuite.integration.TestSuitePlatformAnalysis;
import com.kms.katalon.composer.testsuite.providers.TestCaseTableViewer;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.testops.core.model.AnalyticsTestCase;
import java.text.DecimalFormat;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class TestCaseActionColumnProvider
extends MouseCursorColumnLabelProvider<TestSuiteTestCaseLink> {
    private int charWidth;
    public static final int COLUMN_FLAKINESS_INDEX = 4;
    public static final int COLUMN_AVG_DURATION_INDEX = 6;
    private static final int DF_TABLE_CELL_MARGIN = 5;

    protected void paint(Event event, Object element) {
        super.paint(event, element);
        this.charWidth = (int)Math.max(1.0, event.gc.getFontMetrics().getAverageCharacterWidth());
    }

    protected boolean isPlacedMouseHover(ViewerCell cell) {
        return super.isPlacedMouseHover(cell) && StringUtils.isNotEmpty((String)cell.getText());
    }

    public TestCaseActionColumnProvider(int columnIndex) {
        super(columnIndex);
    }

    private TestCaseTableViewer getTestCaseTableViewer() {
        return (TestCaseTableViewer)this.getViewer();
    }

    private boolean displayRowValue(AnalyticsTestCase analyticsTestCase, TestSuiteTestCaseLink element) {
        TestSuiteTestCaseLink testCaseLink = element;
        Object allTestCaseLinks = this.getTestCaseTableViewer().getInput();
        return analyticsTestCase != null && allTestCaseLinks.indexOf(testCaseLink) < 30;
    }

    private AnalyticsTestCase getAnalyticsTestCase(TestSuiteTestCaseLink testCaseLink) {
        String testSuiteId = this.getTestCaseTableViewer().getTestSuite();
        String testCaseId = testCaseLink.getTestCaseId();
        return TestSuitePlatformAnalysis.getInstance().getAnalyticsTestCase(testSuiteId, testCaseId);
    }

    private static String formatTime(double time) {
        double totalMillis = time;
        double totalSeconds = totalMillis / 1000.0;
        double totalMinutes = totalSeconds / 60.0;
        int elapsedMillis = (int)(totalMillis % 1000.0);
        double elapsedSeconds = (double)((int)(totalSeconds % 60.0)) + (double)elapsedMillis / 1000.0;
        int elapsedMinutes = (int)(totalMinutes % 60.0);
        int elapsedHours = (int)(totalMinutes / 60.0);
        StringBuilder elapsedTimeBuilder = new StringBuilder();
        if (totalMillis < 1000.0) {
            elapsedTimeBuilder.append(new DecimalFormat("#0").format(totalMillis)).append("ms");
            return elapsedTimeBuilder.toString();
        }
        if (elapsedHours > 0) {
            elapsedTimeBuilder.append(Integer.toString(elapsedHours)).append("h ");
        }
        if (elapsedMinutes > 0) {
            elapsedTimeBuilder.append(Integer.toString(elapsedMinutes)).append("m ");
        }
        elapsedTimeBuilder.append(new DecimalFormat("#0").format(elapsedSeconds)).append("s");
        return elapsedTimeBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getText(TestSuiteTestCaseLink element) {
        String testSuiteId = this.getTestCaseTableViewer().getTestSuite();
        String testCaseId = element.getTestCaseId();
        AnalyticsTestCase analyticsTestCase = TestSuitePlatformAnalysis.getInstance().getAnalyticsTestCase(testSuiteId, testCaseId);
        try {
            switch (this.columnIndex) {
                case 4: {
                    if (!this.displayRowValue(analyticsTestCase, element)) {
                        return "--";
                    }
                    return String.format("%.2f", analyticsTestCase.getFlakiness() * 100.0);
                }
                case 6: {
                    if (!this.displayRowValue(analyticsTestCase, element)) {
                        return "--";
                    }
                    if (analyticsTestCase.getAverageDuration() == null) return "--";
                    if (!(analyticsTestCase.getAverageDuration() < 0.0)) return TestCaseActionColumnProvider.formatTime(analyticsTestCase.getAverageDuration());
                    return "--";
                }
            }
            return "";
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return "";
    }

    protected void handleMouseDown(MouseEvent e, ViewerCell cell) {
        Object testSuiteTestCaseLink = cell.getElement();
        if (testSuiteTestCaseLink != null) {
            String testSuiteId = this.getTestCaseTableViewer().getTestSuite();
            String testCaseId = ((TestSuiteTestCaseLink)testSuiteTestCaseLink).getTestCaseId();
            AnalyticsTestCase analyticsTestCase = TestSuitePlatformAnalysis.getInstance().getAnalyticsTestCase(testSuiteId, testCaseId);
            if (analyticsTestCase != null) {
                Program.launch((String)analyticsTestCase.getWebUrl());
            }
        }
    }

    protected boolean shouldShowCursor(ViewerCell cell, Point currentMouseLocation) {
        Object testSuiteTestCaseLink = cell.getElement();
        AnalyticsTestCase analyticsTestCase = this.getAnalyticsTestCase((TestSuiteTestCaseLink)testSuiteTestCaseLink);
        if (this.displayRowValue(analyticsTestCase, (TestSuiteTestCaseLink)testSuiteTestCaseLink)) {
            Rectangle rect = cell.getTextBounds();
            rect.width = cell.getText().length() * this.charWidth;
            Rectangle cellBounds = cell.getBounds();
            if (!cellBounds.contains(new Point(rect.x, rect.y))) {
                rect.x = cellBounds.x;
                rect.y = cellBounds.y;
            }
            return rect.contains(currentMouseLocation);
        }
        return false;
    }

    public void update(ViewerCell cell) {
        super.update(cell);
        Object testSuiteTestCaseLink = cell.getElement();
        AnalyticsTestCase analyticsTestCase = this.getAnalyticsTestCase((TestSuiteTestCaseLink)testSuiteTestCaseLink);
        if (this.displayRowValue(analyticsTestCase, (TestSuiteTestCaseLink)testSuiteTestCaseLink)) {
            cell.setStyleRanges(new StyleRange[]{this.getHyperLinkStyleRange(cell)});
        }
    }

    private StyleRange getHyperLinkStyleRange(ViewerCell cell) {
        StyleRange hyperLinkStyle = new StyleRange();
        hyperLinkStyle.foreground = JFaceColors.getHyperlinkText((Display)Display.getDefault());
        hyperLinkStyle.underline = true;
        hyperLinkStyle.start = 0;
        hyperLinkStyle.length = cell.getText().length();
        return hyperLinkStyle;
    }

    protected Class<TestSuiteTestCaseLink> getElementType() {
        return TestSuiteTestCaseLink.class;
    }

    protected Image getImage(TestSuiteTestCaseLink element) {
        return null;
    }

    public CellLayoutInfo getCellLayoutInfo() {
        return new DefaultCellLayoutInfo(){

            public int getLeftMargin() {
                return 5;
            }
        };
    }
}

