/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.providers;

import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.components.viewer.ITableViewerActions;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.dialogs.TestCaseSelectionDialog;
import com.kms.katalon.composer.testsuite.filters.AlreadyAddedTestCaseViewerFilter;
import com.kms.katalon.composer.testsuite.integration.TestSuitePlatformAnalysis;
import com.kms.katalon.composer.testsuite.parts.TestSuitePartTestCaseView;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.AnalyticsTestCase;
import com.kms.katalon.testops.core.model.exception.AnalyticsApiException;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.testops.services.TestOpsController;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;

public class TestCaseTableViewer
extends TableViewer
implements ITableViewerActions {
    private List<String> testCasesPKs;
    private List<TestSuiteTestCaseLink> data;
    private boolean isRunAll;
    private TestSuitePartTestCaseView parentView;
    private String searchedString;
    private ITestOpsController testOpsController = TestOpsController.getInstance();
    @Inject
    private IEclipseContext context;

    public TestCaseTableViewer(Composite parent, int style, TestSuitePartTestCaseView parentView) {
        super(parent, style);
        this.testCasesPKs = new ArrayList<String>();
        this.data = new ArrayList<TestSuiteTestCaseLink>();
        this.parentView = parentView;
        this.searchedString = "";
        ColumnViewerUtil.setTableActivation((TableViewer)this);
    }

    public String getTestSuite() {
        return this.parentView.getTestSuite().getId();
    }

    private List<AnalyticsTestCase> getTestCaseRuns(List<String> testCaseIds) throws AnalyticsApiException {
        AnalyticsSettingStore settingStore = AnalyticsSettingStore.getStore((String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        AnalyticsProject project = settingStore.getProject();
        if (settingStore.isIntegrationEnabled()) {
            return this.testOpsController.getTestCaseRuns(project.getId(), testCaseIds);
        }
        return Collections.emptyList();
    }

    public void setInput(List<TestSuiteTestCaseLink> data) throws Exception {
        this.data.clear();
        this.isRunAll = true;
        this.testCasesPKs.clear();
        String testSuiteId = this.getTestSuite();
        TestSuitePlatformAnalysis.getInstance().clearTestSuiteData(testSuiteId);
        Iterator<TestSuiteTestCaseLink> iterator = data.iterator();
        while (iterator.hasNext()) {
            TestSuiteTestCaseLink object;
            TestSuiteTestCaseLink link = object = iterator.next();
            TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(link.getTestCaseId());
            if (testCase != null && testCase.getId() != null) {
                this.testCasesPKs.add(testCase.getId());
            } else {
                this.testCasesPKs.add(link.getTestCaseId());
            }
            this.data.add(link);
            if (link.getIsRun()) continue;
            this.isRunAll = false;
        }
        ArrayList<String> testCaseIds = new ArrayList<String>();
        Iterator<TestSuiteTestCaseLink> iterator2 = this.data.iterator();
        while (iterator2.hasNext()) {
            TestSuiteTestCaseLink object;
            TestSuiteTestCaseLink link = object = iterator2.next();
            testCaseIds.add(link.getTestCaseId());
        }
        Executors.newFixedThreadPool(1).submit(() -> {
            try {
                List<AnalyticsTestCase> testCaseRuns = this.getTestCaseRuns(testCaseIds);
                if (testCaseRuns != null && testCaseRuns.size() > 0) {
                    TestSuitePlatformAnalysis.getInstance().setAnalyticsTestCasesMap(testSuiteId, testCaseRuns);
                    UISynchronizeService.asyncExec(() -> this.refresh());
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        });
        super.setInput(this.data);
        this.parentView.updateIsRunColumnHeader();
    }

    public List<TestSuiteTestCaseLink> getInput() {
        return this.data;
    }

    public void addTestCase(TestCaseEntity testCase) throws Exception {
        TestSuiteTestCaseLink link = this.createNewTestSuiteTestCaseLink(testCase);
        this.testCasesPKs.add(testCase.getId());
        this.data.add(link);
        this.refresh();
        this.setSelection((ISelection)new StructuredSelection((Object)link));
        this.parentView.setDirty(true);
    }

    public void addTestCases(List<TestCaseEntity> testCases) throws Exception {
        ArrayList<TestSuiteTestCaseLink> testCaseLinks = new ArrayList<TestSuiteTestCaseLink>();
        for (TestCaseEntity testCase : testCases) {
            TestSuiteTestCaseLink link = this.createNewTestSuiteTestCaseLink(testCase);
            this.testCasesPKs.add(testCase.getId());
            this.data.add(link);
            testCaseLinks.add(link);
        }
        this.refresh();
        this.setSelection((ISelection)new StructuredSelection(testCaseLinks));
        this.parentView.setDirty(true);
    }

    public TestSuiteTestCaseLink insertTestCase(TestCaseEntity testCase, int index) throws Exception {
        if (index < 0 || index > this.data.size()) {
            this.addTestCase(testCase);
            return null;
        }
        TestSuiteTestCaseLink link = this.createNewTestSuiteTestCaseLink(testCase);
        this.testCasesPKs.add(testCase.getId());
        this.data.add(index, link);
        this.refresh();
        this.setSelection((ISelection)new StructuredSelection((Object)link));
        this.parentView.setDirty(true);
        return link;
    }

    protected TestSuiteTestCaseLink createNewTestSuiteTestCaseLink(TestCaseEntity testCase) throws Exception {
        TestSuiteTestCaseLink link = new TestSuiteTestCaseLink();
        link.setIsRun(true);
        link.setTestCaseId(testCase.getIdForDisplay());
        link.setUsingDataBindingAtTestSuiteLevel(false);
        for (VariableEntity variable : testCase.getVariables()) {
            VariableLink variableLink = new VariableLink();
            variableLink.setVariableId(variable.getId());
            link.getVariableLinks().add(variableLink);
        }
        return link;
    }

    private void upTestCase(List<TestSuiteTestCaseLink> selectedObjects) {
        if (selectedObjects != null && selectedObjects.size() >= 1) {
            Collections.sort(selectedObjects, new Comparator<TestSuiteTestCaseLink>(){

                @Override
                public int compare(TestSuiteTestCaseLink arg0, TestSuiteTestCaseLink arg1) {
                    return TestCaseTableViewer.this.data.indexOf(arg0) > TestCaseTableViewer.this.data.indexOf(arg1) ? 1 : -1;
                }
            });
            ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
            for (TestSuiteTestCaseLink selectedLink : selectedObjects) {
                TestSuiteTestCaseLink linkBefore;
                int selectedIndex = this.data.indexOf(selectedLink) - 1;
                if (selectedIndex < 0 || selectedObjects.contains(linkBefore = this.data.get(selectedIndex))) continue;
                this.data.remove(selectedLink);
                this.data.add(selectedIndex, selectedLink);
                selectedIndices.add(selectedIndex);
            }
            this.parentView.setDirty(true);
            this.refresh();
            this.getTable().deselectAll();
            selectedIndices.sort(Integer::compareTo);
            this.getTable().select(selectedIndices.stream().mapToInt(i -> i).toArray());
        }
    }

    private void downTestCase(List<TestSuiteTestCaseLink> selectedObjects) {
        if (selectedObjects != null && selectedObjects.size() >= 1) {
            Collections.sort(selectedObjects, new Comparator<TestSuiteTestCaseLink>(){

                @Override
                public int compare(TestSuiteTestCaseLink arg0, TestSuiteTestCaseLink arg1) {
                    return TestCaseTableViewer.this.data.indexOf(arg0) < TestCaseTableViewer.this.data.indexOf(arg1) ? 1 : -1;
                }
            });
            ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
            for (TestSuiteTestCaseLink selectedLink : selectedObjects) {
                TestSuiteTestCaseLink linkAfter;
                int selectedIndex = this.data.indexOf(selectedLink) + 1;
                if (selectedIndex >= this.data.size() || selectedObjects.contains(linkAfter = this.data.get(selectedIndex))) continue;
                this.data.remove(selectedLink);
                this.data.add(selectedIndex, selectedLink);
                selectedIndices.add(selectedIndex);
            }
            this.parentView.setDirty(true);
            this.refresh();
            this.getTable().deselectAll();
            selectedIndices.sort(Integer::compareTo);
            this.getTable().select(selectedIndices.stream().mapToInt(i -> i).toArray());
        }
    }

    public void removeTestCases(List<TestSuiteTestCaseLink> selectedObjects) throws Exception {
        if (selectedObjects != null && selectedObjects.size() > 0) {
            for (TestSuiteTestCaseLink link : selectedObjects) {
                TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(link.getTestCaseId());
                if (testCase != null) {
                    this.testCasesPKs.remove(testCase.getId());
                } else {
                    this.testCasesPKs.remove(link.getTestCaseId());
                }
                this.data.remove(this.data.indexOf(link));
            }
            this.refreshIsRunAll();
            this.refresh();
            this.parentView.setDirty(true);
        }
    }

    public int getIndex(TestSuiteTestCaseLink testSuiteTestCaseLink) {
        return this.data.indexOf(testSuiteTestCaseLink);
    }

    public void setIsRunValueAllTestCases() {
        this.isRunAll = !this.isRunAll;
        Iterator<TestSuiteTestCaseLink> iterator = this.data.iterator();
        while (iterator.hasNext()) {
            TestSuiteTestCaseLink object;
            TestSuiteTestCaseLink link = object = iterator.next();
            link.setIsRun(this.isRunAll);
            this.update(link, null);
        }
        this.parentView.setDirty(true);
        this.parentView.updateIsRunColumnHeader();
    }

    public boolean getIsRunAll() {
        return this.isRunAll;
    }

    public void refreshIsRunAll() {
        boolean check = true;
        for (TestSuiteTestCaseLink object : this.data) {
            TestSuiteTestCaseLink link = object;
            if (link.getIsRun()) continue;
            check = false;
        }
        if (check != this.isRunAll) {
            this.isRunAll = check;
            this.parentView.updateIsRunColumnHeader();
        }
    }

    public void updateTestCaseProperties(String oldPk, TestCaseEntity testCase) throws Exception {
        if (this.testCasesPKs.contains(oldPk)) {
            List indices = IntStream.range(0, this.testCasesPKs.size()).filter(index -> this.testCasesPKs.get(index).equals(oldPk)).boxed().collect(Collectors.toList());
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                int index2 = (Integer)iterator.next();
                TestSuiteTestCaseLink testCaseLink = this.data.get(index2);
                testCaseLink.setTestCaseId(testCase.getIdForDisplay());
                ArrayList<VariableLink> retainedVariableLinks = new ArrayList<VariableLink>();
                for (VariableEntity variable : testCase.getVariables()) {
                    boolean isNewVariable = true;
                    for (VariableLink variableLink : testCaseLink.getVariableLinks()) {
                        if (!variable.getId().equals(variableLink.getVariableId())) continue;
                        isNewVariable = false;
                        retainedVariableLinks.add(variableLink);
                        break;
                    }
                    if (!isNewVariable) continue;
                    VariableLink newVariableLink = new VariableLink();
                    newVariableLink.setVariableId(variable.getId());
                    testCaseLink.getVariableLinks().add(newVariableLink);
                    retainedVariableLinks.add(newVariableLink);
                }
                testCaseLink.getVariableLinks().retainAll(retainedVariableLinks);
                this.testCasesPKs.remove(index2);
                this.testCasesPKs.add(index2, testCase.getId());
                this.update(testCaseLink, null);
            }
        }
    }

    public TestSuiteTestCaseLink getSelectedTestCaseLink() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        if (selection != null && selection.size() == 1) {
            return (TestSuiteTestCaseLink)selection.getFirstElement();
        }
        return null;
    }

    public boolean containTestCasePk(String testCasePk) {
        return this.testCasesPKs.contains(testCasePk);
    }

    public void updatePk(TestSuiteTestCaseLink link) throws Exception {
        int index = this.data.indexOf(link);
        this.testCasesPKs.remove(index);
        TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(link.getTestCaseId());
        if (this.testCasesPKs.size() <= index) {
            this.testCasesPKs.add(index, testCase.getId());
        } else {
            this.testCasesPKs.add(testCase.getId());
        }
    }

    public String getSearchedString() {
        return this.searchedString;
    }

    public void setSearchedString(String searchedString) {
        this.searchedString = searchedString;
    }

    public void updateDirty(boolean dirty) {
        this.parentView.setDirty(dirty);
    }

    public List<String> getTestCasesPKs() {
        return this.testCasesPKs;
    }

    public List<TestSuiteTestCaseLink> getSelectedItems() {
        List selectedItems = ((IStructuredSelection)this.getSelection()).toList();
        if (selectedItems == null) {
            return Collections.emptyList();
        }
        return selectedItems;
    }

    public void addNewItem() {
        try {
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            if (currentProject == null) {
                return;
            }
            ITreeEntity[] entities = TreeEntityUtil.getChildren(null, (FolderEntity)FolderController.getInstance().getTestCaseRoot(currentProject), (boolean)false);
            TestCaseSelectionDialog dialog = new TestCaseSelectionDialog(null, (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), new AlreadyAddedTestCaseViewerFilter(new EntityProvider(), entities), this);
            ContextInjectionFactory.inject((Object)((Object)dialog), (IEclipseContext)this.context);
            dialog.setInput(entities);
            dialog.open();
        }
        catch (Exception ex) {
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)ComposerTestsuiteMessageConstants.PA_ERROR_MSG_UNABLE_TO_ADD_TEST_CASES);
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    public void removeSelectedItems() {
        try {
            this.removeTestCases(this.getSelectedItems());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void moveSelectedItemsUp() {
        this.upTestCase(this.getSelectedItems());
    }

    public void moveSelectedItemsDown() {
        this.downTestCase(this.getSelectedItems());
    }
}

