/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.machine.service;

import com.kms.katalon.application.machine.service.MachineIdService;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;

public class LinuxMachineIdService
implements MachineIdService {
    private static final String[] LINUX_GET_MACHINE_ID_COMMAND_1 = new String[]{"cat", "/var/lib/dbus/machine-id"};
    public static final String[] LINUX_GET_MACHINE_ID_COMMAND_2 = new String[]{"cat", "/etc/machine-id"};

    @Override
    public String getMachineId() {
        String machineId;
        try {
            LogUtil.logInfo((String)String.format("Start getting machine ID on Linux", new Object[0]));
            machineId = LinuxMachineIdService.getMachineIdFromCmd();
            if (!StringUtils.equals((CharSequence)"N/A", (CharSequence)machineId)) {
                machineId = this.appendAdditionalSignatures(machineId);
            }
        }
        catch (IOException | InterruptedException e) {
            LogUtil.logError((Throwable)e);
            machineId = "N/A";
        }
        String result = MachineIdService.hash(machineId);
        LogUtil.logInfo((String)String.format("End getting machine ID on Linux %s", result));
        return result;
    }

    @Override
    public String getOsDependentUsername() {
        String username = "";
        try {
            Class<?> clazz = Class.forName("com.sun.security.auth.module.UnixSystem");
            Object o = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = clazz.getDeclaredMethod("getUsername", new Class[0]);
            username = (String)method.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            LogUtil.logInfo((String)"OS username is empty");
            username = System.getProperty("user.name", "");
        }
        return username;
    }

    private static String getMachineIdFromCmd() throws IOException, InterruptedException {
        String machineId = ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])LINUX_GET_MACHINE_ID_COMMAND_1);
        if (StringUtils.length((CharSequence)machineId) != 32) {
            machineId = ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])LINUX_GET_MACHINE_ID_COMMAND_2);
        }
        return StringUtils.length((CharSequence)machineId) == 32 ? machineId : "N/A";
    }
}

