/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.machine.service;

import com.kms.katalon.application.machine.service.MachineIdService;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MacMachineIdService
implements MachineIdService {
    private static final String MAC_GET_MACHINE_ID_FIELD = "IOPlatformUUID";
    private static final String MAC_GET_MACHINE_ID_DELIMITER = "=";
    public static final String[] MAC_GET_MACHINE_ID_COMMAND = new String[]{"ioreg", "-rd1", "-c", "IOPlatformExpertDevice", "|", "grep", "IOPlatformUUID"};

    @Override
    public String getMachineId() {
        String machineId = "N/A";
        try {
            LogUtil.logInfo((String)String.format("Start getting machine ID on Mac", new Object[0]));
            machineId = MacMachineIdService.getMachineIdFromCmd();
            if (!StringUtils.equals((CharSequence)"N/A", (CharSequence)machineId)) {
                machineId = this.appendAdditionalSignatures(machineId);
            }
        }
        catch (IOException | InterruptedException e) {
            LogUtil.logError((Throwable)e);
        }
        String result = MachineIdService.hash(machineId);
        LogUtil.logInfo((String)String.format("End getting machine ID on Mac %s", result));
        return result;
    }

    @Override
    public String getOsDependentUsername() {
        String username = "";
        try {
            Class<?> clazz = Class.forName("com.sun.security.auth.module.UnixSystem");
            Object o = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = clazz.getDeclaredMethod("getUsername", new Class[0]);
            username = (String)method.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            LogUtil.logInfo((String)"OS username is empty");
            username = System.getProperty("user.name", "");
        }
        return username;
    }

    private static String getMachineIdFromCmd() throws IOException, InterruptedException {
        List commandLineResults = ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])MAC_GET_MACHINE_ID_COMMAND);
        String commandLineResult = commandLineResults.stream().filter(result -> result.contains(MAC_GET_MACHINE_ID_FIELD)).findAny().orElse("N/A");
        return Arrays.asList(commandLineResult.split(MAC_GET_MACHINE_ID_DELIMITER)).stream().map(String::trim).map(result -> result.replace("\"", "")).map(String::toLowerCase).filter(result -> result.matches("[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}")).findAny().orElse("N/A");
    }
}

