/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.utils;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class VersionInfo
implements Comparable<VersionInfo> {
    private String version;
    private int buildNumber;
    private String latestVersion;
    public static final String MINIMUM_VERSION = "3.0.5";

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionInfo other = (VersionInfo)obj;
        if (this.buildNumber != other.buildNumber) {
            return false;
        }
        if (this.version == null && other.version != null) {
            return false;
        }
        return this.version == null || this.version.equals(other.version);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.buildNumber;
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Override
    public int compareTo(VersionInfo other) {
        if (StringUtils.equals((CharSequence)this.getVersion(), (CharSequence)other.getVersion())) {
            return 0;
        }
        int[] thisVer = Arrays.stream(StringUtils.split((String)this.getVersion(), (char)'.')).mapToInt(Integer::parseInt).toArray();
        int[] thatVer = Arrays.stream(StringUtils.split((String)other.getVersion(), (char)'.')).mapToInt(Integer::parseInt).toArray();
        int maxLength = Math.max(thisVer.length, thatVer.length);
        while (thisVer.length < maxLength) {
            thisVer = ArrayUtils.add((int[])thisVer, (int)0);
        }
        while (thatVer.length < maxLength) {
            thatVer = ArrayUtils.add((int[])thatVer, (int)0);
        }
        int i = 0;
        while (i < maxLength) {
            if (thisVer[i] != thatVer[i]) {
                if (thisVer[i] > thatVer[i]) {
                    return 1;
                }
                if (thisVer[i] < thatVer[i]) {
                    return -1;
                }
            }
            ++i;
        }
        return 0;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }
}

