/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.utils;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.VersionInfo;
import com.kms.katalon.application.utils.VersionRange;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.eclipse.service.EclipseNetworkPreferences;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.program.Program;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil {
    private static final Logger logger = LoggerFactory.getLogger(VersionUtil.class);
    public static final String URL_NEW_VERSION = "http://goo.gl/bNWyP0";
    private static final String VERSION_SEPARATOR_REGEX = "[,;]";
    private static final String LATEST_VERSION_URL = "https://download.katalon.com/update/latest_v11_version.json";
    private static final IHttpClient httpClient = ApacheHttpClient.getInstance();
    private static final INetworkPreferences networkPreferences = EclipseNetworkPreferences.getInstance();

    public static boolean hasNewVersion() {
        VersionInfo currentVersion = VersionUtil.getCurrentVersion();
        return VersionUtil.isNewer(ApplicationInfo.officialReleaseVersion(), currentVersion.getVersion());
    }

    public static VersionInfo getCurrentVersion() {
        VersionInfo curVersion = new VersionInfo();
        curVersion.setVersion(ApplicationInfo.officialReleaseVersion());
        return curVersion;
    }

    public static VersionInfo getLatestVersion() {
        VersionInfo newVersion = new VersionInfo();
        ProxyConfig proxyConfig = networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().proxy(proxyConfig).build();
        try {
            HttpResponse response = httpClient.get(new URI(LATEST_VERSION_URL), httpOptions);
            newVersion.setVersion(((VersionInfo)response.json(VersionInfo.class)).getLatestVersion());
        }
        catch (HttpException | URISyntaxException e) {
            logger.error("Failed to fetch the latest version: " + e.getMessage());
            return VersionUtil.getCurrentVersion();
        }
        return newVersion;
    }

    public static void gotoDownloadPage() {
        try {
            Program.launch((String)URL_NEW_VERSION);
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
        }
    }

    public static boolean isDevelopmentBuild() {
        return "dev".equals(ApplicationInfo.profile()) || "${build.profile}".equals(ApplicationInfo.profile());
    }

    public static boolean isStagingBuild() {
        return "stag".equals(ApplicationInfo.profile()) || "dev".equals(ApplicationInfo.profile());
    }

    public static boolean isNewer(String version, String comparedVersion) {
        if (StringUtils.equals((CharSequence)version, (CharSequence)comparedVersion)) {
            return false;
        }
        int[] thisVer = Arrays.stream(StringUtils.split((String)version, (char)'.')).mapToInt(Integer::parseInt).toArray();
        int[] thatVer = Arrays.stream(StringUtils.split((String)comparedVersion, (char)'.')).mapToInt(Integer::parseInt).toArray();
        int maxLength = Math.max(thisVer.length, thatVer.length);
        while (thisVer.length < maxLength) {
            thisVer = ArrayUtils.add((int[])thisVer, (int)0);
        }
        while (thatVer.length < maxLength) {
            thatVer = ArrayUtils.add((int[])thatVer, (int)0);
        }
        int i = 0;
        while (i < maxLength) {
            if (thisVer[i] != thatVer[i]) {
                if (thisVer[i] > thatVer[i]) {
                    return true;
                }
                if (thisVer[i] < thatVer[i]) {
                    return false;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean isCurrentVersionAppliedToUpdate(String currentVersion, String latestVersion, String appliedToUpdateVersions) {
        String[] strVersionRanges;
        if (appliedToUpdateVersions == null || appliedToUpdateVersions.isEmpty()) {
            return true;
        }
        appliedToUpdateVersions = appliedToUpdateVersions.replaceAll("\\s", "");
        String[] stringArray = strVersionRanges = appliedToUpdateVersions.split(VERSION_SEPARATOR_REGEX);
        int n = strVersionRanges.length;
        int n2 = 0;
        while (n2 < n) {
            String strVersionRange = stringArray[n2];
            VersionRange versionRange = new VersionRange(strVersionRange, latestVersion);
            if (versionRange.contains(currentVersion)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int getMajorVersion() {
        int[] version = Arrays.stream(StringUtils.split((String)VersionUtil.getCurrentVersion().getVersion(), (char)'.')).mapToInt(Integer::parseInt).toArray();
        if (version.length > 0) {
            return version[0];
        }
        return -1;
    }
}

