/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.ide.util;

import com.google.common.io.Files;
import com.kms.katalon.selenium.ide.model.Command;
import com.kms.katalon.selenium.ide.model.TestCase;
import com.kms.katalon.selenium.ide.model.TestSuite;
import com.kms.katalon.selenium.ide.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class HtmlParser {
    public static TestSuite parseTestSuite(File file) {
        String extension = Files.getFileExtension((String)file.getName());
        File parentFile = file.getParentFile();
        String testSuiteHtmlContent = FileUtils.readFileToString(file.toPath());
        String testSuiteName = HtmlParser.parseTitle(testSuiteHtmlContent);
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        if (StringUtils.isBlank((CharSequence)extension) || HtmlParser.hasSuiteTable(file)) {
            Map<String, String> testCaseFiles = HtmlParser.parseTestCaseFiles(testSuiteHtmlContent);
            testCaseFiles.forEach((key, value) -> {
                String testCaseFilePath = parentFile.getAbsolutePath() + File.separator + value;
                TestCase testCase = HtmlParser.parseTestCaseFromFile(testCaseFilePath);
                testCase.setFilePath(testCaseFilePath);
                testCases.add(testCase);
            });
        } else {
            List<String> testCaseHtmlContents = HtmlParser.parseTestCaseHtmlTableContents(testSuiteHtmlContent);
            testCaseHtmlContents.forEach(htmlContent -> {
                TestCase testCase = HtmlParser.parseTestCaseFromHtmlTableContent(htmlContent);
                testCase.setFilePath(file.getAbsolutePath());
                testCases.add(testCase);
            });
        }
        TestSuite testSuite = new TestSuite();
        testSuite.setName(testSuiteName);
        testSuite.setTestCases(testCases);
        testSuite.setFilePath(file.getAbsolutePath());
        return testSuite;
    }

    public static TestCase parseTestCaseFromFile(String testCaseFilePath) {
        String testCaseHtmlContent = FileUtils.readFileToString(new File(testCaseFilePath).toPath());
        ArrayList<Command> commands = new ArrayList<Command>();
        String testCaseBodyContent = HtmlParser.parseTestCaseHtmlBodyContent(testCaseHtmlContent);
        if (StringUtils.isNotBlank((CharSequence)testCaseBodyContent)) {
            Pattern pattern = Pattern.compile("(<tr>.*?</tr>)");
            Matcher matcher = pattern.matcher(testCaseBodyContent);
            while (matcher.find()) {
                Command command = HtmlParser.parseCommand(matcher.group(1));
                if (command == null) continue;
                commands.add(command);
            }
        }
        TestCase testCase = new TestCase();
        testCase.setName(HtmlParser.parseTitle(testCaseHtmlContent));
        testCase.setBaseUrl(HtmlParser.parseBaseUrl(testCaseHtmlContent));
        testCase.setCommands(commands);
        testCase.setFilePath(testCaseFilePath);
        return testCase;
    }

    public static TestCase parseTestCaseFromHtmlTableContent(String htmlTableContent) {
        String baseUrl = "";
        ArrayList<Command> commands = new ArrayList<Command>();
        String htmlBodyContent = HtmlParser.parseTestCaseHtmlBodyContent(htmlTableContent);
        if (StringUtils.isNotBlank((CharSequence)htmlBodyContent)) {
            Pattern pattern = Pattern.compile("(<tr>.*?</tr>)");
            Matcher matcher = pattern.matcher(htmlBodyContent);
            while (matcher.find()) {
                Command command = HtmlParser.parseCommand(matcher.group(1));
                if (StringUtils.isBlank((CharSequence)baseUrl) && "open".equalsIgnoreCase(command.getCommand())) {
                    baseUrl = command.getTarget();
                }
                if (command == null) continue;
                commands.add(command);
            }
        }
        TestCase testCase = new TestCase();
        testCase.setName(HtmlParser.parseTitleFromHtmlTableContent(htmlTableContent));
        testCase.setBaseUrl(baseUrl);
        testCase.setCommands(commands);
        return testCase;
    }

    public static Command parseCommand(String commandHtmlContent) {
        Command command = null;
        Pattern pattern = Pattern.compile("(<tr>.*?<td>)(.*?)(</td>.*?<td>)(.*?)(<datalist>)(.*?)(</datalist)(.*?</td>.*?<td>)(.*?)(</td>.*?</tr>)");
        Matcher matcher = pattern.matcher(commandHtmlContent);
        if (matcher.find()) {
            List<String> options = HtmlParser.parseOptions(matcher.group(6));
            command = HtmlParser.createCommand(matcher.group(2), matcher.group(4), matcher.group(9), options);
        } else {
            pattern = Pattern.compile("(<tr>.*?<td>)(.*?)(</td>.*?<td>)(.*?)(</td>.*?<td>)(.*?)(</td>.*?</tr>)");
            matcher = pattern.matcher(commandHtmlContent);
            if (matcher.find()) {
                command = HtmlParser.createCommand(matcher.group(2), matcher.group(4), matcher.group(6), new ArrayList<String>());
            }
        }
        return command;
    }

    private static List<String> parseOptions(String dataList) {
        ArrayList<String> options = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(.*?<option>)(.*?)(</option>.*?)");
        Matcher matcher = pattern.matcher(dataList);
        while (matcher.find()) {
            options.add(matcher.group(2));
        }
        return options;
    }

    private static Command createCommand(String command, String target, String value, List<String> options) {
        Command ret = new Command();
        ret.setCommand(command);
        ret.setTarget(StringUtils.trim((String)target));
        ret.setValue(StringUtils.trim((String)value));
        ret.setOptions(options);
        return ret;
    }

    public static String parseTitle(String htmlContent) {
        String testSuite = "";
        Pattern pattern = Pattern.compile("(.*?<title>)(.+?)(</title>.*?)");
        Matcher matcher = pattern.matcher(htmlContent);
        if (matcher.find()) {
            testSuite = matcher.group(2);
        }
        return testSuite;
    }

    public static boolean hasBaseUrl(File file) {
        String testSuiteHtmlContent = FileUtils.readFileToString(file.toPath());
        String baseUrl = HtmlParser.parseBaseUrl(testSuiteHtmlContent);
        return StringUtils.isNotBlank((CharSequence)baseUrl);
    }

    public static String parseBaseUrl(String htmlContent) {
        String testSuite = "";
        Pattern pattern = Pattern.compile("<link rel=\"selenium.base\" href=\"(.*?)\" />");
        Matcher matcher = pattern.matcher(htmlContent);
        if (matcher.find()) {
            testSuite = matcher.group(1);
        }
        return testSuite;
    }

    public static List<String> parseTestCaseHtmlTableContents(String htmlContent) {
        ArrayList<String> testCases = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(.*?)(<table.*?>)(.*?)(</table>)(.*?)");
        Matcher matcher = pattern.matcher(htmlContent);
        while (matcher.find()) {
            testCases.add(matcher.group(3));
        }
        return testCases;
    }

    public static String parseTestCaseHtmlBodyContent(String htmlContent) {
        String testCase = "";
        Pattern pattern = Pattern.compile("(.*?<tbody>)(.*?)(</tbody>.*?)");
        Matcher matcher = pattern.matcher(htmlContent);
        if (matcher.find()) {
            testCase = matcher.group(2);
        }
        return testCase;
    }

    public static String parseTitleFromHtmlTableContent(String htmlContent) {
        String title = "";
        Pattern pattern = Pattern.compile("(.*?<thead>.*?<td.*?>)(.*?)(</td>.*?</thead>.*?)");
        Matcher matcher = pattern.matcher(htmlContent);
        if (matcher.find()) {
            title = matcher.group(2);
        }
        return title;
    }

    public static Map<String, String> parseTestCaseFiles(String testSuiteHtmlContent) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        Pattern pattern = Pattern.compile("(.+?<a href=\")(.+?)(\">)(.+?)(</a>.+?)");
        Matcher matcher = pattern.matcher(testSuiteHtmlContent);
        while (matcher.find()) {
            map.put(matcher.group(4), matcher.group(2));
        }
        return map;
    }

    public static boolean isSelector(String selector) {
        Pattern pattern = Pattern.compile("(id|name|title|css|class|xpath)(=)(.*?)");
        Matcher matcher = pattern.matcher(selector);
        if (matcher.find()) {
            return matcher.groupCount() == 3;
        }
        return false;
    }

    public static String[] paseSelector(String selector) {
        String[] matches = new String[3];
        Pattern pattern = Pattern.compile("(.*?)(=)(.*?)$");
        Matcher matcher = pattern.matcher(selector);
        if (matcher.find() && matcher.groupCount() == 3) {
            matches[0] = HtmlParser.replaceSpecialChars(HtmlParser.removeMarks(matcher.group(1)));
            matches[1] = HtmlParser.removeMarks(matcher.group(2));
            matches[2] = HtmlParser.removeMarks(matcher.group(3));
        }
        return matches;
    }

    public static String replaceSpecialChars(String a) {
        return a.replace("link", "text");
    }

    public static String removeMarks(String value) {
        return value.replace("'", "").replace("'", "");
    }

    public static String encodeSelector(String selector) {
        if (StringUtils.isNotBlank((CharSequence)selector)) {
            return FileUtils.encode(selector.replace("=", "_"));
        }
        return "";
    }

    public static boolean hasSuiteTable(File file) {
        String testSuiteHtmlContent = FileUtils.readFileToString(file.toPath());
        return testSuiteHtmlContent.contains("<table id=\"suiteTable\"");
    }
}

