/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.handler;

import com.katalon.capability.constant.DriverType;
import com.katalon.capability.dto.ImportCapabilityRequest;
import com.katalon.capability.exception.WriteCapabilityException;
import com.katalon.capability.handler.ICapabilityHandler;
import com.katalon.capability.model.CapabilitySetting;
import com.katalon.capability.repository.ICapabilityRepository;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public abstract class AbstractCapabilityHandler
implements ICapabilityHandler {
    protected final ICapabilityRepository capabilityRepository;

    public AbstractCapabilityHandler(ICapabilityRepository capabilityRepository) {
        this.capabilityRepository = capabilityRepository;
    }

    @Override
    public CapabilitySetting getCapability(DriverType driverType) {
        String filePath = this.buildCapabilityFilePath();
        Map<DriverType, Map<String, Object>> capabilityMap = this.capabilityRepository.readCapabilityMapFromFile(filePath);
        return new CapabilitySetting(driverType, capabilityMap.get(driverType));
    }

    @Override
    public void saveCapability(CapabilitySetting capabilitySetting) throws IOException, WriteCapabilityException {
        String filePath = this.buildCapabilityFilePath();
        Map<DriverType, Map<String, Object>> data = Map.of(capabilitySetting.getDriverType(), capabilitySetting.getValue());
        this.capabilityRepository.writeCapabilityMapToFile(filePath, data);
    }

    @Override
    public void exportCapability(String exportFilePath, CapabilitySetting capabilitySetting) throws IOException {
        this.capabilityRepository.writeCapabilityValueToFile(exportFilePath, capabilitySetting.getValue());
    }

    @Override
    public CapabilitySetting importCapability(ImportCapabilityRequest request) {
        DriverType driverType = request.getDriverType();
        String importFilePath = request.getImportFilePath();
        boolean overridingExistingProperties = request.getOverridingExistingProperties();
        File file = new File(importFilePath);
        if (file.exists()) {
            Map<String, Object> importData = this.capabilityRepository.readCapabilityValueFromFile(importFilePath);
            if (overridingExistingProperties) {
                return new CapabilitySetting(driverType, importData);
            }
            CapabilitySetting capability = this.getCapability(driverType);
            importData.forEach((key, value) -> {
                Object object = capability.getValue().putIfAbsent(key, value);
            });
            return capability;
        }
        if (overridingExistingProperties) {
            return new CapabilitySetting(driverType, null);
        }
        return this.getCapability(driverType);
    }

    protected abstract String buildCapabilityFilePath();
}

