/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.manager.impl;

import com.katalon.capability.constant.DriverType;
import com.katalon.capability.dto.ImportCapabilityRequest;
import com.katalon.capability.exception.UnsupportedDriverTypeException;
import com.katalon.capability.exception.WriteCapabilityException;
import com.katalon.capability.factory.ICapabilityHandlerFactory;
import com.katalon.capability.handler.ICapabilityHandler;
import com.katalon.capability.manager.ICapabilityManager;
import com.katalon.capability.model.CapabilitySetting;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CapabilityManagerImpl
implements ICapabilityManager {
    private final ICapabilityHandlerFactory capabilityHandlerFactory;

    @Inject
    public CapabilityManagerImpl(ICapabilityHandlerFactory capabilityHandlerFactory) {
        this.capabilityHandlerFactory = capabilityHandlerFactory;
    }

    public CapabilitySetting getCapability(DriverType driverType) throws UnsupportedDriverTypeException {
        ICapabilityHandler capabilityHandler = this.capabilityHandlerFactory.getCapabilityHandler(driverType);
        return capabilityHandler.getCapability(driverType);
    }

    public void saveCapability(CapabilitySetting capabilitySetting) throws UnsupportedDriverTypeException, IOException, WriteCapabilityException {
        ICapabilityHandler capabilityHandler = this.capabilityHandlerFactory.getCapabilityHandler(capabilitySetting.getDriverType());
        capabilityHandler.saveCapability(capabilitySetting);
    }

    public void exportCapability(String exportFilePath, CapabilitySetting capabilitySetting) throws UnsupportedDriverTypeException, IOException {
        ICapabilityHandler capabilityHandler = this.capabilityHandlerFactory.getCapabilityHandler(capabilitySetting.getDriverType());
        capabilityHandler.exportCapability(exportFilePath, capabilitySetting);
    }

    public CapabilitySetting importCapability(ImportCapabilityRequest request) throws UnsupportedDriverTypeException {
        ICapabilityHandler capabilityHandler = this.capabilityHandlerFactory.getCapabilityHandler(request.getDriverType());
        return capabilityHandler.importCapability(request);
    }
}

