/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.event.tracking;

import com.kms.katalon.ai.core.constant.StudioAssistTrackingValueEnum;
import com.kms.katalon.ai.core.model.exception.StudioAssistDisabledException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiAuthenticationException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiIncompatibleModelException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerContentViolatedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerNoAnswerException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerTokenExceededException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiTimeoutException;

public class ChatErrorTrackingEvent {
    public static final String TOPIC = "STUDIOASSIST_TRACK_CHAT_ERROR";
    public static final String ERROR_CODE_GENERAL_ERROR = "I1001";
    public static final String ERROR_CODE_AUTHENTICATION_ERROR = "I1002";
    public static final String ERROR_CODE_VIOLATION_ERROR = "I1003";
    public static final String ERROR_CODE_TIMEOUT_ERROR = "I1004";
    public static final String ERROR_CODE_JSON_PARSE_ERROR = "I1005";
    public static final String ERROR_CODE_TOKEN_EXCEEDED_ERROR = "I1006";
    public static final String ERROR_CODE_NO_ANSWER_FROM_LLM_ERROR = "I1007";
    public static final String ERROR_CODE_FEATURE_DISABLED_ERROR = "C2001";
    public static final String ERROR_CODE_INCOMPATIBLE_AI_MODEL_ERROR = "C2003";
    private final StudioAssistTrackingValueEnum errorType;
    private final String errorCode;
    private final String conversationId;
    private final String questionId;
    private final String chatMode;

    private ChatErrorTrackingEvent(Builder builder) {
        this.errorType = builder.errorType;
        this.errorCode = builder.errorCode;
        this.conversationId = builder.conversationId;
        this.questionId = builder.questionId;
        this.chatMode = builder.chatMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StudioAssistTrackingValueEnum getErrorTypeFromCode(String errorCode) {
        if (errorCode == null) {
            return StudioAssistTrackingValueEnum.GENERAL_ERROR;
        }
        return switch (errorCode) {
            case ERROR_CODE_GENERAL_ERROR -> StudioAssistTrackingValueEnum.GENERAL_ERROR;
            case ERROR_CODE_AUTHENTICATION_ERROR -> StudioAssistTrackingValueEnum.AUTHENTICATION_ERROR;
            case ERROR_CODE_VIOLATION_ERROR -> StudioAssistTrackingValueEnum.VIOLATION_ERROR;
            case ERROR_CODE_TIMEOUT_ERROR -> StudioAssistTrackingValueEnum.TIMEOUT_ERROR;
            case ERROR_CODE_JSON_PARSE_ERROR -> StudioAssistTrackingValueEnum.JSON_PARSE_ERROR;
            case ERROR_CODE_TOKEN_EXCEEDED_ERROR -> StudioAssistTrackingValueEnum.TOKEN_EXCEEDED_ERROR;
            case ERROR_CODE_NO_ANSWER_FROM_LLM_ERROR -> StudioAssistTrackingValueEnum.NO_ANSWER_FROM_LLM_ERROR;
            case ERROR_CODE_FEATURE_DISABLED_ERROR -> StudioAssistTrackingValueEnum.FEATURE_DISABLED_ERROR;
            case ERROR_CODE_INCOMPATIBLE_AI_MODEL_ERROR -> StudioAssistTrackingValueEnum.INCOMPATIBLE_AI_MODEL_ERROR;
            default -> StudioAssistTrackingValueEnum.GENERAL_ERROR;
        };
    }

    public static String getErrorCodeFromException(Throwable exception) {
        if (exception == null) {
            return ERROR_CODE_GENERAL_ERROR;
        }
        if (exception instanceof StudioAssistLlmApiAuthenticationException) {
            return ERROR_CODE_AUTHENTICATION_ERROR;
        }
        if (exception instanceof StudioAssistLlmApiServerContentViolatedException) {
            return ERROR_CODE_VIOLATION_ERROR;
        }
        if (exception instanceof StudioAssistLlmApiTimeoutException) {
            return ERROR_CODE_TIMEOUT_ERROR;
        }
        if (exception instanceof StudioAssistLlmApiServerTokenExceededException) {
            return ERROR_CODE_TOKEN_EXCEEDED_ERROR;
        }
        if (exception instanceof StudioAssistLlmApiServerNoAnswerException) {
            return ERROR_CODE_NO_ANSWER_FROM_LLM_ERROR;
        }
        if (exception instanceof StudioAssistDisabledException) {
            return ERROR_CODE_FEATURE_DISABLED_ERROR;
        }
        if (exception instanceof StudioAssistLlmApiIncompatibleModelException) {
            return ERROR_CODE_INCOMPATIBLE_AI_MODEL_ERROR;
        }
        return ERROR_CODE_GENERAL_ERROR;
    }

    public StudioAssistTrackingValueEnum getErrorType() {
        return this.errorType;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getQuestionId() {
        return this.questionId;
    }

    public String getChatMode() {
        return this.chatMode;
    }

    public static class Builder {
        private StudioAssistTrackingValueEnum errorType;
        private String errorCode;
        private String conversationId;
        private String questionId;
        private String chatMode;

        public Builder errorType(StudioAssistTrackingValueEnum errorType) {
            this.errorType = errorType;
            return this;
        }

        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            if (errorCode != null && this.errorType == null) {
                this.errorType = ChatErrorTrackingEvent.getErrorTypeFromCode(errorCode);
            }
            return this;
        }

        public Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public Builder chatMode(String chatMode) {
            this.chatMode = chatMode;
            return this;
        }

        public ChatErrorTrackingEvent build() {
            return new ChatErrorTrackingEvent(this);
        }
    }
}

