/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.event.tracking;

import com.kms.katalon.ai.core.constant.StudioAssistTrackingValueEnum;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class McpSettingActionTrackingEvent {
    public static final String TOPIC = "STUDIOASSIST_TRACK_MCP_SETTING_ACTION";
    private final StudioAssistTrackingValueEnum action;
    private final String chatMode;
    private final Map<String, Object> trackingData;

    private McpSettingActionTrackingEvent(StudioAssistTrackingValueEnum action, String chatMode, Map<String, Object> trackingData) {
        this.action = action;
        this.chatMode = chatMode;
        this.trackingData = trackingData == null ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(trackingData));
    }

    public static McpSettingActionTrackingEvent of(StudioAssistTrackingValueEnum action, String chatMode) {
        return McpSettingActionTrackingEvent.builder().action(action).chatMode(chatMode).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public StudioAssistTrackingValueEnum getAction() {
        return this.action;
    }

    public String getChatMode() {
        return this.chatMode;
    }

    public Map<String, Object> getTrackingData() {
        return this.trackingData;
    }

    public static final class Builder {
        private StudioAssistTrackingValueEnum action;
        private String chatMode;
        private final Map<String, Object> trackingData = new LinkedHashMap<String, Object>();

        public Builder action(StudioAssistTrackingValueEnum action) {
            this.action = action;
            return this;
        }

        public Builder chatMode(String chatMode) {
            this.chatMode = chatMode;
            return this;
        }

        public Builder addData(String key, Object value) {
            if (key != null && value != null) {
                this.trackingData.put(key, value);
            }
            return this;
        }

        public McpSettingActionTrackingEvent build() {
            return new McpSettingActionTrackingEvent(this.action, this.chatMode, this.trackingData);
        }
    }
}

