/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model.agent;

import com.kms.katalon.ai.core.model.agent.Entity;
import com.kms.katalon.ai.core.model.agent.EntityModification;
import com.kms.katalon.ai.core.model.agent.EntityModificationType;
import com.kms.katalon.ai.core.model.chat.StudioAssistConversation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AgentConversation
extends StudioAssistConversation {
    private Map<String, List<String>> approvedTools = new HashMap<String, List<String>>();
    private final List<EntityModification> entityModifications = new ArrayList<EntityModification>();
    private static final int INIT_CHAT_HISTORY_QUEUE_CAPACITY = 50;

    public AgentConversation() {
        super(50, true);
    }

    public Map<String, List<String>> getApprovedTools() {
        return this.approvedTools;
    }

    public void setApprovedTools(Map<String, List<String>> approvedTools) {
        this.approvedTools = approvedTools;
    }

    @Override
    public String reset() {
        String newConversationId = super.reset();
        this.clearEntityModifications();
        return newConversationId;
    }

    public List<EntityModification> getEntityModifications() {
        return this.entityModifications;
    }

    public EntityModification addEntityModification(EntityModification modification) {
        if (!this.isValidModification(modification)) {
            return null;
        }
        Entity entity = modification.getEntity();
        String entityId = entity.getId();
        EntityModification existing = this.findEntityModificationById(entityId);
        if (existing == null) {
            this.entityModifications.add(modification);
            return modification;
        }
        this.mergeEntityModification(existing, modification);
        return existing;
    }

    public void removeEntityModification(String entityId) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        EntityModification entityModification = this.findEntityModificationById(entityId);
        if (entityModification == null) {
            return;
        }
        this.entityModifications.remove(entityModification);
    }

    public void clearEntityModifications() {
        this.entityModifications.clear();
    }

    private boolean isValidModification(EntityModification modification) {
        if (modification == null) {
            return false;
        }
        Entity entity = modification.getEntity();
        return entity != null && StringUtils.isNotBlank((CharSequence)entity.getId());
    }

    private EntityModification findEntityModificationById(String entityId) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return null;
        }
        return this.entityModifications.stream().filter(entityModification -> entityModification.getEntity().getId().equals(entityId)).findFirst().orElse(null);
    }

    private void mergeEntityModification(EntityModification target, EntityModification incoming) {
        target.setLinesAdded(incoming.getLinesAdded());
        target.setLinesRemoved(incoming.getLinesRemoved());
        if (StringUtils.isBlank((CharSequence)target.getSnapshotId())) {
            target.setSnapshotId(incoming.getSnapshotId());
        }
        if (target.getType() != EntityModificationType.CREATED) {
            target.setType(incoming.getType());
        }
        if (incoming.getStatus() != null) {
            target.setStatus(incoming.getStatus());
        }
    }
}

