/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model.agent;

import com.kms.katalon.ai.core.model.agent.AgentMessageStatus;
import com.kms.katalon.ai.core.model.agent.AgentSetting;
import com.kms.katalon.ai.core.model.agent.EntityModification;
import com.kms.katalon.ai.core.model.agent.MaxedToolCallStatus;
import com.kms.katalon.ai.core.model.agent.ToolCallMessage;
import com.kms.katalon.ai.core.model.agent.ToolCallStatus;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAnswerMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AgentMessage
extends ResponseMessage {
    private MaxedToolCallStatus maxedToolCallStatus = null;
    private AgentMessageStatus status = AgentMessageStatus.IN_PROGRESS;
    private ArrayList<ToolCallMessage> requestedToolCalls = new ArrayList();
    private List<ResponseMessage> children = new ArrayList<ResponseMessage>();
    private boolean isRated = false;
    private List<EntityModification> entityModifications = new ArrayList<EntityModification>();

    public AgentMessage(String messageId) {
        super(messageId);
    }

    public boolean isFinished() {
        boolean rejectedMaxCalls;
        boolean finishedStatus = this.status != AgentMessageStatus.IN_PROGRESS;
        boolean hasAnswer = this.children.stream().anyMatch(child -> child instanceof StudioAssistChatAnswerMessage);
        boolean bl = rejectedMaxCalls = this.maxedToolCallStatus != null && this.maxedToolCallStatus == MaxedToolCallStatus.REJECTED;
        return finishedStatus || hasAnswer || rejectedMaxCalls;
    }

    public MaxedToolCallStatus getMaxedToolCallStatus() {
        return this.maxedToolCallStatus;
    }

    public void setMaxedToolCallStatus(MaxedToolCallStatus maxedToolCallStatus) {
        this.maxedToolCallStatus = maxedToolCallStatus;
    }

    public AgentMessageStatus getStatus() {
        return this.status;
    }

    public void setStatus(AgentMessageStatus status) {
        this.status = status;
    }

    public ArrayList<ToolCallMessage> getRequestedToolCalls() {
        return this.requestedToolCalls;
    }

    public void setRequestedToolCalls(ArrayList<ToolCallMessage> requestedToolCalls) {
        this.requestedToolCalls = requestedToolCalls;
    }

    public List<ResponseMessage> getChildren() {
        return this.children;
    }

    public ToolCallMessage getFirstToolCall(ToolCallStatus status) {
        return this.getToolCalls().stream().filter(toolCall -> toolCall.getStatus() == status).findFirst().orElse(null);
    }

    public void setChildren(List<ResponseMessage> children) {
        this.children = children;
    }

    public void addChild(ResponseMessage child) {
        this.children.add(child);
    }

    public void addChildren(List<ResponseMessage> children) {
        this.children.addAll(children);
    }

    public boolean hasToolCall() {
        return this.children.stream().filter(child -> child instanceof ToolCallMessage).count() > 0L;
    }

    public boolean isRated() {
        return this.isRated;
    }

    public void setRated(boolean isRated) {
        this.isRated = isRated;
    }

    public boolean isReachedMaxToolCalls(AgentSetting agentSetting) {
        return this.getToolCalls().size() > agentSetting.getMaxToolCalls();
    }

    public List<ToolCallMessage> getToolCalls() {
        return this.children.stream().filter(child -> child instanceof ToolCallMessage).map(child -> (ToolCallMessage)child).collect(Collectors.toList());
    }

    public StudioAssistChatAnswerMessage getFinalAnswer() {
        return this.children.stream().filter(child -> child instanceof StudioAssistChatAnswerMessage).map(child -> (StudioAssistChatAnswerMessage)child).findFirst().orElse(null);
    }

    public List<EntityModification> getEntityModifications() {
        return this.entityModifications;
    }

    public void setEntityModifications(List<EntityModification> entityModifications) {
        this.entityModifications = entityModifications;
    }

    public void addEntityModification(EntityModification modification) {
        String modificationId;
        if (modification == null || modification.getEntity() == null) {
            return;
        }
        if (this.entityModifications == null) {
            this.entityModifications = new ArrayList<EntityModification>();
        }
        if ((modificationId = modification.getEntity().getId()) == null) {
            return;
        }
        this.entityModifications.removeIf(existing -> {
            if (existing == null || existing.getEntity() == null) {
                return false;
            }
            String existingId = existing.getEntity().getId();
            return modificationId.equals(existingId);
        });
        this.entityModifications.add(modification);
    }

    public void clearEntityModifications() {
        if (this.entityModifications != null) {
            this.entityModifications.clear();
        }
    }
}

