/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model.agent;

import com.kms.katalon.ai.core.model.agent.AgentConversation;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.McpClient;
import com.kms.katalon.ai.core.model.agent.McpServerConnectionStatus;
import com.kms.katalon.ai.core.model.chat.ChatQuestionMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatItem;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.core.util.internal.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentSession {
    private static final Logger logger = LoggerFactory.getLogger(AgentSession.class);
    private static final int EXPAND_STEP_CHAT_HISTORY_QUEUE_CAPACITY = 20;
    private List<McpClient> mcpClients = new ArrayList<McpClient>();
    private AgentConversation conversation = new AgentConversation();

    public List<McpClient> getMcpClients() {
        return this.mcpClients;
    }

    public void addMcpClient(McpClient client) {
        this.mcpClients.add(client);
    }

    public void setMcpClients(List<McpClient> mcpClient) {
        this.mcpClients = mcpClient;
    }

    public AgentConversation getConversation() {
        return this.conversation;
    }

    public void setConversation(AgentConversation conversation) {
        this.conversation = conversation;
    }

    public McpClient getMcpClient(String server) {
        return this.mcpClients.stream().filter(s -> server.equals(s.getServer())).findFirst().orElse(null);
    }

    public McpClient getMcpClientByOAuthState(String oauthState) {
        return this.mcpClients.stream().filter(mcpClient -> mcpClient.getStatus() == McpServerConnectionStatus.UNAUTHORIZED).filter(mcpClient -> mcpClient.getAuthorization() != null).filter(mcpClient -> mcpClient.getAuthorization().getRequests().containsKey(oauthState)).findFirst().orElse(null);
    }

    public StudioAssistChatPair appendAgentChatItem(ChatQuestionMessage question, boolean isGoodQuestion) {
        this.clearPreviousAgentMessageModifications();
        AgentMessage response = new AgentMessage(question.getMessageId());
        StudioAssistChatPair chatItem = new StudioAssistChatPair(question, response, null, isGoodQuestion);
        ArrayBlockingQueue<StudioAssistChatItem> chatHistory = this.conversation.getMessages();
        if (chatHistory.remainingCapacity() == 0) {
            this.conversation.increaseQueueSize(20, true);
        }
        String currentQuestionId = chatItem.getRequest().getMessageId();
        if (this.conversation.getMessages().stream().anyMatch(item -> {
            StudioAssistChatPair pair;
            return item instanceof StudioAssistChatPair && (pair = (StudioAssistChatPair)item).getRequest().getMessageId().equals(currentQuestionId);
        })) {
            return null;
        }
        if (!this.conversation.addChatItemIntoHistory(chatItem)) {
            logger.error("The chat history capacity reached");
        }
        logger.trace("after appendToConversation -> " + JsonUtil.toJson((Object)this.conversation));
        return chatItem;
    }

    private void clearPreviousAgentMessageModifications() {
        if (this.conversation == null || this.conversation.getMessages() == null) {
            return;
        }
        this.conversation.getMessages().stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> (StudioAssistChatPair)item).map(StudioAssistChatPair::getResponse).filter(response -> response instanceof AgentMessage).map(response -> (AgentMessage)response).forEach(AgentMessage::clearEntityModifications);
    }
}

