/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model.chat;

import com.kms.katalon.ai.core.model.chat.ChatQuestionMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAnswerMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.chat.StudioAssistConversation;
import com.kms.katalon.ai.core.model.presentation.ProjectContext;
import com.kms.katalon.core.setting.StudioAssistSetting;
import java.util.ArrayList;
import java.util.List;

public class ChatSession {
    private static final int INIT_CHAT_HISTORY_QUEUE_CAPACITY = 50;
    private static final boolean QUEUE_CHANGE_OPERATION_FAIR = true;
    private final StudioAssistConversation conversation;
    private final List<ProjectContext> projectContexts;

    public ChatSession() {
        this.conversation = new StudioAssistConversation(50, true);
        this.projectContexts = List.of();
    }

    public ChatSession(StudioAssistConversation conversation, List<ProjectContext> projectContexts) {
        this.conversation = conversation;
        this.projectContexts = projectContexts;
    }

    public StudioAssistConversation getConversation() {
        return this.conversation;
    }

    public List<ProjectContext> getProjectContexts() {
        ArrayList<ProjectContext> projectContexts = new ArrayList<ProjectContext>(this.projectContexts);
        if (StudioAssistSetting.isProjectContextCustomKeywordsEnabled()) {
            projectContexts.add(ProjectContext.CUSTOM_KEYWORD);
        }
        if (StudioAssistSetting.isProjectContextObjectRepositoriesEnabled()) {
            projectContexts.add(ProjectContext.OBJECT_REPOSITORY);
        }
        return projectContexts;
    }

    public void resetConversation() {
        this.conversation.reset();
    }

    public StudioAssistChatPair appendChatItem(ChatQuestionMessage question, boolean isGoodQuestion) {
        StudioAssistChatAnswerMessage response = new StudioAssistChatAnswerMessage();
        response.setMessageId(question.getMessageId());
        StudioAssistChatPair chatPair = new StudioAssistChatPair();
        chatPair.setRequest(question);
        chatPair.setResponse(response);
        chatPair.setGoodQuestion(isGoodQuestion);
        this.conversation.getMessages().add(chatPair);
        return chatPair;
    }
}

