/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model.chat;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.kms.katalon.ai.core.constant.StudioAssistAttachmentSource;
import com.kms.katalon.ai.core.constant.StudioAssistAttachmentStatus;
import com.kms.katalon.ai.core.constant.StudioAssistFileType;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class StudioAssistChatAttachment {
    private static final String SYSTEM_PROPERTY_FILE_SEPARATOR = "file.separator";
    private static final String PROFILE_FOLDER_NAME = "Profiles";
    private static final String INCLUDE_FOLDER_NAME = "Include";
    private static final String KEYWORD_FOLDER_NAME = "Keywords";
    private static final String TEST_LISTENER_FOLDER_NAME = "Test Listeners";
    private static final String OBJECT_REPOSITORY_FOLDER_NAME = "Object Repository";
    private static final String TEST_SUITE_FOLDER_NAME = "Test Suites";
    private static final String TEST_CASE_FOLDER_NAME = "Test Cases";
    private static final String METADATA_KEY_DECLARED_VARIABLES = "declared_variables";
    private static final String METADATA_KEY_RELATIVE_PATH = "relative_path";
    private static final String METADATA_KEY_FILE_TYPE = "file_type";
    protected StudioAssistFileType fileType;
    protected StudioAssistAttachmentSource fileSource;
    private String fileClientId;
    private String fileId;
    private String filePath;
    private Map<String, String> declaredVariables;
    @JsonIgnore
    private String fileContent;
    private Date dateModified;
    private StudioAssistAttachmentStatus status;

    public StudioAssistChatAttachment() {
    }

    public StudioAssistChatAttachment(StudioAssistFileType fileType, String filePath, StudioAssistAttachmentStatus status, StudioAssistAttachmentSource fileSource) {
        this.fileType = fileType;
        this.filePath = filePath;
        this.status = status;
        this.fileSource = fileSource;
    }

    public StudioAssistChatAttachment(StudioAssistFileType fileType, StudioAssistAttachmentSource fileSource, String fileId, String fileClientId, String filePath, Map<String, String> declaredVariables, String fileContent, Date dateModified) {
        this.fileType = fileType;
        this.fileSource = fileSource;
        this.filePath = filePath;
        this.declaredVariables = declaredVariables;
        this.fileContent = fileContent;
        this.dateModified = dateModified;
        this.fileClientId = StringUtils.isBlank((CharSequence)fileClientId) ? UUID.randomUUID().toString() : fileClientId;
    }

    public StudioAssistFileType getFileType() {
        return this.fileType;
    }

    public void setFileType(StudioAssistFileType fileType) {
        this.fileType = fileType;
    }

    public StudioAssistAttachmentSource getFileSource() {
        return this.fileSource;
    }

    public void setFileSource(StudioAssistAttachmentSource fileSource) {
        this.fileSource = fileSource;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFileClientId() {
        return this.fileClientId;
    }

    public void setFileClientId(String fileClientId) {
        this.fileClientId = fileClientId;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getPathForPrompt() {
        int extensionPoint;
        String pathForPrompt = this.getFilePath();
        switch (this.fileType) {
            case TEST_CASE: {
                int testCaseRelativePathIndex = pathForPrompt.indexOf(TEST_CASE_FOLDER_NAME);
                if (testCaseRelativePathIndex == -1) break;
                pathForPrompt = pathForPrompt.substring(testCaseRelativePathIndex + TEST_CASE_FOLDER_NAME.length() + 1);
                break;
            }
            case TEST_SUITE: 
            case DYNAMIC_TEST_SUITE: {
                int testSuiteRelativePathIndex = pathForPrompt.indexOf(TEST_SUITE_FOLDER_NAME);
                if (testSuiteRelativePathIndex == -1) break;
                pathForPrompt = pathForPrompt.substring(testSuiteRelativePathIndex + TEST_SUITE_FOLDER_NAME.length() + 1);
                break;
            }
            case WEB_SERVICE_OBJECT: {
                int webServiceRelativePathIndex = pathForPrompt.indexOf(OBJECT_REPOSITORY_FOLDER_NAME);
                if (webServiceRelativePathIndex == -1) break;
                pathForPrompt = pathForPrompt.substring(webServiceRelativePathIndex + OBJECT_REPOSITORY_FOLDER_NAME.length() + 1);
                break;
            }
            case LISTENER: {
                int listenerRelativePathIndex = pathForPrompt.indexOf(TEST_LISTENER_FOLDER_NAME);
                if (listenerRelativePathIndex == -1) break;
                pathForPrompt = pathForPrompt.substring(listenerRelativePathIndex + TEST_LISTENER_FOLDER_NAME.length() + 1);
                break;
            }
            case GROOVY: 
            case JAVA: 
            case CUSTOM_KEYWORD: 
            case STEP_DEFINITION: 
            case FEATURE_FILE: {
                if (pathForPrompt.contains(KEYWORD_FOLDER_NAME)) {
                    return pathForPrompt.substring(pathForPrompt.indexOf(KEYWORD_FOLDER_NAME) + KEYWORD_FOLDER_NAME.length() + 1);
                }
                if (!pathForPrompt.contains(INCLUDE_FOLDER_NAME)) break;
                return pathForPrompt.substring(pathForPrompt.indexOf(INCLUDE_FOLDER_NAME) + INCLUDE_FOLDER_NAME.length() + 1);
            }
            case PROFILE: {
                int profileRelativePathIndex = pathForPrompt.indexOf(PROFILE_FOLDER_NAME);
                if (profileRelativePathIndex == -1) break;
                pathForPrompt = pathForPrompt.substring(profileRelativePathIndex + PROFILE_FOLDER_NAME.length() + 1);
                break;
            }
            default: {
                int lastFileSeparatorIndex = pathForPrompt.lastIndexOf(System.getProperty(SYSTEM_PROPERTY_FILE_SEPARATOR));
                if (lastFileSeparatorIndex >= 0 && lastFileSeparatorIndex < pathForPrompt.length() - 1) {
                    return pathForPrompt.substring(lastFileSeparatorIndex + 1, pathForPrompt.length());
                }
                return "";
            }
        }
        if ((extensionPoint = pathForPrompt.lastIndexOf(".")) >= 0 && extensionPoint <= pathForPrompt.length()) {
            return pathForPrompt.substring(0, extensionPoint);
        }
        return pathForPrompt;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Map<String, String> getDeclaredVariables() {
        return this.declaredVariables;
    }

    public void setDeclaredVariables(Map<String, String> declaredVariables) {
        this.declaredVariables = declaredVariables;
    }

    public String getFileContent() {
        return this.fileContent;
    }

    public void setFileContent(String fileContent) {
        this.fileContent = fileContent;
    }

    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public StudioAssistAttachmentStatus getStatus() {
        return this.status;
    }

    public void setStatus(StudioAssistAttachmentStatus status) {
        this.status = status;
    }

    public String buildContextContent() {
        StringBuilder builder = new StringBuilder("Properties of file content:");
        builder.append(System.lineSeparator() + "- File type: ").append(this.fileType.value());
        if (StringUtils.isNotBlank((CharSequence)this.filePath)) {
            builder.append(System.lineSeparator() + "- Relative path: ").append(this.getPathForPrompt());
        }
        if (this.declaredVariables != null && this.declaredVariables.size() > 0) {
            builder.append(System.lineSeparator() + "- Declared variables: ");
            for (Map.Entry<String, String> each : this.declaredVariables.entrySet()) {
                builder.append(System.lineSeparator() + "* ").append(each.getKey()).append("=").append(each.getValue());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.fileContent)) {
            builder.append(System.lineSeparator() + "And below is the file content:" + System.lineSeparator()).append(this.fileContent);
        }
        return builder.toString();
    }

    public Map<String, String> buildMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        String escapedNewLine = System.lineSeparator();
        if (this.fileType != null) {
            metadata.put(METADATA_KEY_FILE_TYPE, this.fileType.name());
        }
        if (StringUtils.isNotBlank((CharSequence)this.filePath)) {
            metadata.put(METADATA_KEY_RELATIVE_PATH, this.getPathForPrompt());
        }
        if (this.declaredVariables != null && !this.declaredVariables.isEmpty()) {
            String declaredVar = escapedNewLine + StringUtils.join(this.declaredVariables.entrySet().stream().map(entry -> String.format(" * %s: %s", entry.getKey(), entry.getValue())).toList(), (String)escapedNewLine);
            metadata.put(METADATA_KEY_DECLARED_VARIABLES, declaredVar);
        }
        return metadata;
    }
}

