/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model.config;

import org.apache.commons.lang3.StringUtils;

public enum LlmConfigType {
    NONE("", ""),
    GEN_AI("Katalon AI", "katalon_ai"),
    OPENAI("OpenAI", "openai"),
    AZURE_OPENAI("Azure OpenAI", "azure_openai"),
    GEMINI("Gemini", "gemini"),
    OPENAI_COMPATIBLE("OpenAI Compatible", "openai_compatible"),
    AWS_BEDROCK("AWS Bedrock", "aws_bedrock");

    private final String displayName;
    private final String cliProviderOption;

    private LlmConfigType(String displayName, String cliProviderOption) {
        this.displayName = displayName;
        this.cliProviderOption = cliProviderOption;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCliProviderOption() {
        return this.cliProviderOption;
    }

    public static LlmConfigType parseCliProviderOption(String cliProviderOption) {
        if (StringUtils.isBlank((CharSequence)cliProviderOption)) {
            return null;
        }
        LlmConfigType[] llmConfigTypeArray = LlmConfigType.values();
        int n = llmConfigTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LlmConfigType type = llmConfigTypeArray[n2];
            if (type.cliProviderOption.equalsIgnoreCase(cliProviderOption.trim())) {
                return type;
            }
            ++n2;
        }
        return null;
    }
}

