/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model.config;

import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.exception.StudioAssistConfigUnavailableException;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;

public abstract class StudioAssistConfig {
    public static final int DEFAULT_MAX_TOKEN = 16000;
    protected LlmConfigType type;
    protected int maxToken;

    public LlmConfigType getType() {
        return this.type;
    }

    protected String encode(String value) throws StudioAssistConfigUnavailableException {
        CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)value);
        String encodedText = "";
        try {
            encodedText = CryptoUtil.encode((CryptoUtil.CrytoInfo)cryptoInfo);
        }
        catch (UnsupportedEncodingException | GeneralSecurityException exception) {
            throw new StudioAssistConfigUnavailableException();
        }
        return encodedText;
    }

    protected String decode(String value) throws StudioAssistConfigUnavailableException {
        CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)value);
        String rawText = "";
        try {
            rawText = CryptoUtil.decode((CryptoUtil.CrytoInfo)cryptoInfo);
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new StudioAssistConfigUnavailableException();
        }
        return rawText;
    }

    public int getMaxToken() {
        return this.maxToken;
    }

    public void setMaxToken(int maxToken) {
        this.maxToken = maxToken;
    }

    public boolean isValid() {
        return this.type != null && LlmConfigType.NONE != this.type;
    }
}

