/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model.llm;

import com.kms.katalon.ai.core.model.llm.FileFormat;
import com.kms.katalon.ai.core.model.llm.UserInput;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class InlineFileInput
extends UserInput {
    private String data;
    private FileFormat format;
    private String fileName;

    public InlineFileInput() {
        super(UserInput.UserInputType.INLINE_FILE);
    }

    private InlineFileInput(String data, FileFormat format, String fileName) {
        this();
        this.data = data;
        this.format = format;
        this.fileName = fileName;
    }

    public static InlineFileInput of(String data, FileFormat format) {
        return InlineFileInput.of(data, format, null);
    }

    public static InlineFileInput of(String data, FileFormat format, String fileName) {
        if (StringUtils.isBlank((CharSequence)data)) {
            throw new IllegalArgumentException("InlineFileInput data must not be blank");
        }
        if (format == null) {
            throw new IllegalArgumentException("InlineFileInput format is required");
        }
        return new InlineFileInput(data, format, fileName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public FileFormat getFormat() {
        return this.format;
    }

    public void setFormat(FileFormat format) {
        this.format = format;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getMimeType() {
        return this.format == null ? null : this.format.getMimeType();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void that;
        if (this == o) {
            return true;
        }
        if (!(o instanceof InlineFileInput)) {
            return false;
        }
        InlineFileInput inlineFileInput = (InlineFileInput)o;
        return Objects.equals(this.data, that.data) && this.format == that.format && Objects.equals(this.fileName, that.fileName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.data, this.format, this.fileName});
    }

    public static class Builder {
        private String data;
        private FileFormat format;
        private String fileName;

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        public Builder format(FileFormat format) {
            this.format = format;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public InlineFileInput build() {
            return InlineFileInput.of(this.data, this.format, this.fileName);
        }
    }
}

